/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.utils;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import java.io.IOException;
import java.io.Reader;
import java.nio.channels.Channels;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger log = LoggerFactory.getLogger(PropertyUtils.class);
    private static final MapType mapType = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING);
    private static Map<String, Properties> propertiesMap = new HashMap<String, Properties>();

    public static BString readProperty(Reader reader, BString key, BString defaultValue, String propertiesId) throws IOException {
        Properties readableProperties;
        if (!propertiesMap.containsKey(propertiesId)) {
            readableProperties = new Properties();
            readableProperties.load(reader);
            propertiesMap.put(propertiesId, readableProperties);
        } else {
            readableProperties = propertiesMap.get(propertiesId);
        }
        String value = readableProperties.getProperty(key.getValue(), defaultValue.getValue());
        if (value != null) {
            return StringUtils.fromString((String)value);
        }
        return null;
    }

    public static BMap<BString, Object> readAllProperties(Reader reader, String propertiesId) throws IOException {
        Properties readableProperties;
        if (!propertiesMap.containsKey(propertiesId)) {
            readableProperties = new Properties();
            readableProperties.load(reader);
            propertiesMap.put(propertiesId, readableProperties);
        } else {
            readableProperties = propertiesMap.get(propertiesId);
        }
        BMapInitialValueEntry[] keyValues = new BMapInitialValueEntry[readableProperties.stringPropertyNames().size()];
        int i = 0;
        Enumeration<?> e = readableProperties.propertyNames();
        while (e.hasMoreElements()) {
            BMapInitialValueEntry keyValue;
            String key = (String)e.nextElement();
            String value = readableProperties.getProperty(key);
            keyValues[i] = keyValue = ValueCreator.createKeyFieldEntry((Object)StringUtils.fromString((String)key), (Object)StringUtils.fromString((String)value));
            ++i;
        }
        return ValueCreator.createMapValue((MapType)mapType, (BMapInitialValueEntry[])keyValues);
    }

    public static void writePropertyContent(CharacterChannel characterChannel, BMap<BString, BString> propertiesMap, BString comment) throws IOException {
        Properties writableProperties = new Properties();
        Set propertiesSet = propertiesMap.entrySet();
        for (Map.Entry entry : propertiesSet) {
            writableProperties.setProperty(((BString)entry.getKey()).getValue(), ((BString)entry.getValue()).getValue());
        }
        writableProperties.store(Channels.newOutputStream(characterChannel.getChannel().getByteChannel()), comment.getValue());
    }
}

