/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.java;

import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypedescType;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.jvm.values.api.BObject;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="java", functionName="cast", args={@Argument(name="value", type=TypeKind.ANY), @Argument(name="castType", type=TypeKind.TYPEDESC)}, returnType={@ReturnType(type=TypeKind.ANY), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class Cast {
    private static final String moduleName = "{ballerina/java}";
    private static final String annotationName = "@java:Binding";
    private static final String annotationType = "ballerina/java:Binding";
    private static final String classAttribute = "class";
    private static final String jObjField = "jObj";

    public static Object cast(Strand strand, ObjectValue value, TypedescValue castType) {
        BObjectType objType = value.getType();
        String valueObjName = objType.getName();
        HandleValue handleObj = (HandleValue)value.get(jObjField);
        Object jObj = handleObj.getValue();
        if (jObj == null) {
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Empty handle reference found for `jObj` field in `" + valueObjName + "`")));
        }
        try {
            String castObjClass;
            String castObjTypeName;
            BObjectType castObjType;
            String objClass;
            try {
                Map objAnnotation = (Map)objType.getAnnotation(annotationType);
                objClass = (String)objAnnotation.get(classAttribute);
            }
            catch (Exception e) {
                return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while retrieving details of the `@java:Binding` annotation from `" + valueObjName + "` object: " + e)));
            }
            BType describingBType = castType.getDescribingType();
            try {
                BTypedescType describingType = (BTypedescType)describingBType;
                castObjType = (BObjectType)describingType.getConstraint();
                castObjTypeName = castObjType.getName();
                BField objField = (BField)castObjType.getFields().get(jObjField);
                if (objField == null) {
                    return BallerinaErrors.createError((BString)StringUtils.fromString((String)"{ballerina/java} Handle reference field `jObj` not found in the typedesc object"));
                }
            }
            catch (Exception e) {
                return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while processing the typedesc parameter: " + e)));
            }
            try {
                Map castObjAnnotation = (Map)castObjType.getAnnotation(annotationType);
                castObjClass = (String)castObjAnnotation.get(classAttribute);
            }
            catch (Exception e) {
                return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while retrieving details of the `@java:Binding` annotation from `" + castObjTypeName + "` typedesc: " + e)));
            }
            Class<?> objClassType = Class.forName(objClass);
            Class<?> castObjClassType = Class.forName(castObjClass);
            boolean isList = objClassType.isAssignableFrom(castObjClassType);
            if (isList) {
                BObject bObject;
                try {
                    bObject = BValueCreator.createObjectValue((BPackage)objType.getPackage(), (String)castObjType.getName(), (Object[])new Object[]{new HandleValue(jObj)});
                }
                catch (Exception e) {
                    return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while initializing the new object from `" + castObjTypeName + "` type: " + e)));
                }
                return bObject;
            }
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Cannot cast `" + valueObjName + "` to `" + castObjTypeName + "`")));
        }
        catch (Exception e) {
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while casting `" + valueObjName + "` object to the typedesc provided: " + e)));
        }
    }
}

