/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.java;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypedescType;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.jvm.values.api.BObject;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="java", version="0.9.0", functionName="cast", args={@Argument(name="value", type=TypeKind.ANY), @Argument(name="castType", type=TypeKind.TYPEDESC)}, returnType={@ReturnType(type=TypeKind.ANY), @ReturnType(type=TypeKind.ERROR)}, isPublic=true)
public class Cast {
    private static final String moduleName = "{ballerina/java}";
    private static final String annotationName = "@java:Binding";
    private static final String annotationType = "ballerina/java:0.9.0:Binding";
    private static final String classAttribute = "class";
    private static final String jObjField = "jObj";

    public static Object cast(Strand strand, ObjectValue value, TypedescValue castType) {
        BObjectType objType = value.getType();
        String valueObjName = objType.getName();
        HandleValue handleObj = (HandleValue)value.get(StringUtils.fromString((String)jObjField));
        Object jObj = handleObj.getValue();
        if (jObj == null) {
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Empty handle reference found for `jObj` field in `" + valueObjName + "`")));
        }
        try {
            BString castObjClass;
            String castObjTypeName;
            BObjectType castObjType;
            BString objClass;
            try {
                MapValue objAnnotation = (MapValue)objType.getAnnotation(StringUtils.fromString((String)annotationType));
                objClass = objAnnotation.getStringValue(StringUtils.fromString((String)classAttribute));
            }
            catch (Exception e) {
                return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while retrieving details of the `@java:Binding` annotation from `" + valueObjName + "` object: " + e)));
            }
            BType describingBType = castType.getDescribingType();
            try {
                BTypedescType describingType = (BTypedescType)describingBType;
                castObjType = (BObjectType)describingType.getConstraint();
                castObjTypeName = castObjType.getName();
                BField objField = (BField)castObjType.getFields().get(jObjField);
                if (objField == null) {
                    return BallerinaErrors.createError((BString)StringUtils.fromString((String)"{ballerina/java} Handle reference field `jObj` not found in the typedesc object"));
                }
            }
            catch (Exception e) {
                return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while processing the typedesc parameter: " + e)));
            }
            try {
                MapValue castObjAnnotation = (MapValue)castObjType.getAnnotation(StringUtils.fromString((String)annotationType));
                castObjClass = castObjAnnotation.getStringValue(StringUtils.fromString((String)classAttribute));
            }
            catch (Exception e) {
                return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while retrieving details of the `@java:Binding` annotation from `" + castObjTypeName + "` typedesc: " + e)));
            }
            Class<?> objClassType = Class.forName(objClass.getValue());
            Class<?> castObjClassType = Class.forName(castObjClass.getValue());
            boolean isList = objClassType.isAssignableFrom(castObjClassType);
            if (isList) {
                BObject bObject;
                try {
                    bObject = BValueCreator.createObjectValue((BPackage)objType.getPackage(), (String)castObjType.getName(), (Object[])new Object[]{new HandleValue(jObj)});
                }
                catch (Exception e) {
                    return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while initializing the new object from `" + castObjTypeName + "` type: " + e)));
                }
                return bObject;
            }
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Cannot cast `" + valueObjName + "` to `" + castObjTypeName + "`")));
        }
        catch (Exception e) {
            return BallerinaErrors.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while casting `" + valueObjName + "` object to the typedesc provided: " + e)));
        }
    }
}

