/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.datasource;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinax.jdbc.datasource.PoolKey;
import org.ballerinax.jdbc.datasource.SQLDatasource;
import org.ballerinax.jdbc.datasource.SQLDatasourceUtils;

public class PoolOptionsWrapper {
    private final MapValue<String, Object> poolOptions;
    private final PoolKey poolKey;

    public PoolOptionsWrapper(MapValue<String, Object> poolOptions, PoolKey poolKey) {
        this.poolOptions = poolOptions;
        this.poolKey = poolKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLDatasource retrieveDatasource(SQLDatasource.SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource existingSqlDatasource;
        ConcurrentMap<PoolKey, SQLDatasource> hikariDatasourceMap = this.createPoolMapIfNotExists();
        SQLDatasource sqlDatasourceToBeReturned = existingSqlDatasource = (SQLDatasource)hikariDatasourceMap.get(this.poolKey);
        if (existingSqlDatasource != null) {
            existingSqlDatasource.acquireMutex();
            try {
                if (!existingSqlDatasource.isPoolShutdown()) {
                    existingSqlDatasource.incrementClientCounter();
                }
                sqlDatasourceToBeReturned = hikariDatasourceMap.compute(this.poolKey, (key, value) -> this.createAndInitDatasource(sqlDatasourceParams));
            }
            finally {
                existingSqlDatasource.releaseMutex();
            }
        } else {
            sqlDatasourceToBeReturned = hikariDatasourceMap.computeIfAbsent(this.poolKey, key -> this.createAndInitDatasource(sqlDatasourceParams));
        }
        return sqlDatasourceToBeReturned;
    }

    private SQLDatasource createAndInitDatasource(SQLDatasource.SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource newSqlDatasource = new SQLDatasource().init(sqlDatasourceParams);
        newSqlDatasource.incrementClientCounter();
        return newSqlDatasource;
    }

    public Object get(String fieldName) {
        return this.poolOptions.get((Object)fieldName);
    }

    public Long getInt(String fieldName) {
        return this.poolOptions.getIntValue(fieldName);
    }

    public String getString(String fieldName) {
        return this.poolOptions.getStringValue(fieldName);
    }

    public Boolean getBoolean(String fieldName) {
        return this.poolOptions.getBooleanValue(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<PoolKey, SQLDatasource> createPoolMapIfNotExists() {
        ConcurrentHashMap<PoolKey, SQLDatasource> hikariDatasourceMap = SQLDatasourceUtils.retrieveDatasourceContainer(this.poolOptions);
        if (hikariDatasourceMap == null) {
            MapValue<String, Object> mapValue = this.poolOptions;
            synchronized (mapValue) {
                hikariDatasourceMap = SQLDatasourceUtils.retrieveDatasourceContainer(this.poolOptions);
                if (hikariDatasourceMap == null) {
                    hikariDatasourceMap = new ConcurrentHashMap();
                    SQLDatasourceUtils.addDatasourceContainer(this.poolOptions, hikariDatasourceMap);
                }
            }
        }
        return hikariDatasourceMap;
    }
}

