/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.statement;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.DataIterator;
import org.ballerinalang.jvm.TableResourceManager;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.BallerinaTransactionContext;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.transactions.TransactionResourceManager;
import org.ballerinalang.jvm.transactions.TransactionUtils;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinax.jdbc.Constants;
import org.ballerinax.jdbc.datasource.SQLDatasource;
import org.ballerinax.jdbc.exceptions.ApplicationException;
import org.ballerinax.jdbc.exceptions.ErrorGenerator;
import org.ballerinax.jdbc.statement.SQLStatement;
import org.ballerinax.jdbc.statement.StatementProcessUtils;
import org.ballerinax.jdbc.table.BCursorTable;
import org.ballerinax.jdbc.table.SQLDataIterator;
import org.ballerinax.jdbc.transaction.SQLTransactionContext;

public abstract class AbstractSQLStatement
implements SQLStatement {
    private static final BType SQL_PARAMETER_TYPE = BallerinaValues.createRecordValue((BPackage)Constants.JDBC_PACKAGE_ID, (String)"Parameter").getType();
    Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final BArrayType sqlParameterType = new BArrayType(SQL_PARAMETER_TYPE);
    Strand strand;

    AbstractSQLStatement(Strand strand) {
        this.strand = strand;
    }

    ArrayValue constructParameters(ArrayValue parameters) throws ApplicationException {
        ArrayValue parametersNew = (ArrayValue)BValueCreator.createArrayValue((BArrayType)sqlParameterType);
        int paramCount = parameters.size();
        for (int i = 0; i < paramCount; ++i) {
            MapValue<String, Object> paramRecord;
            Object value = parameters.get((long)i);
            BType type = TypeChecker.getType((Object)value);
            if (type.getTag() == 34 || type.getTag() == 12) {
                paramRecord = (MapValue<String, Object>)value;
            } else {
                paramRecord = this.getSQLParameter();
                paramRecord.put((Object)"value", value);
                paramRecord.put((Object)"direction", (Object)"IN");
                paramRecord.put((Object)"sqlType", (Object)this.getSQLType(value));
            }
            parametersNew.add((long)i, paramRecord);
        }
        return parametersNew;
    }

    String createProcessedQueryString(String query, ArrayValue parameters) {
        String currentQuery = query;
        if (parameters != null) {
            int start = 0;
            int paramCount = parameters.size();
            for (int i = 0; i < paramCount; ++i) {
                MapValue paramValue = (MapValue)parameters.getRefValue((long)i);
                if (paramValue == null) continue;
                String sqlType = StatementProcessUtils.getSQLType((MapValue<String, Object>)paramValue);
                Object value = paramValue.get((Object)"value");
                BType type = TypeChecker.getType((Object)value);
                int count = value != null && type.getTag() == 20 && ((BArrayType)type).getElementType().getTag() != 2 && !"ARRAY".equalsIgnoreCase(sqlType) ? ((ArrayValue)value).size() : 1;
                Object[] vals = this.expandQuery(start, count, currentQuery);
                start = (Integer)vals[0];
                currentQuery = (String)vals[1];
            }
        }
        return currentQuery;
    }

    TableValue constructTable(TableResourceManager rm, ResultSet rs, BStructureType structType, List<ColumnDefinition> columnDefinitions, String databaseProductName) {
        BStructureType tableConstraint = structType;
        if (structType == null) {
            tableConstraint = new BRecordType("$table$anon$constraint$", new BPackage("ballerina", "lang.annotations", "0.0.0"), 0, false, TypeFlags.asMask((int[])new int[]{2, 4}));
            ((BRecordType)tableConstraint).restFieldType = BTypes.typeAnydata;
        }
        return new BCursorTable((DataIterator)new SQLDataIterator(rm, rs, this.utcCalendar, columnDefinitions, structType, databaseProductName), tableConstraint);
    }

    List<ColumnDefinition> getColumnDefinitions(ResultSet rs) throws SQLException {
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        HashSet<String> columnNames = new HashSet<String>();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int cols = rsMetaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String colName = rsMetaData.getColumnLabel(i);
            if (columnNames.contains(colName)) {
                String tableName = rsMetaData.getTableName(i).toUpperCase(Locale.getDefault());
                colName = tableName + "." + colName;
            }
            int colType = rsMetaData.getColumnType(i);
            int mappedType = this.getColumnType(colType);
            columnDefs.add(new SQLDataIterator.SQLColumnDefinition(colName, mappedType, colType));
            columnNames.add(colName);
        }
        return columnDefs;
    }

    Object extractValueFromResultSet(ResultSetMetaData rsMeta, ResultSet rs, int index) throws SQLException {
        Object value;
        int columnType = rsMeta.getColumnType(index);
        switch (columnType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                value = rs.getLong(index);
                break;
            }
            case 6: 
            case 8: {
                value = rs.getDouble(index);
                break;
            }
            case -7: 
            case 16: {
                value = rs.getBoolean(index);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = rs.getBigDecimal(index);
                value = bigDecimal == null ? null : new DecimalValue(bigDecimal);
                break;
            }
            default: {
                value = rs.getString(index);
            }
        }
        return value;
    }

    private int getColumnType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return 20;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: 
            case 2011: 
            case 2013: 
            case 2014: {
                return 5;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 1;
            }
            case -7: 
            case 16: {
                return 6;
            }
            case 2: 
            case 3: {
                return 4;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 35;
            }
            case 2002: {
                return 12;
            }
        }
        return 23;
    }

    private String getSQLType(Object value) throws ApplicationException {
        BType type = TypeChecker.getType((Object)value);
        int tag = type.getTag();
        switch (tag) {
            case 1: {
                return "BIGINT";
            }
            case 5: {
                return "VARCHAR";
            }
            case 3: {
                return "DOUBLE";
            }
            case 6: {
                return "BOOLEAN";
            }
            case 4: {
                return "DECIMAL";
            }
            case 20: {
                if (((BArrayType)type).getElementType().getTag() == 2) {
                    return "BINARY";
                }
                throw new ApplicationException("array data type " + type.getName() + " as a direct value is supported only for byte type elements, use jdbc:Parameter instead");
            }
        }
        throw new ApplicationException("unsupported data type " + type.getName() + " specified as a direct value for sql operations, use jdbc:Parameter instead");
    }

    private MapValue<String, Object> getSQLParameter() {
        return BallerinaValues.createRecordValue((BPackage)Constants.JDBC_PACKAGE_ID, (String)"Parameter");
    }

    void cleanupResources(Statement stmt, Connection conn, boolean connectionClosable) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
            if (conn != null && !conn.isClosed() && connectionClosable) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e, "error while cleaning sql resources: ");
        }
    }

    void cleanupResources(ResultSet rs, Statement stmt, Connection conn, boolean connectionClosable) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
            this.cleanupResources(stmt, conn, connectionClosable);
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e, "error while cleaning sql resources: ");
        }
    }

    void handleErrorOnTransaction(Strand strand) {
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        if (transactionLocalContext == null) {
            return;
        }
        this.notifyTxMarkForAbort(strand, transactionLocalContext);
    }

    Connection getDatabaseConnection(Strand strand, ObjectValue client, SQLDatasource datasource) throws SQLException {
        Connection conn;
        try {
            boolean isInTransaction = strand.isInTransaction();
            if (!isInTransaction) {
                Connection conn2 = datasource.getSQLConnection();
                return conn2;
            }
            if (!strand.transactionLocalContext.hasTransactionBlock()) {
                Connection conn3 = datasource.getSQLConnection();
                return conn3;
            }
            String connectorId = this.retrieveConnectorId(client);
            boolean isXAConnection = datasource.isXAConnection();
            TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
            String globalTxId = transactionLocalContext.getGlobalTransactionId();
            String currentTxBlockId = transactionLocalContext.getCurrentTransactionBlockId();
            BallerinaTransactionContext txContext = transactionLocalContext.getTransactionContext(connectorId);
            if (txContext == null) {
                if (isXAConnection) {
                    XAConnection xaConn = datasource.getXADataSource().getXAConnection();
                    XAResource xaResource = xaConn.getXAResource();
                    TransactionResourceManager.getInstance().beginXATransaction(globalTxId, currentTxBlockId, xaResource);
                    conn = xaConn.getConnection();
                    txContext = new SQLTransactionContext(conn, xaResource);
                } else {
                    conn = datasource.getSQLConnection();
                    conn.setAutoCommit(false);
                    txContext = new SQLTransactionContext(conn);
                }
                transactionLocalContext.registerTransactionContext(connectorId, txContext);
                TransactionResourceManager.getInstance().register(globalTxId, currentTxBlockId, txContext);
            } else {
                conn = ((SQLTransactionContext)txContext).getConnection();
            }
        }
        catch (SQLException e) {
            throw new SQLException("error while getting the connection for ClientConnector. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
        }
        return conn;
    }

    private String retrieveConnectorId(ObjectValue bConnector) {
        return (String)bConnector.getNativeData(Constants.CONNECTOR_ID_KEY);
    }

    private void notifyTxMarkForAbort(Strand strand, TransactionLocalContext transactionLocalContext) {
        String globalTransactionId = transactionLocalContext.getGlobalTransactionId();
        String transactionBlockId = transactionLocalContext.getCurrentTransactionBlockId();
        transactionLocalContext.markFailure();
        TransactionUtils.notifyTransactionAbort((Strand)strand, (String)globalTransactionId, (String)transactionBlockId);
    }

    private Object[] expandQuery(int start, int count, String query) {
        StringBuilder result = new StringBuilder();
        int n = query.length();
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        int end = n;
        for (int i = start; i < n; ++i) {
            if (query.charAt(i) == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (query.charAt(i) == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (query.charAt(i) != '?' || doubleQuoteExists || singleQuoteExists) continue;
            result.append(query, 0, i);
            result.append(this.generateQuestionMarks(count));
            end = result.length() + 1;
            if (i + 1 >= n) break;
            result.append(query.substring(i + 1));
            break;
        }
        return new Object[]{end, result.toString()};
    }

    private String generateQuestionMarks(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append("?");
            if (i + 1 >= n) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    protected void checkAndObserveSQLAction(Strand strand, SQLDatasource datasource, String query) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        observerContext.ifPresent(ctx -> {
            ctx.addTag("peer.address", datasource.getPeerAddress());
            ctx.addTag("db.instance", datasource.getDatabaseProductName());
            ctx.addTag("db.statement", query);
            ctx.addTag("db.type", "sql");
        });
    }

    protected void checkAndObserveSQLError(Strand context, String message) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)context);
        observerContext.ifPresent(ctx -> {
            ctx.addProperty("error", (Object)Boolean.TRUE);
            ctx.addProperty("error_message", (Object)message);
        });
    }
}

