/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.datasource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Calendar;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinax.jdbc.datasource.PoolKey;
import org.ballerinax.jdbc.datasource.SQLDatasource;

public class SQLDatasourceUtils {
    private static final String POOL_MAP_KEY = UUID.randomUUID().toString();

    public static String getString(Clob data) throws IOException, SQLException {
        if (data == null) {
            return null;
        }
        try (BufferedReader r = new BufferedReader(data.getCharacterStream());){
            int pos;
            StringBuilder sb = new StringBuilder();
            while ((pos = ((Reader)r).read()) != -1) {
                sb.append((char)pos);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String getString(Blob data) throws SQLException {
        if (data == null) {
            return null;
        }
        byte[] encode = SQLDatasourceUtils.getBase64Encode(new String(data.getBytes(1L, (int)data.length()), Charset.defaultCharset()));
        return new String(encode, Charset.defaultCharset());
    }

    public static String getString(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(data, Charset.defaultCharset());
    }

    public static String getString(java.util.Date value) {
        String type;
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (value instanceof Time) {
            calendar.setTimeInMillis(value.getTime());
            type = "time";
        } else if (value instanceof Timestamp) {
            calendar.setTimeInMillis(value.getTime());
            type = "datetime";
        } else if (value instanceof Date) {
            calendar.setTime(value);
            type = "date";
        } else {
            calendar.setTime(value);
            type = "time";
        }
        return SQLDatasourceUtils.getString(calendar, type);
    }

    public static String getString(Array dataArray) throws SQLException {
        if (dataArray == null) {
            return null;
        }
        StringJoiner sj = new StringJoiner(",", "[", "]");
        ResultSet rs = dataArray.getResultSet();
        while (rs.next()) {
            Object arrayEl = rs.getObject(2);
            String val = String.valueOf(arrayEl);
            sj.add(val);
        }
        return sj.toString();
    }

    public static String getString(Struct udt) throws SQLException {
        if (udt.getAttributes() != null) {
            Object[] udtValues;
            StringJoiner sj = new StringJoiner(",", "{", "}");
            for (Object obj : udtValues = udt.getAttributes()) {
                sj.add(String.valueOf(obj));
            }
            return sj.toString();
        }
        return null;
    }

    static ConcurrentHashMap<PoolKey, SQLDatasource> retrieveDatasourceContainer(MapValue<String, Object> poolOptions) {
        return (ConcurrentHashMap)poolOptions.getNativeData(POOL_MAP_KEY);
    }

    public static void addDatasourceContainer(MapValue<String, Object> poolOptions, ConcurrentHashMap<PoolKey, SQLDatasource> datasourceMap) {
        poolOptions.addNativeData(POOL_MAP_KEY, datasourceMap);
    }

    static boolean isSupportedDbOptionType(Object value) {
        boolean supported = false;
        if (value != null) {
            BType type = TypeChecker.getType((Object)value);
            int typeTag = type.getTag();
            supported = typeTag == 5 || typeTag == 1 || typeTag == 3 || typeTag == 6 || typeTag == 4 || typeTag == 2;
        }
        return supported;
    }

    private static String getString(Calendar calendar, String type) {
        if (!calendar.isSet(15)) {
            calendar.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer datetimeString = new StringBuffer(28);
        switch (type) {
            case "date": {
                SQLDatasourceUtils.appendDate(datetimeString, calendar);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            case "time": {
                SQLDatasourceUtils.appendTime(calendar, datetimeString);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            case "datetime": {
                SQLDatasourceUtils.appendDate(datetimeString, calendar);
                datetimeString.append("T");
                SQLDatasourceUtils.appendTime(calendar, datetimeString);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            default: {
                throw new AssertionError((Object)("invalid type " + type + " specified for datetime data"));
            }
        }
        return datetimeString.toString();
    }

    private static byte[] getBase64Encode(String st) {
        return Base64.getEncoder().encode(st.getBytes(Charset.defaultCharset()));
    }

    private static void appendTimeZone(Calendar calendar, StringBuffer dateString) {
        int timezoneOffSet = calendar.get(15) + calendar.get(16);
        int timezoneOffSetInMinits = timezoneOffSet / 60000;
        if (timezoneOffSetInMinits < 0) {
            dateString.append("-");
            timezoneOffSetInMinits *= -1;
        } else {
            dateString.append("+");
        }
        int hours = timezoneOffSetInMinits / 60;
        int minits = timezoneOffSetInMinits % 60;
        if (hours < 10) {
            dateString.append("0");
        }
        dateString.append(hours).append(":");
        if (minits < 10) {
            dateString.append("0");
        }
        dateString.append(minits);
    }

    private static void appendTime(Calendar value, StringBuffer dateString) {
        if (value.get(11) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(11)).append(":");
        if (value.get(12) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(12)).append(":");
        if (value.get(13) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(13)).append(".");
        if (value.get(14) < 10) {
            dateString.append("0");
        }
        if (value.get(14) < 100) {
            dateString.append("0");
        }
        dateString.append(value.get(14));
    }

    private static void appendDate(StringBuffer dateString, Calendar calendar) {
        int year = calendar.get(1);
        if (year < 1000) {
            dateString.append("0");
        }
        if (year < 100) {
            dateString.append("0");
        }
        if (year < 10) {
            dateString.append("0");
        }
        dateString.append(year).append("-");
        int month = calendar.get(2) + 1;
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month).append("-");
        if (calendar.get(5) < 10) {
            dateString.append("0");
        }
        dateString.append(calendar.get(5));
    }
}

