/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.jdbc.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;
import org.ballerinax.jdbc.Constants;
import org.ballerinax.jdbc.datasource.SQLDatasource;
import org.ballerinax.jdbc.exceptions.ApplicationException;
import org.ballerinax.jdbc.exceptions.ErrorGenerator;
import org.ballerinax.jdbc.statement.AbstractSQLStatement;
import org.ballerinax.jdbc.statement.ProcessedStatement;

public class UpdateStatement
extends AbstractSQLStatement {
    private final ObjectValue client;
    private final SQLDatasource datasource;
    private final String query;
    private final ArrayValue parameters;
    private final boolean isKeyRetrievalSupported;
    private static final BMapType anydataMapType = new BMapType(BTypes.typeAnydata);

    public UpdateStatement(ObjectValue client, SQLDatasource datasource, String query, ArrayValue parameters, Strand strand) {
        super(strand);
        this.client = client;
        this.datasource = datasource;
        this.query = query;
        this.parameters = parameters;
        this.isKeyRetrievalSupported = this.isKeyRetrievalSupportedStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object execute() {
        MapValue<String, Object> mapValue;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.checkAndObserveSQLAction(this.strand, this.datasource, this.query);
        boolean isInTransaction = this.strand.isInTransaction();
        String errorMessagePrefix = "failed to execute update query: ";
        try {
            ArrayValue generatedParams = this.constructParameters(this.parameters);
            conn = this.getDatabaseConnection(this.strand, this.client, this.datasource);
            String processedQuery = this.createProcessedQueryString(this.query, generatedParams);
            stmt = this.isKeyRetrievalSupported ? conn.prepareStatement(processedQuery, 1) : conn.prepareStatement(processedQuery);
            ProcessedStatement processedStatement = new ProcessedStatement(conn, stmt, generatedParams, this.datasource.getDatabaseProductName());
            stmt = processedStatement.prepare();
            int count = stmt.executeUpdate();
            MapValueImpl generatedKeys = this.isKeyRetrievalSupported ? ((rs = stmt.getGeneratedKeys()).next() ? this.getGeneratedKeys(rs) : new MapValueImpl()) : new MapValueImpl();
            mapValue = this.createFrozenUpdateResultRecord(count, (MapValue<String, Object>)generatedKeys);
            this.cleanupResources(rs, stmt, conn, !isInTransaction);
        }
        catch (SQLException e) {
            this.handleErrorOnTransaction(this.strand);
            this.checkAndObserveSQLError(this.strand, "execute update failed: " + e.getMessage());
            ErrorValue errorValue = ErrorGenerator.getSQLDatabaseError(e, errorMessagePrefix);
            this.cleanupResources(rs, stmt, conn, !isInTransaction);
            return errorValue;
        }
        catch (ApplicationException e2) {
            this.handleErrorOnTransaction(this.strand);
            this.checkAndObserveSQLError(this.strand, "execute update failed: " + e2.getMessage());
            ErrorValue errorValue = ErrorGenerator.getSQLApplicationError(e2, errorMessagePrefix);
            this.cleanupResources(rs, stmt, conn, !isInTransaction);
            {
                catch (Throwable throwable) {
                    this.cleanupResources(rs, stmt, conn, !isInTransaction);
                    throw throwable;
                }
            }
            return errorValue;
        }
        return mapValue;
    }

    private MapValue<String, Object> getGeneratedKeys(ResultSet rs) throws SQLException {
        MapValueImpl generatedKeys = new MapValueImpl((BType)anydataMapType);
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnLabel(i);
            Object value = this.extractValueFromResultSet(metaData, rs, i);
            generatedKeys.put((Object)columnName, value);
        }
        return generatedKeys;
    }

    private MapValue<String, Object> createFrozenUpdateResultRecord(int count, MapValue<String, Object> generatedKeys) {
        MapValue updateResultRecord = BallerinaValues.createRecordValue((BPackage)Constants.JDBC_PACKAGE_ID, (String)"UpdateResult");
        MapValue populatedUpdateResultRecord = BallerinaValues.createRecord((MapValue)updateResultRecord, (Object[])new Object[]{count, generatedKeys});
        populatedUpdateResultRecord.attemptFreeze(new Status(State.FROZEN));
        return populatedUpdateResultRecord;
    }

    private boolean isKeyRetrievalSupportedStatement() {
        if (!this.datasource.supportsGetGeneratedKeys()) {
            return false;
        }
        String query = this.query.trim().toUpperCase(Locale.ENGLISH);
        return Arrays.stream(GenKeyStmt.values()).anyMatch(stmt -> query.startsWith(stmt.name()));
    }

    private static enum GenKeyStmt {
        INSERT,
        DELETE,
        UPDATE,
        MERGE;

    }
}

