/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.session;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.jms.AbstractBlockinAction;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="createTextMessage", receiver=@Receiver(type=TypeKind.STRUCT, structType="Session", structPackage="ballerina.jms"), args={@Argument(name="content", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRUCT, structPackage="ballerina.jms", structType="Message")}, isPublic=true)
public class CreateTextMessage
extends AbstractBlockinAction {
    public static final Logger LOGGER = LoggerFactory.getLogger(CreateTextMessage.class);

    public void execute(Context context, CallableUnitCallback callableUnitCallback) {
        Struct sessionBObject = BallerinaAdapter.getReceiverObject(context);
        Session session = BallerinaAdapter.getNativeObject(sessionBObject, "jms_session_object", Session.class, context);
        String content = context.getStringArgument(0);
        BStruct bStruct = BLangConnectorSPIUtil.createBStruct((Context)context, (String)"ballerina.jms", (String)"Message", (Object[])new Object[0]);
        try {
            TextMessage jmsMessage = session.createTextMessage(content);
            bStruct.addNativeData("jms_message_object", (Object)jmsMessage);
        }
        catch (JMSException e) {
            BallerinaAdapter.returnError("Failed to create message.", context, e);
        }
        context.setReturnValues(new BValue[]{bStruct});
    }
}

