/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.common;

import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.jms.nativeimpl.endpoint.common.SessionConnector;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveActionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveActionHandler.class);

    private ReceiveActionHandler() {
    }

    public static void handle(Context context) {
        Struct connectorBObject = BallerinaAdapter.getReceiverObject(context);
        MessageConsumer messageConsumer = BallerinaAdapter.getNativeObject(connectorBObject, "jms_consumer_object", MessageConsumer.class, context);
        SessionConnector sessionConnector = BallerinaAdapter.getNativeObject(connectorBObject, "jms_session_connector_object", SessionConnector.class, context);
        long timeInMilliSeconds = context.getIntArgument(0);
        try {
            sessionConnector.handleTransactionBlock(context);
            Message message = messageConsumer.receive(timeInMilliSeconds);
            if (Objects.nonNull(message)) {
                BStruct messageBObject = BLangConnectorSPIUtil.createBStruct((Context)context, (String)"ballerina.jms", (String)"Message", (Object[])new Object[0]);
                messageBObject.addNativeData("jms_message_object", (Object)message);
                context.setReturnValues(new BValue[]{messageBObject});
            } else {
                context.setReturnValues(new BValue[0]);
            }
        }
        catch (JMSException e) {
            BallerinaAdapter.returnError("Message receiving failed.", context, e);
        }
    }
}

