/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.common;

import java.util.Objects;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.ballerinalang.bre.Context;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.transactions.BallerinaTransactionContext;
import org.ballerinalang.util.transactions.LocalTransactionInfo;
import org.ballerinalang.util.transactions.TransactionResourceManager;

public class SessionConnector
implements BallerinaTransactionContext {
    private final String connectorId;
    private Session session;

    public SessionConnector(Session session) {
        this.session = session;
        this.connectorId = UUID.randomUUID().toString();
    }

    private String getConnectorId() {
        return this.connectorId;
    }

    public Session getSession() {
        return this.session;
    }

    public void commit() {
        try {
            if (this.session.getAcknowledgeMode() == 0) {
                this.session.commit();
            }
        }
        catch (JMSException e) {
            throw new BallerinaException("transaction commit failed: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void rollback() {
        try {
            if (this.session.getAcknowledgeMode() == 0) {
                this.session.commit();
            }
        }
        catch (JMSException e) {
            throw new BallerinaException("transaction rollback failed: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void close() {
    }

    public void done() {
    }

    public XAResource getXAResource() {
        if (this.session instanceof XASession) {
            return ((XASession)this.session).getXAResource();
        }
        return null;
    }

    public void handleTransactionBlock(Context context) throws JMSException {
        if (this.getSession().getAcknowledgeMode() == 0) {
            if (!context.isInTransaction()) {
                throw new BallerinaException("jms transacted session objects should be used inside a transaction block ", context);
            }
            LocalTransactionInfo localTransactionInfo = context.getLocalTransactionInfo();
            BallerinaTransactionContext txContext = localTransactionInfo.getTransactionContext(this.getConnectorId());
            if (Objects.isNull(txContext)) {
                localTransactionInfo.registerTransactionContext(this.getConnectorId(), (BallerinaTransactionContext)this);
                String globalTxId = localTransactionInfo.getGlobalTransactionId();
                int currentTxBlockId = localTransactionInfo.getCurrentTransactionBlockId();
                TransactionResourceManager.getInstance().register(globalTxId, currentTxBlockId, (BallerinaTransactionContext)this);
            }
        }
    }
}

