/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.topic.subscriber;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.jms.AbstractBlockinAction;
import org.ballerinalang.net.jms.JMSUtils;
import org.ballerinalang.net.jms.nativeimpl.endpoint.common.SessionConnector;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="createSubscriber", receiver=@Receiver(type=TypeKind.STRUCT, structType="TopicSubscriber", structPackage="ballerina.jms"), args={@Argument(name="session", type=TypeKind.STRUCT, structType="Session"), @Argument(name="messageSelector", type=TypeKind.STRING)}, isPublic=true)
public class CreateSubscriber
extends AbstractBlockinAction {
    public void execute(Context context, CallableUnitCallback callback) {
        Struct topicSubscriberBObject = BallerinaAdapter.getReceiverObject(context);
        BStruct sessionBObject = (BStruct)context.getRefArgument(1);
        String messageSelector = context.getStringArgument(0);
        Session session = BallerinaAdapter.getNativeObject(sessionBObject, "jms_session_object", Session.class, context);
        Struct topicSubscriberConfigBRecord = topicSubscriberBObject.getStructField("config");
        String topicPattern = topicSubscriberConfigBRecord.getStringField("topicPattern");
        try {
            Topic topic = JMSUtils.getTopic(session, topicPattern);
            MessageConsumer consumer = session.createConsumer((Destination)topic, messageSelector);
            Struct consumerConnectorBObject = topicSubscriberBObject.getStructField("consumerActions");
            consumerConnectorBObject.addNativeData("jms_consumer_object", (Object)consumer);
            consumerConnectorBObject.addNativeData("jms_session_connector_object", (Object)new SessionConnector(session));
        }
        catch (JMSException e) {
            BallerinaAdapter.throwBallerinaException("Error while creating Qeueu consumer", context, e);
        }
    }
}

