/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.utils;

import javax.jms.JMSException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallerinaAdapter {
    private static final String ERROR_RECORD_PACKAGE = "ballerina.builtin";
    private static final String ERROR_RECORD_NAME = "error";
    private static final Logger LOGGER = LoggerFactory.getLogger(BallerinaAdapter.class);

    private BallerinaAdapter() {
    }

    public static Struct getReceiverObject(Context context) {
        return BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
    }

    public static <T> T getNativeObject(Struct struct, String objectId, Class<T> objectClass, Context context) {
        Object messageNativeData = struct.getNativeData(objectId);
        return BallerinaAdapter.verifyNativeObject(context, struct.getName(), objectClass, messageNativeData);
    }

    public static <T> T getNativeObject(BStruct struct, String objectId, Class<T> objectClass, Context context) {
        Object messageNativeData = struct.getNativeData(objectId);
        return BallerinaAdapter.verifyNativeObject(context, struct.getType().getName(), objectClass, messageNativeData);
    }

    private static <T> T verifyNativeObject(Context context, String structName, Class<T> objectClass, Object nativeData) {
        if (!objectClass.isInstance(nativeData)) {
            throw new BallerinaException(structName + " is not properly initialized.", context);
        }
        return objectClass.cast(nativeData);
    }

    public static void throwBallerinaException(String message, Context context, Throwable throwable) {
        LOGGER.error(message, throwable);
        throw new BallerinaException(message + " " + throwable.getMessage(), throwable, context);
    }

    private static BStruct createErrorRecord(Context context, String errorMsg, JMSException e) {
        BStruct errorStruct = BLangConnectorSPIUtil.createBStruct((Context)context, (String)ERROR_RECORD_PACKAGE, (String)ERROR_RECORD_NAME, (Object[])new Object[0]);
        errorStruct.setStringField(0, errorMsg + " " + e.getMessage());
        return errorStruct;
    }

    public static void returnError(String errorMessage, Context context, JMSException e) {
        LOGGER.error(errorMessage, (Throwable)e);
        BStruct errorRecord = BallerinaAdapter.createErrorRecord(context, errorMessage, e);
        context.setReturnValues(new BValue[]{errorRecord});
    }
}

