/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.queue.receiver;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.jms.nativeimpl.endpoint.common.SessionConnector;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="createQueueReceiver", receiver=@Receiver(type=TypeKind.STRUCT, structType="QueueReceiver", structPackage="ballerina.jms"), args={@Argument(name="session", type=TypeKind.STRUCT, structType="Session"), @Argument(name="messageSelector", type=TypeKind.STRING)}, isPublic=true)
public class CreateConsumer
implements NativeCallableUnit {
    public void execute(Context context, CallableUnitCallback callableUnitCallback) {
        Struct queueConsumerBObject = BallerinaAdapter.getReceiverObject(context);
        BStruct sessionBObject = (BStruct)context.getRefArgument(1);
        String messageSelector = context.getStringArgument(0);
        Session session = BallerinaAdapter.getNativeObject(sessionBObject, "jms_session_object", Session.class, context);
        Struct queueConsumerConfigBRecord = queueConsumerBObject.getStructField("config");
        String queueName = queueConsumerConfigBRecord.getStringField("queueName");
        try {
            Queue queue = session.createQueue(queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue, messageSelector);
            Struct consumerConnectorBObject = queueConsumerBObject.getStructField("consumerActions");
            consumerConnectorBObject.addNativeData("jms_consumer_object", (Object)consumer);
            consumerConnectorBObject.addNativeData("jms_session_connector_object", (Object)new SessionConnector(session));
        }
        catch (JMSException e) {
            BallerinaAdapter.throwBallerinaException("Error while creating queue consumer.", context, e);
        }
    }

    public boolean isBlocking() {
        return true;
    }
}

