/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm;

import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;

public class ASMUtil {
    public static final String CLASS_WRITER = "ClassWriter";
    public static final String METHOD_VISITOR = "MethodVisitor";
    public static final String FIELD_VISITOR = "FieldVisitor";
    public static final String LABEL = "Label";
    public static final String JVM_PKG_PATH = "ballerina/jvm";
    public static final String NATIVE_KEY = "native";
    public static final String INTEROP_VALIDATOR = "InteropValidator";
    public static final String OBJECT_DESC = "Ljava/lang/Object;";
    public static final String FUNCTION_DESC = "Ljava/util/function/Function;";
    public static final String STRING_DESC = "Ljava/lang/String;";
    public static final String METHOD_TYPE_DESC = "Ljava/lang/invoke/MethodType;";
    public static final String MAP_VALUE_DESC = "Lorg/ballerinalang/jvm/values/MapValue;";

    public static ObjectValue newObject(String type) {
        return BallerinaValues.createObjectValue((String)JVM_PKG_PATH, (String)type, (Object[])new Object[0]);
    }

    public static <T> T getRefArgumentNativeData(ObjectValue objectValue) {
        return (T)objectValue.getNativeData().get(NATIVE_KEY);
    }

    public static void addNativeDataToObject(Object data, ObjectValue objectValue) {
        objectValue.addNativeData(NATIVE_KEY, data);
    }

    public static String[] fromNilableStringArray(Object optArray) {
        return optArray == null ? null : ((ArrayValue)optArray).getStringArray();
    }
}

