/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.util.ArrayList;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.nativeimpl.jvm.interop.JInteropException;
import org.ballerinalang.nativeimpl.jvm.interop.JMethod;
import org.ballerinalang.nativeimpl.jvm.interop.ParamTypeConstraint;

class JInterop {
    static final String ORG_NAME = "ballerina";
    static final String BALLERINA_X_ORG_NAME = "ballerinax";
    static final String MODULE_NAME = "jvm";
    static final String JAVA_MODULE_NAME = "java";
    static final String JVM_PACKAGE_PATH = "ballerina/jvm";
    static final String ERROR_REASON_PREFIX = "{ballerinax/java}";
    static final String PARAM_TYPE_CONSTRAINTS_FIELD = "paramTypeConstraints";
    static final String CLASS_FIELD = "class";
    static final String NAME_FIELD = "name";
    static final String KIND_FIELD = "kind";
    static final String IS_INTERFACE_FIELD = "isInterface";
    static final String IS_ARRAY_FIELD = "isArray";
    static final String IS_STATIC_FIELD = "isStatic";
    static final String REST_PARAM_EXIST_FIELD = "restParamExist";
    static final String SIG_FIELD = "sig";
    static final String METHOD_TYPE_FIELD = "mType";
    static final String FIELD_TYPE_FIELD = "fType";
    static final String PARAM_TYPES_FIELD = "paramTypes";
    static final String RETURN_TYPE_FIELD = "retType";
    static final String METHOD_FIELD = "method";
    static final String TAG_FIELD = "tag";
    static final String HANDLE_TYPE_NAME = "handle";
    static final String METHOD_TYPE_NAME = "Method";
    static final String FIELD_TYPE_NAME = "Field";
    static final String METHOD_TYPE_TYPE_NAME = "Method";
    static final String J_REF_TYPE_NAME = "RefType";
    static final String TYPE_NAME_FIELD = "typeName";
    static final String NO_TYPE_NAME = "NoType";
    static final String METHOD_THROWS_FIELD = "throws";
    static final String B_FUNC_TYPE_FIELD = "bFuncType";
    static final String J_ARRAY_TYPE_NAME = "ArrayType";
    static final String ELEMENT_TYPE_FIELD = "elementType";
    static final String DIMENSIONS_FIELD = "dimensions";
    static final String UNION_TYPE_MEMBERS_FIELD = "members";
    static final String TUPLE_TYPE_MEMBERS_FIELD = "tupleTypes";
    static final String ARRAY_ELEMENT_TYPE_FIELD = "eType";
    static final String CLASS_LOADER_DATA = "class_loader";
    static final String RECORD_TNAME = "record";
    static final String OBJECT_TNAME = "object";
    static final String UNION_TNAME = "union";
    static final String TUPLE_TNAME = "tuple";
    static final String ARRAY_TNAME = "array";
    static final String J_OBJECT_TNAME = Object.class.getTypeName();
    static final String J_BOOLEAN_OBJ_TNAME = Boolean.class.getTypeName();
    static final String J_INTEGER_OBJ_TNAME = Integer.class.getTypeName();
    static final String J_BYTE_OBJ_TNAME = Byte.class.getTypeName();
    static final String J_LONG_OBJ_TNAME = Long.class.getTypeName();
    static final String J_DOUBLE_OBJ_TNAME = Double.class.getTypeName();
    static final String J_FLOAT_OBJ_TNAME = Float.class.getTypeName();
    static final String J_PRIMITIVE_INT_TNAME = Integer.TYPE.getTypeName();
    static final String J_PRIMITIVE_LONG_TNAME = Long.TYPE.getTypeName();
    static final String J_PRIMITIVE_BYTE_TNAME = Byte.TYPE.getTypeName();
    static final String J_PRIMITIVE_SHORT_TNAME = Short.TYPE.getTypeName();
    static final String J_PRIMITIVE_CHAR_TNAME = Character.TYPE.getTypeName();
    static final String J_PRIMITIVE_FLOAT_TNAME = Float.TYPE.getTypeName();
    static final String J_PRIMITIVE_DOUBLE_TNAME = Double.TYPE.getTypeName();
    static final String J_PRIMITIVE_BOOLEAN_TNAME = Boolean.TYPE.getTypeName();
    static final String J_VOID_TNAME = Void.TYPE.getTypeName();

    JInterop() {
    }

    static MapValue<String, Object> createRecordBValue(String typeName) {
        return BallerinaValues.createRecordValue((String)JVM_PACKAGE_PATH, (String)typeName);
    }

    static MapValue<String, Object> createJMethodTypeBValue(JMethod jMethod) {
        MapValue<String, Object> jMethodTypeBRecord = JInterop.createRecordBValue("Method");
        ArrayValue paramBTypeArray = new ArrayValue(BTypes.typeAnydata);
        Class<?>[] paramClassTypes = jMethod.getParamTypes();
        for (int paramIndex = 0; paramIndex < paramClassTypes.length; ++paramIndex) {
            Class<?> paramClassType = paramClassTypes[paramIndex];
            Object jParamType = JInterop.createJTypeBValue(paramClassType);
            paramBTypeArray.add((long)paramIndex, jParamType);
        }
        jMethodTypeBRecord.put((Object)PARAM_TYPES_FIELD, (Object)paramBTypeArray);
        Class<?> retClassType = jMethod.getReturnType();
        jMethodTypeBRecord.put((Object)RETURN_TYPE_FIELD, JInterop.createJTypeBValue(retClassType));
        return jMethodTypeBRecord;
    }

    static Object createJTypeBValue(Class<?> jTypeClass) {
        if (jTypeClass.isPrimitive()) {
            return jTypeClass.getName();
        }
        if (jTypeClass == Void.class) {
            throw new IllegalArgumentException("The Java Void type is not yet supported.");
        }
        if (jTypeClass.isArray()) {
            MapValue<String, Object> jArrayTypeBRecord = JInterop.createRecordBValue(J_ARRAY_TYPE_NAME);
            jArrayTypeBRecord.put((Object)ELEMENT_TYPE_FIELD, JInterop.createJTypeBValue(jTypeClass.getComponentType()));
            return jArrayTypeBRecord;
        }
        MapValue<String, Object> jRefTypeBRecord = JInterop.createRecordBValue(J_REF_TYPE_NAME);
        jRefTypeBRecord.put((Object)TAG_FIELD, (Object)J_REF_TYPE_NAME);
        jRefTypeBRecord.put((Object)TYPE_NAME_FIELD, (Object)jTypeClass.getName().replace('.', '/'));
        jRefTypeBRecord.put((Object)IS_INTERFACE_FIELD, (Object)jTypeClass.isInterface());
        jRefTypeBRecord.put((Object)IS_ARRAY_FIELD, (Object)jTypeClass.isArray());
        return jRefTypeBRecord;
    }

    static String getMethodSig(Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Class<?> type : parameterTypes) {
            sb.append(JInterop.getSig(type));
        }
        sb.append(')');
        return sb.append(JInterop.getSig(returnType)).toString();
    }

    static String getSig(Class<?> c) {
        if (c.isPrimitive()) {
            if (Integer.TYPE == c) {
                return "I";
            }
            if (Long.TYPE == c) {
                return "J";
            }
            if (Boolean.TYPE == c) {
                return "Z";
            }
            if (Byte.TYPE == c) {
                return "B";
            }
            if (Short.TYPE == c) {
                return "S";
            }
            if (Character.TYPE == c) {
                return "C";
            }
            if (Float.TYPE == c) {
                return "F";
            }
            if (Double.TYPE == c) {
                return "D";
            }
            return "V";
        }
        if (Void.TYPE == c || Void.class == c) {
            return "V";
        }
        String className = c.getName().replace('.', '/');
        if (c.isArray()) {
            return className;
        }
        return 'L' + className + ';';
    }

    static boolean isHandleType(Object bValue) {
        if (bValue instanceof MapValue) {
            MapValue bTypeValue = (MapValue)bValue;
            String handleTypeName = (String)bTypeValue.get((Object)TYPE_NAME_FIELD);
            return handleTypeName.equals(HANDLE_TYPE_NAME);
        }
        return false;
    }

    static ParamTypeConstraint[] buildParamTypeConstraints(ArrayValue javaTypeConstraints, ClassLoader classLoader) {
        if (javaTypeConstraints == null) {
            return new ParamTypeConstraint[0];
        }
        ArrayList<ParamTypeConstraint> constraintList = new ArrayList<ParamTypeConstraint>();
        for (int paramIndex = 0; paramIndex < javaTypeConstraints.size(); ++paramIndex) {
            Object javaTypeConstraint = javaTypeConstraints.get((long)paramIndex);
            constraintList.add(JInterop.buildParamTypeConstraint(javaTypeConstraint, classLoader));
        }
        return constraintList.toArray(new ParamTypeConstraint[0]);
    }

    private static ParamTypeConstraint buildParamTypeConstraint(Object javaTypeConstraint, ClassLoader classLoader) {
        if (JInterop.isJavaRefType(javaTypeConstraint)) {
            return JInterop.buildConstraintFromJavaRefType((MapValue<String, Object>)((MapValue)javaTypeConstraint), classLoader);
        }
        if (JInterop.isJavaArrayType(javaTypeConstraint)) {
            return JInterop.buildConstraintFromJavaArrayType((MapValue<String, Object>)((MapValue)javaTypeConstraint), classLoader);
        }
        if (JInterop.isJavaNoType(javaTypeConstraint)) {
            return ParamTypeConstraint.NO_CONSTRAINT;
        }
        return JInterop.buildConstraintFromJavaPrimitiveType((String)javaTypeConstraint);
    }

    private static ParamTypeConstraint buildConstraintFromJavaRefType(MapValue<String, Object> javaRefType, ClassLoader classLoader) {
        String constraintBValue = (String)javaRefType.get((Object)TYPE_NAME_FIELD);
        return new ParamTypeConstraint(JInterop.loadClass(constraintBValue, classLoader));
    }

    private static ParamTypeConstraint buildConstraintFromJavaArrayType(MapValue<String, Object> javaRefType, ClassLoader classLoader) {
        String typeSig = JInterop.getJavaArrayTypeSig(javaRefType);
        return new ParamTypeConstraint(JInterop.loadClass(typeSig, classLoader));
    }

    private static String getJavaArrayTypeSig(MapValue<String, Object> javaRefType) {
        MapValue jRefTypeBValue;
        String tagValue;
        Object elementType = javaRefType.get((Object)ELEMENT_TYPE_FIELD);
        String elementTypeSig = "[";
        elementTypeSig = elementType instanceof MapValue ? ((tagValue = (String)(jRefTypeBValue = (MapValue)elementType).get((Object)TAG_FIELD)).equals(J_REF_TYPE_NAME) ? elementTypeSig + "L" + (String)jRefTypeBValue.get((Object)TYPE_NAME_FIELD) + ";" : elementTypeSig + JInterop.getJavaArrayTypeSig((MapValue<String, Object>)jRefTypeBValue)) : elementTypeSig + JInterop.getSignatureFromJavaPrimitiveType((String)elementType);
        return elementTypeSig;
    }

    private static ParamTypeConstraint buildConstraintFromJavaPrimitiveType(String primitiveTypeName) {
        Class<Comparable<Byte>> constraintClass;
        switch (primitiveTypeName) {
            case "byte": {
                constraintClass = Byte.TYPE;
                break;
            }
            case "short": {
                constraintClass = Short.TYPE;
                break;
            }
            case "char": {
                constraintClass = Character.TYPE;
                break;
            }
            case "int": {
                constraintClass = Integer.TYPE;
                break;
            }
            case "long": {
                constraintClass = Long.TYPE;
                break;
            }
            case "float": {
                constraintClass = Float.TYPE;
                break;
            }
            case "double": {
                constraintClass = Double.TYPE;
                break;
            }
            case "boolean": {
                constraintClass = Boolean.TYPE;
                break;
            }
            default: {
                throw new JInteropException("UNSUPPORTED_PRIMITIVE_TYPE", "Unsupported Java primitive type '" + primitiveTypeName + "'");
            }
        }
        return new ParamTypeConstraint(constraintClass);
    }

    private static String getSignatureFromJavaPrimitiveType(String primitiveTypeName) {
        switch (primitiveTypeName) {
            case "byte": {
                return "B";
            }
            case "short": {
                return "S";
            }
            case "char": {
                return "C";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "float": {
                return "F";
            }
            case "double": {
                return "D";
            }
            case "boolean": {
                return "Z";
            }
        }
        throw new JInteropException("UNSUPPORTED_PRIMITIVE_TYPE", "Unsupported Java primitive type '" + primitiveTypeName + "'");
    }

    private static boolean isJavaRefType(Object javaTypeConstraint) {
        if (javaTypeConstraint instanceof MapValue) {
            MapValue jRefTypeBValue = (MapValue)javaTypeConstraint;
            String tagValue = (String)jRefTypeBValue.get((Object)TAG_FIELD);
            return tagValue != null && tagValue.equals(J_REF_TYPE_NAME);
        }
        return false;
    }

    private static boolean isJavaArrayType(Object javaTypeConstraint) {
        if (javaTypeConstraint instanceof MapValue) {
            MapValue jRefTypeBValue = (MapValue)javaTypeConstraint;
            String tagValue = (String)jRefTypeBValue.get((Object)TAG_FIELD);
            return tagValue != null && tagValue.equals(J_ARRAY_TYPE_NAME);
        }
        return false;
    }

    private static boolean isJavaNoType(Object javaTypeConstraint) {
        if (javaTypeConstraint instanceof String) {
            String javaNoTypeBValue = (String)javaTypeConstraint;
            return javaNoTypeBValue.equals(NO_TYPE_NAME);
        }
        return false;
    }

    static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className.replace("/", "."), false, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException("CLASS_NOT_FOUND", e.getMessage(), e);
        }
    }

    static ErrorValue createErrorBValue(String reason, String details) {
        MapValueImpl refData = new MapValueImpl(BTypes.typeError.detailType);
        if (details != null) {
            refData.put((Object)"message", (Object)details);
        } else {
            refData.put((Object)"message", (Object)"");
        }
        return new ErrorValue((BType)BTypes.typeError, ERROR_REASON_PREFIX + reason, (Object)refData);
    }
}

