/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.nativeimpl.jvm.interop.JInterop;
import org.ballerinalang.nativeimpl.jvm.interop.JInteropException;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodKind;

class JMethod {
    static final JMethod NO_SUCH_METHOD = new JMethod(null, null);
    private JMethodKind kind;
    private Executable method;

    static JMethod build(JMethodKind kind, Executable executable) {
        return new JMethod(kind, executable);
    }

    private JMethod(JMethodKind kind, Executable executable) {
        this.kind = kind;
        this.method = executable;
    }

    String getClassName() {
        return this.method.getDeclaringClass().getName();
    }

    boolean isDeclaringClassInterface() {
        return this.method.getDeclaringClass().isInterface();
    }

    boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    boolean isInstanceMethod() {
        return !this.isStatic() && !(this.method instanceof Constructor);
    }

    String getName() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return "<init>";
        }
        return this.method.getName();
    }

    JMethodKind getKind() {
        return this.kind;
    }

    Executable getMethod() {
        return this.method;
    }

    String getSignature() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return JInterop.getMethodSig(Void.TYPE, this.method.getParameterTypes());
        }
        return JInterop.getMethodSig(this.getReturnType(), this.method.getParameterTypes());
    }

    Class<?>[] getParamTypes() {
        return this.method.getParameterTypes();
    }

    Class<?> getReturnType() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return this.method.getDeclaringClass();
        }
        return ((Method)this.method).getReturnType();
    }

    /*
     * WARNING - void declaration
     */
    ArrayValue getExceptionTypes(ClassLoader classLoader) {
        ArrayList checkedExceptions = new ArrayList();
        try {
            void var6_10;
            Class<?> runtimeException = classLoader.loadClass(RuntimeException.class.getCanonicalName());
            Class<?>[] classArray = this.method.getExceptionTypes();
            int n = classArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Class<?> exceptionType = classArray[var6_10];
                if (!runtimeException.isAssignableFrom(exceptionType)) {
                    checkedExceptions.add(exceptionType);
                }
                ++var6_10;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException("CLASS_NOT_FOUND", e.getMessage(), e);
        }
        ArrayValue arrayValue = new ArrayValue((BType)new BArrayType(BTypes.typeString), (long)checkedExceptions.size());
        int i = 0;
        for (Class clazz : checkedExceptions) {
            arrayValue.add((long)i++, clazz.getName().replace(".", "/"));
        }
        return arrayValue;
    }
}

