/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.StreamValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.nativeimpl.jvm.interop.JInterop;
import org.ballerinalang.nativeimpl.jvm.interop.JInteropException;
import org.ballerinalang.nativeimpl.jvm.interop.JMethod;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodKind;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodRequest;
import org.ballerinalang.nativeimpl.jvm.interop.ParamTypeConstraint;

class JMethodResolver {
    private ClassLoader classLoader;

    JMethodResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    JMethod resolve(JMethodRequest jMethodRequest) {
        List<JMethod> jMethods = this.resolveByMethodName(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind);
        if (jMethods.isEmpty()) {
            throw this.getMethodNotFoundError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName);
        }
        int paramCount = this.getBFuncParamCount(jMethodRequest, jMethods);
        if ((jMethods = this.resolveByParamCount(jMethods, paramCount)).isEmpty()) {
            throw this.getMethodNotFoundError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, paramCount);
        }
        JMethod jMethod = this.resolve(jMethodRequest, jMethods);
        this.validateMethodSignature(jMethodRequest, jMethod);
        return jMethod;
    }

    private List<JMethod> resolveByMethodName(Class<?> declaringClass, String methodName, JMethodKind kind) {
        return this.getExecutables(declaringClass, methodName, kind).stream().map(executable -> JMethod.build(kind, executable)).collect(Collectors.toList());
    }

    private List<JMethod> resolveByParamCount(List<JMethod> jMethods, int paramCount) {
        return jMethods.stream().filter(jMethod -> jMethod.getParamTypes().length == paramCount).collect(Collectors.toList());
    }

    private JMethod resolve(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        boolean noConstraints = this.noConstraintsSpecified(jMethodRequest.paramTypeConstraints);
        if (jMethods.size() == 1 && noConstraints) {
            return jMethods.get(0);
        }
        if (noConstraints) {
            int paramCount = jMethods.get(0).getParamTypes().length;
            throw this.getOverloadedMethodExistError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, paramCount);
        }
        JMethod jMethod = this.resolveExactMethod(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind, jMethodRequest.paramTypeConstraints);
        if (jMethod == JMethod.NO_SUCH_METHOD) {
            return this.resolveMatchingMethod(jMethodRequest, jMethods);
        }
        return jMethod;
    }

    private void validateMethodSignature(JMethodRequest jMethodRequest, JMethod jMethod) {
        this.validateExceptionTypes(jMethodRequest, jMethod);
        this.validateArgumentTypes(jMethodRequest, jMethod);
        this.validateReturnTypes(jMethodRequest, jMethod);
    }

    private void validateExceptionTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        boolean returnsErrorValue;
        Executable method = jMethod.getMethod();
        boolean throwsCheckedException = false;
        try {
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (this.classLoader.loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom(exceptionType)) continue;
                throwsCheckedException = true;
                break;
            }
            returnsErrorValue = method instanceof Method && (this.classLoader.loadClass(ErrorValue.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()) || this.classLoader.loadClass(Object.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException("CLASS_NOT_FOUND", e.getMessage(), e);
        }
        if (throwsCheckedException && !jMethodRequest.returnsBErrorType || jMethodRequest.returnsBErrorType && !throwsCheckedException && !returnsErrorValue) {
            throw new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "No such Java method '" + jMethodRequest.methodName + "' which throws checked exception found in class '" + jMethodRequest.declaringClass + "'");
        }
    }

    private void validateArgumentTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        Class<?>[] jParamTypes = jMethod.getParamTypes();
        BType[] bParamTypes = jMethodRequest.bParamTypes;
        int i = 0;
        if (jMethod.isInstanceMethod() && bParamTypes.length > 0) {
            if (!this.isValidExpectedBType(jMethodRequest.declaringClass, bParamTypes[i], jMethodRequest)) {
                throw new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "No such Java method '" + jMethodRequest.methodName + "' with method argument type '" + jParamTypes[i] + "' found in class '" + jMethodRequest.declaringClass + "'");
            }
            i = 1;
        }
        for (int j = 0; j < jParamTypes.length; ++j) {
            if (!this.isValidExpectedBType(jParamTypes[j], bParamTypes[i], jMethodRequest)) {
                throw new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "No such Java method '" + jMethodRequest.methodName + "' with method argument type '" + jParamTypes[j] + "' found in class '" + jMethodRequest.declaringClass + "'");
            }
            ++i;
        }
    }

    private void validateReturnTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        BType bReturnType;
        Class<?> jReturnType = jMethod.getReturnType();
        if (!this.isValidExpectedBType(jReturnType, bReturnType = jMethodRequest.bReturnType, jMethodRequest)) {
            throw new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "No such Java method '" + jMethodRequest.methodName + "' with method return type '" + jReturnType + "' found in class '" + jMethodRequest.declaringClass + "'");
        }
    }

    private boolean isValidExpectedBType(Class<?> jParamType, BType bParamType, JMethodRequest jMethodRequest) {
        try {
            String jParamTypeName = jParamType.getTypeName();
            switch (bParamType.getTag()) {
                case 11: 
                case 17: 
                case 38: {
                    return !jParamType.isPrimitive();
                }
                case 10: {
                    return jParamTypeName.equals(JInterop.J_VOID_TNAME);
                }
                case 1: 
                case 2: 
                case 3: {
                    if (jParamTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (bParamType.getTag() == 1 && jParamTypeName.equals(JInterop.J_LONG_OBJ_TNAME)) {
                        return true;
                    }
                    if (bParamType.getTag() == 2 && jParamTypeName.equals(JInterop.J_INTEGER_OBJ_TNAME)) {
                        return true;
                    }
                    if (bParamType.getTag() == 3 && jParamTypeName.equals(JInterop.J_DOUBLE_OBJ_TNAME)) {
                        return true;
                    }
                    return jParamType.isPrimitive() && (jParamTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jParamTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jParamTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jParamTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jParamTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME) || jParamTypeName.equals(JInterop.J_PRIMITIVE_FLOAT_TNAME) || jParamTypeName.equals(JInterop.J_PRIMITIVE_DOUBLE_TNAME));
                }
                case 6: {
                    if (jParamTypeName.equals(JInterop.J_OBJECT_TNAME) || jParamTypeName.equals(JInterop.J_BOOLEAN_OBJ_TNAME)) {
                        return true;
                    }
                    return jParamType.isPrimitive() && jParamTypeName.equals(JInterop.J_PRIMITIVE_BOOLEAN_TNAME);
                }
                case 4: {
                    return this.classLoader.loadClass(BigDecimal.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 5: {
                    return this.classLoader.loadClass(String.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 7: 
                case 12: 
                case 15: {
                    return this.classLoader.loadClass(MapValue.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 19: 
                case 35: {
                    return this.classLoader.loadClass(ObjectValue.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 29: {
                    return this.classLoader.loadClass(ErrorValue.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 14: {
                    return this.classLoader.loadClass(StreamValue.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 9: {
                    return this.classLoader.loadClass(TableValue.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 8: {
                    return this.classLoader.loadClass(XMLValue.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 20: 
                case 31: {
                    if (jMethodRequest.restParamExist) {
                        return jParamType.isArray();
                    }
                    return this.classLoader.loadClass(ArrayValue.class.getCanonicalName()).isAssignableFrom(jParamType);
                }
                case 21: {
                    List members = ((BUnionType)bParamType).getMemberTypes();
                    for (BType member : members) {
                        if (!this.isValidExpectedBType(jParamType, member, jMethodRequest)) continue;
                        return true;
                    }
                    return !jParamType.isPrimitive();
                }
            }
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException("CLASS_NOT_FOUND", e.getMessage(), e);
        }
    }

    private JMethod resolveExactMethod(Class clazz, String name, JMethodKind kind, ParamTypeConstraint[] constraints) {
        Executable executable;
        Class[] paramTypes = new Class[constraints.length];
        for (int constraintIndex = 0; constraintIndex < constraints.length; ++constraintIndex) {
            paramTypes[constraintIndex] = constraints[constraintIndex].get();
        }
        Executable executable2 = executable = kind == JMethodKind.CONSTRUCTOR ? this.resolveConstructor(clazz, paramTypes) : this.resolveMethod(clazz, name, paramTypes);
        if (executable != null) {
            return JMethod.build(kind, kind == JMethodKind.CONSTRUCTOR ? this.resolveConstructor(clazz, paramTypes) : this.resolveMethod(clazz, name, paramTypes));
        }
        return JMethod.NO_SUCH_METHOD;
    }

    private JMethod resolveMatchingMethod(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        ParamTypeConstraint[] constraints = jMethodRequest.paramTypeConstraints;
        ArrayList<JMethod> resolvedJMethods = new ArrayList<JMethod>();
        for (JMethod jMethod : jMethods) {
            boolean resolved = true;
            Class<?>[] formalParamTypes = jMethod.getParamTypes();
            for (int paramIndex = 0; paramIndex < formalParamTypes.length; ++paramIndex) {
                Class<?> formalParamType = formalParamTypes[paramIndex];
                if (formalParamType.isAssignableFrom(constraints[paramIndex].get())) continue;
                resolved = false;
                break;
            }
            if (!resolved) continue;
            resolvedJMethods.add(jMethod);
        }
        if (resolvedJMethods.isEmpty()) {
            throw this.getMethodNotFoundError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, constraints);
        }
        if (resolvedJMethods.size() > 1) {
            throw this.getAmbiguousOverloadedMethodExistsError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, constraints);
        }
        return (JMethod)resolvedJMethods.get(0);
    }

    private Executable resolveConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Executable resolveMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private List<Executable> getExecutables(Class clazz, String methodName, JMethodKind kind) {
        return kind == JMethodKind.CONSTRUCTOR ? Arrays.asList(clazz.getConstructors()) : Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(methodName)).collect(Collectors.toList());
    }

    private boolean noConstraintsSpecified(ParamTypeConstraint[] constraints) {
        for (ParamTypeConstraint constraint : constraints) {
            if (constraint == ParamTypeConstraint.NO_CONSTRAINT) continue;
            return false;
        }
        return true;
    }

    private int getBFuncParamCount(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        int bFuncParamCount = jMethodRequest.bFuncParamCount;
        if (jMethodRequest.kind == JMethodKind.METHOD) {
            boolean isStaticMethod = jMethods.get(0).isStatic();
            bFuncParamCount = isStaticMethod ? bFuncParamCount : bFuncParamCount - 1;
        }
        return bFuncParamCount;
    }

    private JInteropException getMethodNotFoundError(JMethodKind kind, Class<?> declaringClass, String methodName) {
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("CONSTRUCTOR_NOT_FOUND", "No such public constructor found in class '" + declaringClass + "'");
        }
        return new JInteropException("METHOD_NOT_FOUND", "No such public method '" + methodName + "' found in class '" + declaringClass + "'");
    }

    private JInteropException getMethodNotFoundError(JMethodKind kind, Class<?> declaringClass, String methodName, int paramCount) {
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("CONSTRUCTOR_NOT_FOUND", "No such public constructor with '" + paramCount + "' parameter(s) found in class '" + declaringClass + "'");
        }
        return new JInteropException("METHOD_NOT_FOUND", "No such public method '" + methodName + "' with '" + paramCount + "' parameter(s) found in class '" + declaringClass + "'");
    }

    private JInteropException getMethodNotFoundError(JMethodKind kind, Class<?> declaringClass, String methodName, ParamTypeConstraint[] constraints) {
        String paramTypesSig = this.getParamTypesAsString(constraints);
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("CONSTRUCTOR_NOT_FOUND", "No such public constructor that matches with parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
        }
        return new JInteropException("METHOD_NOT_FOUND", "No such public method '" + methodName + "' that matches with parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
    }

    private JInteropException getOverloadedMethodExistError(JMethodKind kind, Class<?> declaringClass, String methodName, int paramCount) {
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("OVERLOADED_METHODS", "Overloaded constructors with '" + paramCount + "' parameter(s) in class '" + declaringClass + "', please specify class names for each parameter in 'paramTypes' field in the annotation");
        }
        return new JInteropException("OVERLOADED_METHODS", "Overloaded methods '" + methodName + "' with '" + paramCount + "' parameter(s) in class '" + declaringClass + "', please specify class names for each parameter with 'paramTypes' field in the annotation");
    }

    private JInteropException getAmbiguousOverloadedMethodExistsError(JMethodKind kind, Class<?> declaringClass, String methodName, ParamTypeConstraint[] constraints) {
        String paramTypesSig = this.getParamTypesAsString(constraints);
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("OVERLOADED_METHODS", "More than one public constructors that match with the parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
        }
        return new JInteropException("OVERLOADED_METHODS", "More than one public methods '" + methodName + "' that match with the parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
    }

    private String getParamTypesAsString(ParamTypeConstraint[] constraints) {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (ParamTypeConstraint paramTypeConstraint : constraints) {
            stringJoiner.add(paramTypeConstraint.get().getName());
        }
        return stringJoiner.toString();
    }
}

