/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BFiniteType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BDecimal;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.api.BFunctionPointer;
import org.ballerinalang.jvm.values.api.BFuture;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BObject;
import org.ballerinalang.jvm.values.api.BStream;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BTable;
import org.ballerinalang.jvm.values.api.BTypedesc;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.nativeimpl.jvm.interop.JInterop;
import org.ballerinalang.nativeimpl.jvm.interop.JInteropException;
import org.ballerinalang.nativeimpl.jvm.interop.JMethod;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodKind;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodRequest;
import org.ballerinalang.nativeimpl.jvm.interop.ParamTypeConstraint;

class JMethodResolver {
    private ClassLoader classLoader;
    private static final BType[] JSON_MEMBERS = new BType[]{BTypes.typeNull, BTypes.typeString, BTypes.typeInt, BTypes.typeFloat, BTypes.typeBoolean, new BMapType(BTypes.typeJSON), new BArrayType(BTypes.typeJSON)};

    JMethodResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    JMethod resolve(JMethodRequest jMethodRequest) {
        List<JMethod> jMethods = this.resolveByMethodName(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind);
        if (jMethods.isEmpty()) {
            throw this.getMethodNotFoundError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName);
        }
        int paramCount = this.getBFuncParamCount(jMethodRequest, jMethods);
        if ((jMethods = this.resolveByParamCount(jMethods, paramCount)).isEmpty()) {
            throw this.getMethodNotFoundError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, paramCount);
        }
        JMethod jMethod = this.resolve(jMethodRequest, jMethods);
        this.validateMethodSignature(jMethodRequest, jMethod);
        return jMethod;
    }

    private List<JMethod> resolveByMethodName(Class<?> declaringClass, String methodName, JMethodKind kind) {
        return this.getExecutables(declaringClass, methodName, kind).stream().map(executable -> JMethod.build(kind, executable)).collect(Collectors.toList());
    }

    private List<JMethod> resolveByParamCount(List<JMethod> jMethods, int paramCount) {
        return jMethods.stream().filter(jMethod -> jMethod.getParamTypes().length == paramCount).collect(Collectors.toList());
    }

    private JMethod resolve(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        boolean noConstraints = this.noConstraintsSpecified(jMethodRequest.paramTypeConstraints);
        if (jMethods.size() == 1 && noConstraints) {
            return jMethods.get(0);
        }
        if (noConstraints) {
            int paramCount = jMethods.get(0).getParamTypes().length;
            throw this.getOverloadedMethodExistError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, paramCount);
        }
        JMethod jMethod = this.resolveExactMethod(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind, jMethodRequest.paramTypeConstraints);
        if (jMethod == JMethod.NO_SUCH_METHOD) {
            return this.resolveMatchingMethod(jMethodRequest, jMethods);
        }
        return jMethod;
    }

    private void validateMethodSignature(JMethodRequest jMethodRequest, JMethod jMethod) {
        this.validateExceptionTypes(jMethodRequest, jMethod);
        this.validateArgumentTypes(jMethodRequest, jMethod);
        this.validateReturnTypes(jMethodRequest, jMethod);
    }

    private void validateExceptionTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        boolean returnsErrorValue;
        Executable method = jMethod.getMethod();
        boolean throwsCheckedException = false;
        try {
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (this.classLoader.loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom(exceptionType)) continue;
                throwsCheckedException = true;
                break;
            }
            returnsErrorValue = method instanceof Method && (this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()) || this.classLoader.loadClass(Object.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException("CLASS_NOT_FOUND", e.getMessage(), e);
        }
        if (throwsCheckedException && !jMethodRequest.returnsBErrorType || jMethodRequest.returnsBErrorType && !throwsCheckedException && !returnsErrorValue) {
            throw new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "No such Java method '" + jMethodRequest.methodName + "' which throws checked exception found in class '" + jMethodRequest.declaringClass + "'");
        }
    }

    private void validateArgumentTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        Class<?>[] jParamTypes = jMethod.getParamTypes();
        BType[] bParamTypes = jMethodRequest.bParamTypes;
        int i = 0;
        if (jMethod.isInstanceMethod()) {
            if (bParamTypes.length != jParamTypes.length + 1) {
                throw this.getParamCountMismatchError(jMethodRequest);
            }
            BType receiverType = bParamTypes[0];
            if (!this.isValidParamBType(jMethodRequest.declaringClass, receiverType, jMethodRequest)) {
                throw this.getNoSuchMethodError(jMethodRequest.methodName, jParamTypes[0], receiverType, jMethodRequest.declaringClass);
            }
            ++i;
        } else if (bParamTypes.length != jParamTypes.length) {
            throw this.getParamCountMismatchError(jMethodRequest);
        }
        for (int j = 0; j < jParamTypes.length; ++j) {
            Class<?> jParamType = jParamTypes[j];
            BType bParamType = bParamTypes[i];
            if (!this.isValidParamBType(jParamType, bParamType, jMethodRequest)) {
                throw this.getNoSuchMethodError(jMethodRequest.methodName, jParamType, bParamType, jMethodRequest.declaringClass);
            }
            ++i;
        }
    }

    private void validateReturnTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        BType bReturnType;
        Class<?> jReturnType = jMethod.getReturnType();
        if (!this.isValidReturnBType(jReturnType, bReturnType = jMethodRequest.bReturnType, jMethodRequest)) {
            throw new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "Incompatible return type for method '" + jMethodRequest.methodName + "' in class '" + jMethodRequest.declaringClass.getName() + "': Java type '" + jReturnType.getName() + "' will not be matched to ballerina type '" + bReturnType + "'");
        }
    }

    private boolean isValidParamBType(Class<?> jType, BType bType, JMethodRequest jMethodRequest) {
        try {
            String jTypeName = jType.getTypeName();
            switch (bType.getTag()) {
                case 11: 
                case 17: {
                    if (jTypeName.equals(JInterop.J_STRING_TNAME)) {
                        return false;
                    }
                    return !jType.isPrimitive();
                }
                case 38: {
                    return !jType.isPrimitive();
                }
                case 10: {
                    return jTypeName.equals(JInterop.J_VOID_TNAME);
                }
                case 1: 
                case 2: 
                case 3: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (bType.getTag() == 1 && jTypeName.equals(JInterop.J_LONG_OBJ_TNAME)) {
                        return true;
                    }
                    if (bType.getTag() == 2 && jTypeName.equals(JInterop.J_INTEGER_OBJ_TNAME)) {
                        return true;
                    }
                    if (bType.getTag() == 3 && jTypeName.equals(JInterop.J_DOUBLE_OBJ_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive() && (jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_FLOAT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_DOUBLE_TNAME));
                }
                case 6: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME) || jTypeName.equals(JInterop.J_BOOLEAN_OBJ_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive() && jTypeName.equals(JInterop.J_PRIMITIVE_BOOLEAN_TNAME);
                }
                case 4: {
                    return this.classLoader.loadClass(BDecimal.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 5: {
                    return this.classLoader.loadClass(BString.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 12: 
                case 15: {
                    return this.classLoader.loadClass(BMap.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 7: {
                    return jTypeName.equals(JInterop.J_OBJECT_TNAME);
                }
                case 19: 
                case 35: {
                    return this.classLoader.loadClass(BObject.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 29: {
                    return this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 14: {
                    return this.classLoader.loadClass(BStream.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 9: {
                    return this.classLoader.loadClass(BTable.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 8: {
                    return this.classLoader.loadClass(BXML.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 20: 
                case 31: {
                    if (jMethodRequest.restParamExist) {
                        return jType.isArray();
                    }
                    return this.classLoader.loadClass(BArray.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 21: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    List members = ((BUnionType)bType).getMemberTypes();
                    for (BType member : members) {
                        if (this.isValidParamBType(jType, member, jMethodRequest)) continue;
                        return false;
                    }
                    return true;
                }
                case 34: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    Set valueSpace = ((BFiniteType)bType).valueSpace;
                    for (Object value : valueSpace) {
                        BType valueType = TypeChecker.getType(value);
                        if (this.isValidParamBType(jType, valueType, jMethodRequest)) continue;
                        return false;
                    }
                    return true;
                }
                case 37: {
                    return this.classLoader.loadClass(BFunctionPointer.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 32: {
                    return this.classLoader.loadClass(BFuture.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 13: {
                    return this.classLoader.loadClass(BTypedesc.class.getCanonicalName()).isAssignableFrom(jType);
                }
            }
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException("CLASS_NOT_FOUND", e.getMessage(), e);
        }
    }

    private boolean isValidReturnBType(Class<?> jType, BType bType, JMethodRequest jMethodRequest) {
        try {
            String jTypeName = jType.getTypeName();
            switch (bType.getTag()) {
                case 11: 
                case 17: {
                    if (jTypeName.equals(JInterop.J_STRING_TNAME)) {
                        return false;
                    }
                    return !jType.isPrimitive();
                }
                case 38: {
                    return !jType.isPrimitive();
                }
                case 10: {
                    return jTypeName.equals(JInterop.J_VOID_TNAME);
                }
                case 1: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_LONG_OBJ_TNAME);
                }
                case 2: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_INTEGER_OBJ_TNAME);
                }
                case 3: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_FLOAT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_DOUBLE_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_DOUBLE_OBJ_TNAME);
                }
                case 6: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME) || jTypeName.equals(JInterop.J_BOOLEAN_OBJ_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive() && jTypeName.equals(JInterop.J_PRIMITIVE_BOOLEAN_TNAME);
                }
                case 4: {
                    return this.classLoader.loadClass(BDecimal.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 5: {
                    return this.classLoader.loadClass(BString.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 12: 
                case 15: {
                    return this.classLoader.loadClass(BMap.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 7: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    for (BType member : JSON_MEMBERS) {
                        if (!this.isValidReturnBType(jType, member, jMethodRequest)) continue;
                        return true;
                    }
                    return false;
                }
                case 19: 
                case 35: {
                    return this.classLoader.loadClass(BObject.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 29: {
                    return this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 14: {
                    return this.classLoader.loadClass(BStream.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 9: {
                    return this.classLoader.loadClass(BTable.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 8: {
                    return this.classLoader.loadClass(BXML.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 20: 
                case 31: {
                    if (jMethodRequest.restParamExist) {
                        return jType.isArray();
                    }
                    return this.classLoader.loadClass(BArray.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 21: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    List members = ((BUnionType)bType).getMemberTypes();
                    for (BType member : members) {
                        if (!this.isValidReturnBType(jType, member, jMethodRequest)) continue;
                        return true;
                    }
                    return false;
                }
                case 34: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    Set valueSpace = ((BFiniteType)bType).valueSpace;
                    for (Object value : valueSpace) {
                        BType valueType = TypeChecker.getType(value);
                        if (!this.isValidReturnBType(jType, valueType, jMethodRequest)) continue;
                        return true;
                    }
                    return false;
                }
                case 37: {
                    return this.classLoader.loadClass(BFunctionPointer.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 32: {
                    return this.classLoader.loadClass(BFuture.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 13: {
                    return this.classLoader.loadClass(BTypedesc.class.getCanonicalName()).isAssignableFrom(jType);
                }
            }
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException("CLASS_NOT_FOUND", e.getMessage(), e);
        }
    }

    private JMethod resolveExactMethod(Class<?> clazz, String name, JMethodKind kind, ParamTypeConstraint[] constraints) {
        Executable executable;
        Class[] paramTypes = new Class[constraints.length];
        for (int constraintIndex = 0; constraintIndex < constraints.length; ++constraintIndex) {
            paramTypes[constraintIndex] = constraints[constraintIndex].get();
        }
        Executable executable2 = executable = kind == JMethodKind.CONSTRUCTOR ? this.resolveConstructor(clazz, paramTypes) : this.resolveMethod(clazz, name, paramTypes);
        if (executable != null) {
            return JMethod.build(kind, kind == JMethodKind.CONSTRUCTOR ? this.resolveConstructor(clazz, paramTypes) : this.resolveMethod(clazz, name, paramTypes));
        }
        return JMethod.NO_SUCH_METHOD;
    }

    private JMethod resolveMatchingMethod(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        ParamTypeConstraint[] constraints = jMethodRequest.paramTypeConstraints;
        ArrayList<JMethod> resolvedJMethods = new ArrayList<JMethod>();
        for (JMethod jMethod : jMethods) {
            boolean resolved = true;
            Class<?>[] formalParamTypes = jMethod.getParamTypes();
            for (int paramIndex = 0; paramIndex < formalParamTypes.length; ++paramIndex) {
                Class<?> formalParamType = formalParamTypes[paramIndex];
                if (formalParamType.isAssignableFrom(constraints[paramIndex].get())) continue;
                resolved = false;
                break;
            }
            if (!resolved) continue;
            resolvedJMethods.add(jMethod);
        }
        if (resolvedJMethods.isEmpty()) {
            throw this.getMethodNotFoundError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, constraints);
        }
        if (resolvedJMethods.size() > 1) {
            throw this.getAmbiguousOverloadedMethodExistsError(jMethodRequest.kind, jMethodRequest.declaringClass, jMethodRequest.methodName, constraints);
        }
        return (JMethod)resolvedJMethods.get(0);
    }

    private Executable resolveConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Executable resolveMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private List<Executable> getExecutables(Class<?> clazz, String methodName, JMethodKind kind) {
        return kind == JMethodKind.CONSTRUCTOR ? Arrays.asList(clazz.getConstructors()) : Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(methodName)).collect(Collectors.toList());
    }

    private boolean noConstraintsSpecified(ParamTypeConstraint[] constraints) {
        for (ParamTypeConstraint constraint : constraints) {
            if (constraint == ParamTypeConstraint.NO_CONSTRAINT) continue;
            return false;
        }
        return true;
    }

    private int getBFuncParamCount(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        int bFuncParamCount = jMethodRequest.bFuncParamCount;
        if (jMethodRequest.kind == JMethodKind.METHOD) {
            boolean isStaticMethod = jMethods.get(0).isStatic();
            bFuncParamCount = isStaticMethod ? bFuncParamCount : bFuncParamCount - 1;
        }
        return bFuncParamCount;
    }

    private JInteropException getMethodNotFoundError(JMethodKind kind, Class<?> declaringClass, String methodName) {
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("CONSTRUCTOR_NOT_FOUND", "No such public constructor found in class '" + declaringClass + "'");
        }
        return new JInteropException("METHOD_NOT_FOUND", "No such public method '" + methodName + "' found in class '" + declaringClass + "'");
    }

    private JInteropException getMethodNotFoundError(JMethodKind kind, Class<?> declaringClass, String methodName, int paramCount) {
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("CONSTRUCTOR_NOT_FOUND", "No such public constructor with '" + paramCount + "' parameter(s) found in class '" + declaringClass + "'");
        }
        return new JInteropException("METHOD_NOT_FOUND", "No such public method '" + methodName + "' with '" + paramCount + "' parameter(s) found in class '" + declaringClass + "'");
    }

    private JInteropException getMethodNotFoundError(JMethodKind kind, Class<?> declaringClass, String methodName, ParamTypeConstraint[] constraints) {
        String paramTypesSig = this.getParamTypesAsString(constraints);
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("CONSTRUCTOR_NOT_FOUND", "No such public constructor that matches with parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
        }
        return new JInteropException("METHOD_NOT_FOUND", "No such public method '" + methodName + "' that matches with parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
    }

    private JInteropException getOverloadedMethodExistError(JMethodKind kind, Class<?> declaringClass, String methodName, int paramCount) {
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("OVERLOADED_METHODS", "Overloaded constructors with '" + paramCount + "' parameter(s) in class '" + declaringClass + "', please specify class names for each parameter in 'paramTypes' field in the annotation");
        }
        return new JInteropException("OVERLOADED_METHODS", "Overloaded methods '" + methodName + "' with '" + paramCount + "' parameter(s) in class '" + declaringClass + "', please specify class names for each parameter with 'paramTypes' field in the annotation");
    }

    private JInteropException getAmbiguousOverloadedMethodExistsError(JMethodKind kind, Class<?> declaringClass, String methodName, ParamTypeConstraint[] constraints) {
        String paramTypesSig = this.getParamTypesAsString(constraints);
        if (kind == JMethodKind.CONSTRUCTOR) {
            return new JInteropException("OVERLOADED_METHODS", "More than one public constructors that match with the parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
        }
        return new JInteropException("OVERLOADED_METHODS", "More than one public methods '" + methodName + "' that match with the parameter types '" + paramTypesSig + "' found in class '" + declaringClass + "'");
    }

    private String getParamTypesAsString(ParamTypeConstraint[] constraints) {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (ParamTypeConstraint paramTypeConstraint : constraints) {
            stringJoiner.add(paramTypeConstraint.get().getName());
        }
        return stringJoiner.toString();
    }

    private JInteropException getNoSuchMethodError(String methodName, Class<?> jType, BType bType, Class<?> declaringClass) {
        return new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "Incompatible param type for method '" + methodName + "' in class '" + declaringClass.getName() + "': Java type '" + jType.getName() + "' will not be matched to ballerina type '" + bType + "'");
    }

    private JInteropException getParamCountMismatchError(JMethodRequest jMethodRequest) {
        return new JInteropException("METHOD_SIGNATURE_DOES_NOT_MATCH", "Parameter count does not match with Java method '" + jMethodRequest.methodName + "' found in class '" + jMethodRequest.declaringClass.getName() + "'");
    }
}

