/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.ballerinalang.nativeimpl.jvm.interop.JInterop;

class JavaField {
    private JFieldMethod method;
    private Field field;

    JavaField(JFieldMethod method, Field field) {
        this.method = method;
        this.field = field;
    }

    String getDeclaringClassName() {
        return this.field.getDeclaringClass().getName();
    }

    String getName() {
        return this.field.getName();
    }

    boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    JFieldMethod getMethod() {
        return this.method;
    }

    String getSignature() {
        return JInterop.getSig(this.field.getType());
    }

    Class<?> getFieldType() {
        return this.field.getType();
    }

    static enum JFieldMethod {
        ACCESS("access"),
        MUTATE("mutate");

        private String strValue;

        private JFieldMethod(String strValue) {
            this.strValue = strValue;
        }

        static JFieldMethod getKind(String value) {
            if ("access".equals(value)) {
                return ACCESS;
            }
            return MUTATE;
        }

        String getStringValue() {
            return this.strValue;
        }
    }

    static enum JFieldKind {
        STATIC("static"),
        INSTANCE("instance");

        private String strValue;

        private JFieldKind(String strValue) {
            this.strValue = strValue;
        }

        static JFieldKind getKind(String value) {
            if ("static".equals(value)) {
                return STATIC;
            }
            return INSTANCE;
        }

        String getStringValue() {
            return this.strValue;
        }
    }
}

