/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.impl;

import java.util.concurrent.Semaphore;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPollCycleFutureListener
implements CallableUnitCallback {
    private static final Logger logger = LoggerFactory.getLogger(KafkaPollCycleFutureListener.class);
    private Semaphore sem;
    private String serviceId;

    public KafkaPollCycleFutureListener(Semaphore sem, String serviceId) {
        this.sem = sem;
        this.serviceId = serviceId;
    }

    public void notifySuccess() {
        this.sem.release();
        if (logger.isDebugEnabled()) {
            logger.debug("Ballerina engine has completed resource invocation successfully for service " + this.serviceId + ". Semaphore is released to continue next polling cycle.");
        }
    }

    public void notifyFailure(ErrorValue error) {
        this.sem.release();
        logger.error("Ballerina engine has completed resource invocation with exception for service " + this.serviceId + ". Semaphore is released to continue next polling cycle.", (Object)error.stringValue());
    }
}

