/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.producer;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.messaging.kafka.nativeimpl.producer.Send;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendIntValues
extends Send {
    private static final Logger logger = LoggerFactory.getLogger(SendIntValues.class);

    public static Object sendIntValuesNilKeys(ObjectValue producer, long value, String topic, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, null, (Object)value);
        return SendIntValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendIntValuesStringKeys(ObjectValue producer, long value, String topic, String key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)value);
        return SendIntValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendIntValuesIntKeys(ObjectValue producer, long value, String topic, long key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)value);
        return SendIntValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendIntValuesFloatKeys(ObjectValue producer, long value, String topic, double key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)value);
        return SendIntValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendIntValuesByteArrayKeys(ObjectValue producer, long value, String topic, BArray key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key.getBytes(), (Object)value);
        return SendIntValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendIntValuesCustomKeys(ObjectValue producer, long value, String topic, Object key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, key, (Object)value);
        return SendIntValues.sendKafkaRecord(kafkaRecord, producer);
    }
}

