/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.producer;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.messaging.kafka.nativeimpl.producer.Send;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendStringValues
extends Send {
    private static final Logger logger = LoggerFactory.getLogger(SendStringValues.class);

    public static Object sendStringValuesNilKeys(ObjectValue producer, String value, String topic, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, null, (Object)value);
        return SendStringValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendStringValuesStringKeys(ObjectValue producer, String value, String topic, String key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)value);
        return SendStringValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendStringValuesIntKeys(ObjectValue producer, String value, String topic, long key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)value);
        return SendStringValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendStringValuesFloatKeys(ObjectValue producer, String value, String topic, double key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)value);
        return SendStringValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendStringValuesByteArrayKeys(ObjectValue producer, String value, String topic, BArray key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key.getBytes(), (Object)value);
        return SendStringValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendStringValuesCustomKeys(ObjectValue producer, String value, String topic, Object key, Object partition, Object timestamp) {
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, key, (Object)value);
        return SendStringValues.sendKafkaRecord(kafkaRecord, producer);
    }
}

