/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.observability;

import java.util.Optional;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;

public class KafkaTracingUtil {
    public static void traceResourceInvocation(Strand strand, ObjectValue object, String topic) {
        ObserverContext observerContext;
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        Optional observerContextOptional = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        if (observerContextOptional.isPresent()) {
            observerContext = (ObserverContext)observerContextOptional.get();
        } else {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame((Strand)strand, (ObserverContext)observerContext);
        }
        KafkaTracingUtil.setTags(observerContext, object, topic);
    }

    public static void traceResourceInvocation(Strand strand, ObjectValue object) {
        ObserverContext observerContext;
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        Optional observerContextOptional = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        if (observerContextOptional.isPresent()) {
            observerContext = (ObserverContext)observerContextOptional.get();
        } else {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame((Strand)strand, (ObserverContext)observerContext);
        }
        KafkaTracingUtil.setTags(observerContext, object);
    }

    private static void setTags(ObserverContext observerContext, ObjectValue object, String topic) {
        observerContext.addTag("url", KafkaUtils.getBootstrapServers(object));
        observerContext.addTag("client_id", KafkaUtils.getClientId(object));
        observerContext.addTag("topic", topic);
    }

    private static void setTags(ObserverContext observerContext, ObjectValue object) {
        observerContext.addTag("url", KafkaUtils.getBootstrapServers(object));
        observerContext.addTag("client_id", KafkaUtils.getClientId(object));
    }

    private KafkaTracingUtil() {
    }
}

