/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.utils;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;

public class AvroUtils {
    private AvroUtils() {
    }

    protected static void populateBallerinaGenericAvroRecord(MapValue<String, Object> genericAvroRecord, GenericRecord record) {
        List fields = record.getSchema().getFields();
        for (Schema.Field field : fields) {
            if (record.get(field.name()) instanceof Utf8) {
                genericAvroRecord.put((Object)field.name(), (Object)record.get(field.name()).toString());
                continue;
            }
            if (record.get(field.name()) instanceof GenericRecord) {
                AvroUtils.populateBallerinaGenericAvroRecord(genericAvroRecord, (GenericRecord)record.get(field.name()));
                continue;
            }
            genericAvroRecord.put((Object)field.name(), record.get(field.name()));
        }
    }

    protected static MapValue<String, Object> handleAvroConsumer(Object value) {
        if (value instanceof GenericRecord) {
            MapValue<String, Object> genericAvroRecord = KafkaUtils.getAvroGenericRecord();
            AvroUtils.populateBallerinaGenericAvroRecord(genericAvroRecord, (GenericRecord)value);
            return genericAvroRecord;
        }
        throw KafkaUtils.createKafkaError("{ballerina/kafka}AvroError", "Invalid type - expected: AvroGenericRecord");
    }
}

