/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.utils;

import java.util.Objects;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.BallerinaTransactionContext;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.kafka.impl.KafkaTransactionContext;

public class TransactionUtils {
    private TransactionUtils() {
    }

    public static void handleTransactions(Strand strand, ObjectValue producer) {
        if (Objects.nonNull(producer.getNativeData("TransactionInitiated"))) {
            KafkaTransactionContext transactionContext = (KafkaTransactionContext)producer.getNativeData("TransactionInitiated");
            transactionContext.beginTransaction();
            TransactionUtils.registerKafkaTransactionContext(strand, producer, transactionContext);
        }
    }

    public static KafkaTransactionContext createKafkaTransactionContext(ObjectValue producer) {
        KafkaProducer kafkaProducer = (KafkaProducer)producer.getNativeData("KafkaProducer");
        return new KafkaTransactionContext(kafkaProducer);
    }

    public static void registerKafkaTransactionContext(Strand strand, ObjectValue producer, KafkaTransactionContext transactionContext) {
        String connectorId = producer.getStringValue("connectorId");
        if (Objects.isNull(strand.transactionLocalContext.getTransactionContext(connectorId))) {
            TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
            transactionLocalContext.registerTransactionContext(connectorId, (BallerinaTransactionContext)transactionContext);
        }
    }
}

