/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;

public class PackageID {
    public static final PackageID DEFAULT = new PackageID(Names.ANON_ORG, Names.DEFAULT_PACKAGE, Names.DEFAULT_VERSION);
    public static final PackageID INTERNAL = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.INTERNAL), Names.EMPTY);
    public static final PackageID ANNOTATIONS = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.ANNOTATIONS), Names.EMPTY);
    public static final PackageID ARRAY = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.ARRAY), Names.EMPTY);
    public static final PackageID DECIMAL = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.DECIMAL), Names.EMPTY);
    public static final PackageID ERROR = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.ERROR), Names.EMPTY);
    public static final PackageID FLOAT = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.FLOAT), Names.EMPTY);
    public static final PackageID FUTURE = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.FUTURE), Names.EMPTY);
    public static final PackageID INT = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.INT), Names.EMPTY);
    public static final PackageID MAP = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.MAP), Names.EMPTY);
    public static final PackageID OBJECT = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.OBJECT), Names.EMPTY);
    public static final PackageID STREAM = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.STREAM), Names.EMPTY);
    public static final PackageID STRING = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.STRING), Names.EMPTY);
    public static final PackageID TABLE = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.TABLE), Names.EMPTY);
    public static final PackageID TYPEDESC = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.TYPEDESC), Names.EMPTY);
    public static final PackageID VALUE = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.VALUE), Names.EMPTY);
    public static final PackageID XML = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.XML), Names.EMPTY);
    public static final PackageID BOOLEAN = new PackageID(Names.BALLERINA_ORG, Lists.of(Names.LANG, Names.BOOLEAN), Names.EMPTY);
    public final Name orgName;
    public Name name;
    public Name version = Names.DEFAULT_VERSION;
    public boolean isUnnamed = false;
    public Name sourceFileName = null;
    public List<Name> nameComps;

    public PackageID(Name orgName, List<Name> nameComps, Name version) {
        this.orgName = orgName;
        this.nameComps = nameComps;
        this.name = new Name(nameComps.stream().map(Name::getValue).collect(Collectors.joining(".")));
        this.version = version;
    }

    public PackageID(Name orgName, Name name, Name version) {
        this.orgName = orgName;
        this.name = name;
        this.version = version;
        this.nameComps = name == Names.DEFAULT_PACKAGE ? Lists.of(Names.DEFAULT_PACKAGE) : Arrays.stream(name.value.split("\\.")).map(Name::new).collect(Collectors.toList());
    }

    public PackageID(Name orgName, String sourceFileName, Name version) {
        this.orgName = orgName;
        this.name = Names.DEFAULT_PACKAGE;
        this.version = version;
        this.nameComps = Lists.of(Names.DEFAULT_PACKAGE);
        this.isUnnamed = true;
        this.sourceFileName = new Name(sourceFileName);
    }

    public PackageID(String sourceFileName) {
        this.orgName = Names.ANON_ORG;
        this.name = Names.DEFAULT_PACKAGE;
        this.nameComps = new ArrayList<Name>(1){
            {
                this.add(PackageID.this.name);
            }
        };
        this.isUnnamed = true;
        this.sourceFileName = new Name(sourceFileName);
    }

    public Name getName() {
        return this.name;
    }

    public Name getNameComp(int index) {
        return this.nameComps.get(index);
    }

    public List<Name> getNameComps() {
        return this.nameComps;
    }

    public Name getPackageVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageID other = (PackageID)o;
        boolean samePkg = false;
        if (this.isUnnamed == other.isUnnamed) {
            samePkg = !this.isUnnamed || this.sourceFileName.equals(other.sourceFileName);
        }
        return samePkg && this.orgName.equals(other.orgName) && this.name.equals(other.name) && this.version.equals(other.version);
    }

    public int hashCode() {
        int result = this.orgName != null ? this.orgName.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        if (Names.DOT.equals(this.name)) {
            return this.name.value;
        }
        String orgName = "";
        if (this.orgName != null && !this.orgName.equals(Names.ANON_ORG)) {
            orgName = this.orgName + Names.ORG_NAME_SEPARATOR.value;
        }
        if (this.version.equals(Names.EMPTY)) {
            return orgName + this.name.value;
        }
        return orgName + this.name + Names.VERSION_SEPARATOR.value + this.version;
    }

    public Name getOrgName() {
        return this.orgName;
    }

    public static boolean isLangLibPackageID(PackageID packageID) {
        if (!packageID.getOrgName().equals(Names.BALLERINA_ORG)) {
            return false;
        }
        return packageID.nameComps.size() > 1 && packageID.nameComps.get(0).equals(Names.LANG);
    }
}

