/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.repository.fs;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.repository.PackageEntity;
import org.ballerinalang.repository.PackageRepository;
import org.ballerinalang.repository.PackageSource;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchy;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class GeneralFSPackageRepository
implements PackageRepository {
    private static final String BAL_SOURCE_EXT = ".bal";
    protected Path basePath;
    private final Name orgName;

    public GeneralFSPackageRepository(Path basePath, Name orgName) {
        this.basePath = basePath;
        this.orgName = orgName;
    }

    public GeneralFSPackageRepository(Path basePath) {
        this(basePath, null);
    }

    protected PackageSource lookupPackageSource(PackageID pkgID) {
        Path path = this.orgName == null ? this.generatePathNew(pkgID) : this.generatePath(pkgID);
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(path = this.generatePathOld(pkgID), LinkOption.NOFOLLOW_LINKS)) {
            return null;
        }
        return new FSPackageSource(pkgID, path);
    }

    protected PackageSource lookupPackageSource(PackageID pkgID, String entryName) {
        Path path = this.generatePathOld(pkgID);
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            return null;
        }
        try {
            return new FSPackageSource(pkgID, path, entryName);
        }
        catch (FSPackageEntityNotAvailableException e) {
            return null;
        }
    }

    @Override
    public PackageEntity loadPackage(PackageID pkgID) {
        return this.lookupPackageSource(pkgID);
    }

    @Override
    public PackageEntity loadPackage(PackageID pkgID, String entryName) {
        return this.lookupPackageSource(pkgID, entryName);
    }

    private String sanitize(String name, String separator) {
        if (name.startsWith(separator)) {
            name = name.substring(separator.length());
        }
        if (name.endsWith(separator)) {
            name = name.substring(0, name.length() - separator.length());
        }
        return name;
    }

    private boolean isBALFile(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(BAL_SOURCE_EXT);
    }

    @Override
    public Set<PackageID> listPackages(final int maxDepth) {
        if (maxDepth <= 0) {
            throw new IllegalArgumentException("maxDepth must be greater than zero");
        }
        if (!Files.isDirectory(this.basePath, new LinkOption[0])) {
            return Collections.emptySet();
        }
        final LinkedHashSet<PackageID> result = new LinkedHashSet<PackageID>();
        final int baseNameCount = this.basePath.getNameCount();
        final String separator = this.basePath.getFileSystem().getSeparator();
        try {
            Files.walkFileTree(this.basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    int dirNameCount;
                    if (Files.isHidden(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    ArrayList<Name> nameComps = new ArrayList<Name>();
                    if (Files.list(dir).filter(f -> GeneralFSPackageRepository.this.isBALFile(f)).count() > 0L && (dirNameCount = dir.getNameCount()) > baseNameCount) {
                        dir.subpath(baseNameCount, dirNameCount).forEach(f -> nameComps.add(new Name(GeneralFSPackageRepository.this.sanitize(f.getFileName().toString(), separator))));
                        result.add(new PackageID(Names.ANON_ORG, nameComps, Names.DEFAULT_VERSION));
                    }
                    if (dir.getNameCount() + 1 - baseNameCount > maxDepth) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error in listing modules: " + e.getMessage(), e);
        }
        return result;
    }

    protected Path generatePathOld(PackageID pkgID) {
        if (pkgID.isUnnamed) {
            return this.basePath;
        }
        Path pkgDirPath = this.basePath;
        for (Name comp : pkgID.getNameComps()) {
            pkgDirPath = pkgDirPath.resolve(comp.value);
        }
        return pkgDirPath;
    }

    public Path generatePath(PackageID pkgID) {
        return this.basePath.resolve(this.createPackageNameWithDots(pkgID));
    }

    private Path generatePathNew(PackageID pkgID) {
        Path pkgDirPath = this.basePath.resolve(pkgID.getOrgName().value);
        return pkgDirPath.resolve(this.createPackageNameWithDots(pkgID));
    }

    private String createPackageNameWithDots(PackageID pkgID) {
        List<Name> nameComps = pkgID.getNameComps();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nameComps.size(); ++i) {
            if (i != 0) {
                builder.append(".");
            }
            builder.append(nameComps.get((int)i).value);
        }
        return builder.toString();
    }

    public class FSPackageEntityNotAvailableException
    extends Exception {
        private static final long serialVersionUID = 1528033476455781589L;
    }

    public class FSPackageSource
    implements PackageSource {
        protected PackageID pkgID;
        protected Path pkgPath;
        private List<String> cachedEntryNames;

        public FSPackageSource(PackageID pkgID, Path pkgPath) {
            this.pkgID = pkgID;
            this.pkgPath = pkgPath;
        }

        public FSPackageSource(PackageID pkgID, Path pkgPath, String entryName) throws FSPackageEntityNotAvailableException {
            this.pkgID = pkgID;
            this.pkgPath = pkgPath;
            if (!Files.exists(pkgPath.resolve(entryName), new LinkOption[0])) {
                throw new FSPackageEntityNotAvailableException();
            }
            this.cachedEntryNames = Collections.singletonList(entryName);
        }

        @Override
        public PackageID getPackageId() {
            return this.pkgID;
        }

        @Override
        public List<String> getEntryNames() {
            if (this.cachedEntryNames == null) {
                try {
                    List files = Files.walk(this.pkgPath, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> e.getFileName().toString().endsWith(GeneralFSPackageRepository.BAL_SOURCE_EXT)).collect(Collectors.toList());
                    this.cachedEntryNames = new ArrayList<String>(files.size());
                    files.stream().forEach(e -> this.cachedEntryNames.add(e.getFileName().toString()));
                }
                catch (IOException e2) {
                    throw new RuntimeException("Error in listing modules at '" + this.pkgID + "': " + e2.getMessage(), e2);
                }
            }
            return this.cachedEntryNames;
        }

        @Override
        public RepoHierarchy getRepoHierarchy() {
            return null;
        }

        @Override
        public CompilerInput getPackageSourceEntry(String name) {
            return new FSCompilerInput(name);
        }

        @Override
        public List<CompilerInput> getPackageSourceEntries() {
            return this.getEntryNames().stream().map(e -> new FSCompilerInput((String)e)).collect(Collectors.toList());
        }

        @Override
        public PackageEntity.Kind getKind() {
            return PackageEntity.Kind.SOURCE;
        }

        @Override
        public String getName() {
            return this.getPackageId().toString();
        }

        public class FSCompilerInput
        implements CompilerInput {
            private String name;
            private byte[] code;

            public FSCompilerInput(String name) {
                this.name = name;
                Path filePath = GeneralFSPackageRepository.this.basePath.resolve(name);
                try {
                    this.code = Files.readAllBytes(GeneralFSPackageRepository.this.basePath.resolve(FSPackageSource.this.pkgPath).resolve(name));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error in loading module source entry '" + filePath + "': " + e.getMessage(), e);
                }
            }

            @Override
            public String getEntryName() {
                return this.name;
            }

            @Override
            public byte[] getCode() {
                return this.code;
            }
        }
    }
}

