/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.toml.parser;

import com.google.gson.JsonSyntaxException;
import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.toml.exceptions.TomlException;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ManifestProcessor {
    private static final CompilerContext.Key<ManifestProcessor> MANIFEST_PROC_KEY = new CompilerContext.Key();
    private static final Pattern semVerPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private final Manifest manifest;

    public static ManifestProcessor getInstance(CompilerContext context) {
        try {
            ManifestProcessor manifestProcessor = context.get(MANIFEST_PROC_KEY);
            if (manifestProcessor == null) {
                SourceDirectory sourceDirectory = context.get(SourceDirectory.class);
                Manifest manifest = new Manifest();
                if (sourceDirectory instanceof FileSystemProjectDirectory) {
                    manifest = ManifestProcessor.parseTomlContentAsStream(sourceDirectory.getManifestContent());
                }
                ManifestProcessor instance = new ManifestProcessor(manifest);
                context.put(MANIFEST_PROC_KEY, instance);
                return instance;
            }
            return manifestProcessor;
        }
        catch (TomlException tomlException) {
            throw new BLangCompilerException(tomlException.getMessage());
        }
    }

    private ManifestProcessor(Manifest manifest) {
        this.manifest = manifest;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public static Manifest parseTomlContentFromFile(Path tomlPath) throws IOException, TomlException {
        FileInputStream targetStream = new FileInputStream(tomlPath.toFile());
        Manifest manifest = ManifestProcessor.parseTomlContentAsStream(targetStream);
        ManifestProcessor.validateManifestDependencies(manifest);
        return manifest;
    }

    public static Manifest parseTomlContentFromString(String content) throws TomlException {
        try {
            Toml toml = new Toml().read(content);
            if (toml.isEmpty()) {
                throw new TomlException("invalid Ballerina.toml file: organization name and the version of the project is missing. example: \n[project]\norg-name=\"my_org\"\nversion=\"1.0.0\"\n");
            }
            if (null == toml.getTable("project")) {
                throw new TomlException("invalid Ballerina.toml file: cannot find [project]");
            }
            Manifest manifest = (Manifest)toml.to(Manifest.class);
            manifest.getProject().setOrgName(toml.getString("project.org-name"));
            ManifestProcessor.validateManifestProject(manifest);
            ManifestProcessor.validateManifestDependencies(manifest);
            return manifest;
        }
        catch (JsonSyntaxException | IllegalStateException ise) {
            String tomlErrMsg = ManifestProcessor.lowerCaseFirstLetter(ise.getMessage().replace("java.lang.IllegalStateException: ", "").toLowerCase(Locale.getDefault()));
            throw new TomlException("invalid Ballerina.toml file: " + tomlErrMsg);
        }
    }

    public static Manifest parseTomlContentAsStream(InputStream inputStream) throws TomlException {
        try {
            Toml toml = new Toml().read(inputStream);
            if (toml.isEmpty()) {
                throw new TomlException("invalid Ballerina.toml file: organization name and the version of the project is missing. example: \n[project]\norg-name=\"my_org\"\nversion=\"1.0.0\"\n");
            }
            if (null == toml.getTable("project")) {
                throw new TomlException("invalid Ballerina.toml file: cannot find [project]");
            }
            Manifest manifest = (Manifest)toml.to(Manifest.class);
            manifest.getProject().setOrgName(toml.getString("project.org-name"));
            ManifestProcessor.validateManifestProject(manifest);
            ManifestProcessor.validateManifestDependencies(manifest);
            return manifest;
        }
        catch (JsonSyntaxException | IllegalStateException ise) {
            String tomlErrMsg = ManifestProcessor.lowerCaseFirstLetter(ise.getMessage().replace("java.lang.IllegalStateException: ", "").toLowerCase(Locale.getDefault()));
            throw new TomlException("invalid Ballerina.toml file: " + tomlErrMsg);
        }
    }

    private static void validateManifestProject(Manifest manifest) throws TomlException {
        if (null == manifest.getProject().getOrgName() || "".equals(manifest.getProject().getOrgName())) {
            throw new TomlException("invalid Ballerina.toml file: cannot find 'org-name' under [project]");
        }
        if (null == manifest.getProject().getVersion() || "".equals(manifest.getProject().getVersion())) {
            throw new TomlException("invalid Ballerina.toml file: cannot find 'version' under [project]");
        }
        Matcher semverMatcher = semVerPattern.matcher(manifest.getProject().getVersion());
        if (!semverMatcher.matches()) {
            throw new TomlException("invalid Ballerina.toml file: 'version' under [project] is not semver");
        }
    }

    private static void validateManifestDependencies(Manifest manifest) throws TomlException {
        for (Map.Entry<String, Object> dependency : manifest.getDependenciesAsObjectMap().entrySet()) {
            if (dependency.getValue() instanceof String || dependency.getValue() instanceof Map) continue;
            throw new TomlException("invalid Ballerina.toml file: invalid metadata found for dependency [" + dependency.getKey() + "]");
        }
    }

    private static String lowerCaseFirstLetter(String content) {
        return content.substring(0, 1).toLowerCase(Locale.getDefault()) + content.substring(1);
    }

    public static byte[] addDependenciesToManifest(ByteArrayInputStream manifestStream, List<Dependency> deps) {
        Map toml = new Toml().read((InputStream)manifestStream).toMap();
        HashMap dependencies = new LinkedHashMap<String, String>();
        if (toml.containsKey("dependencies")) {
            Iterator<Dependency> tomlDepsAsObject = toml.get("dependencies");
            HashMap updatedDependencies = new HashMap();
            if (tomlDepsAsObject instanceof HashMap) {
                HashMap tomlDeps = (HashMap)((Object)tomlDepsAsObject);
                for (Map.Entry dep : tomlDeps.entrySet()) {
                    updatedDependencies.put(((String)dep.getKey()).replaceAll("^\"|\"$", ""), dep.getValue());
                }
                dependencies = updatedDependencies;
            }
        }
        for (Dependency dep : deps) {
            dependencies.put(dep.getOrgName() + "/" + dep.getModuleName(), dep.getMetadata().getVersion());
        }
        toml.put("dependencies", dependencies);
        TomlWriter writer = new TomlWriter();
        String tomlContent = writer.write((Object)toml);
        return tomlContent.getBytes(Charset.defaultCharset());
    }
}

