/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;

public class BootstrapRunner {
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;
    private static final String CLASSPATH = "CLASSPATH";
    private static final String TMP_OBJECT_FILE_NAME = "ballerina_native_objf.o";
    private static final String COMPILER_BACKEND_JVM = "ballerina.compiler_backend_jvm.___init";
    private static final String COMPILER_BACKEND_LLVM = "ballerina.compiler_backend_llvm.___init";
    private static String javaCommand = System.getProperty("java.command");

    public static void loadTargetAndGenerateJarBinary(String entryBir, String jarOutputPath, boolean dumpBir, HashSet<Path> moduleDependencySet, String ... birCachePaths) {
        ArrayList<String> jarFilePaths = new ArrayList<String>(moduleDependencySet.size());
        for (Path path : moduleDependencySet) {
            jarFilePaths.add(path.toString());
        }
        List<String> commands = BootstrapRunner.createArgsForJBalCompilerBackend(entryBir, jarOutputPath, dumpBir, jarFilePaths, birCachePaths);
        BootstrapRunner.generateJarBinaryInProc(commands);
    }

    public static void genNativeCode(String entryBir, Path targetDir, boolean dumpLLVM, boolean noOptimizeLLVM) {
        Path nativeFolder = BootstrapRunner.genNativeForlderInTarget(targetDir);
        Path objectFilePath = nativeFolder.resolve(TMP_OBJECT_FILE_NAME);
        BootstrapRunner.genObjectFile(entryBir, objectFilePath.toString(), dumpLLVM, noOptimizeLLVM);
        BootstrapRunner.genExecutable(objectFilePath, "llvm");
        Runtime.getRuntime().exit(0);
    }

    public static Path genNativeForlderInTarget(Path targetDir) {
        Path nativeFolder = targetDir.resolve("native");
        BootstrapRunner.buildDirectoryFromPath(nativeFolder);
        return nativeFolder;
    }

    public static void buildDirectoryFromPath(Path directory) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BLangCompilerException("could not create native folder inside target folder", e);
        }
    }

    private static void genObjectFile(String entryBir, String objFileOutputPath, boolean dumpLLVM, boolean noOptimizeLLVM) {
        List<String> commands = BootstrapRunner.createArgsForNBalCompilerBackend(entryBir, objFileOutputPath, dumpLLVM, noOptimizeLLVM);
        BootstrapRunner.generateJarBinaryInProc(commands);
    }

    private static void genExecutable(Path objectFilePath, String execFilename) {
        BootstrapRunner.checkGCCAvailability();
        ProcessBuilder gccProcessBuilder = BootstrapRunner.createOSSpecificGCCCommand(objectFilePath, execFilename);
        try {
            Process gccProcess = gccProcessBuilder.start();
            int exitCode = gccProcess.waitFor();
            if (exitCode != 0) {
                throw new BLangCompilerException("linker failed: " + BootstrapRunner.getProcessErrorOutput(gccProcess));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new BLangCompilerException("linker failed: " + e.getMessage(), e);
        }
    }

    private static void checkGCCAvailability() {
        Runtime rt = Runtime.getRuntime();
        try {
            Process gccCheckProc = rt.exec("gcc -v");
            int exitVal = gccCheckProc.waitFor();
            if (exitVal != 0) {
                throw new BLangCompilerException("'gcc' is not installed in your environment");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new BLangCompilerException("probably, 'gcc' is not installed in your environment: " + e.getMessage(), e);
        }
    }

    private static ProcessBuilder createOSSpecificGCCCommand(Path objectFilePath, String execFilename) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        ProcessBuilder gccProcessBuilder = new ProcessBuilder(new String[0]);
        if (osName.startsWith("windows")) {
            gccProcessBuilder.command("cmd.exe", "/c", "dir");
        } else if (osName.startsWith("mac os x")) {
            gccProcessBuilder.command("gcc", objectFilePath.toString(), "-o", execFilename);
        } else {
            gccProcessBuilder.command("gcc", objectFilePath.toString(), "-static", "-o", execFilename);
        }
        return gccProcessBuilder;
    }

    private static String getProcessErrorOutput(Process process) throws IOException {
        InputStreamReader in = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
        try (BufferedReader errReader = new BufferedReader(in);){
            String string = errReader.lines().collect(Collectors.joining(", "));
            return string;
        }
    }

    public static void generateJarBinaryInProc(List<String> commands) {
        try {
            ProcessBuilder pb = new ProcessBuilder(commands);
            Map<String, String> env = pb.environment();
            env.put(CLASSPATH, System.getProperty("java.class.path"));
            Process process = pb.start();
            BootstrapRunner.getConsoleOutput(process.getInputStream(), out);
            String consoleError = BootstrapRunner.getConsoleOutput(process.getErrorStream(), err);
            boolean processEnded = process.waitFor(120L, TimeUnit.SECONDS);
            if (!processEnded) {
                throw new BLangCompilerException("failed to generate jar file within 120s.");
            }
            if (process.exitValue() != 0) {
                throw new BLangCompilerException(consoleError);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("failed running jvm code gen phase.", e);
        }
    }

    private static void setSystemProperty(List<String> commands, String propertName) {
        String value = System.getProperty(propertName);
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        commands.add("-D" + propertName + "=" + System.getProperty(propertName));
    }

    private static String getConsoleOutput(InputStream inputStream, PrintStream printStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringJoiner sj = new StringJoiner(System.getProperty("line.separator"));
        reader.lines().iterator().forEachRemaining(line -> {
            printStream.println((String)line);
            sj.add((CharSequence)line);
        });
        return sj.toString();
    }

    public static List<String> createArgsForJBalCompilerBackend(String entryBir, String jarOutputPath, boolean dumpBir, List<String> jarFilePaths, String ... birCachePaths) {
        ArrayList<String> commands = new ArrayList<String>();
        if (javaCommand == null) {
            javaCommand = System.getProperty("java.command");
        }
        commands.add(javaCommand);
        BootstrapRunner.setSystemProperty(commands, "ballerina.bstring");
        commands.add(COMPILER_BACKEND_JVM);
        commands.addAll(BootstrapRunner.createArgsForCompilerBackend(entryBir, jarOutputPath, dumpBir, true, birCachePaths, jarFilePaths));
        return commands;
    }

    public static List<String> createArgsForCompilerBackend(String entryBir, String jarOutputPath, boolean dumpBir, boolean useSystemClassLoader, String[] birCachePaths, List<String> jarFilePaths) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(entryBir);
        commands.add(BootstrapRunner.getMapPath());
        commands.add(jarOutputPath);
        commands.add(dumpBir ? "true" : "false");
        commands.add(useSystemClassLoader ? "true" : "false");
        commands.add(String.valueOf(birCachePaths.length));
        commands.addAll(Arrays.asList(birCachePaths));
        commands.addAll(jarFilePaths);
        return commands;
    }

    private static List<String> createArgsForNBalCompilerBackend(String entryBir, String objFileOutputPath, boolean dumpLLVM, boolean noOptimizeLLVM) {
        ArrayList<String> commands = new ArrayList<String>();
        if (javaCommand == null) {
            javaCommand = System.getProperty("java.command");
        }
        commands.add(javaCommand);
        commands.add(COMPILER_BACKEND_LLVM);
        commands.add(entryBir);
        commands.add(objFileOutputPath);
        commands.add(dumpLLVM ? "true" : "false");
        commands.add(noOptimizeLLVM ? "true" : "false");
        return commands;
    }

    private static String getMapPath() {
        String ballerinaNativeMap = System.getenv("BALLERINA_NATIVE_MAP");
        return ballerinaNativeMap == null ? " " : ballerinaNativeMap;
    }
}

