/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.util.HashSet;
import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.bir.BIRGen;
import org.wso2.ballerinalang.compiler.desugar.ConstantPropagation;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.CodeAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.CompilerPluginRunner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.DataflowAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.DocumentationAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TaintAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.util.RepoUtils;

public class CompilerDriver {
    private static final CompilerContext.Key<CompilerDriver> COMPILER_DRIVER_KEY = new CompilerContext.Key();
    private final CompilerOptions options;
    private final BLangDiagnosticLogHelper dlog;
    private final PackageLoader pkgLoader;
    private final PackageCache pkgCache;
    private final SymbolTable symbolTable;
    private final SymbolEnter symbolEnter;
    private final SymbolResolver symResolver;
    private final SemanticAnalyzer semAnalyzer;
    private final CodeAnalyzer codeAnalyzer;
    private final TaintAnalyzer taintAnalyzer;
    private final ConstantPropagation constantPropagation;
    private final DocumentationAnalyzer documentationAnalyzer;
    private final CompilerPluginRunner compilerPluginRunner;
    private final Desugar desugar;
    private final BIRGen birGenerator;
    private final CompilerPhase compilerPhase;
    private final DataflowAnalyzer dataflowAnalyzer;
    private boolean isToolingCompilation;

    public static CompilerDriver getInstance(CompilerContext context) {
        CompilerDriver compilerDriver = context.get(COMPILER_DRIVER_KEY);
        if (compilerDriver == null) {
            compilerDriver = new CompilerDriver(context);
        }
        return compilerDriver;
    }

    private CompilerDriver(CompilerContext context) {
        context.put(COMPILER_DRIVER_KEY, this);
        this.options = CompilerOptions.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.pkgLoader = PackageLoader.getInstance(context);
        this.pkgCache = PackageCache.getInstance(context);
        this.symbolTable = SymbolTable.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.semAnalyzer = SemanticAnalyzer.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.codeAnalyzer = CodeAnalyzer.getInstance(context);
        this.documentationAnalyzer = DocumentationAnalyzer.getInstance(context);
        this.taintAnalyzer = TaintAnalyzer.getInstance(context);
        this.constantPropagation = ConstantPropagation.getInstance(context);
        this.compilerPluginRunner = CompilerPluginRunner.getInstance(context);
        this.desugar = Desugar.getInstance(context);
        this.birGenerator = BIRGen.getInstance(context);
        this.compilerPhase = this.options.getCompilerPhase();
        this.dataflowAnalyzer = DataflowAnalyzer.getInstance(context);
        this.isToolingCompilation = this.options.isSet(CompilerOptionName.TOOLING_COMPILATION) && Boolean.parseBoolean(this.options.get(CompilerOptionName.TOOLING_COMPILATION));
    }

    public BLangPackage compilePackage(BLangPackage packageNode) {
        this.compilePackageSymbol(packageNode.symbol);
        return packageNode;
    }

    void loadLangModules(List<PackageID> pkgIdList) {
        if (!RepoUtils.LOAD_BUILTIN_FROM_SOURCE) {
            this.symbolTable.langAnnotationModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.ANNOTATIONS, null, null);
            this.symbolTable.langInternalModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.INTERNAL, null, null);
            this.symResolver.reloadErrorAndDependentTypes();
            this.symResolver.reloadIntRangeType();
            this.symbolTable.langArrayModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.ARRAY, null, null);
            this.symbolTable.langDecimalModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.DECIMAL, null, null);
            this.symbolTable.langErrorModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.ERROR, null, null);
            this.symbolTable.langFloatModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.FLOAT, null, null);
            this.symbolTable.langFutureModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.FUTURE, null, null);
            this.symbolTable.langIntModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.INT, null, null);
            this.symbolTable.langMapModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.MAP, null, null);
            this.symbolTable.langObjectModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.OBJECT, null, null);
            this.symbolTable.langStreamModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.STREAM, null, null);
            this.symbolTable.langStringModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.STRING, null, null);
            this.symbolTable.langTableModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.TABLE, null, null);
            this.symbolTable.langTypedescModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.TYPEDESC, null, null);
            this.symbolTable.langValueModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.VALUE, null, null);
            this.symbolTable.langXmlModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.XML, null, null);
            this.symbolTable.langBooleanModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.BOOLEAN, null, null);
            return;
        }
        PackageID langLib = pkgIdList.get(0);
        if (!PackageID.isLangLibPackageID(langLib)) {
            return;
        }
        if (langLib.equals(PackageID.ANNOTATIONS)) {
            this.symbolTable.langAnnotationModuleSymbol = this.getLangModuleFromSource(PackageID.ANNOTATIONS);
            return;
        }
        this.symbolTable.langAnnotationModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.ANNOTATIONS, null, null);
        this.symResolver.reloadErrorAndDependentTypes();
        if (langLib.equals(PackageID.INTERNAL)) {
            this.symbolTable.langInternalModuleSymbol = this.getLangModuleFromSource(PackageID.INTERNAL);
            return;
        }
        this.symbolTable.langInternalModuleSymbol = this.pkgLoader.loadPackageSymbol(PackageID.INTERNAL, null, null);
        this.symResolver.reloadIntRangeType();
        this.getLangModuleFromSource(langLib);
    }

    private void compilePackageSymbol(BPackageSymbol packageSymbol) {
        BLangPackage pkgNode = this.pkgCache.get(packageSymbol.pkgID);
        if (pkgNode == null) {
            return;
        }
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.TYPE_CHECK)) {
            return;
        }
        HashSet<BLangImportPackage> importPkgList = new HashSet<BLangImportPackage>();
        importPkgList.addAll(pkgNode.imports);
        String testsEnabled = this.options.get(CompilerOptionName.SKIP_TESTS);
        if (testsEnabled != null && testsEnabled.equals("false")) {
            pkgNode.getTestablePkgs().forEach(testablePackage -> importPkgList.addAll(testablePackage.imports));
        }
        for (BLangImportPackage pkg : importPkgList) {
            if (pkg.symbol == null) continue;
            this.compilePackageSymbol(pkg.symbol);
        }
        this.compile(pkgNode);
    }

    private void compile(BLangPackage pkgNode) {
        if (this.stopCompilation(pkgNode, CompilerPhase.TYPE_CHECK)) {
            return;
        }
        this.typeCheck(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.CODE_ANALYZE)) {
            return;
        }
        this.codeAnalyze(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.DATAFLOW_ANALYZE)) {
            return;
        }
        this.dataflowAnalyze(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.DOCUMENTATION_ANALYZE)) {
            return;
        }
        this.documentationAnalyze(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.TAINT_ANALYZE)) {
            return;
        }
        this.taintAnalyze(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.CONSTANT_PROPAGATION)) {
            return;
        }
        this.propagateConstants(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.COMPILER_PLUGIN)) {
            return;
        }
        this.annotationProcess(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.DESUGAR)) {
            return;
        }
        this.desugar(pkgNode);
        if (this.stopCompilation(pkgNode, CompilerPhase.BIR_GEN)) {
            return;
        }
        this.birGen(pkgNode);
    }

    public BLangPackage define(BLangPackage pkgNode) {
        return this.symbolEnter.definePackage(pkgNode);
    }

    private BLangPackage typeCheck(BLangPackage pkgNode) {
        return this.semAnalyzer.analyze(pkgNode);
    }

    private BLangPackage documentationAnalyze(BLangPackage pkgNode) {
        return this.documentationAnalyzer.analyze(pkgNode);
    }

    private BLangPackage codeAnalyze(BLangPackage pkgNode) {
        return this.codeAnalyzer.analyze(pkgNode);
    }

    private BLangPackage dataflowAnalyze(BLangPackage pkgNode) {
        return this.dataflowAnalyzer.analyze(pkgNode);
    }

    private BLangPackage taintAnalyze(BLangPackage pkgNode) {
        return this.taintAnalyzer.analyze(pkgNode);
    }

    private BLangPackage propagateConstants(BLangPackage pkgNode) {
        return this.constantPropagation.perform(pkgNode);
    }

    private BLangPackage annotationProcess(BLangPackage pkgNode) {
        return this.compilerPluginRunner.runPlugins(pkgNode);
    }

    public BLangPackage desugar(BLangPackage pkgNode) {
        return this.desugar.perform(pkgNode);
    }

    public BLangPackage birGen(BLangPackage pkgNode) {
        return this.birGenerator.genBIR(pkgNode);
    }

    private boolean stopCompilation(BLangPackage pkgNode, CompilerPhase nextPhase) {
        if (this.compilerPhase.compareTo(nextPhase) < 0) {
            return true;
        }
        return this.checkNextPhase(nextPhase) && this.dlog.getErrorCount() > 0;
    }

    private boolean checkNextPhase(CompilerPhase nextPhase) {
        return !this.isToolingCompilation && nextPhase == CompilerPhase.CODE_ANALYZE || nextPhase == CompilerPhase.TAINT_ANALYZE || nextPhase == CompilerPhase.COMPILER_PLUGIN || nextPhase == CompilerPhase.DESUGAR;
    }

    private BPackageSymbol getLangModuleFromSource(PackageID modID) {
        BLangPackage pkg = this.taintAnalyze(this.documentationAnalyzer.analyze(this.codeAnalyze(this.semAnalyzer.analyze(this.pkgLoader.loadAndDefinePackage(modID)))));
        if (this.dlog.getErrorCount() > 0) {
            return null;
        }
        return this.birGen((BLangPackage)this.desugar((BLangPackage)pkg)).symbol;
    }
}

