/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir;

import java.nio.file.Path;
import java.util.Set;
import org.wso2.ballerinalang.compiler.bir.codegen.CodeGenerator;
import org.wso2.ballerinalang.compiler.bir.emit.BIREmitter;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BackendDriver {
    private static final CompilerContext.Key<BackendDriver> BACKEND_DRIVER = new CompilerContext.Key();
    private CodeGenerator codeGenerator;
    private BIREmitter birEmitter;

    public static BackendDriver getInstance(CompilerContext context) {
        BackendDriver backendDriver = context.get(BACKEND_DRIVER);
        if (backendDriver == null) {
            backendDriver = new BackendDriver(context);
        }
        return backendDriver;
    }

    private BackendDriver(CompilerContext context) {
        context.put(BACKEND_DRIVER, this);
        this.codeGenerator = CodeGenerator.getInstance(context);
        this.birEmitter = BIREmitter.getInstance(context);
    }

    public void execute(BIRNode.BIRPackage birPackage, boolean dumpBIR, Path target) {
        if (dumpBIR) {
            this.birEmitter.emit(birPackage);
        }
        this.codeGen(birPackage, target, null);
    }

    public void execute(BIRNode.BIRPackage birPackage, boolean dumpBIR, Path target, Set<Path> moduleDependencies) {
        if (dumpBIR) {
            this.birEmitter.emit(birPackage);
        }
        this.codeGen(birPackage, target, moduleDependencies);
    }

    private void codeGen(BIRNode.BIRPackage birPackage, Path target, Set<Path> moduleDependencies) {
        this.codeGenerator.generate(birPackage, target, moduleDependencies);
    }
}

