/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;

public class CodeGenerator {
    private static final CompilerContext.Key<CodeGenerator> CODE_GEN = new CompilerContext.Key();
    public static BLangDiagnosticLogHelper dlog;
    static SymbolTable symbolTable;
    static PackageCache packageCache;
    private Map<String, BIRNode.BIRPackage> compiledPkgCache = new HashMap<String, BIRNode.BIRPackage>();

    private CodeGenerator(CompilerContext context) {
        context.put(CODE_GEN, this);
        symbolTable = SymbolTable.getInstance(context);
        packageCache = PackageCache.getInstance(context);
        dlog = BLangDiagnosticLogHelper.getInstance(context);
    }

    public static CodeGenerator getInstance(CompilerContext context) {
        CodeGenerator codeGenerator = context.get(CODE_GEN);
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(context);
        }
        return codeGenerator;
    }

    public void generate(BIRNode.BIRPackage entryMod, Path target, Set<Path> moduleDependencies) {
        if (this.compiledPkgCache.containsValue(entryMod)) {
            return;
        }
        JvmPackageGen.intiPackageGen();
        JvmPackageGen.symbolTable = symbolTable;
        JvmMethodGen.errorOrNilType = BUnionType.create(null, CodeGenerator.symbolTable.errorType, CodeGenerator.symbolTable.nilType);
        this.compiledPkgCache.put(entryMod.org.value + entryMod.name.value, entryMod);
        JvmPackageGen.JarFile jarFile = new JvmPackageGen.JarFile();
        this.populateExternalMap();
        ClassLoader classLoader = this.makeClassLoader(moduleDependencies);
        InteropValidator interopValidator = new InteropValidator(classLoader, symbolTable);
        JvmPackageGen.generatePackage(entryMod, jarFile, interopValidator, true);
        CodeGenerator.writeJarFile(jarFile, target);
    }

    private ClassLoader makeClassLoader(Set<Path> moduleDependencies) {
        if (moduleDependencies == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        ArrayList<URL> dependentJars = new ArrayList<URL>();
        for (Path dependency : moduleDependencies) {
            try {
                dependentJars.add(dependency.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new URLClassLoader(dependentJars.toArray(new URL[0]), null);
    }

    private void populateExternalMap() {
        String nativeMap = System.getenv("BALLERINA_NATIVE_MAP");
        if (nativeMap == null) {
            return;
        }
        File mapFile = new File(nativeMap);
        if (!mapFile.exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(mapFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("\"")) continue;
                int firstQuote = line.indexOf(34, 1);
                String key = line.substring(1, firstQuote);
                String value = line.substring(line.indexOf(34, firstQuote + 1) + 1, line.lastIndexOf(34));
                JvmPackageGen.externalMapCache.put(key, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeJarFile(JvmPackageGen.JarFile entries, Path targetPath) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (entries.manifestEntries != null) {
            Map<String, String> manifestEntries = entries.manifestEntries;
            manifestEntries.forEach((key, value) -> manifest.getMainAttributes().put(new Attributes.Name((String)key), value));
        }
        try (JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(targetPath.toString()), manifest);){
            if (entries.pkgEntries == null) {
                throw new BLangCompilerException("no class file entries found in the record");
            }
            Map<String, byte[]> jarEntries = entries.pkgEntries;
            for (Map.Entry<String, byte[]> keyVal : jarEntries.entrySet()) {
                byte[] entryContent = keyVal.getValue();
                JarEntry entry = new JarEntry(keyVal.getKey());
                target.putNextEntry(entry);
                target.write(entryContent);
                target.closeEntry();
            }
        }
        catch (IOException e) {
            throw new BLangCompilerException("jar file generation failed: " + e.getMessage(), e);
        }
    }
}

