/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.NameHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;

class JvmValueGen {
    static final NameHashComparator NAME_HASH_COMPARATOR = new NameHashComparator();

    JvmValueGen() {
    }

    static void injectDefaultParamInitsToAttachedFuncs(BIRNode.BIRPackage module) {
        List<BIRNode.BIRTypeDefinition> typeDefs = module.typeDefs;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            BType bType = typeDef.type;
            if (bType instanceof BServiceType) {
                JvmValueGen.desugarObjectMethods(module, bType, typeDef.attachedFuncs);
                continue;
            }
            if (bType.tag == 32 && !Symbols.isFlagOn(((BObjectType)bType).tsymbol.flags, 4096)) {
                JvmValueGen.desugarObjectMethods(module, bType, typeDef.attachedFuncs);
                continue;
            }
            if (bType.tag != 12) continue;
            JvmValueGen.desugarObjectMethods(module, bType, typeDef.attachedFuncs);
        }
    }

    private static void desugarObjectMethods(BIRNode.BIRPackage module, BType bType, @Nilable List<BIRNode.BIRFunction> attachedFuncs) {
        if (attachedFuncs == null) {
            return;
        }
        for (BIRNode.BIRFunction func : attachedFuncs) {
            if (func == null) continue;
            if (JvmMethodGen.isExternFunc(func)) {
                JvmPackageGen.BIRFunctionWrapper extFuncWrapper = ExternalMethodGen.lookupBIRFunctionWrapper(module, func, bType);
                if (extFuncWrapper instanceof ExternalMethodGen.OldStyleExternalFunctionWrapper) {
                    ExternalMethodGen.desugarOldExternFuncs(module, (ExternalMethodGen.OldStyleExternalFunctionWrapper)extFuncWrapper, func);
                }
            } else {
                JvmDesugarPhase.addDefaultableBooleanVarsToSignature(func);
            }
            JvmDesugarPhase.enrichWithDefaultableParamInits(JvmMethodGen.getFunction(func));
        }
    }

    static List<Label> createLabelsForSwitch(MethodVisitor mv, int nameRegIndex, @Nilable List<? extends NamedNode> nodes, Label defaultCaseLabel) {
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
        int i = 0;
        ArrayList<Label> labels = new ArrayList<Label>();
        int[] hashCodes = new int[nodes.size()];
        for (NamedNode namedNode : nodes) {
            if (namedNode == null) continue;
            labels.add(i, new Label());
            hashCodes[i] = JvmValueGen.getName(namedNode).hashCode();
            ++i;
        }
        mv.visitLookupSwitchInsn(defaultCaseLabel, hashCodes, labels.toArray(new Label[0]));
        return labels;
    }

    static void createDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/util/exceptions/BLangRuntimeException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"No such field or method: ");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", String.format("(L%s;)L%s;", "java/lang/String", "java/lang/StringBuilder"), false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", String.format("()L%s;", "java/lang/String"), false);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/util/exceptions/BLangRuntimeException", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
        mv.visitInsn(191);
    }

    static String getTypeValueClassName(Object module, String typeName) {
        String packageName;
        if (module instanceof BIRNode.BIRPackage) {
            BIRNode.BIRPackage birPackage = (BIRNode.BIRPackage)module;
            packageName = JvmPackageGen.getPackageName(birPackage.org.value, birPackage.name.value);
        } else if (module instanceof PackageID) {
            PackageID packageID = (PackageID)module;
            packageName = JvmPackageGen.getPackageName(packageID.orgName, packageID.name);
        } else {
            throw new ClassCastException("module should be PackageID or BIRPackage but is : " + (module == null ? "null" : module.getClass()));
        }
        return packageName + "$value$" + JvmMethodGen.cleanupTypeName(typeName);
    }

    static List<Label> createLabelsForEqualCheck(MethodVisitor mv, int nameRegIndex, @Nilable List<? extends NamedNode> nodes, List<Label> labels, Label defaultCaseLabel) {
        ArrayList<Label> targetLabels = new ArrayList<Label>();
        int i = 0;
        for (NamedNode namedNode : nodes) {
            if (namedNode == null) continue;
            mv.visitLabel(labels.get(i));
            mv.visitVarInsn(25, nameRegIndex);
            mv.visitLdcInsn((Object)JvmValueGen.getName(namedNode));
            mv.visitMethodInsn(182, "java/lang/String", "equals", String.format("(L%s;)Z", "java/lang/Object"), false);
            Label targetLabel = new Label();
            mv.visitJumpInsn(154, targetLabel);
            mv.visitJumpInsn(167, defaultCaseLabel);
            targetLabels.add(i, targetLabel);
            ++i;
        }
        return targetLabels;
    }

    private static String getName(Object node) {
        if (node instanceof NamedNode) {
            return ((NamedNode)node).getName().value;
        }
        throw new BLangCompilerException(String.format("Invalid node: %s", node));
    }

    static class ObjectGenerator {
        private BIRNode.BIRPackage module;
        @Nilable
        private BObjectType currentObjectType = null;

        private void createLambdas(ClassWriter cw) {
            for (Map.Entry<String, BIRInstruction> entry : JvmPackageGen.lambdas.entrySet()) {
                JvmMethodGen.generateLambdaMethod(entry.getValue(), cw, entry.getKey());
            }
            JvmPackageGen.lambdas = new HashMap<String, BIRInstruction>();
        }

        private void createObjectFields(ClassWriter cw, @Nilable List<BField> fields) {
            for (BField field : fields) {
                if (field == null) continue;
                FieldVisitor fvb = cw.visitField(0, field.name.value, JvmTypeGen.getTypeDesc(field.type), null, null);
                fvb.visitEnd();
                String lockClass = "Lorg/ballerinalang/jvm/BLock;";
                FieldVisitor fv = cw.visitField(17, JvmPackageGen.computeLockNameFromString(field.name.value), lockClass, null, null);
                fv.visitEnd();
            }
        }

        private void createObjectMethods(ClassWriter cw, @Nilable List<BIRNode.BIRFunction> attachedFuncs, boolean isService, String className, String typeName) {
            for (BIRNode.BIRFunction func : attachedFuncs) {
                if (func == null) continue;
                JvmMethodGen.generateMethod(func, cw, this.module, this.currentObjectType, isService, typeName);
            }
        }

        private void createObjectInit(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BObjectType"), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/AbstractObjectValue", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BObjectType"), false);
            String lockClass = "Lorg/ballerinalang/jvm/BLock;";
            for (BField field : fields) {
                if (field == null) continue;
                Label fLabel = new Label();
                mv.visitLabel(fLabel);
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, "org/ballerinalang/jvm/BLock");
                mv.visitInsn(89);
                mv.visitMethodInsn(183, "org/ballerinalang/jvm/BLock", "<init>", "()V", false);
                mv.visitFieldInsn(181, className, JvmPackageGen.computeLockNameFromString(field.name.value), lockClass);
            }
            mv.visitInsn(177);
            mv.visitMaxs(5, 5);
            mv.visitEnd();
        }

        private void createCallMethod(ClassWriter cw, @Nilable List<BIRNode.BIRFunction> functions, String objClassName, String objTypeName, boolean isService) {
            List<BIRNode.BIRFunction> funcs = JvmMethodGen.getFunctions(functions);
            MethodVisitor mv = cw.visitMethod(1, "call", String.format("(L%s;L%s;[L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object"), null, null);
            mv.visitCode();
            int funcNameRegIndex = 2;
            Label defaultCaseLabel = new Label();
            funcs.sort(NAME_HASH_COMPARATOR);
            List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, funcNameRegIndex, funcs, defaultCaseLabel);
            List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, funcNameRegIndex, funcs, labels, defaultCaseLabel);
            int i = 0;
            for (BIRNode.BIRFunction optionalFunc : funcs) {
                BIRNode.BIRFunction func = ObjectGenerator.getFunction(optionalFunc);
                Label targetLabel = targetLabels.get(i);
                mv.visitLabel(targetLabel);
                List<BType> paramTypes = func.type.paramTypes;
                BType retType = func.type.retType;
                String methodSig = "";
                methodSig = JvmMethodGen.getMethodDesc(paramTypes, retType, null, JvmInstructionGen.isBString);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                int j = 0;
                for (BType paramType : paramTypes) {
                    BType pType = JvmMethodGen.getType(paramType);
                    mv.visitVarInsn(25, 3);
                    mv.visitLdcInsn((Object)j);
                    mv.visitInsn(136);
                    mv.visitInsn(50);
                    JvmInstructionGen.addUnboxInsn(mv, pType);
                    ++j;
                }
                mv.visitMethodInsn(182, objClassName, func.name.value, methodSig, false);
                if (retType == null || retType.tag == 10) {
                    mv.visitInsn(1);
                } else {
                    JvmInstructionGen.addBoxInsn(mv, retType);
                    if (isService) {
                        mv.visitMethodInsn(184, "org/ballerinalang/jvm/BallerinaErrors", "handleResourceError", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), false);
                    }
                }
                mv.visitInsn(176);
                ++i;
            }
            JvmValueGen.createDefaultCase(mv, defaultCaseLabel, funcNameRegIndex);
            mv.visitMaxs(funcs.size() + 10, funcs.size() + 10);
            mv.visitEnd();
        }

        private void createObjectGetMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            String signature = String.format("(L%s;)L%s;", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/StringValue" : "java/lang/String", "java/lang/Object");
            MethodVisitor mv = cw.visitMethod(1, "get", signature, null, null);
            mv.visitCode();
            int fieldNameRegIndex = 1;
            if (JvmInstructionGen.isBString) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/StringValue", "getValue", String.format("()L%s;", "java/lang/String"), true);
                fieldNameRegIndex = 2;
                mv.visitVarInsn(58, fieldNameRegIndex);
            }
            Label defaultCaseLabel = new Label();
            ArrayList<BField> sortedFields = new ArrayList<BField>(fields);
            sortedFields.sort(NAME_HASH_COMPARATOR);
            List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, fieldNameRegIndex, sortedFields, defaultCaseLabel);
            List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, fieldNameRegIndex, sortedFields, labels, defaultCaseLabel);
            int i = 0;
            for (BField optionalField : sortedFields) {
                BField field = JvmMethodGen.getObjectField(optionalField);
                Label targetLabel = targetLabels.get(i);
                mv.visitLabel(targetLabel);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, field.name.value, JvmTypeGen.getTypeDesc(field.type));
                JvmInstructionGen.addBoxInsn(mv, field.type);
                mv.visitInsn(176);
                ++i;
            }
            JvmValueGen.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createObjectSetMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "set", String.format("(L%s;L%s;)V", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String", "java/lang/Object"), null, null);
            mv.visitCode();
            int fieldNameRegIndex = 1;
            int valueRegIndex = 2;
            Label defaultCaseLabel = new Label();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, fieldNameRegIndex);
            if (JvmInstructionGen.isBString) {
                mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/api/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
                mv.visitInsn(89);
                fieldNameRegIndex = 3;
                mv.visitVarInsn(58, fieldNameRegIndex);
            }
            mv.visitVarInsn(25, valueRegIndex);
            mv.visitMethodInsn(182, className, "checkFieldUpdate", String.format("(L%s;L%s;)V", "java/lang/String", "java/lang/Object"), false);
            ArrayList<BField> sortedFields = new ArrayList<BField>(fields);
            sortedFields.sort(NAME_HASH_COMPARATOR);
            List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, fieldNameRegIndex, sortedFields, defaultCaseLabel);
            List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, fieldNameRegIndex, sortedFields, labels, defaultCaseLabel);
            int i = 0;
            for (BField optionalField : sortedFields) {
                BField field = JvmMethodGen.getObjectField(optionalField);
                Label targetLabel = targetLabels.get(i);
                mv.visitLabel(targetLabel);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, valueRegIndex);
                JvmInstructionGen.addUnboxInsn(mv, field.type);
                String filedName = field.name.value;
                mv.visitFieldInsn(181, className, filedName, JvmTypeGen.getTypeDesc(field.type));
                mv.visitInsn(177);
                ++i;
            }
            JvmValueGen.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static BIRNode.BIRFunction getFunction(@Nilable BIRNode.BIRFunction func) {
            if (func == null) {
                throw new BLangCompilerException(String.format("Invalid function: %s", func));
            }
            return func;
        }

        private byte[] createRecordValueClass(BRecordType recordType, String className, BIRNode.BIRTypeDefinition typeDef) {
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            if (typeDef.pos != null && typeDef.pos.src != null) {
                cw.visitSource(typeDef.pos.getSource().cUnitName, null);
            } else {
                cw.visitSource(className, null);
            }
            JvmPackageGen.currentClass = className;
            cw.visit(52, 33, className, String.format("<K:L%s;V:L%s;>L%s<TK;TV;>;L%s<TK;TV;>;", "java/lang/Object", "java/lang/Object", "org/ballerinalang/jvm/values/MapValueImpl", "org/ballerinalang/jvm/values/MapValue"), "org/ballerinalang/jvm/values/MapValueImpl", new String[]{"org/ballerinalang/jvm/values/MapValue"});
            List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
            if (attachedFuncs != null) {
                this.createRecordMethods(cw, attachedFuncs);
            }
            List fields = recordType.fields;
            this.createRecordFields(cw, fields);
            this.createRecordGetMethod(cw, fields, className);
            this.createRecordSetMethod(cw, fields, className);
            this.createRecordEntrySetMethod(cw, fields, className);
            this.createRecordContainsKeyMethod(cw, fields, className);
            this.createRecordGetValuesMethod(cw, fields, className);
            this.createGetSizeMethod(cw, fields, className);
            this.createRecordRemoveMethod(cw);
            this.createRecordClearMethod(cw, fields, className);
            this.createRecordGetKeysMethod(cw, fields, className);
            this.createRecordConstructor(cw, className);
            this.createRecordInitWrapper(cw, className, typeDef);
            this.createLambdas(cw);
            cw.visitEnd();
            return JvmPackageGen.getBytes(cw, typeDef);
        }

        private void createRecordMethods(ClassWriter cw, @Nilable List<BIRNode.BIRFunction> attachedFuncs) {
            for (BIRNode.BIRFunction func : attachedFuncs) {
                if (func == null) continue;
                JvmMethodGen.generateMethod(func, cw, this.module, null, false, "");
            }
        }

        private void createRecordConstructor(ClassWriter cw, String className) {
            MethodVisitor mv = cw.visitMethod(1, "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createRecordInitWrapper(ClassWriter cw, String className, BIRNode.BIRTypeDefinition typeDef) {
            String valueClassName;
            String initFuncName;
            MethodVisitor mv = cw.visitMethod(9, "$init", String.format("(L%s;L%s;)V", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/values/MapValue"), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            for (BType typeRef : typeDef.referencedTypes) {
                if (typeRef.tag != 12) continue;
                String refTypeClassName = JvmValueGen.getTypeValueClassName(typeRef.tsymbol.pkgID, JvmTerminatorGen.TerminatorGenerator.toNameString(typeRef));
                mv.visitInsn(92);
                mv.visitMethodInsn(184, refTypeClassName, "$init", String.format("(L%s;L%s;)V", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/values/MapValue"), false);
            }
            List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
            if (attachedFuncs.size() != 0) {
                initFuncName = attachedFuncs.get((int)0).name.value;
                valueClassName = className;
            } else {
                BRecordType recordType = (BRecordType)typeDef.type;
                valueClassName = JvmValueGen.getTypeValueClassName(recordType.tsymbol.pkgID, JvmTerminatorGen.TerminatorGenerator.toNameString(recordType));
                initFuncName = JvmMethodGen.cleanupFunctionName(recordType.name + "__init_");
            }
            mv.visitMethodInsn(184, valueClassName, initFuncName, String.format("(L%s;L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/values/MapValue", "java/lang/Object"), false);
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createRecordFields(ClassWriter cw, @Nilable List<BField> fields) {
            for (BField field : fields) {
                if (field == null) continue;
                FieldVisitor fv = cw.visitField(0, field.name.value, JvmTypeGen.getTypeDesc(field.type), null, null);
                fv.visitEnd();
                if (!this.isOptionalRecordField(field)) continue;
                fv = cw.visitField(0, this.getFieldIsPresentFlagName(field.name.value), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType), null, null);
                fv.visitEnd();
            }
        }

        private String getFieldIsPresentFlagName(String fieldName) {
            return String.format("%s$isPresent", fieldName);
        }

        private boolean isOptionalRecordField(BField field) {
            return (field.symbol.flags & 0x2000) == 8192;
        }

        private void createRecordGetMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "get", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), String.format("(L%s;)TV;", "java/lang/Object"), null);
            mv.visitCode();
            int fieldNameRegIndex = 1;
            int strKeyVarIndex = 2;
            Label defaultCaseLabel = new Label();
            mv.visitVarInsn(25, fieldNameRegIndex);
            mv.visitTypeInsn(192, JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String");
            if (JvmInstructionGen.isBString) {
                mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/api/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
            }
            mv.visitVarInsn(58, strKeyVarIndex);
            ArrayList<BField> sortedFields = new ArrayList<BField>(fields);
            sortedFields.sort(NAME_HASH_COMPARATOR);
            List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
            List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
            int i = 0;
            for (BField optionalField : sortedFields) {
                BField field = JvmMethodGen.getRecordField(optionalField);
                Label targetLabel = targetLabels.get(i);
                mv.visitLabel(targetLabel);
                Label ifPresentLabel = new Label();
                String fieldName = field.name.value;
                if (this.isOptionalRecordField(field)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                    mv.visitJumpInsn(154, ifPresentLabel);
                    mv.visitInsn(1);
                    mv.visitInsn(176);
                }
                mv.visitLabel(ifPresentLabel);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(field.type));
                JvmInstructionGen.addBoxInsn(mv, field.type);
                mv.visitInsn(176);
                ++i;
            }
            this.createRecordGetDefaultCase(mv, defaultCaseLabel, strKeyVarIndex);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createRecordSetMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(4, "putValue", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), "(TK;TV;)TV;", null);
            mv.visitCode();
            int fieldNameRegIndex = 1;
            int valueRegIndex = 2;
            int strKeyVarIndex = 3;
            Label defaultCaseLabel = new Label();
            mv.visitVarInsn(25, fieldNameRegIndex);
            mv.visitTypeInsn(192, JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/StringValue" : "java/lang/String");
            if (JvmInstructionGen.isBString) {
                mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/StringValue", "getValue", String.format("()L%s;", "java/lang/String"), true);
            }
            mv.visitVarInsn(58, strKeyVarIndex);
            ArrayList<BField> sortedFields = new ArrayList<BField>(fields);
            sortedFields.sort(NAME_HASH_COMPARATOR);
            List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
            List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
            int i = 0;
            for (BField optionalField : sortedFields) {
                BField field = JvmMethodGen.getRecordField(optionalField);
                Label targetLabel = targetLabels.get(i);
                mv.visitLabel(targetLabel);
                String fieldName = field.name.value;
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(field.type));
                JvmInstructionGen.addBoxInsn(mv, field.type);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, valueRegIndex);
                JvmInstructionGen.addUnboxInsn(mv, field.type);
                mv.visitFieldInsn(181, className, fieldName, JvmTypeGen.getTypeDesc(field.type));
                if (this.isOptionalRecordField(field)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitInsn(4);
                    mv.visitFieldInsn(181, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                }
                mv.visitInsn(176);
                ++i;
            }
            this.createRecordPutDefaultCase(mv, defaultCaseLabel, strKeyVarIndex, valueRegIndex);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createRecordPutDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex, int valueRegIndex) {
            mv.visitLabel(defaultCaseLabel);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, nameRegIndex);
            mv.visitVarInsn(25, valueRegIndex);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "putValue", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), false);
            mv.visitInsn(176);
        }

        private void createRecordGetDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex) {
            mv.visitLabel(defaultCaseLabel);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, nameRegIndex);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "get", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), false);
            mv.visitInsn(176);
        }

        private void createRecordEntrySetMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "entrySet", String.format("()L%s;", "java/util/Set"), String.format("()L%s<L%s<TK;TV;>;>;", "java/util/Set", "java/util/Map$Entry"), null);
            mv.visitCode();
            int entrySetVarIndex = 1;
            mv.visitTypeInsn(187, "java/util/LinkedHashSet");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
            mv.visitVarInsn(58, entrySetVarIndex);
            for (BField optionalField : fields) {
                BField field = JvmMethodGen.getRecordField(optionalField);
                Label ifNotPresent = new Label();
                String fieldName = field.name.value;
                if (this.isOptionalRecordField(field)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                    mv.visitJumpInsn(153, ifNotPresent);
                }
                mv.visitVarInsn(25, entrySetVarIndex);
                mv.visitTypeInsn(187, "java/util/AbstractMap$SimpleEntry");
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)fieldName);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(field.type));
                JvmInstructionGen.addBoxInsn(mv, field.type);
                mv.visitMethodInsn(183, "java/util/AbstractMap$SimpleEntry", "<init>", String.format("(L%s;L%s;)V", "java/lang/Object", "java/lang/Object"), false);
                mv.visitMethodInsn(185, "java/util/Set", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
                mv.visitInsn(87);
                mv.visitLabel(ifNotPresent);
            }
            mv.visitVarInsn(25, entrySetVarIndex);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/util/LinkedHashMap", "entrySet", String.format("()L%s;", "java/util/Set"), false);
            mv.visitMethodInsn(185, "java/util/Set", "addAll", String.format("(L%s;)Z", "java/util/Collection"), true);
            mv.visitInsn(87);
            mv.visitVarInsn(25, entrySetVarIndex);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createRecordContainsKeyMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "containsKey", String.format("(L%s;)Z", "java/lang/Object"), null, null);
            mv.visitCode();
            int fieldNameRegIndex = 1;
            int strKeyVarIndex = 2;
            mv.visitVarInsn(25, fieldNameRegIndex);
            mv.visitTypeInsn(192, JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String");
            if (JvmInstructionGen.isBString) {
                mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/api/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
            }
            mv.visitVarInsn(58, strKeyVarIndex);
            ArrayList<BField> sortedFields = new ArrayList<BField>(fields);
            sortedFields.sort(NAME_HASH_COMPARATOR);
            Label defaultCaseLabel = new Label();
            List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
            List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
            int i = 0;
            for (BField optionalField : sortedFields) {
                BField field = JvmMethodGen.getObjectField(optionalField);
                Label targetLabel = targetLabels.get(i);
                mv.visitLabel(targetLabel);
                String fieldName = field.name.value;
                if (this.isOptionalRecordField(field)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                } else {
                    mv.visitLdcInsn((Object)true);
                }
                mv.visitInsn(172);
                ++i;
            }
            mv.visitLabel(defaultCaseLabel);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, strKeyVarIndex);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "containsKey", String.format("(L%s;)Z", "java/lang/Object"), false);
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        void createRecordGetValuesMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "values", String.format("()L%s;", "java/util/Collection"), String.format("()L%s<TV;>;", "java/util/Collection"), null);
            mv.visitCode();
            int valuesVarIndex = 1;
            mv.visitTypeInsn(187, "java/util/ArrayList");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
            mv.visitVarInsn(58, valuesVarIndex);
            for (BField optionalField : fields) {
                BField field = JvmMethodGen.getRecordField(optionalField);
                Label ifNotPresent = new Label();
                String fieldName = field.name.value;
                if (this.isOptionalRecordField(field)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                    mv.visitJumpInsn(153, ifNotPresent);
                }
                mv.visitVarInsn(25, valuesVarIndex);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(field.type));
                JvmInstructionGen.addBoxInsn(mv, field.type);
                mv.visitMethodInsn(185, "java/util/List", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
                mv.visitInsn(87);
                mv.visitLabel(ifNotPresent);
            }
            mv.visitVarInsn(25, valuesVarIndex);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "values", String.format("()L%s;", "java/util/Collection"), false);
            mv.visitMethodInsn(185, "java/util/List", "addAll", String.format("(L%s;)Z", "java/util/Collection"), true);
            mv.visitInsn(87);
            mv.visitVarInsn(25, 1);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        void createGetSizeMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "size", "()I", null, null);
            mv.visitCode();
            int sizeVarIndex = 1;
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "size", "()I", false);
            mv.visitVarInsn(54, sizeVarIndex);
            int requiredFieldsCount = 0;
            for (BField optionalField : fields) {
                BField field = JvmMethodGen.getObjectField(optionalField);
                String fieldName = field.name.value;
                if (this.isOptionalRecordField(field)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                    Label l3 = new Label();
                    mv.visitJumpInsn(153, l3);
                    mv.visitIincInsn(sizeVarIndex, 1);
                    mv.visitLabel(l3);
                    continue;
                }
                ++requiredFieldsCount;
            }
            mv.visitIincInsn(sizeVarIndex, requiredFieldsCount);
            mv.visitVarInsn(21, sizeVarIndex);
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createRecordRemoveMethod(ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, "clear", "()V", null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V", false);
            mv.visitInsn(191);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void createRecordClearMethod(ClassWriter cw, List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "remove", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), String.format("(L%s;)TV;", "java/lang/Object"), null);
            mv.visitCode();
            int fieldNameRegIndex = 1;
            int strKeyVarIndex = 2;
            mv.visitVarInsn(25, fieldNameRegIndex);
            mv.visitTypeInsn(192, "java/lang/String");
            mv.visitVarInsn(58, strKeyVarIndex);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "validateFreezeStatus", "()V", false);
            ArrayList<BField> sortedFields = new ArrayList<BField>(fields);
            sortedFields.sort(NAME_HASH_COMPARATOR);
            Label defaultCaseLabel = new Label();
            List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
            List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
            int i = 0;
            for (BField optionalField : sortedFields) {
                BField field = JvmMethodGen.getObjectField(optionalField);
                Label targetLabel = targetLabels.get(i);
                mv.visitLabel(targetLabel);
                if (this.isOptionalRecordField(field)) {
                    String fieldName = field.name.value;
                    mv.visitVarInsn(25, 0);
                    mv.visitInsn(3);
                    mv.visitFieldInsn(181, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(field.type));
                    JvmInstructionGen.addBoxInsn(mv, field.type);
                    if (this.checkIfValueIsJReferenceType(field.type)) {
                        mv.visitVarInsn(25, 0);
                        mv.visitInsn(1);
                        mv.visitFieldInsn(181, className, fieldName, JvmTypeGen.getTypeDesc(field.type));
                    }
                    mv.visitInsn(176);
                } else {
                    mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
                    mv.visitInsn(89);
                    mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V", false);
                    mv.visitInsn(191);
                }
                ++i;
            }
            mv.visitLabel(defaultCaseLabel);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, strKeyVarIndex);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/MapValueImpl", "remove", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private boolean checkIfValueIsJReferenceType(BType bType) {
            switch (bType.getKind()) {
                case INT: 
                case BOOLEAN: 
                case FLOAT: 
                case BYTE: {
                    return false;
                }
            }
            return true;
        }

        void createRecordGetKeysMethod(ClassWriter cw, @Nilable List<BField> fields, String className) {
            MethodVisitor mv = cw.visitMethod(1, "getKeys", String.format("()[L%s;", "java/lang/Object"), "()[TK;", null);
            mv.visitCode();
            int keysVarIndex = 1;
            mv.visitTypeInsn(187, "java/util/LinkedHashSet");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
            mv.visitVarInsn(58, keysVarIndex);
            for (BField optionalField : fields) {
                BField field = JvmMethodGen.getRecordField(optionalField);
                Label ifNotPresent = new Label();
                String fieldName = field.name.value;
                if (this.isOptionalRecordField(field)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(JvmPackageGen.symbolTable.booleanType));
                    mv.visitJumpInsn(153, ifNotPresent);
                }
                mv.visitVarInsn(25, keysVarIndex);
                mv.visitLdcInsn((Object)fieldName);
                mv.visitMethodInsn(185, "java/util/Set", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
                mv.visitInsn(87);
                mv.visitLabel(ifNotPresent);
            }
            mv.visitVarInsn(25, keysVarIndex);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/util/LinkedHashMap", "keySet", String.format("()L%s;", "java/util/Set"), false);
            mv.visitMethodInsn(185, "java/util/Set", "addAll", String.format("(L%s;)Z", "java/util/Collection"), true);
            mv.visitInsn(87);
            mv.visitVarInsn(25, keysVarIndex);
            mv.visitInsn(89);
            mv.visitMethodInsn(185, "java/util/Set", "size", "()I", true);
            mv.visitTypeInsn(189, "java/lang/String");
            mv.visitMethodInsn(185, "java/util/Set", "toArray", String.format("([L%s;)[L%s;", "java/lang/Object", "java/lang/Object"), true);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        ObjectGenerator(BIRNode.BIRPackage module) {
            this.module = module;
        }

        void generateValueClasses(@Nilable List<BIRNode.BIRTypeDefinition> typeDefs, Map<String, byte[]> jarEntries) {
            for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
                byte[] bytes;
                String className;
                BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
                BType bType = typeDef.type;
                if (bType instanceof BServiceType) {
                    BServiceType serviceType = (BServiceType)bType;
                    this.currentObjectType = serviceType;
                    className = JvmValueGen.getTypeValueClassName(this.module, typeDef.name.value);
                    bytes = this.createObjectValueClass(serviceType, className, typeDef, true);
                    jarEntries.put(className + ".class", bytes);
                    continue;
                }
                if (bType.tag == 32 && !Symbols.isFlagOn(((BObjectType)bType).tsymbol.flags, 4096)) {
                    BObjectType objectType;
                    this.currentObjectType = objectType = (BObjectType)bType;
                    className = JvmValueGen.getTypeValueClassName(this.module, typeDef.name.value);
                    bytes = this.createObjectValueClass(objectType, className, typeDef, false);
                    jarEntries.put(className + ".class", bytes);
                    continue;
                }
                if (bType.tag != 12) continue;
                BRecordType recordType = (BRecordType)bType;
                className = JvmValueGen.getTypeValueClassName(this.module, typeDef.name.value);
                bytes = this.createRecordValueClass(recordType, className, typeDef);
                jarEntries.put(className + ".class", bytes);
            }
        }

        private byte[] createObjectValueClass(BObjectType objectType, String className, BIRNode.BIRTypeDefinition typeDef, boolean isService) {
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            cw.visitSource(typeDef.pos.getSource().cUnitName, null);
            JvmPackageGen.currentClass = className;
            cw.visit(52, 33, className, null, "org/ballerinalang/jvm/values/AbstractObjectValue", new String[]{"org/ballerinalang/jvm/values/ObjectValue"});
            List fields = objectType.fields;
            this.createObjectFields(cw, fields);
            List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
            if (attachedFuncs != null) {
                this.createObjectMethods(cw, attachedFuncs, isService, className, typeDef.name.value);
            }
            this.createObjectInit(cw, fields, className);
            this.createCallMethod(cw, attachedFuncs, className, JvmTerminatorGen.TerminatorGenerator.toNameString(objectType), isService);
            this.createObjectGetMethod(cw, fields, className);
            this.createObjectSetMethod(cw, fields, className);
            this.createLambdas(cw);
            cw.visitEnd();
            return JvmPackageGen.getBytes(cw, typeDef);
        }
    }
}

