/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;

public class AnnotationProc {
    public static final String NAME_FIELD_NAME = "name";
    public static final String CLASS_FIELD_NAME = "class";
    public static final String FIELD_METHOD_FIELD_NAME = "method";
    public static final String PARAM_TYPES_FIELD_NAME = "paramTypes";
    public static final String DIMENSIONS_FIELD_NAME = "dimensions";

    @Nilable
    static InteropValidationRequest getInteropAnnotValue(BIRNode.BIRFunction birFunc) {
        BIRNode.BIRAnnotationAttachment annotAttach = AnnotationProc.getInteropAnnotAttachment(birFunc);
        if (annotAttach == null) {
            return null;
        }
        String annotTagRef = annotAttach.annotTagRef.value;
        return AnnotationProc.createJInteropValidationRequest(annotTagRef, annotAttach, birFunc);
    }

    @Nilable
    private static BIRNode.BIRAnnotationAttachment getInteropAnnotAttachment(BIRNode.BIRFunction birFunc) {
        for (BIRNode.BIRAnnotationAttachment annotationAttachment : birFunc.annotAttachments) {
            if (!AnnotationProc.isInteropAnnotAttachment(annotationAttachment)) continue;
            return annotationAttachment;
        }
        return null;
    }

    private static boolean isInteropAnnotAttachment(BIRNode.BIRAnnotationAttachment annotAttach) {
        return "ballerina".equals(annotAttach.packageID.orgName.value) && "java".equals(annotAttach.packageID.name.value) && JInterop.isInteropAnnotationTag(annotAttach.annotTagRef.value);
    }

    private static InteropValidationRequest createJInteropValidationRequest(String annotTagRef, BIRNode.BIRAnnotationAttachment annotAttach, BIRNode.BIRFunction birFunc) {
        BIRNode.BIRAnnotationRecordValue annotRecValue = (BIRNode.BIRAnnotationRecordValue)annotAttach.annotValues.get(0);
        Map<String, BIRNode.BIRAnnotationValue> annotValueMap = annotRecValue.annotValueEntryMap;
        if (JInterop.isMethodAnnotationTag(annotTagRef)) {
            return AnnotationProc.createJMethodValidationRequest(annotTagRef, annotValueMap, birFunc);
        }
        return AnnotationProc.createJFieldValidationRequest(annotTagRef, annotValueMap, birFunc);
    }

    private static InteropValidationRequest createJMethodValidationRequest(String annotTagRef, Map<String, BIRNode.BIRAnnotationValue> annotValues, BIRNode.BIRFunction birFunc) {
        InteropValidationRequest.MethodValidationRequest valRequest = new InteropValidationRequest.MethodValidationRequest(AnnotationProc.getJMethodNameFromAnnot(annotTagRef, annotValues.get(NAME_FIELD_NAME), birFunc), (String)AnnotationProc.getLiteralValueFromAnnotValue(annotValues.get(CLASS_FIELD_NAME)), birFunc.type, JInterop.getMethodKindFromAnnotTag(annotTagRef));
        List<JType> paramTypeConstraints = AnnotationProc.buildParamTypeConstraints(annotValues.get(PARAM_TYPES_FIELD_NAME));
        if (paramTypeConstraints != null) {
            valRequest.paramTypeConstraints = paramTypeConstraints;
        }
        return valRequest;
    }

    private static InteropValidationRequest createJFieldValidationRequest(String annotTagRef, Map<String, BIRNode.BIRAnnotationValue> annotValues, BIRNode.BIRFunction birFunc) {
        return new InteropValidationRequest.FieldValidationRequest(AnnotationProc.getJFieldNameFromAnnot(annotValues.get(NAME_FIELD_NAME), birFunc), (String)AnnotationProc.getLiteralValueFromAnnotValue(annotValues.get(CLASS_FIELD_NAME)), birFunc.type, JInterop.getFieldMethodFromAnnotTag(annotTagRef));
    }

    @Nilable
    private static List<JType> buildParamTypeConstraints(@Nilable BIRNode.BIRAnnotationValue annotValue) {
        if (annotValue instanceof BIRNode.BIRAnnotationArrayValue) {
            BIRNode.BIRAnnotationValue[] annotArrayElements = ((BIRNode.BIRAnnotationArrayValue)annotValue).annotArrayValue;
            ArrayList<JType> constraints = new ArrayList<JType>();
            for (BIRNode.BIRAnnotationValue annotArrayElement : annotArrayElements) {
                JType jType;
                if (annotArrayElement instanceof BIRNode.BIRAnnotationLiteralValue) {
                    jType = JType.getJTypeFromTypeName((String)((BIRNode.BIRAnnotationLiteralValue)annotArrayElement).value);
                } else if (annotArrayElement instanceof BIRNode.BIRAnnotationRecordValue) {
                    Map<String, BIRNode.BIRAnnotationValue> annotValueMap = ((BIRNode.BIRAnnotationRecordValue)annotArrayElement).annotValueEntryMap;
                    String elementClass = (String)AnnotationProc.getLiteralValueFromAnnotValue(annotValueMap.get(CLASS_FIELD_NAME));
                    byte dimensions = ((Long)AnnotationProc.getLiteralValueFromAnnotValue(annotValueMap.get(DIMENSIONS_FIELD_NAME))).byteValue();
                    jType = JType.getJArrayTypeFromTypeName(elementClass, dimensions);
                } else {
                    throw new BLangCompilerException(String.format("unexpected annotation value: %s", annotArrayElement));
                }
                constraints.add(jType);
            }
            return constraints;
        }
        return null;
    }

    private static Object getLiteralValueFromAnnotValue(@Nilable BIRNode.BIRAnnotationValue annotValue) {
        if (annotValue == null) {
            return null;
        }
        if (annotValue instanceof BIRNode.BIRAnnotationLiteralValue) {
            return ((BIRNode.BIRAnnotationLiteralValue)annotValue).value;
        }
        throw new BLangCompilerException(String.format("unexpected annotation value, expected a literal value, found %s", annotValue));
    }

    private static String getJMethodNameFromAnnot(String annotTagRef, @Nilable BIRNode.BIRAnnotationValue jNameValueEntry, BIRNode.BIRFunction birFunc) {
        if (annotTagRef.equals("Constructor")) {
            return "<init>";
        }
        String methodName = (String)AnnotationProc.getLiteralValueFromAnnotValue(jNameValueEntry);
        return methodName != null ? methodName : birFunc.name.value;
    }

    private static String getJFieldNameFromAnnot(@Nilable BIRNode.BIRAnnotationValue jNameValueEntry, BIRNode.BIRFunction birFunc) {
        String fieldName = (String)AnnotationProc.getLiteralValueFromAnnotValue(jNameValueEntry);
        return fieldName != null ? fieldName : birFunc.name.value;
    }
}

