/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.objectweb.asm.ClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.AnnotationProc;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ExternalMethodGen {
    public static void genJMethodForBExternalFunc(BIRNode.BIRFunction birFunc, ClassWriter cw, BIRNode.BIRPackage birModule, @Nilable BType attachedType) {
        ExternalFunctionWrapper extFuncWrapper = ExternalMethodGen.getExternalFunctionWrapper(birModule, birFunc, attachedType);
        if (extFuncWrapper instanceof InteropMethodGen.JFieldFunctionWrapper) {
            InteropMethodGen.genJFieldForInteropField((InteropMethodGen.JFieldFunctionWrapper)extFuncWrapper, cw, birModule);
        } else {
            JvmMethodGen.genJMethodForBFunc(birFunc, cw, birModule, false, "", attachedType);
        }
    }

    public static void injectDefaultParamInits(BIRNode.BIRPackage module) {
        List<BIRNode.BIRFunction> functions = module.functions;
        if (functions.size() > 0) {
            int funcSize = functions.size();
            for (int count = 3; count < funcSize; ++count) {
                BIRNode.BIRFunction birFunc = functions.get(count);
                JvmPackageGen.BIRFunctionWrapper extFuncWrapper = ExternalMethodGen.lookupBIRFunctionWrapper(module, birFunc, null);
                if (extFuncWrapper instanceof OldStyleExternalFunctionWrapper) {
                    ExternalMethodGen.desugarOldExternFuncs(module, (OldStyleExternalFunctionWrapper)extFuncWrapper, birFunc);
                    JvmDesugarPhase.enrichWithDefaultableParamInits(birFunc);
                    continue;
                }
                if (!(extFuncWrapper instanceof InteropMethodGen.JMethodFunctionWrapper)) continue;
                InteropMethodGen.desugarInteropFuncs(module, (InteropMethodGen.JMethodFunctionWrapper)extFuncWrapper, birFunc);
                JvmDesugarPhase.enrichWithDefaultableParamInits(birFunc);
            }
        }
    }

    public static void desugarOldExternFuncs(BIRNode.BIRPackage module, OldStyleExternalFunctionWrapper extFuncWrapper, BIRNode.BIRFunction birFunc) {
        BType retType = birFunc.type.retType;
        BIROperand retRef = null;
        if (retType.tag != 10) {
            BIRNode.BIRVariableDcl localVar = JvmMethodGen.getVariableDcl(birFunc.localVars.get(0));
            BIRNode.BIRVariableDcl variableDcl = new BIRNode.BIRVariableDcl(retType, localVar.name, localVar.scope, localVar.kind);
            retRef = new BIROperand(variableDcl);
        }
        JvmMethodGen.nextId = -1;
        JvmMethodGen.nextVarId = -1;
        BIRNode.BIRBasicBlock beginBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, "wrapperGen");
        BIRNode.BIRBasicBlock retBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, "wrapperGen");
        ArrayList<BIROperand> args = new ArrayList<BIROperand>();
        BIRNode.BIRVariableDcl receiver = birFunc.receiver;
        if (receiver != null) {
            BIROperand argRef = new BIROperand(receiver);
            args.add(argRef);
        }
        Set<BIRNode.BIRFunctionParameter> birFuncParams = birFunc.parameters.keySet();
        for (BIRNode.BIRFunctionParameter birFuncParam : birFuncParams) {
            BIROperand argRef = new BIROperand(birFuncParam);
            args.add(argRef);
        }
        String jMethodName = birFunc.name.value;
        beginBB.terminator = new JavaMethodCall(birFunc.pos, InstructionKind.PLATFORM, args, retRef, extFuncWrapper.jClassName, extFuncWrapper.jMethodVMSigBString != null ? extFuncWrapper.jMethodVMSigBString : "<error>", extFuncWrapper.jMethodVMSig, jMethodName, retBB);
        retBB.terminator = new BIRTerminator.Return(birFunc.pos);
    }

    private static ExternalFunctionWrapper getExternalFunctionWrapper(BIRNode.BIRPackage birModule, BIRNode.BIRFunction birFunc, @Nilable BType attachedType) {
        JvmPackageGen.BIRFunctionWrapper birFuncWrapper = ExternalMethodGen.lookupBIRFunctionWrapper(birModule, birFunc, attachedType);
        if (birFuncWrapper instanceof ExternalFunctionWrapper) {
            return (ExternalFunctionWrapper)((Object)birFuncWrapper);
        }
        throw new BLangCompilerException("cannot find function definition for : " + birFunc.name.value);
    }

    public static JvmPackageGen.BIRFunctionWrapper lookupBIRFunctionWrapper(BIRNode.BIRPackage birModule, BIRNode.BIRFunction birFunc, @Nilable BType attachedType) {
        String lookupKey;
        String currentPackageName = JvmPackageGen.getPackageName(birModule.org.value, birModule.name.value);
        String birFuncName = birFunc.name.value;
        if (attachedType == null) {
            lookupKey = currentPackageName + birFuncName;
        } else if (attachedType.tag == 32) {
            lookupKey = currentPackageName + JvmTerminatorGen.TerminatorGenerator.toNameString(attachedType) + "." + birFuncName;
        } else {
            throw new BLangCompilerException(String.format("Java method generation for the receiver type %s is not supported: ", attachedType));
        }
        JvmPackageGen.BIRFunctionWrapper birFuncWrapper = JvmPackageGen.birFunctionMap.get(lookupKey);
        if (birFuncWrapper != null) {
            return birFuncWrapper;
        }
        throw new BLangCompilerException("cannot find function definition for : " + lookupKey);
    }

    public static OldStyleExternalFunctionWrapper createOldStyleExternalFunctionWrapper(BIRNode.BIRFunction birFunc, String orgName, String moduleName, String version, String birModuleClassName, String jClassName, boolean isEntryModule) {
        BIRNode.BIRVariableDcl receiver;
        ArrayList<BType> jMethodPramTypes = new ArrayList<BType>(birFunc.type.paramTypes);
        if (isEntryModule) {
            JvmDesugarPhase.addDefaultableBooleanVarsToSignature(birFunc);
        }
        BInvokableType functionTypeDesc = birFunc.type;
        BType restType = functionTypeDesc.restType;
        if (restType != null) {
            jMethodPramTypes.add(restType);
        }
        BType attachedType = (receiver = birFunc.receiver) != null ? receiver.type : null;
        String jvmMethodDescription = JvmMethodGen.getMethodDesc(functionTypeDesc.paramTypes, functionTypeDesc.retType, attachedType, false);
        String jvmMethodDescriptionBString = JvmMethodGen.getMethodDesc(functionTypeDesc.paramTypes, functionTypeDesc.retType, attachedType, false);
        String jMethodVMSig = JvmMethodGen.getMethodDesc(jMethodPramTypes, functionTypeDesc.retType, attachedType, true);
        String jMethodVMSigBString = JvmMethodGen.getMethodDesc(jMethodPramTypes, functionTypeDesc.retType, attachedType, true);
        return new OldStyleExternalFunctionWrapper(orgName, moduleName, version, birFunc, birModuleClassName, jvmMethodDescription, jvmMethodDescriptionBString, jClassName, jMethodPramTypes, jMethodVMSigBString, jMethodVMSig);
    }

    public static boolean isBallerinaBuiltinModule(String orgName, String moduleName) {
        return orgName.equals("ballerina") && moduleName.equals("builtin");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JvmPackageGen.BIRFunctionWrapper createExternalFunctionWrapper(InteropValidator interopValidator, BIRNode.BIRFunction birFunc, String orgName, String moduleName, String version, String birModuleClassName) {
        InteropValidationRequest jInteropValidationReq = AnnotationProc.getInteropAnnotValue(birFunc);
        if (jInteropValidationReq != null) return InteropMethodGen.createJInteropFunctionWrapper(interopValidator, jInteropValidationReq, birFunc, orgName, moduleName, version, birModuleClassName);
        String pkgName = JvmPackageGen.getPackageName(orgName, moduleName);
        String jClassName = JvmPackageGen.lookupExternClassName(JvmPackageGen.cleanupPackageName(pkgName), birFunc.name.value);
        if (jClassName == null) throw new BLangCompilerException("cannot find full qualified class name for extern function : " + pkgName + birFunc.name.value);
        if (!ExternalMethodGen.isBallerinaBuiltinModule(orgName, moduleName)) return ExternalMethodGen.createOldStyleExternalFunctionWrapper(birFunc, orgName, moduleName, version, birModuleClassName, jClassName, interopValidator.isEntryModuleValidation());
        return JvmPackageGen.getFunctionWrapper(birFunc, orgName, moduleName, version, jClassName);
    }

    public static class JavaMethodCall
    extends BIRTerminator {
        @Nilable
        public List<BIROperand> args;
        public String jClassName;
        public String jMethodVMSig;
        public String jMethodVMSigBString;
        public String name;

        public JavaMethodCall(DiagnosticPos pos, InstructionKind kind, List<BIROperand> args, BIROperand lhsOp, String jClassName, String jMethodVMSig, String jMethodVMSigBString, String name, BIRNode.BIRBasicBlock thenBB) {
            super(pos, kind);
            this.pos = pos;
            this.args = args;
            this.kind = kind;
            this.lhsOp = lhsOp;
            this.jClassName = jClassName;
            this.jMethodVMSig = jMethodVMSig;
            this.jMethodVMSigBString = jMethodVMSigBString;
            this.name = name;
            this.thenBB = thenBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
        }
    }

    public static class OldStyleExternalFunctionWrapper
    extends JvmPackageGen.BIRFunctionWrapper
    implements ExternalFunctionWrapper {
        String jClassName;
        @Nilable
        List<BType> jMethodPramTypes;
        String jMethodVMSig;
        @Nilable
        String jMethodVMSigBString = null;

        public OldStyleExternalFunctionWrapper(String orgName, String moduleName, String version, BIRNode.BIRFunction func, String fullQualifiedClassName, String jvmMethodDescription, String jvmMethodDescriptionBString, String jClassName, List<BType> jMethodPramTypes, String jMethodVMSig, String jMethodVMSigBString) {
            super(orgName, moduleName, version, func, fullQualifiedClassName, jvmMethodDescription, jvmMethodDescriptionBString);
            this.jClassName = jClassName;
            this.jMethodPramTypes = jMethodPramTypes;
            this.jMethodVMSig = jMethodVMSig;
            this.jMethodVMSigBString = jMethodVMSigBString;
        }
    }
}

