/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmLabelGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInsKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JTermKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JavaField;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class InteropMethodGen {
    public static final int JCAST = 1;
    public static final int JNEW = 2;

    static void genJFieldForInteropField(JFieldFunctionWrapper jFieldFuncWrapper, ClassWriter cw, BIRNode.BIRPackage birModule) {
        String currentPackageName = JvmPackageGen.getPackageName(birModule.org.value, birModule.name.value);
        JvmMethodGen.BalToJVMIndexMap indexMap = new JvmMethodGen.BalToJVMIndexMap();
        BIRNode.BIRVariableDcl strandVarDcl = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.stringType, new Name("$_strand_$"), null, VarKind.ARG);
        int strandParamIndex = indexMap.getIndex(strandVarDcl);
        BIRNode.BIRFunction birFunc = jFieldFuncWrapper.func;
        String desc = JvmMethodGen.getMethodDesc(birFunc.type.paramTypes, birFunc.type.retType, null, false);
        int access = 9;
        MethodVisitor mv = cw.visitMethod(access, birFunc.name.value, desc, null, null);
        JvmInstructionGen.InstructionGenerator instGen = new JvmInstructionGen.InstructionGenerator(mv, indexMap, birModule);
        JvmErrorGen.ErrorHandlerGenerator errorGen = new JvmErrorGen.ErrorHandlerGenerator(mv, indexMap, currentPackageName);
        JvmLabelGen.LabelGenerator labelGen = new JvmLabelGen.LabelGenerator();
        JvmTerminatorGen.TerminatorGenerator termGen = new JvmTerminatorGen.TerminatorGenerator(mv, indexMap, labelGen, errorGen, birModule);
        mv.visitCode();
        Label paramLoadLabel = labelGen.getLabel("param_load");
        mv.visitLabel(paramLoadLabel);
        mv.visitLineNumber(birFunc.pos.sLine, paramLoadLabel);
        ArrayList<Object> birFuncParams = new ArrayList<Object>();
        for (BIRNode.BIRVariableDcl birLocalVarOptional : birFunc.localVars) {
            if (!(birLocalVarOptional instanceof BIRNode.BIRFunctionParameter)) continue;
            BIRNode.BIRFunctionParameter functionParameter = (BIRNode.BIRFunctionParameter)birLocalVarOptional;
            birFuncParams.add(functionParameter);
            indexMap.getIndex(functionParameter);
        }
        int birFuncParamIndex = 0;
        int paramDefaultsBBIndex = 0;
        for (BIRNode.BIRFunctionParameter bIRFunctionParameter : birFuncParams) {
            if (birFuncParamIndex % 2 != 0 || !bIRFunctionParameter.hasDefaultExpr) {
                ++birFuncParamIndex;
                continue;
            }
            BIRNode.BIRFunctionParameter isDefaultValueExist = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex + 1);
            mv.visitVarInsn(21, indexMap.getIndex(isDefaultValueExist));
            Label paramNextLabel = labelGen.getLabel(bIRFunctionParameter.name.value + "next");
            mv.visitJumpInsn(154, paramNextLabel);
            List<BIRNode.BIRBasicBlock> basicBlocks = birFunc.parameters.get(bIRFunctionParameter);
            JvmMethodGen.generateBasicBlocks(mv, basicBlocks, labelGen, errorGen, instGen, termGen, birFunc, -1, -1, strandParamIndex, true, birModule, currentPackageName, null, false, false, null);
            mv.visitLabel(paramNextLabel);
            ++birFuncParamIndex;
            ++paramDefaultsBBIndex;
        }
        JavaField jField = jFieldFuncWrapper.jField;
        JType jType = JInterop.getJType(jField.getFieldType());
        if (!jField.isStatic()) {
            int receiverLocalVarIndex = indexMap.getIndex((BIRNode.BIRVariableDcl)birFuncParams.get(0));
            mv.visitVarInsn(25, receiverLocalVarIndex);
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            mv.visitTypeInsn(192, jField.getDeclaringClassName());
            Label ifNonNullLabel = labelGen.getLabel("receiver_null_check");
            mv.visitLabel(ifNonNullLabel);
            mv.visitInsn(89);
            Label elseBlockLabel = labelGen.getLabel("receiver_null_check_else");
            mv.visitJumpInsn(199, elseBlockLabel);
            Label thenBlockLabel = labelGen.getLabel("receiver_null_check_then");
            mv.visitLabel(thenBlockLabel);
            mv.visitFieldInsn(178, "org/ballerinalang/jvm/util/exceptions/BallerinaErrorReasons", "JAVA_NULL_REFERENCE_ERROR", "Ljava/lang/String;");
            mv.visitFieldInsn(178, "org/ballerinalang/jvm/util/exceptions/RuntimeErrors", "JAVA_NULL_REFERENCE", "Lorg/ballerinalang/jvm/util/exceptions/RuntimeErrors;");
            mv.visitInsn(3);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/exceptions/BLangExceptionHelper", "getRuntimeException", "(Ljava/lang/String;Lorg/ballerinalang/jvm/util/exceptions/RuntimeErrors;[Ljava/lang/Object;)Lorg/ballerinalang/jvm/values/ErrorValue;", false);
            mv.visitInsn(191);
            mv.visitLabel(elseBlockLabel);
        }
        birFuncParamIndex = jField.isStatic() ? 0 : 2;
        boolean jMethodParamIndex = false;
        if (birFuncParamIndex < birFuncParams.size()) {
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            int paramLocalVarIndex = indexMap.getIndex(birFuncParam);
            InteropMethodGen.loadMethodParamToStackInInteropFunction(mv, birFuncParam, jType, currentPackageName, paramLocalVarIndex, indexMap, false);
        }
        if (jField.isStatic()) {
            if (jField.method == JFieldMethod.ACCESS) {
                mv.visitFieldInsn(178, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
            } else {
                mv.visitFieldInsn(179, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
            }
        } else if (jField.method == JFieldMethod.ACCESS) {
            mv.visitFieldInsn(180, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
        } else {
            mv.visitFieldInsn(181, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
        }
        BType retType = birFunc.type.retType;
        BIRNode.BIRVariableDcl retVarDcl = new BIRNode.BIRVariableDcl(retType, new Name("$_ret_var_$"), null, VarKind.LOCAL);
        int returnVarRefIndex = indexMap.getIndex(retVarDcl);
        if (retType.tag == 10) {
            mv.visitInsn(1);
        } else if (retType.tag == 35) {
            BIRNode.BIRVariableDcl retJObjectVarDcl = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("$_ret_jobject_var_$"), null, VarKind.LOCAL);
            int returnJObjectVarRefIndex = indexMap.getIndex(retJObjectVarDcl);
            mv.visitVarInsn(58, returnJObjectVarRefIndex);
            mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/HandleValue");
            mv.visitInsn(89);
            mv.visitVarInsn(25, returnJObjectVarRefIndex);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/HandleValue", "<init>", "(Ljava/lang/Object;)V", false);
        } else if (jField.getFieldType().isPrimitive()) {
            InteropMethodGen.performWideningPrimitiveConversion(mv, retType, jType);
        } else {
            JvmInstructionGen.addUnboxInsn(mv, retType);
        }
        JvmInstructionGen.generateVarStore(mv, retVarDcl, currentPackageName, returnVarRefIndex);
        Label retLabel = labelGen.getLabel("return_lable");
        mv.visitLabel(retLabel);
        mv.visitLineNumber(birFunc.pos.sLine, retLabel);
        termGen.genReturnTerm(new BIRTerminator.Return(birFunc.pos), returnVarRefIndex, birFunc, false, -1);
        mv.visitMaxs(200, 400);
        mv.visitEnd();
    }

    static void desugarInteropFuncs(BIRNode.BIRPackage module, JMethodFunctionWrapper extFuncWrapper, BIRNode.BIRFunction birFunc) {
        BIRTerminator jCall;
        BType retType = birFunc.type.retType;
        JMethod jMethod = extFuncWrapper.jMethod;
        Class<?>[] jMethodParamTypes = jMethod.getParamTypes();
        JType jMethodRetType = JInterop.getJType(jMethod.getReturnType());
        JvmMethodGen.nextId = -1;
        JvmMethodGen.nextVarId = -1;
        String bbPrefix = "wrapperGen";
        BIRNode.BIRBasicBlock beginBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, bbPrefix);
        BIRNode.BIRBasicBlock retBB = new BIRNode.BIRBasicBlock(JvmDesugarPhase.getNextDesugarBBId(bbPrefix));
        ArrayList<BIROperand> args = new ArrayList<BIROperand>();
        BIRNode.BIRVariableDcl receiver = birFunc.receiver;
        ArrayList<BIRNode.BIRFunctionParameter> birFuncParams = new ArrayList<BIRNode.BIRFunctionParameter>(birFunc.parameters.keySet());
        int birFuncParamIndex = 0;
        if (jMethod.kind == JMethodKind.METHOD && !jMethod.isStatic()) {
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            BType bPType = birFuncParam.type;
            BIROperand argRef = new BIROperand(birFuncParam);
            args.add(argRef);
            birFuncParamIndex = 1;
        }
        JType varArgType = null;
        int jMethodParamIndex = 0;
        int paramCount = birFuncParams.size();
        while (birFuncParamIndex < paramCount) {
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            boolean isVarArg = birFuncParamIndex == paramCount - 1 && birFunc.restParam != null;
            BType bPType = birFuncParam.type;
            JType jPType = JInterop.getJType(jMethodParamTypes[jMethodParamIndex]);
            BIROperand argRef = new BIROperand(birFuncParam);
            if (!isVarArg && !InteropMethodGen.isMatchingBAndJType(bPType, jPType)) {
                String varName = "$_param_jobject_var" + birFuncParamIndex + "_$";
                BIRNode.BIRVariableDcl paramVarDcl = new BIRNode.BIRVariableDcl(jPType, new Name(varName), null, VarKind.LOCAL);
                birFunc.localVars.add(paramVarDcl);
                BIROperand paramVarRef = new BIROperand(paramVarDcl);
                JCast jToBCast = new JCast(birFunc.pos);
                jToBCast.lhsOp = paramVarRef;
                jToBCast.rhsOp = argRef;
                jToBCast.targetType = jPType;
                argRef = paramVarRef;
                beginBB.instructions.add(jToBCast);
            }
            if (isVarArg) {
                varArgType = jPType;
            }
            args.add(argRef);
            ++birFuncParamIndex;
            ++jMethodParamIndex;
        }
        int invocationType = 184;
        if (jMethod.kind == JMethodKind.METHOD && !jMethod.isStatic()) {
            invocationType = jMethod.isDeclaringClassInterface() ? 185 : 182;
        } else if (jMethod.kind != JMethodKind.METHOD || !jMethod.isStatic()) {
            invocationType = 183;
        }
        BIROperand jRetVarRef = null;
        BIRNode.BIRBasicBlock thenBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, bbPrefix);
        thenBB.terminator = new BIRTerminator.GOTO(birFunc.pos, retBB);
        if (retType.tag != 10) {
            BIROperand retRef = new BIROperand(JvmMethodGen.getVariableDcl(birFunc.localVars.get(0)));
            if (JType.jVoid != jMethodRetType) {
                BIROperand castVarRef;
                BIRNode.BIRVariableDcl retJObjectVarDcl = new BIRNode.BIRVariableDcl(jMethodRetType, new Name("$_ret_jobject_var_$"), null, VarKind.LOCAL);
                birFunc.localVars.add(retJObjectVarDcl);
                jRetVarRef = castVarRef = new BIROperand(retJObjectVarDcl);
                JCast jToBCast = new JCast(birFunc.pos);
                jToBCast.lhsOp = retRef;
                jToBCast.rhsOp = castVarRef;
                jToBCast.targetType = retType;
                thenBB.instructions.add(jToBCast);
            }
            BIRNode.BIRBasicBlock catchBB = new BIRNode.BIRBasicBlock(JvmDesugarPhase.getNextDesugarBBId(bbPrefix));
            JErrorEntry ee = new JErrorEntry(beginBB, thenBB, retRef, catchBB);
            for (Class<?> exception : extFuncWrapper.jMethod.getExceptionTypes()) {
                BIRTerminator.Return exceptionRet = new BIRTerminator.Return(birFunc.pos);
                CatchIns catchIns = new CatchIns();
                catchIns.errorClass = exception.getName().replace(".", "/");
                catchIns.term = exceptionRet;
                ee.catchIns.add(catchIns);
            }
            birFunc.errorTable.add(ee);
        }
        String jMethodName = birFunc.name.value;
        if (jMethod.kind == JMethodKind.CONSTRUCTOR) {
            jCall = new JIConstructorCall(birFunc.pos);
            jCall.args = args;
            jCall.varArgExist = birFunc.restParam != null;
            jCall.varArgType = varArgType;
            jCall.lhsOp = jRetVarRef;
            jCall.jClassName = jMethod.getClassName().replace(".", "/");
            jCall.name = jMethod.getName();
            jCall.jMethodVMSig = jMethod.getSignature();
            jCall.thenBB = thenBB;
            beginBB.terminator = jCall;
        } else {
            jCall = new JIMethodCall(birFunc.pos);
            ((JIMethodCall)jCall).args = args;
            ((JIMethodCall)jCall).varArgExist = birFunc.restParam != null;
            ((JIMethodCall)jCall).varArgType = varArgType;
            ((JIMethodCall)jCall).lhsOp = jRetVarRef;
            ((JIMethodCall)jCall).jClassName = jMethod.getClassName().replace(".", "/");
            ((JIMethodCall)jCall).name = jMethod.getName();
            ((JIMethodCall)jCall).jMethodVMSig = jMethod.getSignature();
            ((JIMethodCall)jCall).invocationType = invocationType;
            ((JIMethodCall)jCall).thenBB = thenBB;
            beginBB.terminator = jCall;
        }
        birFunc.basicBlocks.add(retBB);
        retBB.terminator = new BIRTerminator.Return(birFunc.pos);
    }

    private static boolean isMatchingBAndJType(BType sourceTypes, JType targetType) {
        return TypeTags.isIntegerTypeTag(sourceTypes.tag) && targetType.jTag == 5 || sourceTypes.tag == 3 && targetType.jTag == 7 || sourceTypes.tag == 6 && targetType.jTag == 8;
    }

    private static void performWideningPrimitiveConversion(MethodVisitor mv, BType bType, JType jType) {
        if (TypeTags.isIntegerTypeTag(bType.tag) && jType.jTag == 5) {
            return;
        }
        if (bType.tag == 3 && jType.jTag == 7) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitInsn(133);
        } else if (bType.tag == 3) {
            if (jType.jTag == 5) {
                mv.visitInsn(138);
            } else if (jType.jTag == 6) {
                mv.visitInsn(141);
            } else {
                mv.visitInsn(135);
            }
        }
    }

    private static void loadMethodParamToStackInInteropFunction(MethodVisitor mv, BIRNode.BIRFunctionParameter birFuncParam, JType jMethodParamType, String currentPackageName, int localVarIndex, JvmMethodGen.BalToJVMIndexMap indexMap, boolean isVarArg) {
        BType bFuncParamType = birFuncParam.type;
        if (isVarArg) {
            InteropMethodGen.genVarArg(mv, indexMap, bFuncParamType, jMethodParamType, localVarIndex);
        } else {
            JvmInstructionGen.generateVarLoad(mv, birFuncParam, currentPackageName, localVarIndex);
            JvmCastGen.generateBToJCheckCast(mv, bFuncParamType, jMethodParamType);
        }
    }

    public static String getJTypeSignature(JType jType) {
        if (jType.jTag == 10) {
            return "L" + ((JType.JRefType)jType).typeValue + ";";
        }
        if (jType.jTag == 9) {
            JType eType = ((JType.JArrayType)jType).elementType;
            return "[" + InteropMethodGen.getJTypeSignature(eType);
        }
        if (jType.jTag == 1) {
            return "B";
        }
        if (jType.jTag == 2) {
            return "C";
        }
        if (jType.jTag == 3) {
            return "S";
        }
        if (jType.jTag == 4) {
            return "I";
        }
        if (jType.jTag == 5) {
            return "J";
        }
        if (jType.jTag == 6) {
            return "F";
        }
        if (jType.jTag == 7) {
            return "D";
        }
        if (jType.jTag == 8) {
            return "Z";
        }
        throw new BLangCompilerException(String.format("invalid element type: %s", jType));
    }

    public static String getSignatureForJType(JType jType) {
        if (jType.jTag == 10) {
            return ((JType.JRefType)jType).typeValue;
        }
        if (jType.jTag == 9) {
            JType eType = ((JType.JArrayType)jType).elementType;
            String sig = "[";
            while (eType.jTag == 9) {
                eType = ((JType.JArrayType)eType).elementType;
                sig = sig + "[";
            }
            if (eType.jTag == 10) {
                return sig + "L" + InteropMethodGen.getSignatureForJType(eType) + ";";
            }
            if (eType.jTag == 1) {
                return sig + "B";
            }
            if (eType.jTag == 2) {
                return sig + "C";
            }
            if (eType.jTag == 3) {
                return sig + "S";
            }
            if (eType.jTag == 4) {
                return sig + "I";
            }
            if (eType.jTag == 5) {
                return sig + "J";
            }
            if (eType.jTag == 6) {
                return sig + "F";
            }
            if (eType.jTag == 7) {
                return sig + "D";
            }
            if (eType.jTag == 8) {
                return sig + "Z";
            }
            throw new BLangCompilerException(String.format("invalid element type: %s", eType));
        }
        throw new BLangCompilerException(String.format("invalid element type: %s", jType));
    }

    public static void genVarArg(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, BType bType, JType jvmType, int varArgIndex) {
        if (jvmType.jTag != 9 || bType.tag != 19) {
            throw new BLangCompilerException(String.format("invalid type for var-arg: %s", jvmType));
        }
        JType jElementType = ((JType.JArrayType)jvmType).elementType;
        BType bElementType = ((BArrayType)bType).eType;
        BIRNode.BIRVariableDcl varArgsLen = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.intType, new Name("$varArgsLen"), null, VarKind.TEMP);
        BIRNode.BIRVariableDcl index = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.intType, new Name("$index"), null, VarKind.TEMP);
        BIRNode.BIRVariableDcl valueArray = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("$valueArray"), null, VarKind.TEMP);
        int varArgsLenVarIndex = indexMap.getIndex(varArgsLen);
        int indexVarIndex = indexMap.getIndex(index);
        int valueArrayIndex = indexMap.getIndex(valueArray);
        mv.visitVarInsn(25, varArgIndex);
        mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "size", "()I", true);
        mv.visitInsn(89);
        mv.visitVarInsn(54, varArgsLenVarIndex);
        InteropMethodGen.genArrayNew(mv, jElementType);
        mv.visitVarInsn(58, valueArrayIndex);
        mv.visitInsn(3);
        mv.visitVarInsn(54, indexVarIndex);
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitVarInsn(21, varArgsLenVarIndex);
        mv.visitJumpInsn(162, l2);
        mv.visitVarInsn(25, valueArrayIndex);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitVarInsn(25, varArgIndex);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitInsn(133);
        if (TypeTags.isIntegerTypeTag(bElementType.tag)) {
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getInt", "(J)J", true);
        } else if (TypeTags.isStringTypeTag(bElementType.tag)) {
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getString", String.format("(J)L%s;", "java/lang/String"), true);
        } else if (bElementType.tag == 6) {
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getBoolean", "(J)Z", true);
        } else if (bElementType.tag == 2) {
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getByte", "(J)B", true);
        } else if (bElementType.tag == 3) {
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getFloat", "(J)D", true);
        } else if (bElementType.tag == 35) {
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
            mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/HandleValue");
        } else {
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
        }
        JvmCastGen.generateBToJCheckCast(mv, bElementType, jElementType);
        InteropMethodGen.genArrayStore(mv, jElementType);
        mv.visitIincInsn(indexVarIndex, 1);
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, valueArrayIndex);
    }

    private static void genArrayStore(MethodVisitor mv, JType jType) {
        int code = jType.jTag == 4 ? 79 : (jType.jTag == 5 ? 80 : (jType.jTag == 7 ? 82 : (jType.jTag == 1 || jType.jTag == 8 ? 84 : (jType.jTag == 3 ? 86 : (jType.jTag == 2 ? 85 : (jType.jTag == 6 ? 81 : 83))))));
        mv.visitInsn(code);
    }

    private static void genArrayNew(MethodVisitor mv, JType elementType) {
        if (elementType.jTag == 4) {
            mv.visitIntInsn(188, 10);
        } else if (elementType.jTag == 5) {
            mv.visitIntInsn(188, 11);
        } else if (elementType.jTag == 7) {
            mv.visitIntInsn(188, 7);
        } else if (elementType.jTag == 1 || elementType.jTag == 8) {
            mv.visitIntInsn(188, 4);
        } else if (elementType.jTag == 3) {
            mv.visitIntInsn(188, 9);
        } else if (elementType.jTag == 2) {
            mv.visitIntInsn(188, 5);
        } else if (elementType.jTag == 6) {
            mv.visitIntInsn(188, 6);
        } else if (elementType.jTag == 10 || elementType.jTag == 9) {
            mv.visitTypeInsn(189, InteropMethodGen.getSignatureForJType(elementType));
        } else {
            throw new BLangCompilerException(String.format("invalid type for var-arg: %s", elementType));
        }
    }

    static JvmPackageGen.BIRFunctionWrapper createJInteropFunctionWrapper(InteropValidator interopValidator, InteropValidationRequest jInteropValidationReq, BIRNode.BIRFunction birFunc, String orgName, String moduleName, String version, String birModuleClassName) {
        if (interopValidator.isEntryModuleValidation()) {
            JvmDesugarPhase.addDefaultableBooleanVarsToSignature(birFunc);
        }
        JvmPackageGen.BIRFunctionWrapper birFuncWrapper = JvmPackageGen.getFunctionWrapper(birFunc, orgName, moduleName, version, birModuleClassName);
        if (jInteropValidationReq instanceof InteropValidationRequest.MethodValidationRequest) {
            InteropValidationRequest.MethodValidationRequest methodValidationRequest = (InteropValidationRequest.MethodValidationRequest)jInteropValidationReq;
            methodValidationRequest.restParamExist = birFunc.restParam != null;
            return InteropMethodGen.createJMethodWrapper(interopValidator, methodValidationRequest, birFuncWrapper);
        }
        InteropValidationRequest.FieldValidationRequest fieldValidationRequest = (InteropValidationRequest.FieldValidationRequest)jInteropValidationReq;
        return InteropMethodGen.createJFieldWrapper(interopValidator, fieldValidationRequest, birFuncWrapper);
    }

    private static JMethodFunctionWrapper createJMethodWrapper(InteropValidator interopValidator, InteropValidationRequest jMethodValidationReq, JvmPackageGen.BIRFunctionWrapper birFuncWrapper) {
        JMethod jMethod = interopValidator.validateAndGetJMethod((InteropValidationRequest.MethodValidationRequest)jMethodValidationReq);
        return new JMethodFunctionWrapper(birFuncWrapper, jMethod);
    }

    private static JFieldFunctionWrapper createJFieldWrapper(InteropValidator interopValidator, InteropValidationRequest jFieldValidationReq, JvmPackageGen.BIRFunctionWrapper birFuncWrapper) {
        JavaField jField = interopValidator.validateAndGetJField((InteropValidationRequest.FieldValidationRequest)jFieldValidationReq);
        return new JFieldFunctionWrapper(birFuncWrapper, jField);
    }

    public static class CatchIns {
        public String errorClass;
        public BIRTerminator.Return term;
    }

    public static class JErrorEntry
    extends BIRNode.BIRErrorEntry {
        public List<CatchIns> catchIns = new ArrayList<CatchIns>();

        public JErrorEntry(BIRNode.BIRBasicBlock trapBB, BIRNode.BIRBasicBlock endBB, BIROperand errorOp, BIRNode.BIRBasicBlock targetBB) {
            super(trapBB, endBB, errorOp, targetBB);
        }
    }

    public static class JCast
    extends JInstruction {
        public BIROperand rhsOp;
        public BType targetType;

        JCast(DiagnosticPos pos) {
            super(pos);
            this.jKind = JInsKind.JCAST;
        }
    }

    public static class JInstruction
    extends BIRNonTerminator {
        public JInsKind jKind;

        JInstruction(DiagnosticPos pos) {
            super(pos, InstructionKind.PLATFORM);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            throw new UnsupportedOperationException();
        }
    }

    public static class JIConstructorCall
    extends BIRTerminator {
        @Nilable
        public List<BIROperand> args;
        boolean varArgExist;
        @Nilable
        JType varArgType;
        JTermKind jKind = JTermKind.JTERM_NEW;
        public String jClassName;
        public String jMethodVMSig;
        public String name;

        public JIConstructorCall(DiagnosticPos pos) {
            super(pos, InstructionKind.PLATFORM);
        }

        @Override
        public void accept(BIRVisitor visitor) {
        }
    }

    public static class JIMethodCall
    extends BIRTerminator {
        @Nilable
        public List<BIROperand> args;
        public boolean varArgExist;
        @Nilable
        public JType varArgType;
        JTermKind jKind = JTermKind.JTERM_CALL;
        public String jClassName;
        public String jMethodVMSig;
        public String name;
        public int invocationType;

        public JIMethodCall(DiagnosticPos pos) {
            super(pos, InstructionKind.PLATFORM);
        }

        @Override
        public void accept(BIRVisitor visitor) {
        }
    }

    static class JFieldFunctionWrapper
    extends JvmPackageGen.BIRFunctionWrapper
    implements ExternalFunctionWrapper {
        JavaField jField;

        JFieldFunctionWrapper(JvmPackageGen.BIRFunctionWrapper functionWrapper, JavaField jField) {
            super(functionWrapper.orgName, functionWrapper.moduleName, functionWrapper.version, functionWrapper.func, functionWrapper.fullQualifiedClassName, functionWrapper.jvmMethodDescription, functionWrapper.jvmMethodDescriptionBString);
            this.jField = jField;
        }
    }

    static class JMethodFunctionWrapper
    extends JvmPackageGen.BIRFunctionWrapper
    implements ExternalFunctionWrapper {
        JMethod jMethod;

        JMethodFunctionWrapper(JvmPackageGen.BIRFunctionWrapper functionWrapper, JMethod jMethod) {
            super(functionWrapper.orgName, functionWrapper.moduleName, functionWrapper.version, functionWrapper.func, functionWrapper.fullQualifiedClassName, functionWrapper.jvmMethodDescription, functionWrapper.jvmMethodDescriptionBString);
            this.jMethod = jMethod;
        }
    }
}

