/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.emit;

import java.util.List;
import org.wso2.ballerinalang.compiler.bir.emit.EmitterUtils;
import org.wso2.ballerinalang.compiler.bir.emit.TypeEmitter;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;

class InstructionEmitter {
    InstructionEmitter() {
    }

    static String emitInstructions(List<? extends BIRInstruction> instructions, int tabs) {
        StringBuilder insStr = new StringBuilder();
        for (BIRInstruction bIRInstruction : instructions) {
            insStr.append(InstructionEmitter.emitInstruction(bIRInstruction, tabs));
            insStr.append(EmitterUtils.emitLBreaks(1));
        }
        return insStr.toString();
    }

    private static String emitInstruction(BIRInstruction ins, int tabs) {
        InstructionKind kind = ins.getKind();
        if (EmitterUtils.isBinaryInstructionKind(kind)) {
            return InstructionEmitter.emitInsBinaryOp((BIRNonTerminator.BinaryOp)ins, tabs);
        }
        if (EmitterUtils.isUnaryInstructionKind(kind)) {
            return InstructionEmitter.emitInsUnaryOp((BIRNonTerminator.UnaryOP)ins, tabs);
        }
        switch (kind) {
            case CONST_LOAD: {
                return InstructionEmitter.emitInsConstantLoad((BIRNonTerminator.ConstantLoad)ins, tabs);
            }
            case NEW_STRUCTURE: {
                return InstructionEmitter.emitInsNewMap((BIRNonTerminator.NewStructure)ins, tabs);
            }
            case NEW_TABLE: {
                return InstructionEmitter.emitInsNewTable((BIRNonTerminator.NewTable)ins, tabs);
            }
            case NEW_INSTANCE: {
                return InstructionEmitter.emitInsNewInstance((BIRNonTerminator.NewInstance)ins, tabs);
            }
            case NEW_ARRAY: {
                return InstructionEmitter.emitInsNewArray((BIRNonTerminator.NewArray)ins, tabs);
            }
            case NEW_ERROR: {
                return InstructionEmitter.emitInsNewError((BIRNonTerminator.NewError)ins, tabs);
            }
            case FP_LOAD: {
                return InstructionEmitter.emitInsFPLoad((BIRNonTerminator.FPLoad)ins, tabs);
            }
            case MAP_LOAD: 
            case MAP_STORE: 
            case ARRAY_LOAD: 
            case ARRAY_STORE: 
            case OBJECT_LOAD: 
            case OBJECT_STORE: 
            case XML_ATTRIBUTE_LOAD: 
            case XML_ATTRIBUTE_STORE: {
                return InstructionEmitter.emitInsFieldAccess((BIRNonTerminator.FieldAccess)ins, tabs);
            }
            case TYPE_CAST: {
                return InstructionEmitter.emitInsTypeCast((BIRNonTerminator.TypeCast)ins, tabs);
            }
            case IS_LIKE: {
                return InstructionEmitter.emitInsIsLike((BIRNonTerminator.IsLike)ins, tabs);
            }
            case TYPE_TEST: {
                return InstructionEmitter.emitInsTypeTest((BIRNonTerminator.TypeTest)ins, tabs);
            }
            case MOVE: {
                return InstructionEmitter.emitInsMove((BIRNonTerminator.Move)ins, tabs);
            }
            case NEW_XML_ELEMENT: {
                return InstructionEmitter.emitInsNewXMLElement((BIRNonTerminator.NewXMLElement)ins, tabs);
            }
            case NEW_XML_QNAME: {
                return InstructionEmitter.emitInsNewXMLQName((BIRNonTerminator.NewXMLQName)ins, tabs);
            }
            case NEW_STRING_XML_QNAME: {
                return InstructionEmitter.emitInsNewStringXMLQName((BIRNonTerminator.NewStringXMLQName)ins, tabs);
            }
            case XML_LOAD_ALL: {
                return InstructionEmitter.emitInsXMLAccess((BIRNonTerminator.XMLAccess)ins, tabs);
            }
            case NEW_XML_TEXT: {
                return InstructionEmitter.emitInsNewXMLText((BIRNonTerminator.NewXMLText)ins, tabs);
            }
            case NEW_XML_COMMENT: {
                return InstructionEmitter.emitInsNewXMLComment((BIRNonTerminator.NewXMLComment)ins, tabs);
            }
            case NEW_XML_PI: {
                return InstructionEmitter.emitInsNewXMLPI((BIRNonTerminator.NewXMLProcIns)ins, tabs);
            }
            case NEW_TYPEDESC: {
                return InstructionEmitter.emitInsNewTypeDesc((BIRNonTerminator.NewTypeDesc)ins, tabs);
            }
        }
        throw new IllegalStateException("Not an instruction");
    }

    private static String emitInsConstantLoad(BIRNonTerminator.ConstantLoad ins, int tabs) {
        String cnstLStr = "";
        cnstLStr = cnstLStr + EmitterUtils.emitTabs(tabs);
        cnstLStr = cnstLStr + EmitterUtils.emitVarRef(ins.lhsOp);
        cnstLStr = cnstLStr + EmitterUtils.emitSpaces(1);
        cnstLStr = cnstLStr + "=";
        cnstLStr = cnstLStr + EmitterUtils.emitSpaces(1);
        cnstLStr = cnstLStr + "ConstLoad";
        cnstLStr = cnstLStr + EmitterUtils.emitSpaces(1);
        cnstLStr = cnstLStr + EmitterUtils.emitValue(ins.value, ins.type);
        cnstLStr = cnstLStr + ";";
        return cnstLStr;
    }

    private static String emitInsNewMap(BIRNonTerminator.NewStructure ins, int tabs) {
        String nMapStr = "";
        nMapStr = nMapStr + EmitterUtils.emitTabs(tabs);
        nMapStr = nMapStr + EmitterUtils.emitVarRef(ins.lhsOp);
        nMapStr = nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = nMapStr + "=";
        nMapStr = nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = nMapStr + "NewMap";
        nMapStr = nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = nMapStr + TypeEmitter.emitTypeRef(ins.type, 0);
        nMapStr = nMapStr + ";";
        return nMapStr;
    }

    private static String emitInsNewTable(BIRNonTerminator.NewTable ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "table(";
        str = str + EmitterUtils.emitVarRef(ins.columnsOp);
        str = str + ",";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.dataOp);
        str = str + ",";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.keyColOp);
        str = str + ")<";
        str = str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = str + ">;";
        return str;
    }

    private static String emitInsNewInstance(BIRNonTerminator.NewInstance ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "new";
        str = str + EmitterUtils.emitSpaces(1);
        if (ins.isExternalDef) {
            str = str + EmitterUtils.emitModuleID(ins.externalPackageId);
            str = str + ":";
            str = str + ins.objectName;
        } else {
            str = str + EmitterUtils.emitName(ins.def.name);
        }
        str = str + ";";
        return str;
    }

    private static String emitInsNewArray(BIRNonTerminator.NewArray ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "newArray";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = str + "[";
        str = str + EmitterUtils.emitVarRef(ins.sizeOp);
        str = str + "]";
        str = str + ";";
        return str;
    }

    private static String emitInsNewError(BIRNonTerminator.NewError ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "error";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = str + "(";
        str = str + EmitterUtils.emitVarRef(ins.reasonOp);
        str = str + ",";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.detailOp);
        str = str + ")";
        str = str + ";";
        return str;
    }

    private static String emitInsFPLoad(BIRNonTerminator.FPLoad ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "fp";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitModuleID(ins.pkgId);
        str = str + "::";
        str = str + EmitterUtils.emitName(ins.funcName);
        str = str + ";";
        return str;
    }

    private static String emitInsFieldAccess(BIRNonTerminator.FieldAccess ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        if (ins.kind == InstructionKind.MAP_LOAD || ins.kind == InstructionKind.ARRAY_LOAD) {
            str = str + EmitterUtils.emitSpaces(1);
            str = str + "=";
            str = str + EmitterUtils.emitSpaces(1);
            str = str + EmitterUtils.emitVarRef(ins.rhsOp);
            str = str + "[";
            str = str + EmitterUtils.emitVarRef(ins.keyOp);
            str = str + "]";
        } else if (ins.kind == InstructionKind.MAP_STORE || ins.kind == InstructionKind.ARRAY_STORE) {
            str = str + "[";
            str = str + EmitterUtils.emitVarRef(ins.keyOp);
            str = str + "]";
            str = str + EmitterUtils.emitSpaces(1);
            str = str + "=";
            str = str + EmitterUtils.emitSpaces(1);
            str = str + EmitterUtils.emitVarRef(ins.rhsOp);
        }
        str = str + ";";
        return str;
    }

    private static String emitInsTypeCast(BIRNonTerminator.TypeCast ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "<";
        str = str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = str + ">";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = str + ";";
        return str;
    }

    private static String emitInsIsLike(BIRNonTerminator.IsLike ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "isLike";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = str + ";";
        return str;
    }

    private static String emitInsTypeTest(BIRNonTerminator.TypeTest ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "is";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = str + ";";
        return str;
    }

    private static String emitInsMove(BIRNonTerminator.Move ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = str + ";";
        return str;
    }

    private static String emitInsBinaryOp(BIRNonTerminator.BinaryOp ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.rhsOp1);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitBinaryOpInstructionKind(ins.kind);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.rhsOp2);
        str = str + ";";
        return str;
    }

    private static String emitInsNewXMLElement(BIRNonTerminator.NewXMLElement ins, int tabs) {
        return "";
    }

    private static String emitInsNewXMLQName(BIRNonTerminator.NewXMLQName ins, int tabs) {
        return "";
    }

    private static String emitInsNewStringXMLQName(BIRNonTerminator.NewStringXMLQName ins, int tabs) {
        return "";
    }

    private static String emitInsXMLAccess(BIRNonTerminator.XMLAccess ins, int tabs) {
        return "";
    }

    private static String emitInsNewXMLText(BIRNonTerminator.NewXMLText ins, int tabs) {
        return "";
    }

    private static String emitInsNewXMLComment(BIRNonTerminator.NewXMLComment ins, int tabs) {
        return "";
    }

    private static String emitInsNewXMLPI(BIRNonTerminator.NewXMLProcIns ins, int tabs) {
        return "";
    }

    private static String emitInsUnaryOp(BIRNonTerminator.UnaryOP ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = str + ";";
        return str;
    }

    private static String emitInsNewTypeDesc(BIRNonTerminator.NewTypeDesc ins, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "newType";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = str + ";";
        return str;
    }

    static String emitTerminator(BIRTerminator term, int tabs) {
        switch (term.kind) {
            case WAIT: {
                return InstructionEmitter.emitWait((BIRTerminator.Wait)term, tabs);
            }
            case FLUSH: {
                return InstructionEmitter.emitFlush((BIRTerminator.Flush)term, tabs);
            }
            case WK_RECEIVE: {
                return InstructionEmitter.emitWorkerReceive((BIRTerminator.WorkerReceive)term, tabs);
            }
            case WK_SEND: {
                return InstructionEmitter.emitWorkerSend((BIRTerminator.WorkerSend)term, tabs);
            }
            case CALL: {
                return InstructionEmitter.emitCall((BIRTerminator.Call)term, tabs);
            }
            case ASYNC_CALL: {
                return InstructionEmitter.emitAsyncCall((BIRTerminator.AsyncCall)term, tabs);
            }
            case BRANCH: {
                return InstructionEmitter.emitBranch((BIRTerminator.Branch)term, tabs);
            }
            case GOTO: {
                return InstructionEmitter.emitGOTO((BIRTerminator.GOTO)term, tabs);
            }
            case LOCK: {
                return InstructionEmitter.emitLock((BIRTerminator.Lock)term, tabs);
            }
            case FIELD_LOCK: {
                return InstructionEmitter.emitFieldLock((BIRTerminator.FieldLock)term, tabs);
            }
            case UNLOCK: {
                return InstructionEmitter.emitUnlock((BIRTerminator.Unlock)term, tabs);
            }
            case RETURN: {
                return InstructionEmitter.emitReturn((BIRTerminator.Return)term, tabs);
            }
            case PANIC: {
                return InstructionEmitter.emitPanic((BIRTerminator.Panic)term, tabs);
            }
            case FP_CALL: {
                return InstructionEmitter.emitFPCall((BIRTerminator.FPCall)term, tabs);
            }
            case WAIT_ALL: {
                return InstructionEmitter.emitWaitAll((BIRTerminator.WaitAll)term, tabs);
            }
        }
        throw new IllegalStateException("Not a terminator instruction");
    }

    private static String emitWait(BIRTerminator.Wait term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        str.append(EmitterUtils.emitVarRef(term.lhsOp));
        str.append(EmitterUtils.emitSpaces(1));
        str.append("=");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("wait");
        str.append(EmitterUtils.emitSpaces(1));
        int i = 0;
        int argLength = term.exprList.size();
        while (i < argLength) {
            BIROperand ref = term.exprList.get(i);
            if (ref == null) continue;
            str.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            str.append(EmitterUtils.emitSpaces(1));
            str.append("|");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }

    private static String emitFlush(BIRTerminator.Flush term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        str.append(EmitterUtils.emitVarRef(term.lhsOp));
        str.append(EmitterUtils.emitSpaces(1));
        str.append("=");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("flush");
        str.append(EmitterUtils.emitSpaces(1));
        int i = 0;
        int argLength = term.channels.length;
        while (i < argLength) {
            BIRNode.ChannelDetails ref = term.channels[i];
            str.append(ref.name);
            if (++i >= argLength) continue;
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }

    private static String emitWorkerReceive(BIRTerminator.WorkerReceive term, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(term.lhsOp);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "<=";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitName(term.workerName);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "->";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitBasicBlockRef(term.thenBB);
        str = str + ";";
        return str;
    }

    private static String emitWorkerSend(BIRTerminator.WorkerSend term, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            str = str + EmitterUtils.emitVarRef(lhsOp);
            str = str + EmitterUtils.emitSpaces(1);
            str = str + "=";
            str = str + EmitterUtils.emitSpaces(1);
        }
        str = str + EmitterUtils.emitVarRef(term.data);
        str = str + EmitterUtils.emitSpaces(1);
        str = term.isSync ? str + "=>" : str + "=>>";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitName(term.channel);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "->";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitBasicBlockRef(term.thenBB);
        str = str + ";";
        return str;
    }

    private static String emitCall(BIRTerminator.Call term, int tabs) {
        StringBuilder callStr = new StringBuilder();
        callStr.append(EmitterUtils.emitTabs(tabs));
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            callStr.append(EmitterUtils.emitVarRef(lhsOp));
            callStr.append(EmitterUtils.emitSpaces(1));
            callStr.append("=");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append(EmitterUtils.emitName(term.name));
        callStr.append("(");
        int i = 0;
        int argLength = term.args.size();
        for (BIROperand ref : term.args) {
            if (ref == null) continue;
            callStr.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            callStr.append(",");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append(")");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append("->");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        callStr.append(";");
        return callStr.toString();
    }

    private static String emitAsyncCall(BIRTerminator.AsyncCall term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            str.append(EmitterUtils.emitVarRef(lhsOp));
            str.append(EmitterUtils.emitSpaces(1));
            str.append("=");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append("start");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitName(term.name));
        str.append("(");
        int i = 0;
        int argLength = term.args.size();
        for (BIROperand ref : term.args) {
            if (ref == null) continue;
            str.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append(")");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }

    private static String emitBranch(BIRTerminator.Branch term, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitVarRef(term.op);
        str = str + "?";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitBasicBlockRef(term.trueBB);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + ":";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitBasicBlockRef(term.falseBB);
        str = str + ";";
        return str;
    }

    private static String emitGOTO(BIRTerminator.GOTO term, int tabs) {
        String retStr = "";
        retStr = retStr + EmitterUtils.emitTabs(tabs);
        retStr = retStr + "GOTO";
        retStr = retStr + EmitterUtils.emitSpaces(1);
        retStr = retStr + EmitterUtils.emitBasicBlockRef(term.targetBB);
        retStr = retStr + ";";
        return retStr;
    }

    private static String emitLock(BIRTerminator.Lock term, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + "lock";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "->";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitBasicBlockRef(term.lockedBB);
        str = str + ";";
        return str;
    }

    private static String emitFieldLock(BIRTerminator.FieldLock term, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + "lock";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + term.field;
        str = str + "[\"";
        str = str + term.field;
        str = str + "\"]";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + "->";
        str = str + EmitterUtils.emitSpaces(1);
        str = str + EmitterUtils.emitBasicBlockRef(term.lockedBB);
        str = str + ";";
        return str;
    }

    private static String emitUnlock(BIRTerminator.Unlock term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        str.append("unlock");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.unlockBB));
        str.append(";");
        return str.toString();
    }

    private static String emitReturn(BIRTerminator.Return term, int tabs) {
        String retStr = "";
        retStr = retStr + EmitterUtils.emitTabs(tabs);
        retStr = retStr + "return";
        retStr = retStr + ";";
        return retStr;
    }

    private static String emitPanic(BIRTerminator.Panic term, int tabs) {
        String retStr = "";
        retStr = retStr + EmitterUtils.emitTabs(tabs);
        retStr = retStr + "panic";
        retStr = retStr + EmitterUtils.emitSpaces(1);
        retStr = retStr + EmitterUtils.emitVarRef(term.errorOp);
        retStr = retStr + ";";
        return retStr;
    }

    private static String emitFPCall(BIRTerminator.FPCall term, int tabs) {
        StringBuilder callStr = new StringBuilder();
        callStr.append(EmitterUtils.emitTabs(tabs));
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            callStr.append(EmitterUtils.emitVarRef(lhsOp));
            callStr.append(EmitterUtils.emitSpaces(1));
            callStr.append("=");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append("FPCall");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append(EmitterUtils.emitVarRef(term.fp));
        callStr.append("(");
        int i = 0;
        int argLength = term.args.size();
        for (BIROperand ref : term.args) {
            if (ref == null) continue;
            callStr.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            callStr.append(",");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append(")");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append("->");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        callStr.append(";");
        return callStr.toString();
    }

    private static String emitWaitAll(BIRTerminator.WaitAll term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        str.append(EmitterUtils.emitVarRef(term.lhsOp));
        str.append(EmitterUtils.emitSpaces(1));
        str.append("=");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("waitAll");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("{");
        int i = 0;
        int argLength = term.valueExprs.size();
        while (i < argLength) {
            BIROperand ref = term.valueExprs.get(i);
            String key = term.keys.get(i);
            if (ref == null) continue;
            str.append("\"");
            str.append(key);
            str.append("\"");
            str.append(":");
            str.append(EmitterUtils.emitSpaces(1));
            str.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append("}");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }
}

