/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.model;

import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRAssignInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public abstract class BIRNonTerminator
extends BIRAbstractInstruction
implements BIRInstruction {
    public BIRNonTerminator(DiagnosticPos pos, InstructionKind kind) {
        super(pos, kind);
    }

    @Override
    public InstructionKind getKind() {
        return this.kind;
    }

    public static class NewTypeDesc
    extends BIRNonTerminator {
        public BType type;

        public NewTypeDesc(DiagnosticPos pos, BIROperand lhsOp, BType type) {
            super(pos, InstructionKind.NEW_TYPEDESC);
            this.lhsOp = lhsOp;
            this.type = type;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewTable
    extends BIRNonTerminator {
        public BIROperand columnsOp;
        public BIROperand dataOp;
        public BIROperand keyColOp;
        public BType type;

        public NewTable(DiagnosticPos pos, BType type, BIROperand lhsOp, BIROperand columnsOp, BIROperand dataOp, BIROperand keyColOp) {
            super(pos, InstructionKind.NEW_TABLE);
            this.type = type;
            this.lhsOp = lhsOp;
            this.columnsOp = columnsOp;
            this.dataOp = dataOp;
            this.keyColOp = keyColOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FPLoad
    extends BIRNonTerminator {
        public SchedulerPolicy schedulerPolicy;
        public Name funcName;
        public PackageID pkgId;
        public List<BIRNode.BIRVariableDcl> params;
        public List<BIROperand> closureMaps;
        public BType retType;

        public FPLoad(DiagnosticPos pos, PackageID pkgId, Name funcName, BIROperand lhsOp, List<BIRNode.BIRVariableDcl> params, List<BIROperand> closureMaps, BType retType, SchedulerPolicy schedulerPolicy) {
            super(pos, InstructionKind.FP_LOAD);
            this.schedulerPolicy = schedulerPolicy;
            this.lhsOp = lhsOp;
            this.funcName = funcName;
            this.pkgId = pkgId;
            this.params = params;
            this.closureMaps = closureMaps;
            this.retType = retType;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class XMLAccess
    extends BIRNonTerminator {
        public BIROperand rhsOp;

        public XMLAccess(DiagnosticPos pos, InstructionKind kind, BIROperand lhsOp, BIROperand rhsOp) {
            super(pos, kind);
            this.lhsOp = lhsOp;
            this.rhsOp = rhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewXMLComment
    extends BIRNonTerminator {
        public BIROperand textOp;

        public NewXMLComment(DiagnosticPos pos, BIROperand lhsOp, BIROperand textOp) {
            super(pos, InstructionKind.NEW_XML_COMMENT);
            this.lhsOp = lhsOp;
            this.textOp = textOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewXMLProcIns
    extends BIRNonTerminator {
        public BIROperand dataOp;
        public BIROperand targetOp;

        public NewXMLProcIns(DiagnosticPos pos, BIROperand lhsOp, BIROperand dataOp, BIROperand targetOp) {
            super(pos, InstructionKind.NEW_XML_PI);
            this.lhsOp = lhsOp;
            this.dataOp = dataOp;
            this.targetOp = targetOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewXMLText
    extends BIRNonTerminator {
        public BIROperand textOp;

        public NewXMLText(DiagnosticPos pos, BIROperand lhsOp, BIROperand textOp) {
            super(pos, InstructionKind.NEW_XML_TEXT);
            this.lhsOp = lhsOp;
            this.textOp = textOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewStringXMLQName
    extends BIRNonTerminator {
        public BIROperand stringQNameOP;

        public NewStringXMLQName(DiagnosticPos pos, BIROperand lhsOp, BIROperand stringQName) {
            super(pos, InstructionKind.NEW_STRING_XML_QNAME);
            this.lhsOp = lhsOp;
            this.stringQNameOP = stringQName;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewXMLQName
    extends BIRNonTerminator {
        public BIROperand localnameOp;
        public BIROperand nsURIOp;
        public BIROperand prefixOp;

        public NewXMLQName(DiagnosticPos pos, BIROperand lhsOp, BIROperand localnameOp, BIROperand nsURIOp, BIROperand prefixOp) {
            super(pos, InstructionKind.NEW_XML_QNAME);
            this.lhsOp = lhsOp;
            this.localnameOp = localnameOp;
            this.nsURIOp = nsURIOp;
            this.prefixOp = prefixOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewXMLElement
    extends BIRNonTerminator {
        public BIROperand startTagOp;
        public BIROperand defaultNsURIOp;

        public NewXMLElement(DiagnosticPos pos, BIROperand lhsOp, BIROperand startTagOp, BIROperand defaultNsURIOp) {
            super(pos, InstructionKind.NEW_XML_ELEMENT);
            this.lhsOp = lhsOp;
            this.startTagOp = startTagOp;
            this.defaultNsURIOp = defaultNsURIOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class TypeTest
    extends BIRNonTerminator {
        public BIROperand rhsOp;
        public BType type;

        public TypeTest(DiagnosticPos pos, BType type, BIROperand lhsOp, BIROperand rhsOp) {
            super(pos, InstructionKind.TYPE_TEST);
            this.type = type;
            this.lhsOp = lhsOp;
            this.rhsOp = rhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class IsLike
    extends BIRNonTerminator {
        public BIROperand rhsOp;
        public BType type;

        public IsLike(DiagnosticPos pos, BType type, BIROperand lhsOp, BIROperand rhsOp) {
            super(pos, InstructionKind.IS_LIKE);
            this.type = type;
            this.lhsOp = lhsOp;
            this.rhsOp = rhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class TypeCast
    extends BIRNonTerminator {
        public BIROperand rhsOp;
        public BType type;
        public boolean checkTypes;

        public TypeCast(DiagnosticPos pos, BIROperand lhsOp, BIROperand rhsOp, BType castType, boolean checkTypes) {
            super(pos, InstructionKind.TYPE_CAST);
            this.lhsOp = lhsOp;
            this.rhsOp = rhsOp;
            this.type = castType;
            this.checkTypes = checkTypes;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewError
    extends BIRNonTerminator {
        public BType type;
        public BIROperand reasonOp;
        public BIROperand detailOp;

        public NewError(DiagnosticPos pos, BType type, BIROperand lhsOp, BIROperand reasonOp, BIROperand detailOp) {
            super(pos, InstructionKind.NEW_ERROR);
            this.type = type;
            this.lhsOp = lhsOp;
            this.reasonOp = reasonOp;
            this.detailOp = detailOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FieldAccess
    extends BIRNonTerminator {
        public BIROperand keyOp;
        public BIROperand rhsOp;
        public boolean optionalFieldAccess = false;
        public boolean fillingRead = false;

        public FieldAccess(DiagnosticPos pos, InstructionKind kind, BIROperand lhsOp, BIROperand keyOp, BIROperand rhsOp) {
            super(pos, kind);
            this.lhsOp = lhsOp;
            this.keyOp = keyOp;
            this.rhsOp = rhsOp;
        }

        public FieldAccess(DiagnosticPos pos, InstructionKind kind, BIROperand lhsOp, BIROperand keyOp, BIROperand rhsOp, boolean optionalFieldAccess, boolean fillingRead) {
            super(pos, kind);
            this.lhsOp = lhsOp;
            this.keyOp = keyOp;
            this.rhsOp = rhsOp;
            this.optionalFieldAccess = optionalFieldAccess;
            this.fillingRead = fillingRead;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewArray
    extends BIRNonTerminator {
        public BIROperand sizeOp;
        public BType type;

        public NewArray(DiagnosticPos pos, BType type, BIROperand lhsOp, BIROperand sizeOp) {
            super(pos, InstructionKind.NEW_ARRAY);
            this.type = type;
            this.lhsOp = lhsOp;
            this.sizeOp = sizeOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewInstance
    extends BIRNonTerminator {
        public final boolean isExternalDef;
        public final PackageID externalPackageId;
        public BIRNode.BIRTypeDefinition def;
        public final String objectName;

        public NewInstance(DiagnosticPos pos, BIRNode.BIRTypeDefinition def, BIROperand lhsOp) {
            super(pos, InstructionKind.NEW_INSTANCE);
            this.lhsOp = lhsOp;
            this.def = def;
            this.objectName = null;
            this.externalPackageId = null;
            this.isExternalDef = false;
        }

        public NewInstance(DiagnosticPos pos, PackageID externalPackageId, String objectName, BIROperand lhsOp) {
            super(pos, InstructionKind.NEW_INSTANCE);
            this.objectName = objectName;
            this.lhsOp = lhsOp;
            this.def = null;
            this.externalPackageId = externalPackageId;
            this.isExternalDef = true;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NewStructure
    extends BIRNonTerminator {
        public BType type;
        public final boolean isExternalDef;
        public final PackageID externalPackageId;
        public final String recordName;

        public NewStructure(DiagnosticPos pos, BType type, BIROperand lhsOp) {
            super(pos, InstructionKind.NEW_STRUCTURE);
            this.type = type;
            this.lhsOp = lhsOp;
            this.recordName = null;
            this.externalPackageId = null;
            this.isExternalDef = false;
        }

        public NewStructure(DiagnosticPos pos, PackageID externalPackageId, String recordName, BType type, BIROperand lhsOp) {
            super(pos, InstructionKind.NEW_STRUCTURE);
            this.recordName = recordName;
            this.type = type;
            this.lhsOp = lhsOp;
            this.externalPackageId = externalPackageId;
            this.isExternalDef = true;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ConstantLoad
    extends BIRNonTerminator
    implements BIRAssignInstruction {
        public Object value;
        public BType type;

        public ConstantLoad(DiagnosticPos pos, Object value, BType type, BIROperand lhsOp) {
            super(pos, InstructionKind.CONST_LOAD);
            this.value = value;
            this.type = type;
            this.lhsOp = lhsOp;
        }

        @Override
        public BIROperand getLhsOperand() {
            return this.lhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class UnaryOP
    extends BIRNonTerminator
    implements BIRAssignInstruction {
        public BIROperand rhsOp;

        public UnaryOP(DiagnosticPos pos, InstructionKind kind, BIROperand lhsOp, BIROperand rhsOp) {
            super(pos, kind);
            this.lhsOp = lhsOp;
            this.rhsOp = rhsOp;
        }

        @Override
        public BIROperand getLhsOperand() {
            return this.lhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BinaryOp
    extends BIRNonTerminator
    implements BIRAssignInstruction {
        public BIROperand rhsOp1;
        public BIROperand rhsOp2;

        public BinaryOp(DiagnosticPos pos, InstructionKind kind, BType type, BIROperand lhsOp, BIROperand rhsOp1, BIROperand rhsOp2) {
            super(pos, kind);
            this.lhsOp = lhsOp;
            this.rhsOp1 = rhsOp1;
            this.rhsOp2 = rhsOp2;
        }

        @Override
        public BIROperand getLhsOperand() {
            return this.lhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Move
    extends BIRNonTerminator
    implements BIRAssignInstruction {
        public BIROperand rhsOp;

        public Move(DiagnosticPos pos, BIROperand fromOperand, BIROperand toOperand) {
            super(pos, InstructionKind.MOVE);
            this.rhsOp = fromOperand;
            this.lhsOp = toOperand;
        }

        @Override
        public BIROperand getLhsOperand() {
            return this.lhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }
}

