/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.AttachPoint;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.writer.BIRInstructionWriter;
import org.wso2.ballerinalang.compiler.bir.writer.BIRTypeWriter;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class BIRBinaryWriter {
    private final ConstantPool cp = new ConstantPool();
    private final BIRNode.BIRPackage birPackage;

    public BIRBinaryWriter(BIRNode.BIRPackage birPackage) {
        this.birPackage = birPackage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize() {
        ByteBuf birbuf = Unpooled.buffer();
        BIRTypeWriter typeWriter = new BIRTypeWriter(birbuf, this.cp);
        BIRInstructionWriter insWriter = new BIRInstructionWriter(birbuf, typeWriter, this.cp, this);
        int orgCPIndex = this.addStringCPEntry(this.birPackage.org.value);
        int nameCPIndex = this.addStringCPEntry(this.birPackage.name.value);
        int versionCPIndex = this.addStringCPEntry(this.birPackage.version.value);
        int pkgIndex = this.cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
        birbuf.writeInt(pkgIndex);
        this.writeImportModuleDecls(birbuf, this.birPackage.importModules);
        this.writeConstants(birbuf, this.birPackage.constants);
        this.writeTypeDefs(birbuf, typeWriter, insWriter, this.birPackage.typeDefs);
        this.writeGlobalVars(birbuf, typeWriter, this.birPackage.globalVars);
        this.writeTypeDefBodies(birbuf, typeWriter, insWriter, this.birPackage.typeDefs);
        this.writeFunctions(birbuf, typeWriter, insWriter, this.birPackage.functions);
        this.writeAnnotations(birbuf, typeWriter, insWriter, this.birPackage.annotations);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dataOut = new DataOutputStream(baos);){
            dataOut.write(this.cp.serialize());
            dataOut.write(birbuf.nioBuffer().array(), 0, birbuf.nioBuffer().limit());
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BLangCompilerException("failed to serialize the bir", e);
        }
    }

    private void writeImportModuleDecls(ByteBuf buf, List<BIRNode.BIRImportModule> birImpModList) {
        buf.writeInt(birImpModList.size());
        birImpModList.forEach(impMod -> {
            buf.writeInt(this.addStringCPEntry(impMod.org.value));
            buf.writeInt(this.addStringCPEntry(impMod.name.value));
            buf.writeInt(this.addStringCPEntry(impMod.version.value));
        });
    }

    private void writeTypeDefs(ByteBuf buf, BIRTypeWriter typeWriter, BIRInstructionWriter insWriter, List<BIRNode.BIRTypeDefinition> birTypeDefList) {
        buf.writeInt(birTypeDefList.size());
        birTypeDefList.forEach(typeDef -> this.writeType(buf, typeWriter, insWriter, (BIRNode.BIRTypeDefinition)typeDef));
    }

    private void writeTypeDefBodies(ByteBuf buf, BIRTypeWriter typeWriter, BIRInstructionWriter insWriter, List<BIRNode.BIRTypeDefinition> birTypeDefList) {
        List<BIRNode.BIRTypeDefinition> filtered = birTypeDefList.stream().filter(t -> t.type.tag == 32 || t.type.tag == 12).collect(Collectors.toList());
        filtered.forEach(typeDef -> {
            this.writeFunctions(buf, typeWriter, insWriter, typeDef.attachedFuncs);
            this.writeReferencedTypes(buf, typeDef.referencedTypes);
        });
    }

    private void writeReferencedTypes(ByteBuf buf, List<BType> referencedTypes) {
        buf.writeInt(referencedTypes.size());
        referencedTypes.forEach(type -> this.writeType(buf, (BType)type));
    }

    private void writeGlobalVars(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRGlobalVariableDcl> birGlobalVars) {
        buf.writeInt(birGlobalVars.size());
        for (BIRNode.BIRGlobalVariableDcl birGlobalVar : birGlobalVars) {
            buf.writeByte((int)birGlobalVar.kind.getValue());
            buf.writeInt(this.addStringCPEntry(birGlobalVar.name.value));
            buf.writeInt(birGlobalVar.flags);
            typeWriter.writeMarkdownDocAttachment(buf, birGlobalVar.markdownDocAttachment);
            this.writeType(buf, birGlobalVar.type);
        }
    }

    private void writeType(ByteBuf buf, BIRTypeWriter typeWriter, BIRInstructionWriter insWriter, BIRNode.BIRTypeDefinition typeDef) {
        insWriter.writePosition(typeDef.pos);
        buf.writeInt(this.addStringCPEntry(typeDef.name.value));
        buf.writeInt(typeDef.flags);
        buf.writeByte(typeDef.isLabel ? 1 : 0);
        typeWriter.writeMarkdownDocAttachment(buf, typeDef.markdownDocAttachment);
        this.writeType(buf, typeDef.type);
    }

    private void writeFunctions(ByteBuf buf, BIRTypeWriter typeWriter, BIRInstructionWriter insWriter, List<BIRNode.BIRFunction> birFunctionList) {
        buf.writeInt(birFunctionList.size());
        birFunctionList.forEach(func -> this.writeFunction(buf, typeWriter, insWriter, (BIRNode.BIRFunction)func));
    }

    private void writeFunction(ByteBuf buf, BIRTypeWriter typeWriter, BIRInstructionWriter insWriter, BIRNode.BIRFunction birFunction) {
        insWriter.writePosition(birFunction.pos);
        buf.writeInt(this.addStringCPEntry(birFunction.name.value));
        buf.writeInt(this.addStringCPEntry(birFunction.workerName.value));
        buf.writeInt(birFunction.flags);
        this.writeType(buf, birFunction.type);
        this.writeAnnotAttachments(buf, insWriter, birFunction.annotAttachments);
        buf.writeInt(birFunction.requiredParams.size());
        for (BIRNode.BIRParameter parameter : birFunction.requiredParams) {
            buf.writeInt(this.addStringCPEntry(parameter.name.value));
            buf.writeInt(parameter.flags);
        }
        boolean restParamExist = birFunction.restParam != null;
        buf.writeBoolean(restParamExist);
        if (restParamExist) {
            buf.writeInt(this.addStringCPEntry(birFunction.restParam.name.value));
        }
        boolean hasReceiverType = birFunction.receiver != null;
        buf.writeBoolean(hasReceiverType);
        if (hasReceiverType) {
            buf.writeByte((int)birFunction.receiver.kind.getValue());
            this.writeType(buf, birFunction.receiver.type);
            buf.writeInt(this.addStringCPEntry(birFunction.receiver.name.value));
        }
        this.writeTaintTable(buf, birFunction.taintTable);
        typeWriter.writeMarkdownDocAttachment(buf, birFunction.markdownDocAttachment);
        ByteBuf birbuf = Unpooled.buffer();
        BIRTypeWriter funcTypeWriter = new BIRTypeWriter(birbuf, this.cp);
        BIRInstructionWriter funcInsWriter = new BIRInstructionWriter(birbuf, funcTypeWriter, this.cp, this);
        birbuf.writeInt(birFunction.argsCount);
        birbuf.writeBoolean(birFunction.returnVariable != null);
        if (birFunction.returnVariable != null) {
            birbuf.writeByte((int)birFunction.returnVariable.kind.getValue());
            this.writeType(birbuf, birFunction.returnVariable.type);
            birbuf.writeInt(this.addStringCPEntry(birFunction.returnVariable.name.value));
        }
        birbuf.writeInt(birFunction.parameters.size());
        for (BIRNode.BIRFunctionParameter param : birFunction.parameters.keySet()) {
            birbuf.writeByte((int)param.kind.getValue());
            this.writeType(birbuf, param.type);
            birbuf.writeInt(this.addStringCPEntry(param.name.value));
            if (param.kind.equals((Object)VarKind.ARG)) {
                birbuf.writeInt(this.addStringCPEntry(param.metaVarName != null ? param.metaVarName : ""));
            }
            birbuf.writeBoolean(param.hasDefaultExpr);
        }
        birbuf.writeInt(birFunction.localVars.size());
        for (BIRNode.BIRVariableDcl localVar : birFunction.localVars) {
            birbuf.writeByte((int)localVar.kind.getValue());
            this.writeType(birbuf, localVar.type);
            birbuf.writeInt(this.addStringCPEntry(localVar.name.value));
            if (localVar.kind.equals((Object)VarKind.LOCAL) || localVar.kind.equals((Object)VarKind.ARG)) {
                birbuf.writeInt(this.addStringCPEntry(localVar.metaVarName != null ? localVar.metaVarName : ""));
            }
            if (!localVar.kind.equals((Object)VarKind.LOCAL)) continue;
            birbuf.writeInt(this.addStringCPEntry(localVar.endBB != null ? localVar.endBB.id.value : ""));
            birbuf.writeInt(this.addStringCPEntry(localVar.startBB != null ? localVar.startBB.id.value : ""));
            birbuf.writeInt(localVar.insOffset);
        }
        birFunction.parameters.values().stream().filter(bbList -> !bbList.isEmpty()).forEach(funcInsWriter::writeBBs);
        funcInsWriter.writeBBs(birFunction.basicBlocks);
        funcInsWriter.writeErrorTable(birFunction.errorTable);
        birbuf.writeInt(birFunction.workerChannels.length);
        for (Iterator<BIRNode.BIRVariableDcl> iterator : birFunction.workerChannels) {
            birbuf.writeInt(this.addStringCPEntry(((BIRNode.ChannelDetails)((Object)iterator)).name));
            birbuf.writeBoolean(((BIRNode.ChannelDetails)((Object)iterator)).channelInSameStrand);
            birbuf.writeBoolean(((BIRNode.ChannelDetails)((Object)iterator)).send);
        }
        int length = birbuf.nioBuffer().limit();
        buf.writeLong((long)length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeTaintTable(ByteBuf buf, BIRNode.TaintTable taintTable) {
        ByteBuf birbuf = Unpooled.buffer();
        birbuf.writeShort(taintTable.rowCount);
        birbuf.writeShort(taintTable.columnCount);
        for (Integer paramIndex : taintTable.taintTable.keySet()) {
            birbuf.writeShort(paramIndex.intValue());
            List<Byte> taintRecord = taintTable.taintTable.get(paramIndex);
            for (Byte taintStatus : taintRecord) {
                birbuf.writeByte((int)taintStatus.byteValue());
            }
        }
        int length = birbuf.nioBuffer().limit();
        buf.writeLong((long)length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeAnnotations(ByteBuf buf, BIRTypeWriter typeWriter, BIRInstructionWriter insWriter, List<BIRNode.BIRAnnotation> birAnnotationList) {
        buf.writeInt(birAnnotationList.size());
        birAnnotationList.forEach(annotation -> this.writeAnnotation(buf, typeWriter, (BIRNode.BIRAnnotation)annotation));
    }

    private void writeAnnotation(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRAnnotation birAnnotation) {
        buf.writeInt(this.addStringCPEntry(birAnnotation.name.value));
        buf.writeInt(birAnnotation.flags);
        buf.writeInt(birAnnotation.attachPoints.size());
        for (AttachPoint attachPoint : birAnnotation.attachPoints) {
            buf.writeInt(this.addStringCPEntry(attachPoint.point.getValue()));
            buf.writeBoolean(attachPoint.source);
        }
        this.writeType(buf, birAnnotation.annotationType);
        typeWriter.writeMarkdownDocAttachment(buf, birAnnotation.markdownDocAttachment);
    }

    private void writeConstants(ByteBuf buf, List<BIRNode.BIRConstant> birConstList) {
        BIRTypeWriter constTypeWriter = new BIRTypeWriter(buf, this.cp);
        buf.writeInt(birConstList.size());
        birConstList.forEach(constant -> this.writeConstant(buf, constTypeWriter, (BIRNode.BIRConstant)constant));
    }

    private void writeConstant(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRConstant birConstant) {
        buf.writeInt(this.addStringCPEntry(birConstant.name.value));
        buf.writeInt(birConstant.flags);
        typeWriter.writeMarkdownDocAttachment(buf, birConstant.markdownDocAttachment);
        this.writeType(buf, birConstant.type);
        ByteBuf birbuf = Unpooled.buffer();
        this.writeConstValue(birbuf, birConstant.constValue);
        int length = birbuf.nioBuffer().limit();
        buf.writeLong((long)length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeConstValue(ByteBuf buf, BIRNode.ConstValue constValue) {
        this.writeType(buf, constValue.type);
        switch (constValue.type.tag) {
            case 1: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                buf.writeInt(this.addIntCPEntry((Long)constValue.value));
                break;
            }
            case 2: {
                int byteValue = ((Number)constValue.value).intValue();
                buf.writeInt(this.addByteCPEntry(byteValue));
                break;
            }
            case 3: {
                double doubleVal = constValue.value instanceof String ? Double.parseDouble((String)constValue.value) : (Double)constValue.value;
                buf.writeInt(this.addFloatCPEntry(doubleVal));
                break;
            }
            case 4: 
            case 5: 
            case 42: {
                buf.writeInt(this.addStringCPEntry((String)constValue.value));
                break;
            }
            case 6: {
                buf.writeByte((Boolean)constValue.value != false ? 1 : 0);
                break;
            }
            case 10: {
                break;
            }
            case 15: {
                Map mapConstVal = (Map)constValue.value;
                buf.writeInt(mapConstVal.size());
                mapConstVal.forEach((key, value) -> {
                    buf.writeInt(this.addStringCPEntry((String)key));
                    this.writeConstValue(buf, (BIRNode.ConstValue)value);
                });
                break;
            }
            default: {
                throw new UnsupportedOperationException("finite type value is not supported for type: " + constValue.type);
            }
        }
    }

    private int addIntCPEntry(long value) {
        return this.cp.addCPEntry(new CPEntry.IntegerCPEntry(value));
    }

    private int addFloatCPEntry(double value) {
        return this.cp.addCPEntry(new CPEntry.FloatCPEntry(value));
    }

    private int addStringCPEntry(String value) {
        return this.cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    private int addByteCPEntry(int value) {
        return this.cp.addCPEntry(new CPEntry.ByteCPEntry(value));
    }

    private void writeType(ByteBuf buf, BType type) {
        buf.writeInt(this.cp.addShapeCPEntry(type));
    }

    void writeAnnotAttachments(ByteBuf buff, BIRInstructionWriter insWriter, List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        ByteBuf annotBuf = Unpooled.buffer();
        annotBuf.writeInt(annotAttachments.size());
        for (BIRNode.BIRAnnotationAttachment annotAttachment : annotAttachments) {
            this.writeAnnotAttachment(annotBuf, insWriter, annotAttachment);
        }
        int length = annotBuf.nioBuffer().limit();
        buff.writeLong((long)length);
        buff.writeBytes(annotBuf.nioBuffer().array(), 0, length);
    }

    private void writeAnnotAttachment(ByteBuf annotBuf, BIRInstructionWriter insWriter, BIRNode.BIRAnnotationAttachment annotAttachment) {
        annotBuf.writeInt(insWriter.addPkgCPEntry(annotAttachment.packageID));
        insWriter.writePosition(annotBuf, annotAttachment.pos);
        annotBuf.writeInt(this.addStringCPEntry(annotAttachment.annotTagRef.value));
        this.writeAnnotAttachValues(annotBuf, annotAttachment.annotValues);
    }

    private void writeAnnotAttachValues(ByteBuf annotBuf, List<BIRNode.BIRAnnotationValue> annotValues) {
        annotBuf.writeInt(annotValues.size());
        for (BIRNode.BIRAnnotationValue annotValue : annotValues) {
            this.writeAnnotAttachValue(annotBuf, annotValue);
        }
    }

    private void writeAnnotAttachValue(ByteBuf annotBuf, BIRNode.BIRAnnotationValue annotValue) {
        if (annotValue.type.tag == 19) {
            this.writeType(annotBuf, annotValue.type);
            BIRNode.BIRAnnotationArrayValue annotArrayValue = (BIRNode.BIRAnnotationArrayValue)annotValue;
            annotBuf.writeInt(annotArrayValue.annotArrayValue.length);
            for (BIRNode.BIRAnnotationValue annotValueEntry : annotArrayValue.annotArrayValue) {
                this.writeAnnotAttachValue(annotBuf, annotValueEntry);
            }
        } else if (annotValue.type.tag == 12 || annotValue.type.tag == 15) {
            this.writeType(annotBuf, annotValue.type);
            BIRNode.BIRAnnotationRecordValue annotRecValue = (BIRNode.BIRAnnotationRecordValue)annotValue;
            annotBuf.writeInt(annotRecValue.annotValueEntryMap.size());
            for (Map.Entry<String, BIRNode.BIRAnnotationValue> annotValueEntry : annotRecValue.annotValueEntryMap.entrySet()) {
                annotBuf.writeInt(this.addStringCPEntry(annotValueEntry.getKey()));
                this.writeAnnotAttachValue(annotBuf, annotValueEntry.getValue());
            }
        } else {
            BIRNode.BIRAnnotationLiteralValue annotLiteralValue = (BIRNode.BIRAnnotationLiteralValue)annotValue;
            this.writeConstValue(annotBuf, new BIRNode.ConstValue(annotLiteralValue.value, annotLiteralValue.type));
        }
    }
}

