/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.elements.TableColumnFlag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.BlockFunctionBodyNode;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.NamedArgNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.Transactions;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.AnnotationDesugar;
import org.wso2.ballerinalang.compiler.desugar.ClosureDesugar;
import org.wso2.ballerinalang.compiler.desugar.MockDesugar;
import org.wso2.ballerinalang.compiler.desugar.QueryDesugar;
import org.wso2.ballerinalang.compiler.desugar.ServiceDesugar;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAbort;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnosticSource;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class Desugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<Desugar> DESUGAR_KEY = new CompilerContext.Key();
    private static final String QUERY_TABLE_WITH_JOIN_CLAUSE = "queryTableWithJoinClause";
    private static final String QUERY_TABLE_WITHOUT_JOIN_CLAUSE = "queryTableWithoutJoinClause";
    private static final String BASE_64 = "base64";
    private static final String ERROR_REASON_FUNCTION_NAME = "reason";
    private static final String ERROR_DETAIL_FUNCTION_NAME = "detail";
    private static final String TO_STRING_FUNCTION_NAME = "toString";
    private static final String LENGTH_FUNCTION_NAME = "length";
    private static final String ERROR_REASON_NULL_REFERENCE_ERROR = "NullReferenceException";
    private static final String CONSTRUCT_FROM = "constructFrom";
    public static final String XML_INTERNAL_SELECT_DESCENDANTS = "selectDescendants";
    public static final String XML_INTERNAL_CHILDREN = "children";
    public static final String XML_INTERNAL_GET_FILTERED_CHILDREN_FLAT = "getFilteredChildrenFlat";
    public static final String XML_INTERNAL_GET_ELEMENT_NAME_NIL_LIFTING = "getElementNameNilLifting";
    public static final String XML_INTERNAL_GET_ATTRIBUTE = "getAttribute";
    public static final String XML_INTERNAL_GET_ELEMENTS = "getElements";
    private SymbolTable symTable;
    private SymbolResolver symResolver;
    private final SymbolEnter symbolEnter;
    private ClosureDesugar closureDesugar;
    private QueryDesugar queryDesugar;
    private AnnotationDesugar annotationDesugar;
    private Types types;
    private Names names;
    private ServiceDesugar serviceDesugar;
    private BLangNode result;
    private NodeCloner nodeCloner;
    private SemanticAnalyzer semanticAnalyzer;
    private MockDesugar mockDesugar;
    private BLangStatement.BLangStatementLink currentLink;
    public Stack<BLangLock.BLangLockStmt> enclLocks = new Stack();
    private SymbolEnv env;
    private int lambdaFunctionCount = 0;
    private int transactionIndex = 0;
    private int recordCount = 0;
    private int errorCount = 0;
    private int annonVarCount = 0;
    private int initFuncIndex = 0;
    private int indexExprCount = 0;
    private int letCount = 0;
    private Stack<BLangMatch> matchStmtStack = new Stack();
    Stack<BLangExpression> accessExprStack = new Stack();
    private BLangMatch.BLangMatchTypedBindingPatternClause successPattern;
    private BLangAssignment safeNavigationAssignment;
    static boolean isJvmTarget = false;

    public static Desugar getInstance(CompilerContext context) {
        Desugar desugar = context.get(DESUGAR_KEY);
        if (desugar == null) {
            desugar = new Desugar(context);
        }
        return desugar;
    }

    private Desugar(CompilerContext context) {
        isJvmTarget = true;
        context.put(DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.closureDesugar = ClosureDesugar.getInstance(context);
        this.queryDesugar = QueryDesugar.getInstance(context);
        this.annotationDesugar = AnnotationDesugar.getInstance(context);
        this.types = Types.getInstance(context);
        this.names = Names.getInstance(context);
        this.names = Names.getInstance(context);
        this.serviceDesugar = ServiceDesugar.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
        this.mockDesugar = MockDesugar.getInstance(context);
    }

    public BLangPackage perform(BLangPackage pkgNode) {
        this.annotationDesugar.initializeAnnotationMap(pkgNode);
        SymbolEnv env = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        return this.rewrite(pkgNode, env);
    }

    private void addAttachedFunctionsToPackageLevel(BLangPackage pkgNode, SymbolEnv env) {
        for (BLangTypeDefinition typeDef : pkgNode.typeDefinitions) {
            if (typeDef.typeNode.getKind() == NodeKind.USER_DEFINED_TYPE) continue;
            if (typeDef.symbol.tag == 196700) {
                BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)typeDef.typeNode;
                objectTypeNode.functions.forEach(f -> {
                    if (!pkgNode.objAttachedFunctions.contains(f.symbol)) {
                        pkgNode.functions.add((BLangFunction)f);
                        pkgNode.topLevelNodes.add((TopLevelNode)f);
                    }
                });
                if (objectTypeNode.flagSet.contains((Object)Flag.ABSTRACT)) continue;
                BLangFunction tempGeneratedInitFunction = this.createGeneratedInitializerFunction(objectTypeNode, env);
                tempGeneratedInitFunction.clonedEnv = SymbolEnv.createFunctionEnv(tempGeneratedInitFunction, tempGeneratedInitFunction.symbol.scope, env);
                this.semanticAnalyzer.analyzeNode(tempGeneratedInitFunction, env);
                objectTypeNode.generatedInitFunction = tempGeneratedInitFunction;
                pkgNode.functions.add(objectTypeNode.generatedInitFunction);
                pkgNode.topLevelNodes.add(objectTypeNode.generatedInitFunction);
                if (objectTypeNode.initFunction == null) continue;
                pkgNode.functions.add(objectTypeNode.initFunction);
                pkgNode.topLevelNodes.add(objectTypeNode.initFunction);
                continue;
            }
            if (typeDef.symbol.tag != 327772) continue;
            BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)typeDef.typeNode;
            recordTypeNode.initFunction = this.rewrite(TypeDefBuilderHelper.createInitFunctionForRecordType(recordTypeNode, env, this.names, this.symTable), env);
            pkgNode.functions.add(recordTypeNode.initFunction);
            pkgNode.topLevelNodes.add(recordTypeNode.initFunction);
        }
    }

    private BLangFunction createGeneratedInitializerFunction(BLangObjectTypeNode objectTypeNode, SymbolEnv env) {
        BLangFunction generatedInitFunc = this.createInitFunctionForObjectType(objectTypeNode, env);
        if (objectTypeNode.initFunction == null) {
            return generatedInitFunc;
        }
        BAttachedFunction initializerFunc = ((BObjectTypeSymbol)objectTypeNode.symbol).initializerFunc;
        BAttachedFunction generatedInitializerFunc = ((BObjectTypeSymbol)objectTypeNode.symbol).generatedInitializerFunc;
        this.addRequiredParamsToGeneratedInitFunction(objectTypeNode.initFunction, generatedInitFunc, generatedInitializerFunc);
        this.addRestParamsToGeneratedInitFunction(objectTypeNode.initFunction, generatedInitFunc, generatedInitializerFunc);
        generatedInitFunc.returnTypeNode = objectTypeNode.initFunction.returnTypeNode;
        generatedInitializerFunc.symbol.retType = generatedInitFunc.returnTypeNode.type;
        ((BInvokableType)generatedInitFunc.symbol.type).paramTypes = initializerFunc.type.paramTypes;
        ((BInvokableType)generatedInitFunc.symbol.type).retType = initializerFunc.type.retType;
        ((BInvokableType)generatedInitFunc.symbol.type).restType = initializerFunc.type.restType;
        generatedInitializerFunc.type = initializerFunc.type;
        generatedInitFunc.desugared = false;
        return generatedInitFunc;
    }

    private void addRequiredParamsToGeneratedInitFunction(BLangFunction initFunction, BLangFunction generatedInitFunc, BAttachedFunction generatedInitializerFunc) {
        if (initFunction.requiredParams.isEmpty()) {
            return;
        }
        for (BLangSimpleVariable requiredParameter : initFunction.requiredParams) {
            BLangSimpleVariable var = ASTBuilderUtil.createVariable(initFunction.pos, requiredParameter.name.getValue(), requiredParameter.type, this.createRequiredParamExpr(requiredParameter.expr), new BVarSymbol(0, this.names.fromString(requiredParameter.name.getValue()), requiredParameter.symbol.pkgID, requiredParameter.type, requiredParameter.symbol.owner));
            generatedInitFunc.requiredParams.add(var);
            generatedInitializerFunc.symbol.params.add(var.symbol);
        }
    }

    private BLangExpression createRequiredParamExpr(BLangExpression expr) {
        if (expr == null) {
            return null;
        }
        if (expr.getKind() == NodeKind.LAMBDA) {
            BLangFunction func = ((BLangLambdaFunction)expr).function;
            return this.createLambdaFunction(func.pos, func.name.value, func.requiredParams, func.returnTypeNode, func.body);
        }
        BLangExpression expression = this.nodeCloner.clone(expr);
        if (expression.getKind() == NodeKind.ARROW_EXPR) {
            BLangIdentifier func = (BLangIdentifier)((BLangArrowFunction)expression).functionName;
            ((BLangArrowFunction)expression).functionName = ASTBuilderUtil.createIdentifier(func.pos, "$" + func.getValue() + "$");
        }
        return expression;
    }

    private void addRestParamsToGeneratedInitFunction(BLangFunction initFunction, BLangFunction generatedInitFunc, BAttachedFunction generatedInitializerFunc) {
        if (initFunction.restParam == null) {
            return;
        }
        BLangSimpleVariable restParam = initFunction.restParam;
        generatedInitFunc.restParam = ASTBuilderUtil.createVariable(initFunction.pos, restParam.name.getValue(), restParam.type, null, new BVarSymbol(0, this.names.fromString(restParam.name.getValue()), restParam.symbol.pkgID, restParam.type, restParam.symbol.owner));
        generatedInitializerFunc.symbol.restParam = generatedInitFunc.restParam.symbol;
    }

    private void createPackageInitFunctions(BLangPackage pkgNode, SymbolEnv env) {
        String alias = pkgNode.symbol.pkgID.toString();
        pkgNode.initFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(pkgNode.pos, alias, Names.INIT_FUNCTION_SUFFIX, this.symTable);
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)pkgNode.initFunction.body;
        for (BLangXMLNS xmlns : pkgNode.xmlnsList) {
            initFnBody.addStatement(this.createNamespaceDeclrStatement(xmlns));
        }
        pkgNode.startFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(pkgNode.pos, alias, Names.START_FUNCTION_SUFFIX, this.symTable);
        pkgNode.stopFunction = ASTBuilderUtil.createInitFunctionWithNilReturn(pkgNode.pos, alias, Names.STOP_FUNCTION_SUFFIX);
        this.createInvokableSymbol(pkgNode.initFunction, env);
        this.createInvokableSymbol(pkgNode.startFunction, env);
        this.createInvokableSymbol(pkgNode.stopFunction, env);
    }

    private void addUserDefinedModuleInitInvocationAndReturn(BLangPackage pkgNode) {
        Optional<BLangFunction> userDefInitOptional = pkgNode.functions.stream().filter(bLangFunction -> !bLangFunction.attachedFunction && bLangFunction.name.value.equals(Names.USER_DEFINED_INIT_SUFFIX.value)).findFirst();
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)pkgNode.initFunction.body;
        if (!userDefInitOptional.isPresent()) {
            this.addNilReturnStatement(initFnBody);
            return;
        }
        BLangFunction userDefInit = userDefInitOptional.get();
        BLangInvocation userDefInitInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        userDefInitInvocation.pos = pkgNode.initFunction.pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(userDefInit.name.value);
        userDefInitInvocation.name = name;
        userDefInitInvocation.symbol = userDefInit.symbol;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setLiteral(false);
        pkgAlias.setValue(pkgNode.packageID.name.value);
        userDefInitInvocation.pkgAlias = pkgAlias;
        userDefInitInvocation.type = userDefInit.returnTypeNode.type;
        userDefInitInvocation.requiredArgs = Collections.emptyList();
        BLangReturn returnStmt = (BLangReturn)TreeBuilder.createReturnNode();
        returnStmt.pos = pkgNode.initFunction.pos;
        returnStmt.expr = userDefInitInvocation;
        initFnBody.stmts.add(returnStmt);
    }

    private void createInvokableSymbol(BLangFunction bLangFunction, SymbolEnv env) {
        BType returnType = bLangFunction.returnTypeNode.type == null ? this.symResolver.resolveTypeNode(bLangFunction.returnTypeNode, env) : bLangFunction.returnTypeNode.type;
        BInvokableType invokableType = new BInvokableType(new ArrayList<BType>(), this.getRestType(bLangFunction), returnType, null);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(bLangFunction.flagSet), new Name(bLangFunction.name.value), env.enclPkg.packageID, invokableType, env.enclPkg.symbol, true);
        functionSymbol.retType = returnType;
        for (BLangVariable param : bLangFunction.requiredParams) {
            functionSymbol.params.add(param.symbol);
        }
        functionSymbol.scope = new Scope(functionSymbol);
        bLangFunction.symbol = functionSymbol;
    }

    private void addNilReturnStatement(BlockNode bLangBlockStmt) {
        BLangReturn returnStmt = ASTBuilderUtil.createNilReturnStmt(((BLangNode)((Object)bLangBlockStmt)).pos, this.symTable.nilType);
        bLangBlockStmt.addStatement(returnStmt);
    }

    private BLangXMLNSStatement createNamespaceDeclrStatement(BLangXMLNS xmlns) {
        BLangXMLNSStatement xmlnsStmt = (BLangXMLNSStatement)TreeBuilder.createXMLNSDeclrStatementNode();
        xmlnsStmt.xmlnsDecl = xmlns;
        xmlnsStmt.pos = xmlns.pos;
        return xmlnsStmt;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.DESUGAR)) {
            this.result = pkgNode;
            return;
        }
        this.createPackageInitFunctions(pkgNode, this.env);
        this.addAttachedFunctionsToPackageLevel(pkgNode, this.env);
        if (!pkgNode.testablePkgs.isEmpty() && pkgNode.getTestablePkg().getMockFunctionNamesMap() != null) {
            this.mockDesugar.generateMockFunctions(pkgNode);
        }
        pkgNode.constants.stream().filter(constant -> constant.expr.getKind() == NodeKind.LITERAL || constant.expr.getKind() == NodeKind.NUMERIC_LITERAL).forEach(constant -> pkgNode.typeDefinitions.add(constant.associatedTypeDefinition));
        BLangBlockStmt serviceAttachments = this.serviceDesugar.rewriteServiceVariables(pkgNode.services, this.env);
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)pkgNode.initFunction.body;
        for (BLangConstant constant2 : pkgNode.constants) {
            if (constant2.symbol.type.tag != 15) continue;
            BLangSimpleVarRef constVarRef = ASTBuilderUtil.createVariableRef(constant2.pos, constant2.symbol);
            constant2.expr = this.rewrite(constant2.expr, SymbolEnv.createTypeEnv(constant2.typeNode, pkgNode.initFunction.symbol.scope, this.env));
            BLangInvocation frozenConstValExpr = this.createLangLibInvocationNode("cloneReadOnly", constant2.expr, new ArrayList<BLangExpression>(), constant2.expr.type, constant2.pos);
            BLangAssignment constInit = ASTBuilderUtil.createAssignmentStmt(constant2.pos, constVarRef, frozenConstValExpr);
            initFnBody.stmts.add(constInit);
        }
        pkgNode.globalVars.forEach(globalVar -> {
            BLangAssignment assignment = this.createAssignmentStmt((BLangSimpleVariable)globalVar);
            if (assignment.expr != null) {
                initFnBody.stmts.add(assignment);
            }
        });
        pkgNode.services.forEach(service -> this.serviceDesugar.engageCustomServiceDesugar((BLangService)service, this.env));
        this.annotationDesugar.rewritePackageAnnotations(pkgNode, this.env);
        this.addUserDefinedModuleInitInvocationAndReturn(pkgNode);
        pkgNode.typeDefinitions.sort(Comparator.comparing(t -> t.precedence));
        pkgNode.typeDefinitions = this.rewrite(pkgNode.typeDefinitions, this.env);
        pkgNode.xmlnsList = this.rewrite(pkgNode.xmlnsList, this.env);
        pkgNode.constants = this.rewrite(pkgNode.constants, this.env);
        pkgNode.globalVars = this.rewrite(pkgNode.globalVars, this.env);
        pkgNode.functions = this.rewrite(pkgNode.functions, this.env);
        this.serviceDesugar.rewriteListeners(pkgNode.globalVars, this.env, pkgNode.startFunction, pkgNode.stopFunction);
        ASTBuilderUtil.appendStatements(serviceAttachments, (BLangBlockFunctionBody)pkgNode.initFunction.body);
        this.addNilReturnStatement((BLangBlockFunctionBody)pkgNode.startFunction.body);
        this.addNilReturnStatement((BLangBlockFunctionBody)pkgNode.stopFunction.body);
        pkgNode.initFunction = this.splitInitFunction(pkgNode, this.env);
        pkgNode.initFunction = this.rewrite(pkgNode.initFunction, this.env);
        pkgNode.startFunction = this.rewrite(pkgNode.startFunction, this.env);
        pkgNode.stopFunction = this.rewrite(pkgNode.stopFunction, this.env);
        this.closureDesugar.visit(pkgNode);
        for (BLangTestablePackage testablePkg : pkgNode.getTestablePkgs()) {
            this.rewrite(testablePkg, this.symTable.pkgEnvMap.get(testablePkg.symbol));
        }
        pkgNode.completedPhases.add(CompilerPhase.DESUGAR);
        this.initFuncIndex = 0;
        this.result = pkgNode;
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        BPackageSymbol pkgSymbol = importPkgNode.symbol;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgSymbol);
        this.rewrite(pkgEnv.node, pkgEnv);
        this.result = importPkgNode;
    }

    @Override
    public void visit(BLangTypeDefinition typeDef) {
        if (typeDef.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDef.typeNode.getKind() == NodeKind.RECORD_TYPE) {
            typeDef.typeNode = this.rewrite(typeDef.typeNode, this.env);
        }
        typeDef.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = typeDef;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        objectTypeNode.fields.addAll(objectTypeNode.referencedFields);
        if (objectTypeNode.flagSet.contains((Object)Flag.ABSTRACT)) {
            this.result = objectTypeNode;
            return;
        }
        for (Object bLangSimpleVariable : objectTypeNode.fields) {
            ((BLangSimpleVariable)bLangSimpleVariable).typeNode = this.rewrite(((BLangSimpleVariable)bLangSimpleVariable).typeNode, this.env);
        }
        Map<BSymbol, BLangStatement> initFuncStmts = objectTypeNode.generatedInitFunction.initFunctionStmts;
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            if (initFuncStmts.containsKey(field.symbol) || field.expr == null) continue;
            initFuncStmts.put(field.symbol, this.createStructFieldUpdate(objectTypeNode.generatedInitFunction, field, objectTypeNode.generatedInitFunction.receiver.symbol));
        }
        BLangStatement[] initStmts = initFuncStmts.values().toArray(new BLangStatement[0]);
        BLangBlockFunctionBody generatedInitFnBody = (BLangBlockFunctionBody)objectTypeNode.generatedInitFunction.body;
        for (int i = 0; i < initStmts.length; ++i) {
            generatedInitFnBody.stmts.add(i, initStmts[i]);
        }
        if (objectTypeNode.initFunction != null) {
            ((BLangReturn)generatedInitFnBody.stmts.get((int)i)).expr = this.createUserDefinedInitInvocation(objectTypeNode);
        }
        for (BLangFunction fn : objectTypeNode.functions) {
            this.rewrite(fn, this.env);
        }
        this.rewrite(objectTypeNode.generatedInitFunction, this.env);
        this.rewrite(objectTypeNode.initFunction, this.env);
        this.result = objectTypeNode;
    }

    private BLangInvocation createUserDefinedInitInvocation(BLangObjectTypeNode objectTypeNode) {
        ArrayList<BLangExpression> paramRefs = new ArrayList<BLangExpression>();
        for (BLangSimpleVariable var : objectTypeNode.generatedInitFunction.requiredParams) {
            paramRefs.add(ASTBuilderUtil.createVariableRef(objectTypeNode.pos, var.symbol));
        }
        BLangInvocation invocation = ASTBuilderUtil.createInvocationExprMethod(objectTypeNode.pos, ((BObjectTypeSymbol)objectTypeNode.symbol).initializerFunc.symbol, paramRefs, Collections.emptyList(), this.symResolver);
        if (objectTypeNode.generatedInitFunction.restParam != null) {
            BLangSimpleVarRef restVarRef = ASTBuilderUtil.createVariableRef(objectTypeNode.pos, objectTypeNode.generatedInitFunction.restParam.symbol);
            BLangRestArgsExpression bLangRestArgsExpression = new BLangRestArgsExpression();
            bLangRestArgsExpression.expr = restVarRef;
            bLangRestArgsExpression.pos = objectTypeNode.generatedInitFunction.pos;
            bLangRestArgsExpression.expectedType = bLangRestArgsExpression.type = objectTypeNode.generatedInitFunction.restParam.type;
            invocation.restArgs.add(bLangRestArgsExpression);
        }
        invocation.exprSymbol = ((BObjectTypeSymbol)objectTypeNode.symbol).generatedInitializerFunc.symbol.receiverSymbol;
        return this.rewriteExpr(invocation);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        recordTypeNode.fields.addAll(recordTypeNode.referencedFields);
        for (BLangSimpleVariable bLangSimpleVariable : recordTypeNode.fields) {
            bLangSimpleVariable.typeNode = this.rewrite(bLangSimpleVariable.typeNode, this.env);
        }
        if (recordTypeNode.initFunction == null) {
            recordTypeNode.initFunction = TypeDefBuilderHelper.createInitFunctionForRecordType(recordTypeNode, this.env, this.names, this.symTable);
            this.env.enclPkg.addFunction(recordTypeNode.initFunction);
            this.env.enclPkg.topLevelNodes.add(recordTypeNode.initFunction);
        }
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            if (recordTypeNode.initFunction.initFunctionStmts.containsKey(field.symbol) || Symbols.isOptional(field.symbol) || field.expr == null) continue;
            recordTypeNode.initFunction.initFunctionStmts.put(field.symbol, this.createStructFieldUpdate(recordTypeNode.initFunction, field, recordTypeNode.initFunction.receiver.symbol));
        }
        BLangStatement[] initStmts = recordTypeNode.initFunction.initFunctionStmts.values().toArray(new BLangStatement[0]);
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)recordTypeNode.initFunction.body;
        for (int i = 0; i < recordTypeNode.initFunction.initFunctionStmts.size(); ++i) {
            initFnBody.stmts.add(i, initStmts[i]);
        }
        if (recordTypeNode.isAnonymous && recordTypeNode.isLocal) {
            BLangUserDefinedType userDefinedType = this.desugarLocalAnonRecordTypeNode(recordTypeNode);
            TypeDefBuilderHelper.addTypeDefinition(recordTypeNode.type, recordTypeNode.type.tsymbol, recordTypeNode, this.env);
            recordTypeNode.desugared = true;
            this.result = userDefinedType;
            return;
        }
        this.result = recordTypeNode;
    }

    private BLangUserDefinedType desugarLocalAnonRecordTypeNode(BLangRecordTypeNode recordTypeNode) {
        return ASTBuilderUtil.createUserDefineTypeNode(recordTypeNode.symbol.name.value, recordTypeNode.type, recordTypeNode.pos);
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        arrayType.elemtype = this.rewrite(arrayType.elemtype, this.env);
        this.result = arrayType;
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        constrainedType.constraint = this.rewrite(constrainedType.constraint, this.env);
        this.result = constrainedType;
    }

    @Override
    public void visit(BLangStreamType streamType) {
        streamType.constraint = this.rewrite(streamType.constraint, this.env);
        streamType.error = this.rewrite(streamType.error, this.env);
        this.result = streamType;
    }

    @Override
    public void visit(BLangValueType valueType) {
        this.result = valueType;
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        this.result = userDefinedType;
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        ArrayList<BLangType> rewrittenMembers = new ArrayList<BLangType>();
        unionTypeNode.memberTypeNodes.forEach(typeNode -> rewrittenMembers.add(this.rewrite(typeNode, this.env)));
        unionTypeNode.memberTypeNodes = rewrittenMembers;
        this.result = unionTypeNode;
    }

    @Override
    public void visit(BLangErrorType errorType) {
        errorType.detailType = this.rewrite(errorType.detailType, this.env);
        this.result = errorType;
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        functionTypeNode.params.forEach(param -> this.rewrite(param.typeNode, this.env));
        functionTypeNode.returnTypeNode = this.rewrite(functionTypeNode.returnTypeNode, this.env);
        this.result = functionTypeNode;
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode refTypeNode) {
        this.result = refTypeNode;
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        ArrayList<BLangType> rewrittenMembers = new ArrayList<BLangType>();
        tupleTypeNode.memberTypeNodes.forEach(member -> rewrittenMembers.add(this.rewrite(member, this.env)));
        tupleTypeNode.memberTypeNodes = rewrittenMembers;
        tupleTypeNode.restParamType = this.rewrite(tupleTypeNode.restParamType, this.env);
        this.result = tupleTypeNode;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        body.stmts = this.rewriteStmt(body.stmts, bodyEnv);
        this.result = body;
    }

    @Override
    public void visit(BLangExprFunctionBody exprBody) {
        BLangBlockFunctionBody body = ASTBuilderUtil.createBlockFunctionBody(exprBody.pos, new ArrayList<BLangStatement>());
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(exprBody.pos, body);
        returnStmt.expr = this.rewriteExpr(exprBody.expr);
        this.result = body;
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        for (BLangAnnotationAttachment attachment : body.annAttachments) {
            this.rewrite(attachment, this.env);
        }
        this.result = body;
    }

    @Override
    public void visit(BLangFunction funcNode) {
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        if (!funcNode.interfaceFunction) {
            this.addReturnIfNotPresent(funcNode);
        }
        funcNode.originalFuncSymbol = funcNode.symbol;
        funcNode.symbol = ASTBuilderUtil.duplicateInvokableSymbol(funcNode.symbol);
        funcNode.requiredParams = this.rewrite(funcNode.requiredParams, funcEnv);
        funcNode.restParam = this.rewrite(funcNode.restParam, funcEnv);
        funcNode.workers = this.rewrite(funcNode.workers, funcEnv);
        if (funcNode.returnTypeNode != null && funcNode.returnTypeNode.getKind() != null) {
            funcNode.returnTypeNode = this.rewrite(funcNode.returnTypeNode, funcEnv);
        }
        List<BLangAnnotationAttachment> participantAnnotation = funcNode.annAttachments.stream().filter(a -> Transactions.isTransactionsAnnotation(a.pkgAlias.value, a.annotationName.value)).collect(Collectors.toList());
        funcNode.body = this.rewrite(funcNode.body, funcEnv);
        funcNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        if (funcNode.returnTypeNode != null) {
            funcNode.returnTypeAnnAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        }
        if (participantAnnotation.isEmpty()) {
            this.result = funcNode;
            return;
        }
        this.result = this.desugarParticipantFunction(funcNode, participantAnnotation);
    }

    private BLangFunction desugarParticipantFunction(BLangFunction funcNode, List<BLangAnnotationAttachment> participantAnnotation) {
        BLangReturn returnStmt;
        BLangAnnotationAttachment annotation = participantAnnotation.get(0);
        BLangBlockFunctionBody onCommitBody = null;
        BLangBlockFunctionBody onAbortBody = null;
        funcNode.requiredParams.forEach(bLangSimpleVariable -> {
            bLangSimpleVariable.symbol.closure = true;
        });
        if (funcNode.receiver != null) {
            funcNode.receiver.symbol.closure = true;
        }
        BUnionType trxReturnType = BUnionType.create(null, this.symTable.errorType, this.symTable.anyType);
        BLangType trxReturnNode = ASTBuilderUtil.createTypeNode(trxReturnType);
        BLangLambdaFunction commitFunc = this.createLambdaFunction(funcNode.pos, "$anonOnCommitFunc$", ASTBuilderUtil.createTypeNode(this.symTable.nilType));
        BLangLambdaFunction abortFunc = this.createLambdaFunction(funcNode.pos, "$anonOnAbortFunc$", ASTBuilderUtil.createTypeNode(this.symTable.nilType));
        BLangSimpleVariable onCommitTrxVar = ASTBuilderUtil.createVariable(funcNode.pos, "$trxId$0", this.symTable.stringType, null, new BVarSymbol(0, this.names.fromString("$trxId$0"), this.env.scope.owner.pkgID, this.symTable.stringType, commitFunc.function.symbol));
        BLangSimpleVariable onAbortTrxVar = ASTBuilderUtil.createVariable(funcNode.pos, "$trxId$0", this.symTable.stringType, null, new BVarSymbol(0, this.names.fromString("$trxId$0"), this.env.scope.owner.pkgID, this.symTable.stringType, abortFunc.function.symbol));
        BLangSimpleVarRef trxIdOnCommitRef = ASTBuilderUtil.createVariableRef(funcNode.pos, onCommitTrxVar.symbol);
        BLangSimpleVarRef trxIdOnAbortRef = ASTBuilderUtil.createVariableRef(funcNode.pos, onAbortTrxVar.symbol);
        for (Map.Entry<String, BLangExpression> entry : this.getKeyValuePairs((BLangStatementExpression)annotation.expr).entrySet()) {
            switch (entry.getKey()) {
                case "oncommit": {
                    BInvokableSymbol commitSym = (BInvokableSymbol)((BLangSimpleVarRef)entry.getValue()).symbol;
                    BLangInvocation onCommit = ASTBuilderUtil.createInvocationExprMethod(funcNode.pos, commitSym, Lists.of(trxIdOnCommitRef), Collections.emptyList(), this.symResolver);
                    BLangReturn onCommitStmt = ASTBuilderUtil.createReturnStmt(funcNode.pos, onCommit);
                    onCommitBody = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos, Lists.of(onCommitStmt));
                    break;
                }
                case "onabort": {
                    BInvokableSymbol abortSym = (BInvokableSymbol)((BLangSimpleVarRef)entry.getValue()).symbol;
                    BLangInvocation onAbort = ASTBuilderUtil.createInvocationExprMethod(funcNode.pos, abortSym, Lists.of(trxIdOnAbortRef), Collections.emptyList(), this.symResolver);
                    BLangReturn onAbortStmt = ASTBuilderUtil.createReturnStmt(funcNode.pos, onAbort);
                    onAbortBody = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos, Lists.of(onAbortStmt));
                }
            }
        }
        if (onCommitBody == null) {
            onCommitBody = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos);
            returnStmt = ASTBuilderUtil.createReturnStmt(funcNode.pos, onCommitBody);
            returnStmt.expr = ASTBuilderUtil.createLiteral(funcNode.pos, this.symTable.nilType, Names.NIL_VALUE);
        }
        if (onAbortBody == null) {
            onAbortBody = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos);
            returnStmt = ASTBuilderUtil.createReturnStmt(funcNode.pos, onAbortBody);
            returnStmt.expr = ASTBuilderUtil.createLiteral(funcNode.pos, this.symTable.nilType, Names.NIL_VALUE);
        }
        commitFunc.function.body = onCommitBody;
        commitFunc.function.requiredParams.add(onCommitTrxVar);
        commitFunc.function.symbol.type = commitFunc.type = new BInvokableType(Lists.of(onCommitTrxVar.symbol.type), commitFunc.function.symbol.type.getReturnType(), null);
        commitFunc.function.symbol.params = Lists.of(onCommitTrxVar.symbol);
        abortFunc.function.body = onAbortBody;
        abortFunc.function.requiredParams.add(onAbortTrxVar);
        abortFunc.function.symbol.type = abortFunc.type = new BInvokableType(Lists.of(onAbortTrxVar.symbol.type), abortFunc.function.symbol.type.getReturnType(), null);
        abortFunc.function.symbol.params = Lists.of(onAbortTrxVar.symbol);
        BPackageSymbol trxModSym = this.env.enclPkg.imports.stream().filter((Predicate<BLangImportPackage>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$desugarParticipantFunction$15(org.wso2.ballerinalang.compiler.tree.BLangImportPackage ), (Lorg/wso2/ballerinalang/compiler/tree/BLangImportPackage;)Z)()).findAny().get().symbol;
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)this.symResolver.lookupSymbolInMainSpace(this.symTable.pkgEnvMap.get(trxModSym), this.getParticipantFunctionName(funcNode));
        BLangLiteral transactionBlockId = ASTBuilderUtil.createLiteral(funcNode.pos, this.symTable.stringType, this.getTransactionBlockId());
        BLangLambdaFunction trxMainWrapperFunc = this.createLambdaFunction(funcNode.pos, "$anonTrxWrapperFunc$", Collections.emptyList(), funcNode.returnTypeNode, funcNode.body);
        for (BLangSimpleVariable var : funcNode.requiredParams) {
            trxMainWrapperFunc.function.closureVarSymbols.add(new ClosureVarSymbol(var.symbol, var.pos));
        }
        BLangBlockFunctionBody trxMainBody = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos);
        BLangLambdaFunction trxMainFunc = this.createLambdaFunction(funcNode.pos, "$anonTrxParticipantFunc$", Collections.emptyList(), trxReturnNode, trxMainBody);
        trxMainWrapperFunc.capturedClosureEnv = trxMainFunc.function.clonedEnv;
        commitFunc.capturedClosureEnv = this.env.createClone();
        abortFunc.capturedClosureEnv = this.env.createClone();
        BVarSymbol wrapperSym = new BVarSymbol(0, this.names.fromString("$wrapper$1"), this.env.scope.owner.pkgID, trxMainWrapperFunc.type, trxMainFunc.function.symbol);
        BLangSimpleVariable wrapperFuncVar = ASTBuilderUtil.createVariable(funcNode.pos, "$wrapper$1", trxMainWrapperFunc.type, trxMainWrapperFunc, wrapperSym);
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(funcNode.pos, trxMainBody);
        variableDef.var = wrapperFuncVar;
        BLangSimpleVarRef wrapperVarRef = this.rewrite(ASTBuilderUtil.createVariableRef(variableDef.pos, wrapperFuncVar.symbol), this.env);
        BLangInvocation.BFunctionPointerInvocation wrapperInvocation = new BLangInvocation.BFunctionPointerInvocation(trxMainWrapperFunc.pos, wrapperVarRef, wrapperFuncVar.symbol, trxMainWrapperFunc.function.symbol.retType);
        BLangReturn wrapperReturn = ASTBuilderUtil.createReturnStmt(funcNode.pos, this.addConversionExprIfRequired(wrapperInvocation, trxReturnNode.type));
        trxMainWrapperFunc.function.receiver = funcNode.receiver;
        trxMainFunc.function.receiver = funcNode.receiver;
        trxMainBody.stmts.add(wrapperReturn);
        this.rewrite(trxMainFunc.function, this.env);
        List<BLangExpression> requiredArgs = Lists.of(transactionBlockId, trxMainFunc, commitFunc, abortFunc);
        BLangInvocation participantInvocation = ASTBuilderUtil.createInvocationExprMethod(funcNode.pos, invokableSymbol, requiredArgs, Collections.emptyList(), this.symResolver);
        participantInvocation.type = ((BInvokableType)invokableSymbol.type).retType;
        BLangReturn stmt = ASTBuilderUtil.createReturnStmt(funcNode.pos, this.addConversionExprIfRequired(participantInvocation, funcNode.symbol.retType));
        funcNode.body = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos, Lists.of(this.rewrite(stmt, this.env)));
        return funcNode;
    }

    private Name getParticipantFunctionName(BLangFunction function) {
        if (Symbols.isFlagOn(function.symbol.flags, 262144)) {
            return Names.TRX_REMOTE_PARTICIPANT_BEGIN_FUNCTION;
        }
        return Names.TRX_LOCAL_PARTICIPANT_BEGIN_FUNCTION;
    }

    @Override
    public void visit(BLangResource resourceNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        annotationNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        annAttachmentNode.expr = this.rewrite(annAttachmentNode.expr, this.env);
        this.result = annAttachmentNode;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        BLangExpression bLangExpression;
        if ((varNode.symbol.owner.tag & 0x100) != 256 && (varNode.symbol.owner.tag & 0x8000000) != 0x8000000) {
            varNode.expr = null;
            this.result = varNode;
            return;
        }
        if (varNode.typeNode != null && varNode.typeNode.getKind() != null) {
            varNode.typeNode = this.rewrite(varNode.typeNode, this.env);
        }
        if ((bLangExpression = this.rewriteExpr(varNode.expr)) != null) {
            bLangExpression = this.addConversionExprIfRequired(bLangExpression, varNode.type);
        }
        varNode.expr = bLangExpression;
        varNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = varNode;
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        SymbolEnv prevEnv = this.env;
        this.env = letExpression.env;
        BLangExpression expr = letExpression.expr;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(letExpression.pos);
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            BLangNode node = this.rewrite((BLangNode)((Object)letVariable.definitionNode), this.env);
            if (node.getKind() == NodeKind.BLOCK) {
                blockStmt.stmts.addAll(((BLangBlockStmt)node).stmts);
                continue;
            }
            blockStmt.addStatement((BLangSimpleVariableDef)node);
        }
        BLangSimpleVariableDef tempVarDef = this.createVarDef(String.format("$let_var_%d_$", this.letCount++), expr.type, expr, expr.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(expr.pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, tempVarRef);
        stmtExpr.type = expr.type;
        this.result = this.rewrite(stmtExpr, this.env);
        this.env = prevEnv;
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        this.result = varNode;
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        this.result = varNode;
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        this.result = varNode;
    }

    @Override
    public void visit(BLangBlockStmt block) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(block, this.env);
        block.stmts = this.rewriteStmt(block.stmts, blockEnv);
        this.result = block;
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangTupleVariableDef varDefNode) {
        BLangTupleVariable tupleVariable = varDefNode.var = this.rewrite(varDefNode.var, this.env);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(varDefNode.pos);
        BArrayType runTimeType = new BArrayType(this.symTable.anyType);
        String name = "tuple";
        BLangSimpleVariable tuple = ASTBuilderUtil.createVariable(varDefNode.pos, name, runTimeType, null, new BVarSymbol(0, this.names.fromString(name), this.env.scope.owner.pkgID, runTimeType, this.env.scope.owner));
        tuple.expr = tupleVariable.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(varDefNode.pos, blockStmt);
        variableDef.var = tuple;
        this.createVarDefStmts(tupleVariable, blockStmt, tuple.symbol, null);
        this.createRestFieldVarDefStmts(tupleVariable, blockStmt, tuple.symbol);
        this.result = this.rewrite(blockStmt, this.env);
    }

    private void createRestFieldVarDefStmts(BLangTupleVariable parentTupleVariable, BLangBlockStmt blockStmt, BVarSymbol tupleVarSymbol) {
        BLangSimpleVariable arrayVar = (BLangSimpleVariable)parentTupleVariable.restVariable;
        boolean isTupleType = parentTupleVariable.type.tag == 29;
        DiagnosticPos pos = blockStmt.pos;
        if (arrayVar != null) {
            BLangListConstructorExpr.BLangArrayLiteral arrayExpr = this.createArrayLiteralExprNode();
            arrayExpr.type = arrayVar.type;
            arrayVar.expr = arrayExpr;
            BLangSimpleVariableDef arrayVarDef = ASTBuilderUtil.createVariableDefStmt(arrayVar.pos, blockStmt);
            arrayVarDef.var = arrayVar;
            BLangExpression tupleExpr = parentTupleVariable.expr;
            BLangSimpleVarRef arrayVarRef = ASTBuilderUtil.createVariableRef(pos, arrayVar.symbol);
            BLangLiteral startIndexLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
            startIndexLiteral.value = (long)(isTupleType ? ((BTupleType)parentTupleVariable.type).tupleTypes.size() : parentTupleVariable.memberVariables.size());
            startIndexLiteral.type = this.symTable.intType;
            BLangInvocation lengthInvocation = this.createLengthInvocation(pos, tupleExpr);
            BLangInvocation intRangeInvocation = this.replaceWithIntRange(pos, startIndexLiteral, this.getModifiedIntRangeEndExpr(lengthInvocation));
            BLangForeach foreach = (BLangForeach)TreeBuilder.createForeachNode();
            foreach.pos = pos;
            foreach.collection = intRangeInvocation;
            this.types.setForeachTypedBindingPatternType(foreach);
            BLangSimpleVariable foreachVariable = ASTBuilderUtil.createVariable(pos, "$foreach$i", foreach.varType);
            foreachVariable.symbol = new BVarSymbol(0, this.names.fromIdNode(foreachVariable.name), this.env.scope.owner.pkgID, foreachVariable.type, this.env.scope.owner);
            BLangSimpleVarRef foreachVarRef = ASTBuilderUtil.createVariableRef(pos, foreachVariable.symbol);
            foreach.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, foreachVariable);
            foreach.isDeclaredWithVar = true;
            BLangBlockStmt foreachBody = ASTBuilderUtil.createBlockStmt(pos);
            BLangIndexBasedAccess indexAccessExpr = ASTBuilderUtil.createIndexAccessExpr(arrayVarRef, this.createLengthInvocation(pos, arrayVarRef));
            indexAccessExpr.type = isTupleType ? ((BTupleType)parentTupleVariable.type).restType : this.symTable.anyType;
            this.createSimpleVarRefAssignmentStmt(indexAccessExpr, foreachBody, foreachVarRef, tupleVarSymbol, null);
            foreach.body = foreachBody;
            blockStmt.addStatement(foreach);
        }
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode) {
        BLangRecordVariable varNode = varDefNode.var;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(varDefNode.pos);
        BMapType runTimeType = new BMapType(15, this.symTable.anyType, null);
        BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(varDefNode.pos, "$map$0", runTimeType, null, new BVarSymbol(0, this.names.fromString("$map$0"), this.env.scope.owner.pkgID, runTimeType, this.env.scope.owner));
        mapVariable.expr = varDefNode.var.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(varDefNode.pos, blockStmt);
        variableDef.var = mapVariable;
        this.createVarDefStmts(varNode, blockStmt, mapVariable.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode) {
        BLangErrorVariable errorVariable = varDefNode.errorVariable;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(varDefNode.pos);
        BVarSymbol errorVarSymbol = new BVarSymbol(0, this.names.fromString("$error$"), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner);
        BLangSimpleVariable error = ASTBuilderUtil.createVariable(varDefNode.pos, errorVarSymbol.name.value, this.symTable.errorType, null, errorVarSymbol);
        error.expr = errorVariable.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(varDefNode.pos, blockStmt);
        variableDef.var = error;
        this.createVarDefStmts(errorVariable, blockStmt, error.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    private void createVarDefStmts(BLangTupleVariable parentTupleVariable, BLangBlockStmt parentBlockStmt, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        List<BLangVariable> memberVars = parentTupleVariable.memberVariables;
        for (int index = 0; index < memberVars.size(); ++index) {
            BLangIndexBasedAccess arrayAccessExpr;
            BLangVariable variable = memberVars.get(index);
            BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(variable.pos, this.symTable.intType, index);
            if (NodeKind.VARIABLE == variable.getKind()) {
                this.createSimpleVarDefStmt((BLangSimpleVariable)variable, parentBlockStmt, indexExpr, tupleVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (variable.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVariable.pos, new BArrayType(this.symTable.anyType), tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangTupleVariable)variable, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                continue;
            }
            if (variable.getKind() == NodeKind.RECORD_VARIABLE) {
                BLangIndexBasedAccess arrayAccessExpr2 = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, this.symTable.mapType, tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr2.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangRecordVariable)variable, parentBlockStmt, tupleVarSymbol, arrayAccessExpr2);
                continue;
            }
            if (variable.getKind() != NodeKind.ERROR_VARIABLE) continue;
            BType accessedElemType = this.symTable.errorType;
            if (tupleVarSymbol.type.tag == 19) {
                BArrayType arrayType = (BArrayType)tupleVarSymbol.type;
                accessedElemType = arrayType.eType;
            }
            arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, accessedElemType, tupleVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr.expr = parentIndexAccessExpr;
            }
            this.createVarDefStmts((BLangErrorVariable)variable, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
        }
    }

    private void createVarDefStmts(BLangRecordVariable parentRecordVariable, BLangBlockStmt parentBlockStmt, BVarSymbol recordVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        List<BLangRecordVariable.BLangRecordVariableKeyValue> variableList = parentRecordVariable.variableList;
        for (BLangRecordVariable.BLangRecordVariableKeyValue recordFieldKeyValue : variableList) {
            BLangIndexBasedAccess arrayAccessExpr;
            BLangVariable variable = recordFieldKeyValue.valueBindingPattern;
            BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(variable.pos, this.symTable.stringType, recordFieldKeyValue.key.value);
            if (recordFieldKeyValue.valueBindingPattern.getKind() == NodeKind.VARIABLE) {
                this.createSimpleVarDefStmt((BLangSimpleVariable)recordFieldKeyValue.valueBindingPattern, parentBlockStmt, indexExpr, recordVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (recordFieldKeyValue.valueBindingPattern.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)recordFieldKeyValue.valueBindingPattern;
                BLangIndexBasedAccess arrayAccessExpr2 = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVariable.pos, new BArrayType(this.symTable.anyType), recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr2.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangTupleVariable)recordFieldKeyValue.valueBindingPattern, parentBlockStmt, recordVarSymbol, arrayAccessExpr2);
                continue;
            }
            if (recordFieldKeyValue.valueBindingPattern.getKind() == NodeKind.RECORD_VARIABLE) {
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentRecordVariable.pos, this.symTable.mapType, recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangRecordVariable)recordFieldKeyValue.valueBindingPattern, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
                continue;
            }
            if (variable.getKind() != NodeKind.ERROR_VARIABLE) continue;
            arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentRecordVariable.pos, variable.type, recordVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr.expr = parentIndexAccessExpr;
            }
            this.createVarDefStmts((BLangErrorVariable)variable, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
        }
        if (parentRecordVariable.restParam != null) {
            BLangSimpleVarRef variableReference;
            DiagnosticPos pos = parentBlockStmt.pos;
            BMapType restParamType = (BMapType)((BLangVariable)parentRecordVariable.restParam).type;
            if (parentIndexAccessExpr != null) {
                BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(pos, "$map$1", parentIndexAccessExpr.type, null, new BVarSymbol(0, this.names.fromString("$map$1"), this.env.scope.owner.pkgID, parentIndexAccessExpr.type, this.env.scope.owner));
                mapVariable.expr = parentIndexAccessExpr;
                BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
                variableDef.var = mapVariable;
                variableReference = ASTBuilderUtil.createVariableRef(pos, mapVariable.symbol);
            } else {
                variableReference = ASTBuilderUtil.createVariableRef(pos, ((BLangSimpleVariableDef)parentBlockStmt.stmts.get((int)0)).var.symbol);
            }
            List<String> keysToRemove = parentRecordVariable.variableList.stream().map(var -> var.getKey().getValue()).collect(Collectors.toList());
            BLangSimpleVariable filteredDetail = this.generateRestFilter(variableReference, pos, keysToRemove, restParamType, parentBlockStmt);
            BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, filteredDetail.symbol);
            BLangSimpleVariable restParam = (BLangSimpleVariable)parentRecordVariable.restParam;
            BLangSimpleVariableDef restParamVarDef = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
            restParamVarDef.var = restParam;
            restParamVarDef.var.type = restParamType;
            restParam.expr = varRef;
        }
    }

    private void createVarDefStmts(BLangErrorVariable parentErrorVariable, BLangBlockStmt parentBlockStmt, BVarSymbol errorVariableSymbol, BLangIndexBasedAccess parentIndexBasedAccess) {
        BVarSymbol convertedErrorVarSymbol;
        if (parentIndexBasedAccess != null) {
            BType prevType = parentIndexBasedAccess.type;
            parentIndexBasedAccess.type = this.symTable.anyType;
            BLangSimpleVariableDef errorVarDef = this.createVarDef("$error$" + this.errorCount++, this.symTable.errorType, this.addConversionExprIfRequired(parentIndexBasedAccess, this.symTable.errorType), parentErrorVariable.pos);
            parentIndexBasedAccess.type = prevType;
            parentBlockStmt.addStatement(errorVarDef);
            convertedErrorVarSymbol = errorVarDef.var.symbol;
        } else {
            convertedErrorVarSymbol = errorVariableSymbol;
        }
        parentErrorVariable.reason.expr = this.generateErrorReasonBuiltinFunction(parentErrorVariable.reason.pos, parentErrorVariable.reason.type, convertedErrorVarSymbol, null);
        if (this.names.fromIdNode(parentErrorVariable.reason.name) == Names.IGNORE) {
            parentErrorVariable.reason = null;
        } else {
            BLangSimpleVariableDef reasonVariableDef = ASTBuilderUtil.createVariableDefStmt(parentErrorVariable.reason.pos, parentBlockStmt);
            reasonVariableDef.var = parentErrorVariable.reason;
        }
        if ((parentErrorVariable.detail == null || parentErrorVariable.detail.isEmpty()) && parentErrorVariable.restDetail == null) {
            return;
        }
        BType detailType = ((BErrorType)parentErrorVariable.type).detailType;
        BType detailMapType = detailType.tag == 15 ? detailType : this.symTable.detailType;
        parentErrorVariable.detailExpr = this.generateErrorDetailBuiltinFunction(parentErrorVariable.pos, convertedErrorVarSymbol, null);
        BLangSimpleVariableDef detailTempVarDef = this.createVarDef("$error$detail", parentErrorVariable.detailExpr.type, parentErrorVariable.detailExpr, parentErrorVariable.pos);
        detailTempVarDef.type = parentErrorVariable.detailExpr.type;
        parentBlockStmt.addStatement(detailTempVarDef);
        this.env.scope.define(this.names.fromIdNode(detailTempVarDef.var.name), detailTempVarDef.var.symbol);
        for (BLangErrorVariable.BLangErrorDetailEntry detailEntry : parentErrorVariable.detail) {
            BLangExpression detailEntryVar = this.createErrorDetailVar(detailEntry, detailTempVarDef.var.symbol);
            this.createAndAddBoundVariableDef(parentBlockStmt, detailEntry, detailEntryVar);
        }
        if (parentErrorVariable.restDetail != null && !parentErrorVariable.restDetail.name.value.equals(Names.IGNORE.value)) {
            DiagnosticPos pos = parentErrorVariable.restDetail.pos;
            BLangSimpleVarRef detailVarRef = ASTBuilderUtil.createVariableRef(pos, detailTempVarDef.var.symbol);
            List<String> keysToRemove = parentErrorVariable.detail.stream().map(detail -> detail.key.getValue()).collect(Collectors.toList());
            BLangSimpleVariable filteredDetail = this.generateRestFilter(detailVarRef, parentErrorVariable.pos, keysToRemove, parentErrorVariable.restDetail.type, parentBlockStmt);
            BLangSimpleVariableDef variableDefStmt = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
            variableDefStmt.var = ASTBuilderUtil.createVariable(pos, parentErrorVariable.restDetail.name.value, filteredDetail.type, ASTBuilderUtil.createVariableRef(pos, filteredDetail.symbol), parentErrorVariable.restDetail.symbol);
            BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(pos, ASTBuilderUtil.createVariableRef(pos, parentErrorVariable.restDetail.symbol), ASTBuilderUtil.createVariableRef(pos, filteredDetail.symbol));
            parentBlockStmt.addStatement(assignmentStmt);
        }
        this.rewrite(parentBlockStmt, this.env);
    }

    private BLangSimpleVariableDef forceCastIfApplicable(BVarSymbol errorVarySymbol, DiagnosticPos pos, BType targetType) {
        BVarSymbol errorVarSym = new BVarSymbol(1, this.names.fromString("$cast$temp$"), this.env.enclPkg.packageID, targetType, this.env.scope.owner);
        BLangSimpleVarRef variableRef = ASTBuilderUtil.createVariableRef(pos, errorVarySymbol);
        BLangExpression expr = targetType.tag == 12 ? variableRef : this.addConversionExprIfRequired(variableRef, targetType);
        BLangSimpleVariable errorVar = ASTBuilderUtil.createVariable(pos, errorVarSym.name.value, targetType, expr, errorVarSym);
        return ASTBuilderUtil.createVariableDef(pos, errorVar);
    }

    private BLangSimpleVariable generateRestFilter(BLangSimpleVarRef mapVarRef, DiagnosticPos pos, List<String> keysToRemove, BType targetType, BLangBlockStmt parentBlockStmt) {
        BLangExpression typeCastExpr = this.addConversionExprIfRequired(mapVarRef, targetType);
        int restNum = this.annonVarCount++;
        String name = "$map$ref$" + restNum;
        BLangSimpleVariable mapVariable = this.defVariable(pos, targetType, parentBlockStmt, typeCastExpr, name);
        BLangInvocation entriesInvocation = this.generateMapEntriesInvocation(ASTBuilderUtil.createVariableRef(pos, mapVariable.symbol), typeCastExpr.type);
        String entriesVarName = "$map$ref$entries$" + restNum;
        BMapType entriesType = new BMapType(15, new BTupleType(Arrays.asList(this.symTable.stringType, ((BMapType)targetType).constraint)), null);
        BLangSimpleVariable entriesInvocationVar = this.defVariable(pos, entriesType, parentBlockStmt, this.addConversionExprIfRequired(entriesInvocation, entriesType), entriesVarName);
        BLangLambdaFunction filter = this.createFuncToFilterOutRestParam(keysToRemove, pos);
        BLangInvocation filterInvocation = this.generateMapFilterInvocation(pos, entriesInvocationVar, filter);
        String filteredEntriesName = "$filtered$detail$entries" + restNum;
        BLangSimpleVariable filteredVar = this.defVariable(pos, entriesType, parentBlockStmt, filterInvocation, filteredEntriesName);
        String filteredVarName = "$detail$filtered" + restNum;
        BLangLambdaFunction backToMapLambda = this.generateEntriesToMapLambda(pos);
        BLangInvocation mapInvocation = this.generateMapMapInvocation(pos, filteredVar, backToMapLambda);
        BLangSimpleVariable filtered = this.defVariable(pos, targetType, parentBlockStmt, mapInvocation, filteredVarName);
        String filteredRestVarName = "$restVar$" + restNum;
        BLangInvocation constructed = this.generateConstructFromInvocation(pos, targetType, filtered.symbol);
        return this.defVariable(pos, targetType, parentBlockStmt, this.addConversionExprIfRequired(constructed, targetType), filteredRestVarName);
    }

    private BLangInvocation generateMapEntriesInvocation(BLangExpression expr, BType type) {
        BLangInvocation invocationNode = this.createInvocationNode("entries", new ArrayList<BLangExpression>(), type);
        invocationNode.expr = expr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(type, this.names.fromString("entries"));
        invocationNode.requiredArgs = Lists.of(expr);
        invocationNode.type = invocationNode.symbol.type.getReturnType();
        invocationNode.langLibInvocation = true;
        return invocationNode;
    }

    private BLangInvocation generateMapMapInvocation(DiagnosticPos pos, BLangSimpleVariable filteredVar, BLangLambdaFunction backToMapLambda) {
        BLangInvocation invocationNode = this.createInvocationNode("map", new ArrayList<BLangExpression>(), filteredVar.type);
        invocationNode.expr = ASTBuilderUtil.createVariableRef(pos, filteredVar.symbol);
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(filteredVar.type, this.names.fromString("map"));
        invocationNode.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, filteredVar.symbol));
        invocationNode.type = invocationNode.symbol.type.getReturnType();
        invocationNode.requiredArgs.add(backToMapLambda);
        return invocationNode;
    }

    private BLangLambdaFunction generateEntriesToMapLambda(DiagnosticPos pos) {
        String anonfuncName = "$anonGetValFunc$" + this.lambdaFunctionCount++;
        BLangFunction function = ASTBuilderUtil.createFunction(pos, anonfuncName);
        BVarSymbol keyValSymbol = new BVarSymbol(0, this.names.fromString("$lambdaArg$0"), this.env.scope.owner.pkgID, this.getStringAnyTupleType(), this.env.scope.owner);
        BLangSimpleVariable inputParameter = ASTBuilderUtil.createVariable(pos, null, this.getStringAnyTupleType(), null, keyValSymbol);
        function.requiredParams.add(inputParameter);
        BLangValueType anyType = new BLangValueType();
        anyType.typeKind = TypeKind.ANY;
        anyType.type = this.symTable.anyType;
        function.returnTypeNode = anyType;
        BLangBlockFunctionBody functionBlock = ASTBuilderUtil.createBlockFunctionBody(pos, new ArrayList<BLangStatement>());
        function.body = functionBlock;
        BLangIndexBasedAccess indexBasesAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(pos, this.symTable.anyType, keyValSymbol, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 1L));
        BLangSimpleVariableDef tupSecondElem = this.createVarDef("val", indexBasesAccessExpr.type, indexBasesAccessExpr, pos);
        functionBlock.addStatement(tupSecondElem);
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(pos, functionBlock);
        returnStmt.expr = ASTBuilderUtil.createVariableRef(pos, tupSecondElem.var.symbol);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(function.flagSet), new Name(function.name.value), this.env.enclPkg.packageID, function.type, this.env.enclEnv.enclVarSym, true);
        functionSymbol.retType = function.returnTypeNode.type;
        functionSymbol.params = function.requiredParams.stream().map(param -> param.symbol).collect(Collectors.toList());
        functionSymbol.scope = this.env.scope;
        functionSymbol.type = new BInvokableType(Collections.singletonList(this.getStringAnyTupleType()), this.symTable.anyType, null);
        function.symbol = functionSymbol;
        this.rewrite(function, this.env);
        this.env.enclPkg.addFunction(function);
        return this.createLambdaFunction(function, functionSymbol);
    }

    private BLangInvocation generateMapFilterInvocation(DiagnosticPos pos, BLangSimpleVariable entriesInvocationVar, BLangLambdaFunction filter) {
        BLangInvocation invocationNode = this.createInvocationNode("filter", new ArrayList<BLangExpression>(), entriesInvocationVar.type);
        invocationNode.expr = ASTBuilderUtil.createVariableRef(pos, entriesInvocationVar.symbol);
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(entriesInvocationVar.type, this.names.fromString("filter"));
        invocationNode.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, entriesInvocationVar.symbol));
        invocationNode.type = invocationNode.symbol.type.getReturnType();
        invocationNode.requiredArgs.add(filter);
        return invocationNode;
    }

    private BLangSimpleVariable defVariable(DiagnosticPos pos, BType varType, BLangBlockStmt parentBlockStmt, BLangExpression expression, String name) {
        Name varName = this.names.fromString(name);
        BLangSimpleVariable detailMap = ASTBuilderUtil.createVariable(pos, name, varType, expression, new BVarSymbol(1, varName, this.env.enclPkg.packageID, varType, this.env.scope.owner));
        BLangSimpleVariableDef constructedMap = ASTBuilderUtil.createVariableDef(pos, detailMap);
        constructedMap.type = varType;
        parentBlockStmt.addStatement(constructedMap);
        this.env.scope.define(varName, detailMap.symbol);
        return detailMap;
    }

    private void createAndAddBoundVariableDef(BLangBlockStmt parentBlockStmt, BLangErrorVariable.BLangErrorDetailEntry detailEntry, BLangExpression detailEntryVar) {
        if (detailEntry.valueBindingPattern.getKind() == NodeKind.VARIABLE) {
            BLangSimpleVariableDef errorDetailVar = this.createVarDef(((BLangSimpleVariable)detailEntry.valueBindingPattern).name.value, detailEntry.valueBindingPattern.type, detailEntryVar, detailEntry.valueBindingPattern.pos);
            parentBlockStmt.addStatement(errorDetailVar);
        } else if (detailEntry.valueBindingPattern.getKind() == NodeKind.RECORD_VARIABLE) {
            BLangRecordVariableDef recordVariableDef = ASTBuilderUtil.createRecordVariableDef(detailEntry.valueBindingPattern.pos, (BLangRecordVariable)detailEntry.valueBindingPattern);
            recordVariableDef.var.expr = detailEntryVar;
            recordVariableDef.type = this.symTable.recordType;
            parentBlockStmt.addStatement(recordVariableDef);
        } else if (detailEntry.valueBindingPattern.getKind() == NodeKind.TUPLE_VARIABLE) {
            BLangTupleVariableDef tupleVariableDef = ASTBuilderUtil.createTupleVariableDef(detailEntry.valueBindingPattern.pos, (BLangTupleVariable)detailEntry.valueBindingPattern);
            parentBlockStmt.addStatement(tupleVariableDef);
        }
    }

    private BLangExpression createErrorDetailVar(BLangErrorVariable.BLangErrorDetailEntry detailEntry, BVarSymbol tempDetailVarSymbol) {
        BLangExpression detailEntryVar = this.createIndexBasedAccessExpr(detailEntry.valueBindingPattern.type, detailEntry.valueBindingPattern.pos, this.createStringLiteral(detailEntry.key.pos, detailEntry.key.value), tempDetailVarSymbol, null);
        if (detailEntryVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            BLangIndexBasedAccess bLangIndexBasedAccess = (BLangIndexBasedAccess)detailEntryVar;
            bLangIndexBasedAccess.originalType = this.symTable.pureType;
        }
        return detailEntryVar;
    }

    private BLangExpression constructStringTemplateConcatExpression(List<BLangExpression> exprs) {
        BLangExpression concatExpr = null;
        Iterator<BLangExpression> iterator = exprs.iterator();
        while (iterator.hasNext()) {
            BLangExpression expr;
            BLangExpression currentExpr = expr = iterator.next();
            if (expr.type.tag != 5 && expr.type.tag != 8) {
                currentExpr = this.getToStringInvocationOnExpr(expr);
            }
            if (concatExpr == null) {
                concatExpr = currentExpr;
                continue;
            }
            BType binaryExprType = TypeTags.isXMLTypeTag(concatExpr.type.tag) || TypeTags.isXMLTypeTag(currentExpr.type.tag) ? this.symTable.xmlType : this.symTable.stringType;
            concatExpr = ASTBuilderUtil.createBinaryExpr(concatExpr.pos, concatExpr, currentExpr, binaryExprType, OperatorKind.ADD, null);
        }
        return concatExpr;
    }

    private BLangInvocation getToStringInvocationOnExpr(final BLangExpression expression) {
        final BInvokableSymbol symbol = (BInvokableSymbol)this.symTable.langValueModuleSymbol.scope.lookup((Name)this.names.fromString((String)TO_STRING_FUNCTION_NAME)).symbol;
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>(){
            {
                this.add(Desugar.this.addConversionExprIfRequired(expression, symbol.params.get((int)0).type));
            }
        };
        return ASTBuilderUtil.createInvocationExprMethod(expression.pos, symbol, (List<BLangExpression>)requiredArgs, new ArrayList<BLangSimpleVariable>(), this.symResolver);
    }

    private BLangInvocation generateErrorDetailBuiltinFunction(DiagnosticPos pos, BVarSymbol errorVarySymbol, BLangIndexBasedAccess parentIndexBasedAccess) {
        BLangIndexBasedAccess onExpr = parentIndexBasedAccess != null ? parentIndexBasedAccess : ASTBuilderUtil.createVariableRef(pos, errorVarySymbol);
        return this.createLangLibInvocationNode(ERROR_DETAIL_FUNCTION_NAME, onExpr, new ArrayList<BLangExpression>(), null, pos);
    }

    private BLangInvocation generateErrorReasonBuiltinFunction(DiagnosticPos pos, BType reasonType, BVarSymbol errorVarSymbol, BLangIndexBasedAccess parentIndexBasedAccess) {
        BLangIndexBasedAccess onExpr = parentIndexBasedAccess != null ? parentIndexBasedAccess : ASTBuilderUtil.createVariableRef(pos, errorVarSymbol);
        return this.createLangLibInvocationNode(ERROR_REASON_FUNCTION_NAME, onExpr, new ArrayList<BLangExpression>(), reasonType, pos);
    }

    private BLangInvocation generateConstructFromInvocation(DiagnosticPos pos, BType targetType, BVarSymbol source) {
        BTypedescType typedescType = new BTypedescType(targetType, this.symTable.typeDesc.tsymbol);
        BLangInvocation invocationNode = this.createInvocationNode(CONSTRUCT_FROM, new ArrayList<BLangExpression>(), typedescType);
        BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
        typedescExpr.resolvedType = targetType;
        typedescExpr.type = typedescType;
        invocationNode.expr = typedescExpr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(typedescType, this.names.fromString(CONSTRUCT_FROM));
        invocationNode.requiredArgs = Lists.of(typedescExpr, ASTBuilderUtil.createVariableRef(pos, source));
        invocationNode.type = BUnionType.create(null, targetType, this.symTable.errorType);
        return invocationNode;
    }

    private BLangLambdaFunction createFuncToFilterOutRestParam(List<String> toRemoveList, DiagnosticPos pos) {
        String anonfuncName = "$anonRestParamFilterFunc$" + this.lambdaFunctionCount++;
        BLangFunction function = ASTBuilderUtil.createFunction(pos, anonfuncName);
        BVarSymbol keyValSymbol = new BVarSymbol(0, this.names.fromString("$lambdaArg$0"), this.env.scope.owner.pkgID, this.getStringAnyTupleType(), this.env.scope.owner);
        BLangBlockFunctionBody functionBlock = this.createAnonymousFunctionBlock(pos, function, keyValSymbol);
        BLangIndexBasedAccess indexBasesAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(pos, this.symTable.anyType, keyValSymbol, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 0L));
        BLangSimpleVariableDef tupFirstElem = this.createVarDef("key", indexBasesAccessExpr.type, indexBasesAccessExpr, pos);
        functionBlock.addStatement(tupFirstElem);
        for (String toRemoveItem : toRemoveList) {
            this.createIfStmt(pos, tupFirstElem.var.symbol, functionBlock, toRemoveItem);
        }
        BInvokableSymbol functionSymbol = this.createReturnTrueStatement(pos, function, functionBlock);
        return this.createLambdaFunction(function, functionSymbol);
    }

    private BLangLambdaFunction createFuncToFilterOutRestParam(BLangRecordVariable recordVariable, DiagnosticPos pos) {
        List<String> fieldNamesToRemove = recordVariable.variableList.stream().map(var -> var.getKey().getValue()).collect(Collectors.toList());
        return this.createFuncToFilterOutRestParam(fieldNamesToRemove, pos);
    }

    private void createIfStmt(DiagnosticPos pos, BVarSymbol inputParamSymbol, BLangBlockFunctionBody blockStmt, String key) {
        BLangSimpleVarRef firstElemRef = ASTBuilderUtil.createVariableRef(pos, inputParamSymbol);
        BLangExpression converted = this.addConversionExprIfRequired(firstElemRef, this.symTable.stringType);
        BLangIf ifStmt = ASTBuilderUtil.createIfStmt(pos, blockStmt);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(pos, new ArrayList<BLangStatement>());
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(pos, ifBlock);
        returnStmt.expr = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, false);
        ifStmt.body = ifBlock;
        BLangGroupExpr groupExpr = new BLangGroupExpr();
        groupExpr.type = this.symTable.booleanType;
        BLangBinaryExpr binaryExpr = ASTBuilderUtil.createBinaryExpr(pos, converted, ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, key), this.symTable.booleanType, OperatorKind.EQUAL, null);
        binaryExpr.opSymbol = (BOperatorSymbol)this.symResolver.resolveBinaryOperator(binaryExpr.opKind, binaryExpr.lhsExpr.type, binaryExpr.rhsExpr.type);
        groupExpr.expression = binaryExpr;
        ifStmt.expr = groupExpr;
    }

    BLangLambdaFunction createLambdaFunction(BLangFunction function, BInvokableSymbol functionSymbol) {
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.function = function;
        lambdaFunction.type = functionSymbol.type;
        return lambdaFunction;
    }

    private BInvokableSymbol createReturnTrueStatement(DiagnosticPos pos, BLangFunction function, BLangBlockFunctionBody functionBlock) {
        BLangReturn trueReturnStmt = ASTBuilderUtil.createReturnStmt(pos, functionBlock);
        trueReturnStmt.expr = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(function.flagSet), new Name(function.name.value), this.env.enclPkg.packageID, function.type, this.env.enclEnv.enclVarSym, true);
        functionSymbol.retType = function.returnTypeNode.type;
        functionSymbol.params = function.requiredParams.stream().map(param -> param.symbol).collect(Collectors.toList());
        functionSymbol.scope = this.env.scope;
        functionSymbol.type = new BInvokableType(Collections.singletonList(this.getStringAnyTupleType()), this.getRestType(functionSymbol), this.symTable.booleanType, null);
        function.symbol = functionSymbol;
        this.rewrite(function, this.env);
        this.env.enclPkg.addFunction(function);
        return functionSymbol;
    }

    private BLangBlockFunctionBody createAnonymousFunctionBlock(DiagnosticPos pos, BLangFunction function, BVarSymbol keyValSymbol) {
        BLangSimpleVariable inputParameter = ASTBuilderUtil.createVariable(pos, null, this.getStringAnyTupleType(), null, keyValSymbol);
        function.requiredParams.add(inputParameter);
        BLangValueType booleanTypeKind = new BLangValueType();
        booleanTypeKind.typeKind = TypeKind.BOOLEAN;
        booleanTypeKind.type = this.symTable.booleanType;
        function.returnTypeNode = booleanTypeKind;
        BLangBlockFunctionBody functionBlock = ASTBuilderUtil.createBlockFunctionBody(pos, new ArrayList<BLangStatement>());
        function.body = functionBlock;
        return functionBlock;
    }

    private BTupleType getStringAnyTupleType() {
        ArrayList<BType> typeList = new ArrayList<BType>(){
            {
                this.add(((Desugar)Desugar.this).symTable.stringType);
                this.add(((Desugar)Desugar.this).symTable.anyType);
            }
        };
        return new BTupleType((List<BType>)typeList);
    }

    private void createSimpleVarDefStmt(BLangSimpleVariable simpleVariable, BLangBlockStmt parentBlockStmt, BLangLiteral indexExpr, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentArrayAccessExpr) {
        Name varName = this.names.fromIdNode(simpleVariable.name);
        if (varName == Names.IGNORE) {
            return;
        }
        BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDefStmt(simpleVariable.pos, parentBlockStmt);
        simpleVariableDef.var = simpleVariable;
        simpleVariable.expr = this.createIndexBasedAccessExpr(simpleVariable.type, simpleVariable.pos, indexExpr, tupleVarSymbol, parentArrayAccessExpr);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        if (this.safeNavigateLHS(assignNode.varRef)) {
            BLangAccessExpression accessExpr = (BLangAccessExpression)assignNode.varRef;
            accessExpr.leafNode = true;
            this.result = this.rewriteSafeNavigationAssignment(accessExpr, assignNode.expr, assignNode.safeAssignment);
            this.result = this.rewrite(this.result, this.env);
            return;
        }
        assignNode.varRef = this.rewriteExpr(assignNode.varRef);
        assignNode.expr = this.rewriteExpr(assignNode.expr);
        assignNode.expr = this.addConversionExprIfRequired(this.rewriteExpr(assignNode.expr), assignNode.varRef.type);
        this.result = assignNode;
    }

    @Override
    public void visit(BLangTupleDestructure tupleDestructure) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(tupleDestructure.pos);
        BArrayType runTimeType = new BArrayType(this.symTable.anyType);
        String name = "tuple";
        BLangSimpleVariable tuple = ASTBuilderUtil.createVariable(tupleDestructure.pos, name, runTimeType, null, new BVarSymbol(0, this.names.fromString(name), this.env.scope.owner.pkgID, runTimeType, this.env.scope.owner));
        tuple.expr = tupleDestructure.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(tupleDestructure.pos, blockStmt);
        variableDef.var = tuple;
        this.createVarRefAssignmentStmts(tupleDestructure.varRef, blockStmt, tuple.symbol, null);
        this.createRestFieldAssignmentStmt(tupleDestructure, blockStmt, tuple.symbol);
        this.result = this.rewrite(blockStmt, this.env);
    }

    private void createRestFieldAssignmentStmt(BLangTupleDestructure tupleDestructure, BLangBlockStmt blockStmt, BVarSymbol tupleVarSymbol) {
        BLangTupleVarRef tupleVarRef = tupleDestructure.varRef;
        DiagnosticPos pos = blockStmt.pos;
        if (tupleVarRef.restParam != null) {
            BLangExpression tupleExpr = tupleDestructure.expr;
            BLangSimpleVarRef restParam = (BLangSimpleVarRef)tupleVarRef.restParam;
            BArrayType restParamType = (BArrayType)restParam.type;
            BLangListConstructorExpr.BLangArrayLiteral arrayExpr = this.createArrayLiteralExprNode();
            arrayExpr.type = restParamType;
            BLangAssignment restParamAssignment = ASTBuilderUtil.createAssignmentStmt(pos, blockStmt);
            restParamAssignment.varRef = restParam;
            restParamAssignment.varRef.type = restParamType;
            restParamAssignment.expr = arrayExpr;
            BLangLiteral startIndexLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
            startIndexLiteral.value = (long)tupleVarRef.expressions.size();
            startIndexLiteral.type = this.symTable.intType;
            BLangInvocation lengthInvocation = this.createLengthInvocation(pos, tupleExpr);
            BLangInvocation intRangeInvocation = this.replaceWithIntRange(pos, startIndexLiteral, this.getModifiedIntRangeEndExpr(lengthInvocation));
            BLangForeach foreach = (BLangForeach)TreeBuilder.createForeachNode();
            foreach.pos = pos;
            foreach.collection = intRangeInvocation;
            this.types.setForeachTypedBindingPatternType(foreach);
            BLangSimpleVariable foreachVariable = ASTBuilderUtil.createVariable(pos, "$foreach$i", foreach.varType);
            foreachVariable.symbol = new BVarSymbol(0, this.names.fromIdNode(foreachVariable.name), this.env.scope.owner.pkgID, foreachVariable.type, this.env.scope.owner);
            BLangSimpleVarRef foreachVarRef = ASTBuilderUtil.createVariableRef(pos, foreachVariable.symbol);
            foreach.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, foreachVariable);
            foreach.isDeclaredWithVar = true;
            BLangBlockStmt foreachBody = ASTBuilderUtil.createBlockStmt(pos);
            BLangIndexBasedAccess indexAccessExpr = ASTBuilderUtil.createIndexAccessExpr(restParam, this.createLengthInvocation(pos, restParam));
            indexAccessExpr.type = restParamType.eType;
            this.createSimpleVarRefAssignmentStmt(indexAccessExpr, foreachBody, foreachVarRef, tupleVarSymbol, null);
            foreach.body = foreachBody;
            blockStmt.addStatement(foreach);
        }
    }

    private BLangInvocation createLengthInvocation(DiagnosticPos pos, BLangExpression collection) {
        BInvokableSymbol lengthInvokableSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collection.type, this.names.fromString(LENGTH_FUNCTION_NAME));
        BLangInvocation lengthInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, lengthInvokableSymbol, Lists.of(collection), this.symResolver);
        lengthInvocation.argExprs = lengthInvocation.requiredArgs;
        lengthInvocation.type = lengthInvokableSymbol.type.getReturnType();
        return lengthInvocation;
    }

    private void createVarRefAssignmentStmts(BLangTupleVarRef parentTupleVariable, BLangBlockStmt parentBlockStmt, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        List<BLangExpression> expressions = parentTupleVariable.expressions;
        for (int index = 0; index < expressions.size(); ++index) {
            BLangIndexBasedAccess arrayAccessExpr;
            BLangLiteral indexExpr;
            BLangExpression expression = expressions.get(index);
            if (NodeKind.SIMPLE_VARIABLE_REF == expression.getKind() || NodeKind.FIELD_BASED_ACCESS_EXPR == expression.getKind() || NodeKind.INDEX_BASED_ACCESS_EXPR == expression.getKind() || NodeKind.XML_ATTRIBUTE_ACCESS_EXPR == expression.getKind()) {
                BLangLiteral indexExpr2 = ASTBuilderUtil.createLiteral(expression.pos, this.symTable.intType, index);
                this.createSimpleVarRefAssignmentStmt((BLangVariableReference)expression, parentBlockStmt, indexExpr2, tupleVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (expression.getKind() == NodeKind.TUPLE_VARIABLE_REF) {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)expression;
                indexExpr = ASTBuilderUtil.createLiteral(tupleVarRef.pos, this.symTable.intType, index);
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVarRef.pos, new BArrayType(this.symTable.anyType), tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts((BLangTupleVarRef)expression, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                continue;
            }
            if (expression.getKind() == NodeKind.RECORD_VARIABLE_REF) {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)expression;
                indexExpr = ASTBuilderUtil.createLiteral(recordVarRef.pos, this.symTable.intType, index);
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, this.symTable.mapType, tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts((BLangRecordVarRef)expression, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                TypeDefBuilderHelper.addTypeDefinition(recordVarRef.type, recordVarRef.type.tsymbol, TypeDefBuilderHelper.createRecordTypeNode((BRecordType)recordVarRef.type, this.env.enclPkg.packageID, this.symTable, recordVarRef.pos), this.env);
                continue;
            }
            if (expression.getKind() != NodeKind.ERROR_VARIABLE_REF) continue;
            BLangErrorVarRef errorVarRef = (BLangErrorVarRef)expression;
            indexExpr = ASTBuilderUtil.createLiteral(errorVarRef.pos, this.symTable.intType, index);
            arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, expression.type, tupleVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr.expr = parentIndexAccessExpr;
            }
            this.createVarRefAssignmentStmts((BLangErrorVarRef)expression, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
        }
    }

    private void createSimpleVarRefAssignmentStmt(BLangVariableReference simpleVarRef, BLangBlockStmt parentBlockStmt, BLangExpression indexExpr, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentArrayAccessExpr) {
        Name varName;
        if (simpleVarRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF && (varName = this.names.fromIdNode(((BLangSimpleVarRef)simpleVarRef).variableName)) == Names.IGNORE) {
            return;
        }
        BLangExpression assignmentExpr = this.createIndexBasedAccessExpr(simpleVarRef.type, simpleVarRef.pos, indexExpr, tupleVarSymbol, parentArrayAccessExpr);
        assignmentExpr = this.addConversionExprIfRequired(assignmentExpr, simpleVarRef.type);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(parentBlockStmt.pos, parentBlockStmt);
        assignmentStmt.varRef = simpleVarRef;
        assignmentStmt.expr = assignmentExpr;
    }

    private BLangExpression createIndexBasedAccessExpr(BType varType, DiagnosticPos varPos, BLangExpression indexExpr, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentExpr) {
        BLangExpression assignmentExpr;
        BLangIndexBasedAccess arrayAccess = ASTBuilderUtil.createIndexBasesAccessExpr(varPos, this.symTable.anyType, tupleVarSymbol, indexExpr);
        arrayAccess.originalType = varType;
        if (parentExpr != null) {
            arrayAccess.expr = parentExpr;
        }
        if (this.types.isValueType(varType)) {
            BLangTypeConversionExpr castExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
            castExpr.expr = arrayAccess;
            castExpr.type = varType;
            assignmentExpr = castExpr;
        } else {
            assignmentExpr = arrayAccess;
        }
        return assignmentExpr;
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(recordDestructure.pos);
        BMapType runTimeType = new BMapType(15, this.symTable.anyType, null);
        String name = "$map$0";
        BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(recordDestructure.pos, name, runTimeType, null, new BVarSymbol(0, this.names.fromString(name), this.env.scope.owner.pkgID, runTimeType, this.env.scope.owner));
        mapVariable.expr = recordDestructure.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(recordDestructure.pos, blockStmt);
        variableDef.var = mapVariable;
        this.createVarRefAssignmentStmts(recordDestructure.varRef, blockStmt, mapVariable.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(errorDestructure.pos);
        String name = "$error$";
        BLangSimpleVariable errorVar = ASTBuilderUtil.createVariable(errorDestructure.pos, name, this.symTable.errorType, null, new BVarSymbol(0, this.names.fromString(name), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner));
        errorVar.expr = errorDestructure.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(errorDestructure.pos, blockStmt);
        variableDef.var = errorVar;
        this.createVarRefAssignmentStmts(errorDestructure.varRef, blockStmt, errorVar.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    private void createVarRefAssignmentStmts(BLangRecordVarRef parentRecordVarRef, BLangBlockStmt parentBlockStmt, BVarSymbol recordVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        BLangExpression variableReference;
        List<BLangRecordVarRef.BLangRecordVarRefKeyValue> variableRefList = parentRecordVarRef.recordRefFields;
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue varRefKeyValue : variableRefList) {
            BLangIndexBasedAccess arrayAccessExpr;
            variableReference = varRefKeyValue.variableReference;
            BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(variableReference.pos, this.symTable.stringType, varRefKeyValue.variableName.getValue());
            if (NodeKind.SIMPLE_VARIABLE_REF == variableReference.getKind() || NodeKind.FIELD_BASED_ACCESS_EXPR == variableReference.getKind() || NodeKind.INDEX_BASED_ACCESS_EXPR == variableReference.getKind() || NodeKind.XML_ATTRIBUTE_ACCESS_EXPR == variableReference.getKind()) {
                this.createSimpleVarRefAssignmentStmt((BLangVariableReference)variableReference, parentBlockStmt, indexExpr, recordVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (NodeKind.RECORD_VARIABLE_REF == variableReference.getKind()) {
                BLangRecordVarRef recordVariable = (BLangRecordVarRef)variableReference;
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentRecordVarRef.pos, this.symTable.mapType, recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts(recordVariable, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
                continue;
            }
            if (NodeKind.TUPLE_VARIABLE_REF == variableReference.getKind()) {
                BLangTupleVarRef tupleVariable = (BLangTupleVarRef)variableReference;
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVariable.pos, this.symTable.tupleType, recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts(tupleVariable, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
                continue;
            }
            if (NodeKind.ERROR_VARIABLE_REF != variableReference.getKind()) continue;
            BLangIndexBasedAccess arrayAccessExpr2 = ASTBuilderUtil.createIndexBasesAccessExpr(variableReference.pos, this.symTable.errorType, recordVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr2.expr = parentIndexAccessExpr;
            }
            this.createVarRefAssignmentStmts((BLangErrorVarRef)variableReference, parentBlockStmt, recordVarSymbol, arrayAccessExpr2);
        }
        if (parentRecordVarRef.restParam != null) {
            DiagnosticPos pos = parentBlockStmt.pos;
            BMapType restParamType = (BMapType)((BLangSimpleVarRef)parentRecordVarRef.restParam).type;
            if (parentIndexAccessExpr != null) {
                BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(pos, "$map$1", restParamType, null, new BVarSymbol(0, this.names.fromString("$map$1"), this.env.scope.owner.pkgID, restParamType, this.env.scope.owner));
                mapVariable.expr = parentIndexAccessExpr;
                BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
                variableDef.var = mapVariable;
                variableReference = ASTBuilderUtil.createVariableRef(pos, mapVariable.symbol);
            } else {
                variableReference = ASTBuilderUtil.createVariableRef(pos, ((BLangSimpleVariableDef)parentBlockStmt.stmts.get((int)0)).var.symbol);
            }
            BLangSimpleVarRef restParam = (BLangSimpleVarRef)parentRecordVarRef.restParam;
            List<String> keysToRemove = parentRecordVarRef.recordRefFields.stream().map(field -> field.variableName.value).collect(Collectors.toList());
            BLangSimpleVariable filteredDetail = this.generateRestFilter((BLangSimpleVarRef)variableReference, pos, keysToRemove, restParamType, parentBlockStmt);
            BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, filteredDetail.symbol);
            BLangAssignment restParamAssignment = ASTBuilderUtil.createAssignmentStmt(pos, parentBlockStmt);
            restParamAssignment.varRef = restParam;
            restParamAssignment.varRef.type = restParamType;
            restParamAssignment.expr = varRef;
        }
    }

    private void createVarRefAssignmentStmts(BLangErrorVarRef parentErrorVarRef, BLangBlockStmt parentBlockStmt, BVarSymbol errorVarySymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        if (parentErrorVarRef.reason.getKind() != NodeKind.SIMPLE_VARIABLE_REF || this.names.fromIdNode(((BLangSimpleVarRef)parentErrorVarRef.reason).variableName) != Names.IGNORE) {
            BLangAssignment reasonAssignment = ASTBuilderUtil.createAssignmentStmt(parentBlockStmt.pos, parentBlockStmt);
            reasonAssignment.expr = this.generateErrorReasonBuiltinFunction(parentErrorVarRef.reason.pos, this.symTable.stringType, errorVarySymbol, parentIndexAccessExpr);
            reasonAssignment.expr = this.addConversionExprIfRequired(reasonAssignment.expr, parentErrorVarRef.reason.type);
            reasonAssignment.varRef = parentErrorVarRef.reason;
        }
        if (parentErrorVarRef.detail.isEmpty() && this.isIgnoredErrorRefRestVar(parentErrorVarRef)) {
            return;
        }
        BLangInvocation errorDetailBuiltinFunction = this.generateErrorDetailBuiltinFunction(parentErrorVarRef.pos, errorVarySymbol, parentIndexAccessExpr);
        BLangSimpleVariableDef detailTempVarDef = this.createVarDef("$error$detail$" + this.errorCount++, this.symTable.detailType, errorDetailBuiltinFunction, parentErrorVarRef.pos);
        detailTempVarDef.type = this.symTable.detailType;
        parentBlockStmt.addStatement(detailTempVarDef);
        this.env.scope.define(this.names.fromIdNode(detailTempVarDef.var.name), detailTempVarDef.var.symbol);
        ArrayList<String> extractedKeys = new ArrayList<String>();
        for (BLangNamedArgsExpression detail : parentErrorVarRef.detail) {
            extractedKeys.add(detail.name.value);
            BLangVariableReference ref = (BLangVariableReference)detail.expr;
            BLangExpression detailEntryVar = this.createIndexBasedAccessExpr(ref.type, ref.pos, this.createStringLiteral(detail.name.pos, detail.name.value), detailTempVarDef.var.symbol, null);
            if (detailEntryVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                BLangIndexBasedAccess bLangIndexBasedAccess = (BLangIndexBasedAccess)detailEntryVar;
                bLangIndexBasedAccess.originalType = this.symTable.pureType;
            }
            BLangAssignment detailAssignment = ASTBuilderUtil.createAssignmentStmt(ref.pos, parentBlockStmt);
            detailAssignment.varRef = ref;
            detailAssignment.expr = detailEntryVar;
        }
        if (!this.isIgnoredErrorRefRestVar(parentErrorVarRef)) {
            BLangSimpleVarRef detailVarRef = ASTBuilderUtil.createVariableRef(parentErrorVarRef.restVar.pos, detailTempVarDef.var.symbol);
            BLangSimpleVariable filteredDetail = this.generateRestFilter(detailVarRef, parentErrorVarRef.restVar.pos, extractedKeys, parentErrorVarRef.restVar.type, parentBlockStmt);
            BLangAssignment restAssignment = ASTBuilderUtil.createAssignmentStmt(parentErrorVarRef.restVar.pos, parentBlockStmt);
            restAssignment.varRef = parentErrorVarRef.restVar;
            restAssignment.expr = ASTBuilderUtil.createVariableRef(parentErrorVarRef.restVar.pos, filteredDetail.symbol);
        }
        BErrorType errorType = (BErrorType)parentErrorVarRef.type;
        if (errorType.detailType.getKind() == TypeKind.RECORD) {
            BRecordTypeSymbol tsymbol = (BRecordTypeSymbol)errorType.detailType.tsymbol;
            tsymbol.initializerFunc = this.createRecordInitFunc();
            tsymbol.scope.define(tsymbol.initializerFunc.funcName, tsymbol.initializerFunc.symbol);
        }
    }

    private boolean isIgnoredErrorRefRestVar(BLangErrorVarRef parentErrorVarRef) {
        if (parentErrorVarRef.restVar == null) {
            return true;
        }
        if (parentErrorVarRef.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)parentErrorVarRef.restVar).variableName.value.equals(Names.IGNORE.value);
        }
        return false;
    }

    @Override
    public void visit(BLangAbort abortNode) {
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(abortNode.pos, this.symTable.intType, -1L);
        this.result = this.rewrite(returnStmt, this.env);
    }

    @Override
    public void visit(BLangRetry retryNode) {
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(retryNode.pos, this.symTable.intType, 1L);
        this.result = this.rewrite(returnStmt, this.env);
    }

    @Override
    public void visit(BLangContinue nextNode) {
        this.result = nextNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangReturn returnNode) {
        if (returnNode.expr != null) {
            returnNode.expr = this.rewriteExpr(returnNode.expr);
        }
        this.result = returnNode;
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr = this.rewriteExpr(panicNode.expr);
        this.result = panicNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl = this.rewrite(xmlnsStmtNode.xmlnsDecl, this.env);
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        BSymbol ownerSymbol = xmlnsNode.symbol.owner;
        BLangXMLNS generatedXMLNSNode = (ownerSymbol.tag & 0x100) == 256 || (ownerSymbol.tag & 0x84) == 132 ? new BLangXMLNS.BLangLocalXMLNS() : new BLangXMLNS.BLangPackageXMLNS();
        generatedXMLNSNode.namespaceURI = xmlnsNode.namespaceURI;
        generatedXMLNSNode.prefix = xmlnsNode.prefix;
        generatedXMLNSNode.symbol = xmlnsNode.symbol;
        this.result = generatedXMLNSNode;
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment) {
        BLangVariableReference varRef = compoundAssignment.varRef;
        if (compoundAssignment.varRef.getKind() != NodeKind.INDEX_BASED_ACCESS_EXPR) {
            if (varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                varRef = ASTBuilderUtil.createVariableRef(compoundAssignment.varRef.pos, varRef.symbol);
                varRef.lhsVar = true;
            }
            this.result = ASTBuilderUtil.createAssignmentStmt(compoundAssignment.pos, this.rewriteExpr(varRef), this.rewriteExpr(compoundAssignment.modifiedExpr));
            return;
        }
        ArrayList<BLangStatement> statements = new ArrayList<BLangStatement>();
        ArrayList<BLangSimpleVarRef> varRefs = new ArrayList<BLangSimpleVarRef>();
        ArrayList<BType> types = new ArrayList<BType>();
        do {
            BLangSimpleVariableDef tempIndexVarDef = this.createVarDef("$temp" + ++this.indexExprCount + "$", ((BLangIndexBasedAccess)varRef).indexExpr.type, ((BLangIndexBasedAccess)varRef).indexExpr, compoundAssignment.pos);
            BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(tempIndexVarDef.pos, tempIndexVarDef.var.symbol);
            statements.add(0, tempIndexVarDef);
            varRefs.add(0, tempVarRef);
            types.add(0, varRef.type);
        } while ((varRef = (BLangVariableReference)((BLangIndexBasedAccess)varRef).expr).getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR);
        BLangVariableReference var = varRef;
        for (int ref = 0; ref < varRefs.size(); ++ref) {
            var = ASTBuilderUtil.createIndexAccessExpr(var, (BLangExpression)varRefs.get(ref));
            var.type = (BType)types.get(ref);
        }
        var.type = compoundAssignment.varRef.type;
        BLangBinaryExpr rhsExpression = ASTBuilderUtil.createBinaryExpr(compoundAssignment.pos, var, compoundAssignment.expr, compoundAssignment.type, compoundAssignment.opKind, null);
        rhsExpression.type = compoundAssignment.modifiedExpr.type;
        BLangAssignment assignStmt = ASTBuilderUtil.createAssignmentStmt(compoundAssignment.pos, var, rhsExpression);
        statements.add(assignStmt);
        BLangBlockStmt bLangBlockStmt = ASTBuilderUtil.createBlockStmt(compoundAssignment.pos, statements);
        this.result = this.rewrite(bLangBlockStmt, this.env);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr = this.rewriteExpr(exprStmtNode.expr);
        this.result = exprStmtNode;
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr = this.rewriteExpr(ifNode.expr);
        ifNode.body = this.rewrite(ifNode.body, this.env);
        ifNode.elseStmt = this.rewrite(ifNode.elseStmt, this.env);
        this.result = ifNode;
    }

    @Override
    public void visit(BLangMatch matchStmt) {
        BLangBlockStmt matchBlockStmt = (BLangBlockStmt)TreeBuilder.createBlockNode();
        matchBlockStmt.pos = matchStmt.pos;
        String matchExprVarName = Names.GEN_VAR_PREFIX.value;
        BLangSimpleVariable matchExprVar = ASTBuilderUtil.createVariable(matchStmt.expr.pos, matchExprVarName, matchStmt.expr.type, matchStmt.expr, new BVarSymbol(0, this.names.fromString(matchExprVarName), this.env.scope.owner.pkgID, matchStmt.expr.type, this.env.scope.owner));
        BLangSimpleVariableDef matchExprVarDef = ASTBuilderUtil.createVariableDef(matchBlockStmt.pos, matchExprVar);
        matchBlockStmt.stmts.add(matchExprVarDef);
        matchBlockStmt.stmts.add(this.generateIfElseStmt(matchStmt, matchExprVar));
        this.rewrite(matchBlockStmt, this.env);
        this.result = matchBlockStmt;
    }

    @Override
    public void visit(BLangForeach foreach) {
        BLangBlockStmt blockNode;
        BVarSymbol dataSymbol = new BVarSymbol(0, this.names.fromString("$data$"), this.env.scope.owner.pkgID, foreach.collection.type, this.env.scope.owner);
        BLangSimpleVariable dataVariable = ASTBuilderUtil.createVariable(foreach.pos, "$data$", foreach.collection.type, foreach.collection, dataSymbol);
        BLangSimpleVariableDef dataVarDef = ASTBuilderUtil.createVariableDef(foreach.pos, dataVariable);
        BVarSymbol collectionSymbol = dataVariable.symbol;
        switch (foreach.collection.type.tag) {
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 29: {
                BInvokableSymbol iteratorSymbol = this.getLangLibIteratorInvokableSymbol(collectionSymbol);
                blockNode = this.desugarForeachWithIteratorDef(foreach, dataVarDef, collectionSymbol, iteratorSymbol, true);
                break;
            }
            case 32: {
                BInvokableSymbol iteratorSymbol = this.getIterableObjectIteratorInvokableSymbol(collectionSymbol);
                blockNode = this.desugarForeachWithIteratorDef(foreach, dataVarDef, collectionSymbol, iteratorSymbol, false);
                break;
            }
            default: {
                blockNode = ASTBuilderUtil.createBlockStmt(foreach.pos);
                blockNode.stmts.add(0, dataVarDef);
            }
        }
        this.rewrite(blockNode, this.env);
        this.result = blockNode;
    }

    private BLangBlockStmt desugarForeachWithIteratorDef(BLangForeach foreach, BLangSimpleVariableDef dataVariableDefinition, BVarSymbol collectionSymbol, BInvokableSymbol iteratorInvokableSymbol, boolean isIteratorFuncFromLangLib) {
        BLangSimpleVariableDef iteratorVarDef = this.getIteratorVariableDefinition(foreach.pos, collectionSymbol, iteratorInvokableSymbol, isIteratorFuncFromLangLib);
        BLangBlockStmt blockNode = this.desugarForeachToWhile(foreach, iteratorVarDef);
        blockNode.stmts.add(0, dataVariableDefinition);
        return blockNode;
    }

    public BInvokableSymbol getIterableObjectIteratorInvokableSymbol(BVarSymbol collectionSymbol) {
        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)collectionSymbol.type.tsymbol;
        BAttachedFunction iteratorFunc = null;
        for (BAttachedFunction func : typeSymbol.attachedFuncs) {
            if (!func.funcName.value.equals("__iterator")) continue;
            iteratorFunc = func;
            break;
        }
        BAttachedFunction function = iteratorFunc;
        return function.symbol;
    }

    BInvokableSymbol getLangLibIteratorInvokableSymbol(BVarSymbol collectionSymbol) {
        return (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionSymbol.type, this.names.fromString("iterator"));
    }

    private BLangBlockStmt desugarForeachToWhile(BLangForeach foreach, BLangSimpleVariableDef varDef) {
        BVarSymbol iteratorSymbol = varDef.var.symbol;
        BVarSymbol resultSymbol = new BVarSymbol(0, this.names.fromString("$result$"), this.env.scope.owner.pkgID, foreach.nillableResultType, this.env.scope.owner);
        BLangSimpleVariableDef resultVariableDefinition = this.getIteratorNextVariableDefinition(foreach.pos, foreach.nillableResultType, iteratorSymbol, resultSymbol);
        BLangType userDefineType = this.getUserDefineTypeNode(foreach.resultType);
        BLangSimpleVarRef resultReferenceInWhile = ASTBuilderUtil.createVariableRef(foreach.pos, resultSymbol);
        BLangTypeTestExpr typeTestExpr = ASTBuilderUtil.createTypeTestExpr(foreach.pos, resultReferenceInWhile, userDefineType);
        BLangWhile whileNode = (BLangWhile)TreeBuilder.createWhileNode();
        whileNode.pos = foreach.pos;
        whileNode.expr = typeTestExpr;
        whileNode.body = foreach.body;
        BLangAssignment resultAssignment = this.getIteratorNextAssignment(foreach.pos, iteratorSymbol, resultSymbol);
        VariableDefinitionNode variableDefinitionNode = foreach.variableDefinitionNode;
        BLangFieldBasedAccess valueAccessExpr = this.getValueAccessExpression(foreach.pos, foreach.varType, resultSymbol);
        valueAccessExpr.expr = this.addConversionExprIfRequired(valueAccessExpr.expr, this.types.getSafeType(valueAccessExpr.expr.type, true, false));
        variableDefinitionNode.getVariable().setInitialExpression(this.addConversionExprIfRequired(valueAccessExpr, foreach.varType));
        whileNode.body.stmts.add(0, (BLangStatement)((Object)variableDefinitionNode));
        whileNode.body.stmts.add(1, resultAssignment);
        BLangBlockStmt blockNode = ASTBuilderUtil.createBlockStmt(foreach.pos);
        blockNode.addStatement(varDef);
        blockNode.addStatement(resultVariableDefinition);
        blockNode.addStatement(whileNode);
        return blockNode;
    }

    private BLangType getUserDefineTypeNode(BType type) {
        BLangUserDefinedType recordType = new BLangUserDefinedType(ASTBuilderUtil.createIdentifier(null, ""), ASTBuilderUtil.createIdentifier(null, ""));
        recordType.type = type;
        return recordType;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr = this.rewriteExpr(whileNode.expr);
        whileNode.body = this.rewrite(whileNode.body, this.env);
        this.result = whileNode;
    }

    @Override
    public void visit(BLangLock lockNode) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(lockNode.pos);
        BLangLock.BLangLockStmt lockStmt = new BLangLock.BLangLockStmt(lockNode.pos);
        blockStmt.addStatement(lockStmt);
        this.enclLocks.push(lockStmt);
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(lockNode.pos, this.symTable.nilType, Names.NIL_VALUE);
        BUnionType nillableError = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(lockNode.body, nilLiteral);
        statementExpression.type = this.symTable.nilType;
        BLangTrapExpr trapExpr = (BLangTrapExpr)TreeBuilder.createTrapExpressionNode();
        trapExpr.type = nillableError;
        trapExpr.expr = statementExpression;
        BVarSymbol nillableErrorVarSymbol = new BVarSymbol(0, this.names.fromString("$errorResult"), this.env.scope.owner.pkgID, nillableError, this.env.scope.owner);
        BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(lockNode.pos, "$errorResult", nillableError, trapExpr, nillableErrorVarSymbol);
        BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDef(lockNode.pos, simpleVariable);
        blockStmt.addStatement(simpleVariableDef);
        BLangLock.BLangUnLockStmt unLockStmt = new BLangLock.BLangUnLockStmt(lockNode.pos);
        blockStmt.addStatement(unLockStmt);
        BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(lockNode.pos, nillableErrorVarSymbol);
        BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(lockNode.pos);
        BLangPanic panicNode = (BLangPanic)TreeBuilder.createPanicNode();
        panicNode.pos = lockNode.pos;
        panicNode.expr = this.addConversionExprIfRequired(varRef, this.symTable.errorType);
        ifBody.addStatement(panicNode);
        BLangTypeTestExpr isErrorTest = ASTBuilderUtil.createTypeTestExpr(lockNode.pos, varRef, this.getErrorTypeNode());
        isErrorTest.type = this.symTable.booleanType;
        BLangIf ifelse = ASTBuilderUtil.createIfElseStmt(lockNode.pos, isErrorTest, ifBody, null);
        blockStmt.addStatement(ifelse);
        this.result = this.rewrite(blockStmt, this.env);
        this.enclLocks.pop();
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmt) {
        this.result = lockStmt;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockStmt) {
        this.result = unLockStmt;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        DiagnosticPos pos = transactionNode.pos;
        BType trxReturnType = this.symTable.intType;
        BType otherReturnType = this.symTable.nilType;
        BLangType trxReturnNode = ASTBuilderUtil.createTypeNode(trxReturnType);
        BLangType otherReturnNode = ASTBuilderUtil.createTypeNode(otherReturnType);
        DiagnosticPos invPos = transactionNode.pos;
        DiagnosticPos returnStmtPos = new DiagnosticPos(invPos.src, invPos.eLine, invPos.eLine, invPos.sCol, invPos.sCol);
        Node statement = null;
        if (!transactionNode.transactionBody.stmts.isEmpty()) {
            statement = transactionNode.transactionBody.stmts.get(transactionNode.transactionBody.stmts.size() - 1);
        }
        if (statement == null || statement.getKind() != NodeKind.ABORT && statement.getKind() != NodeKind.ABORT) {
            BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(returnStmtPos, trxReturnType, 0L);
            transactionNode.transactionBody.addStatement(returnStmt);
        }
        if (transactionNode.abortedBody == null) {
            transactionNode.abortedBody = ASTBuilderUtil.createBlockStmt(transactionNode.pos);
        }
        if (transactionNode.committedBody == null) {
            transactionNode.committedBody = ASTBuilderUtil.createBlockStmt(transactionNode.pos);
        }
        if (transactionNode.onRetryBody == null) {
            transactionNode.onRetryBody = ASTBuilderUtil.createBlockStmt(transactionNode.pos);
        }
        if (transactionNode.retryCount == null) {
            transactionNode.retryCount = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 3L);
        }
        BLangLambdaFunction trxMainFunc = this.createLambdaFunction(pos, "$anonTrxMainFunc$", Collections.emptyList(), trxReturnNode, transactionNode.transactionBody.stmts, this.env, transactionNode.transactionBody.scope);
        BLangLambdaFunction trxOnRetryFunc = this.createLambdaFunction(pos, "$anonTrxOnRetryFunc$", Collections.emptyList(), otherReturnNode, transactionNode.onRetryBody.stmts, this.env, transactionNode.onRetryBody.scope);
        BLangLambdaFunction trxCommittedFunc = this.createLambdaFunction(pos, "$anonTrxCommittedFunc$", Collections.emptyList(), otherReturnNode, transactionNode.committedBody.stmts, this.env, transactionNode.committedBody.scope);
        BLangLambdaFunction trxAbortedFunc = this.createLambdaFunction(pos, "$anonTrxAbortedFunc$", Collections.emptyList(), otherReturnNode, transactionNode.abortedBody.stmts, this.env, transactionNode.abortedBody.scope);
        trxMainFunc.capturedClosureEnv = this.env.createClone();
        trxOnRetryFunc.capturedClosureEnv = this.env.createClone();
        trxCommittedFunc.capturedClosureEnv = this.env.createClone();
        trxAbortedFunc.capturedClosureEnv = this.env.createClone();
        PackageID packageID = new PackageID(Names.BALLERINA_ORG, Names.TRANSACTION_PACKAGE, Names.EMPTY);
        BPackageSymbol transactionPkgSymbol = new BPackageSymbol(packageID, null, 0);
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)this.symResolver.lookupSymbolInMainSpace(this.symTable.pkgEnvMap.get(transactionPkgSymbol), Names.TRX_INITIATOR_BEGIN_FUNCTION);
        BLangLiteral transactionBlockId = ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, this.getTransactionBlockId());
        List<BLangExpression> requiredArgs = Lists.of(transactionBlockId, transactionNode.retryCount, trxMainFunc, trxOnRetryFunc, trxCommittedFunc, trxAbortedFunc);
        BLangInvocation trxInvocation = ASTBuilderUtil.createInvocationExprMethod(pos, invokableSymbol, requiredArgs, Collections.emptyList(), this.symResolver);
        BLangExpressionStmt stmt = ASTBuilderUtil.createExpressionStmt(pos, ASTBuilderUtil.createBlockStmt(pos));
        stmt.expr = trxInvocation;
        this.result = this.rewrite(stmt, this.env);
    }

    private String getTransactionBlockId() {
        return this.env.enclPkg.packageID.orgName + "$" + this.env.enclPkg.packageID.name + "$" + this.transactionIndex++;
    }

    private BLangLambdaFunction createLambdaFunction(DiagnosticPos pos, String functionNamePrefix, List<BLangSimpleVariable> lambdaFunctionVariable, TypeNode returnType, BLangFunctionBody lambdaBody) {
        BLangFunction func;
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.function = func = ASTBuilderUtil.createFunction(pos, functionNamePrefix + this.lambdaFunctionCount++);
        func.requiredParams.addAll(lambdaFunctionVariable);
        func.setReturnTypeNode(returnType);
        func.desugaredReturnType = true;
        this.defineFunction(func, this.env.enclPkg);
        lambdaFunctionVariable = func.requiredParams;
        func.body = lambdaBody;
        func.desugared = false;
        lambdaFunction.pos = pos;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        lambdaFunctionVariable.forEach(variable -> paramTypes.add(variable.symbol.type));
        lambdaFunction.type = new BInvokableType(paramTypes, func.symbol.type.getReturnType(), null);
        return lambdaFunction;
    }

    private BLangLambdaFunction createLambdaFunction(DiagnosticPos pos, String functionNamePrefix, List<BLangSimpleVariable> lambdaFunctionVariable, TypeNode returnType, List<BLangStatement> fnBodyStmts, SymbolEnv env, Scope trxScope) {
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)TreeBuilder.createBlockFunctionBodyNode();
        body.scope = trxScope;
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, env);
        body.stmts = this.rewriteStmt(fnBodyStmts, bodyEnv);
        return this.createLambdaFunction(pos, functionNamePrefix, lambdaFunctionVariable, returnType, body);
    }

    private BLangLambdaFunction createLambdaFunction(DiagnosticPos pos, String functionNamePrefix, TypeNode returnType) {
        BLangFunction func;
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.function = func = ASTBuilderUtil.createFunction(pos, functionNamePrefix + this.lambdaFunctionCount++);
        func.setReturnTypeNode(returnType);
        func.desugaredReturnType = true;
        this.defineFunction(func, this.env.enclPkg);
        func.desugared = false;
        lambdaFunction.pos = pos;
        return lambdaFunction;
    }

    private void defineFunction(BLangFunction funcNode, BLangPackage targetPkg) {
        BPackageSymbol packageSymbol = targetPkg.symbol;
        SymbolEnv packageEnv = this.symTable.pkgEnvMap.get(packageSymbol);
        this.symbolEnter.defineNode(funcNode, packageEnv);
        packageEnv.enclPkg.functions.add(funcNode);
        packageEnv.enclPkg.topLevelNodes.add(funcNode);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        if (literalExpr.type.tag == 19 && ((BArrayType)literalExpr.type).eType.tag == 2) {
            this.result = this.rewriteBlobLiteral(literalExpr);
            return;
        }
        this.result = literalExpr;
    }

    private BLangNode rewriteBlobLiteral(BLangLiteral literalExpr) {
        String[] result = this.getBlobTextValue((String)literalExpr.value);
        byte[] values = BASE_64.equals(result[0]) ? Base64.getDecoder().decode(result[1].getBytes(StandardCharsets.UTF_8)) : Desugar.hexStringToByteArray(result[1]);
        BLangListConstructorExpr.BLangArrayLiteral arrayLiteralNode = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        arrayLiteralNode.type = literalExpr.type;
        arrayLiteralNode.pos = literalExpr.pos;
        arrayLiteralNode.exprs = new ArrayList();
        for (byte b : values) {
            arrayLiteralNode.exprs.add(this.createByteLiteral(literalExpr.pos, b));
        }
        return arrayLiteralNode;
    }

    private String[] getBlobTextValue(String blobLiteralNodeText) {
        String nodeText = blobLiteralNodeText.replaceAll(" ", "");
        String[] result = new String[]{nodeText.substring(0, nodeText.indexOf(96)), nodeText.substring(nodeText.indexOf(96) + 1, nodeText.lastIndexOf(96))};
        return result;
    }

    private static byte[] hexStringToByteArray(String str) {
        int len = str.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return data;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructor) {
        listConstructor.exprs = this.rewriteExprs(listConstructor.exprs);
        if (listConstructor.type.tag == 29) {
            BLangListConstructorExpr.BLangTupleLiteral expr = new BLangListConstructorExpr.BLangTupleLiteral(listConstructor.pos, listConstructor.exprs, listConstructor.type);
            this.result = this.rewriteExpr(expr);
        } else if (listConstructor.type.tag == 7) {
            BLangListConstructorExpr.BLangJSONArrayLiteral expr = new BLangListConstructorExpr.BLangJSONArrayLiteral(listConstructor.exprs, new BArrayType(listConstructor.type));
            this.result = this.rewriteExpr(expr);
        } else if (this.getElementType((BType)listConstructor.type).tag == 7) {
            BLangListConstructorExpr.BLangJSONArrayLiteral expr = new BLangListConstructorExpr.BLangJSONArrayLiteral(listConstructor.exprs, listConstructor.type);
            this.result = this.rewriteExpr(expr);
        } else if (listConstructor.type.tag == 13) {
            BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
            typedescExpr.resolvedType = listConstructor.typedescType;
            typedescExpr.type = this.symTable.typeDesc;
            this.result = this.rewriteExpr(typedescExpr);
        } else {
            BLangListConstructorExpr.BLangArrayLiteral expr = new BLangListConstructorExpr.BLangArrayLiteral(listConstructor.pos, listConstructor.exprs, listConstructor.type);
            this.result = this.rewriteExpr(expr);
        }
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        arrayLiteral.exprs = this.rewriteExprs(arrayLiteral.exprs);
        if (arrayLiteral.type.tag == 7) {
            this.result = new BLangListConstructorExpr.BLangJSONArrayLiteral(arrayLiteral.exprs, new BArrayType(arrayLiteral.type));
            return;
        }
        if (this.getElementType((BType)arrayLiteral.type).tag == 7) {
            this.result = new BLangListConstructorExpr.BLangJSONArrayLiteral(arrayLiteral.exprs, arrayLiteral.type);
            return;
        }
        this.result = arrayLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        if (tupleLiteral.isTypedescExpr) {
            BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
            typedescExpr.resolvedType = tupleLiteral.typedescType;
            typedescExpr.type = this.symTable.typeDesc;
            this.result = this.rewriteExpr(typedescExpr);
            return;
        }
        tupleLiteral.exprs.forEach(expr -> {
            BType expType = expr.impConversionExpr == null ? expr.type : expr.impConversionExpr.type;
            this.types.setImplicitCastExpr((BLangExpression)expr, expType, this.symTable.anyType);
        });
        tupleLiteral.exprs = this.rewriteExprs(tupleLiteral.exprs);
        this.result = tupleLiteral;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        if (groupExpr.isTypedescExpr) {
            BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
            typedescExpr.resolvedType = groupExpr.typedescType;
            typedescExpr.type = this.symTable.typeDesc;
            this.result = this.rewriteExpr(typedescExpr);
        } else {
            this.result = this.rewriteExpr(groupExpr.expression);
        }
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        List<RecordLiteralNode.RecordField> fields = recordLiteral.fields;
        fields.sort((v1, v2) -> Boolean.compare(this.isComputedKey((RecordLiteralNode.RecordField)v1), this.isComputedKey((RecordLiteralNode.RecordField)v2)));
        this.result = this.rewriteExpr(this.rewriteMappingConstructor(recordLiteral));
    }

    @Override
    public void visit(BLangTableLiteral tableLiteral) {
        tableLiteral.tableDataRows = this.rewriteExprs(tableLiteral.tableDataRows);
        ArrayList<String> keyColumns = new ArrayList<String>();
        for (BLangTableLiteral.BLangTableColumn column : tableLiteral.columns) {
            if (!column.flagSet.contains((Object)TableColumnFlag.PRIMARYKEY)) continue;
            keyColumns.add(column.columnName);
        }
        BLangListConstructorExpr.BLangArrayLiteral keyColumnsArrayLiteral = this.createArrayLiteralExprNode();
        keyColumnsArrayLiteral.exprs = keyColumns.stream().map(expr -> ASTBuilderUtil.createLiteral(tableLiteral.pos, this.symTable.stringType, expr)).collect(Collectors.toList());
        keyColumnsArrayLiteral.type = new BArrayType(this.symTable.stringType);
        tableLiteral.keyColumnsArrayLiteral = keyColumnsArrayLiteral;
        ArrayList<String> indexColumns = new ArrayList<String>();
        for (BLangTableLiteral.BLangTableColumn column : tableLiteral.columns) {
            if (!column.flagSet.contains((Object)TableColumnFlag.INDEX)) continue;
            indexColumns.add(column.columnName);
        }
        BLangListConstructorExpr.BLangArrayLiteral indexColumnsArrayLiteral = this.createArrayLiteralExprNode();
        indexColumnsArrayLiteral.exprs = indexColumns.stream().map(expr -> ASTBuilderUtil.createLiteral(tableLiteral.pos, this.symTable.stringType, expr)).collect(Collectors.toList());
        indexColumnsArrayLiteral.type = new BArrayType(this.symTable.stringType);
        tableLiteral.indexColumnsArrayLiteral = indexColumnsArrayLiteral;
        this.result = tableLiteral;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BLangSimpleVarRef genVarRefExpr = varRefExpr;
        if (varRefExpr.pkgSymbol != null && varRefExpr.pkgSymbol.tag == 8193) {
            BLangXMLQName qnameExpr = new BLangXMLQName(varRefExpr.variableName);
            qnameExpr.nsSymbol = (BXMLNSSymbol)varRefExpr.pkgSymbol;
            qnameExpr.localname = varRefExpr.variableName;
            qnameExpr.prefix = varRefExpr.pkgAlias;
            qnameExpr.namespaceURI = qnameExpr.nsSymbol.namespaceURI;
            qnameExpr.isUsedInXML = false;
            qnameExpr.pos = varRefExpr.pos;
            qnameExpr.type = this.symTable.stringType;
            this.result = qnameExpr;
            return;
        }
        if (varRefExpr.symbol == null) {
            this.result = varRefExpr;
            return;
        }
        if ((varRefExpr.symbol.tag & 0x34) == 52) {
            BVarSymbol varSymbol = (BVarSymbol)varRefExpr.symbol;
            if (varSymbol.originalSymbol != null) {
                varRefExpr.symbol = varSymbol.originalSymbol;
            }
        }
        BSymbol ownerSymbol = varRefExpr.symbol.owner;
        if ((varRefExpr.symbol.tag & 0x334) == 820 && varRefExpr.symbol.type.tag == 16) {
            genVarRefExpr = new BLangSimpleVarRef.BLangFunctionVarRef((BVarSymbol)varRefExpr.symbol);
        } else if ((varRefExpr.symbol.tag & 0xC) == 12 && (varRefExpr.symbol.tag & 0x100001C) != 0x100001C) {
            genVarRefExpr = new BLangSimpleVarRef.BLangTypeLoad(varRefExpr.symbol);
        } else if ((ownerSymbol.tag & 0x100) == 256 || (ownerSymbol.tag & 0x8000000) == 0x8000000) {
            genVarRefExpr = new BLangSimpleVarRef.BLangLocalVarRef((BVarSymbol)varRefExpr.symbol);
        } else if ((ownerSymbol.tag & 0x5C) == 92) {
            genVarRefExpr = new BLangSimpleVarRef.BLangFieldVarRef((BVarSymbol)varRefExpr.symbol);
        } else if ((ownerSymbol.tag & 0x1001) == 4097 || (ownerSymbol.tag & 0x84) == 132) {
            if ((varRefExpr.symbol.tag & 0x100001C) == 0x100001C) {
                BConstantSymbol constSymbol = (BConstantSymbol)varRefExpr.symbol;
                if (constSymbol.literalType.tag <= 6 || constSymbol.literalType.tag == 10) {
                    BLangLiteral literal = ASTBuilderUtil.createLiteral(varRefExpr.pos, constSymbol.literalType, constSymbol.value.value);
                    this.result = this.rewriteExpr(this.addConversionExprIfRequired(literal, varRefExpr.type));
                    return;
                }
            }
            genVarRefExpr = new BLangSimpleVarRef.BLangPackageVarRef((BVarSymbol)varRefExpr.symbol);
        }
        genVarRefExpr.type = varRefExpr.type;
        genVarRefExpr.pos = varRefExpr.pos;
        if (varRefExpr.lhsVar || genVarRefExpr.symbol.name.equals(Names.IGNORE)) {
            genVarRefExpr.lhsVar = varRefExpr.lhsVar;
            genVarRefExpr.type = varRefExpr.symbol.type;
            this.result = genVarRefExpr;
            return;
        }
        genVarRefExpr.lhsVar = varRefExpr.lhsVar;
        BType targetType = genVarRefExpr.type;
        genVarRefExpr.type = genVarRefExpr.symbol.type;
        BLangExpression expression = this.addConversionExprIfRequired(genVarRefExpr, targetType);
        this.result = expression.impConversionExpr != null ? expression.impConversionExpr : expression;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        if (this.safeNavigate(fieldAccessExpr)) {
            this.result = this.rewriteExpr(this.rewriteSafeNavigationExpr(fieldAccessExpr));
            return;
        }
        BLangAccessExpression targetVarRef = fieldAccessExpr;
        BType varRefType = fieldAccessExpr.expr.type;
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        if (!this.types.isSameType(fieldAccessExpr.expr.type, varRefType)) {
            fieldAccessExpr.expr = this.addConversionExprIfRequired(fieldAccessExpr.expr, varRefType);
        }
        BLangLiteral stringLit = this.createStringLiteral(fieldAccessExpr.pos, fieldAccessExpr.field.value);
        int varRefTypeTag = varRefType.tag;
        if (varRefTypeTag == 32 || varRefTypeTag == 20 && ((BUnionType)varRefType).getMemberTypes().iterator().next().tag == 32) {
            targetVarRef = fieldAccessExpr.symbol != null && fieldAccessExpr.symbol.type.tag == 16 && (fieldAccessExpr.symbol.flags & 8) == 8 ? new BLangFieldBasedAccess.BLangStructFunctionVarRef(fieldAccessExpr.expr, (BVarSymbol)fieldAccessExpr.symbol) : new BLangIndexBasedAccess.BLangStructFieldAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit, (BVarSymbol)fieldAccessExpr.symbol, false);
        } else if (varRefTypeTag == 12 || varRefTypeTag == 20 && ((BUnionType)varRefType).getMemberTypes().iterator().next().tag == 12) {
            targetVarRef = fieldAccessExpr.symbol != null && fieldAccessExpr.symbol.type.tag == 16 && (fieldAccessExpr.symbol.flags & 8) == 8 ? new BLangFieldBasedAccess.BLangStructFunctionVarRef(fieldAccessExpr.expr, (BVarSymbol)fieldAccessExpr.symbol) : new BLangIndexBasedAccess.BLangStructFieldAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit, (BVarSymbol)fieldAccessExpr.symbol, false);
        } else if (this.types.isLax(varRefType)) {
            if (varRefType.tag != 8 && varRefType.tag != 43) {
                if (varRefType.tag == 15 && TypeTags.isXMLTypeTag(((BMapType)varRefType).constraint.tag)) {
                    this.result = this.rewriteExpr(this.rewriteLaxMapAccess(fieldAccessExpr));
                    return;
                }
                fieldAccessExpr.expr = this.addConversionExprIfRequired(fieldAccessExpr.expr, this.symTable.jsonType);
                targetVarRef = new BLangIndexBasedAccess.BLangJSONAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit);
            } else {
                targetVarRef = this.rewriteXMLAttributeOrElemNameAccess(fieldAccessExpr);
            }
        } else if (varRefTypeTag == 15) {
            targetVarRef = new BLangIndexBasedAccess.BLangMapAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit);
        } else if (TypeTags.isXMLTypeTag(varRefTypeTag)) {
            targetVarRef = new BLangIndexBasedAccess.BLangXMLAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit, fieldAccessExpr.fieldKind);
        }
        targetVarRef.lhsVar = fieldAccessExpr.lhsVar;
        targetVarRef.type = fieldAccessExpr.type;
        targetVarRef.optionalFieldAccess = fieldAccessExpr.optionalFieldAccess;
        this.result = targetVarRef;
    }

    private BLangStatementExpression rewriteLaxMapAccess(BLangFieldBasedAccess fieldAccessExpr) {
        BLangBlockStmt resultNilBody;
        BLangStatementExpression statementExpression = new BLangStatementExpression();
        BLangBlockStmt block = new BLangBlockStmt();
        statementExpression.stmt = block;
        BUnionType fieldAccessType = BUnionType.create(null, fieldAccessExpr.type, this.symTable.errorType);
        DiagnosticPos pos = fieldAccessExpr.pos;
        BLangSimpleVariableDef result = this.createVarDef("$mapAccessResult$", fieldAccessType, null, pos);
        block.addStatement(result);
        BLangSimpleVarRef resultRef = ASTBuilderUtil.createVariableRef(pos, result.var.symbol);
        resultRef.type = fieldAccessType;
        statementExpression.type = fieldAccessType;
        BLangLiteral mapIndex = ASTBuilderUtil.createLiteral(fieldAccessExpr.field.pos, this.symTable.stringType, fieldAccessExpr.field.value);
        BLangIndexBasedAccess.BLangMapAccessExpr mapAccessExpr = new BLangIndexBasedAccess.BLangMapAccessExpr(pos, fieldAccessExpr.expr, mapIndex);
        BUnionType xmlOrNil = BUnionType.create(null, fieldAccessExpr.type, this.symTable.nilType);
        mapAccessExpr.type = xmlOrNil;
        BLangSimpleVariableDef mapResult = this.createVarDef("$mapAccess", xmlOrNil, mapAccessExpr, pos);
        BLangSimpleVarRef mapResultRef = ASTBuilderUtil.createVariableRef(pos, mapResult.var.symbol);
        block.addStatement(mapResult);
        BLangIf ifStmt = ASTBuilderUtil.createIfStmt(pos, block);
        BLangIsLikeExpr isLikeNilExpr = this.createIsLikeExpression(pos, mapResultRef, this.symTable.nilType);
        ifStmt.expr = isLikeNilExpr;
        ifStmt.body = resultNilBody = new BLangBlockStmt();
        BLangBlockStmt resultHasValueBody = new BLangBlockStmt();
        ifStmt.elseStmt = resultHasValueBody;
        BLangInvocation errorInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue("error");
        errorInvocation.name = name;
        errorInvocation.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        errorInvocation.symbol = this.symTable.errorConstructor;
        errorInvocation.type = this.symTable.errorType;
        ArrayList<BLangExpression> errorCtorArgs = new ArrayList<BLangExpression>();
        errorInvocation.requiredArgs = errorCtorArgs;
        errorCtorArgs.add(this.createStringLiteral(pos, "{lang.map}InvalidKey"));
        BLangNamedArgsExpression message = new BLangNamedArgsExpression();
        message.name = ASTBuilderUtil.createIdentifier(pos, "key");
        message.expr = this.createStringLiteral(pos, fieldAccessExpr.field.value);
        errorCtorArgs.add(message);
        BLangSimpleVariableDef errorDef = this.createVarDef("_$_invalid_key_error", this.symTable.errorType, errorInvocation, pos);
        resultNilBody.addStatement(errorDef);
        BLangSimpleVarRef errorRef = ASTBuilderUtil.createVariableRef(pos, errorDef.var.symbol);
        BLangAssignment errorVarAssignment = ASTBuilderUtil.createAssignmentStmt(pos, resultNilBody);
        errorVarAssignment.varRef = resultRef;
        errorVarAssignment.expr = errorRef;
        BLangAssignment mapResultAssignment = ASTBuilderUtil.createAssignmentStmt(pos, resultHasValueBody);
        mapResultAssignment.varRef = resultRef;
        mapResultAssignment.expr = mapResultRef;
        statementExpression.expr = resultRef;
        return statementExpression;
    }

    private BLangAccessExpression rewriteXMLAttributeOrElemNameAccess(BLangFieldBasedAccess fieldAccessExpr) {
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        String fieldName = fieldAccessExpr.field.value;
        if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
            BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess nsPrefixAccess = (BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr;
            fieldName = this.createExpandedQName(nsPrefixAccess.nsSymbol.namespaceURI, fieldName);
        }
        if (fieldName.equals("_")) {
            return this.createLanglibXMLInvocation(fieldAccessExpr.pos, XML_INTERNAL_GET_ELEMENT_NAME_NIL_LIFTING, fieldAccessExpr.expr, new ArrayList<BLangExpression>(), new ArrayList<BLangExpression>());
        }
        BLangLiteral attributeNameLiteral = this.createStringLiteral(fieldAccessExpr.field.pos, fieldName);
        args.add(attributeNameLiteral);
        args.add(this.isOptionalAccessToLiteral(fieldAccessExpr));
        return this.createLanglibXMLInvocation(fieldAccessExpr.pos, XML_INTERNAL_GET_ATTRIBUTE, fieldAccessExpr.expr, args, new ArrayList<BLangExpression>());
    }

    private BLangExpression isOptionalAccessToLiteral(BLangFieldBasedAccess fieldAccessExpr) {
        return this.rewrite(ASTBuilderUtil.createLiteral(fieldAccessExpr.pos, this.symTable.booleanType, fieldAccessExpr.isOptionalFieldAccess()), this.env);
    }

    private String createExpandedQName(String nsURI, String localName) {
        return "{" + nsURI + "}" + localName;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        if (this.safeNavigate(indexAccessExpr)) {
            this.result = this.rewriteExpr(this.rewriteSafeNavigationExpr(indexAccessExpr));
            return;
        }
        BLangIndexBasedAccess targetVarRef = indexAccessExpr;
        indexAccessExpr.indexExpr = this.rewriteExpr(indexAccessExpr.indexExpr);
        BType varRefType = indexAccessExpr.expr.type;
        indexAccessExpr.expr = this.rewriteExpr(indexAccessExpr.expr);
        if (!this.types.isSameType(indexAccessExpr.expr.type, varRefType)) {
            indexAccessExpr.expr = this.addConversionExprIfRequired(indexAccessExpr.expr, varRefType);
        }
        if (varRefType.tag == 15) {
            targetVarRef = new BLangIndexBasedAccess.BLangMapAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr);
        } else if (this.types.isSubTypeOfMapping(this.types.getSafeType(varRefType, true, false))) {
            targetVarRef = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr, (BVarSymbol)indexAccessExpr.symbol, false);
        } else if (this.types.isSubTypeOfList(varRefType)) {
            targetVarRef = new BLangIndexBasedAccess.BLangArrayAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr);
        } else if (this.types.isAssignable(varRefType, this.symTable.stringType)) {
            indexAccessExpr.expr = this.addConversionExprIfRequired(indexAccessExpr.expr, this.symTable.stringType);
            targetVarRef = new BLangIndexBasedAccess.BLangStringAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr);
        } else if (TypeTags.isXMLTypeTag(varRefType.tag)) {
            targetVarRef = new BLangIndexBasedAccess.BLangXMLAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr);
        }
        targetVarRef.lhsVar = indexAccessExpr.lhsVar;
        targetVarRef.type = indexAccessExpr.type;
        this.result = targetVarRef;
    }

    @Override
    public void visit(BLangInvocation iExpr) {
        BLangInvocation genIExpr = iExpr;
        if (iExpr.symbol != null && iExpr.symbol.kind == SymbolKind.ERROR_CONSTRUCTOR) {
            this.result = this.rewriteErrorConstructor(iExpr);
        }
        this.reorderArguments(iExpr);
        iExpr.requiredArgs = this.rewriteExprs(iExpr.requiredArgs);
        this.fixNonRestArgTypeCastInTypeParamInvocation(iExpr);
        iExpr.restArgs = this.rewriteExprs(iExpr.restArgs);
        this.annotationDesugar.defineStatementAnnotations(iExpr.annAttachments, iExpr.pos, iExpr.symbol.pkgID, iExpr.symbol.owner, this.env);
        if (iExpr.functionPointerInvocation) {
            this.visitFunctionPointerInvocation(iExpr);
            return;
        }
        iExpr.expr = this.rewriteExpr(iExpr.expr);
        this.result = genIExpr;
        if (iExpr.expr == null) {
            this.fixTypeCastInTypeParamInvocation(iExpr, genIExpr);
            if (iExpr.exprSymbol == null) {
                return;
            }
            iExpr.expr = ASTBuilderUtil.createVariableRef(iExpr.pos, iExpr.exprSymbol);
            iExpr.expr = this.rewriteExpr(iExpr.expr);
        }
        switch (iExpr.expr.type.tag) {
            case 12: 
            case 32: {
                if (iExpr.langLibInvocation) break;
                ArrayList<BLangExpression> argExprs = new ArrayList<BLangExpression>(iExpr.requiredArgs);
                argExprs.add(0, iExpr.expr);
                BLangInvocation.BLangAttachedFunctionInvocation attachedFunctionInvocation = new BLangInvocation.BLangAttachedFunctionInvocation(iExpr.pos, argExprs, iExpr.restArgs, iExpr.symbol, iExpr.type, iExpr.expr, iExpr.async);
                attachedFunctionInvocation.actionInvocation = iExpr.actionInvocation;
                attachedFunctionInvocation.name = iExpr.name;
                attachedFunctionInvocation.annAttachments = iExpr.annAttachments;
                genIExpr = attachedFunctionInvocation;
                this.result = genIExpr;
            }
        }
        this.fixTypeCastInTypeParamInvocation(iExpr, genIExpr);
    }

    private void fixNonRestArgTypeCastInTypeParamInvocation(BLangInvocation iExpr) {
        if (!iExpr.langLibInvocation) {
            return;
        }
        List<BLangExpression> requiredArgs = iExpr.requiredArgs;
        List<BVarSymbol> params = ((BInvokableSymbol)iExpr.symbol).params;
        for (int i = 1; i < requiredArgs.size(); ++i) {
            requiredArgs.set(i, this.addConversionExprIfRequired(requiredArgs.get(i), params.get((int)i).type));
        }
    }

    private void fixTypeCastInTypeParamInvocation(BLangInvocation iExpr, BLangInvocation genIExpr) {
        if (iExpr.langLibInvocation || TypeParamAnalyzer.containsTypeParam(((BInvokableSymbol)iExpr.symbol).retType)) {
            BType originalInvType = genIExpr.type;
            genIExpr.type = ((BInvokableSymbol)genIExpr.symbol).retType;
            BLangExpression expr = this.addConversionExprIfRequired(genIExpr, originalInvType);
            if (expr.getKind() == NodeKind.TYPE_CONVERSION_EXPR) {
                this.result = expr;
                return;
            }
            BLangTypeConversionExpr conversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
            conversionExpr.expr = genIExpr;
            conversionExpr.targetType = originalInvType;
            conversionExpr.type = originalInvType;
            conversionExpr.pos = genIExpr.pos;
            this.result = conversionExpr;
        }
    }

    private BLangInvocation rewriteErrorConstructor(BLangInvocation iExpr) {
        BLangExpression errorDetail;
        BLangExpression reasonExpr = iExpr.requiredArgs.get(0);
        if (reasonExpr.impConversionExpr != null && reasonExpr.impConversionExpr.targetType.tag != 5) {
            reasonExpr.impConversionExpr = null;
        }
        reasonExpr = this.addConversionExprIfRequired(reasonExpr, this.symTable.stringType);
        reasonExpr = this.rewriteExpr(reasonExpr);
        iExpr.requiredArgs.remove(0);
        iExpr.requiredArgs.add(reasonExpr);
        BLangRecordLiteral recordLiteral = ASTBuilderUtil.createEmptyRecordLiteral(iExpr.pos, ((BErrorType)iExpr.symbol.type).detailType);
        List namedArgs = iExpr.requiredArgs.stream().filter(a -> a.getKind() == NodeKind.NAMED_ARGS_EXPR).collect(Collectors.toList());
        if (namedArgs.isEmpty()) {
            errorDetail = this.visitCloneReadonly(this.rewriteExpr(recordLiteral), recordLiteral.type);
        } else {
            for (BLangExpression arg : namedArgs) {
                BLangNamedArgsExpression namedArg = (BLangNamedArgsExpression)arg;
                BLangRecordLiteral.BLangRecordKeyValueField member = new BLangRecordLiteral.BLangRecordKeyValueField();
                member.key = new BLangRecordLiteral.BLangRecordKey(ASTBuilderUtil.createLiteral(namedArg.name.pos, this.symTable.stringType, namedArg.name.value));
                member.valueExpr = recordLiteral.type.tag == 12 ? this.addConversionExprIfRequired(namedArg.expr, this.symTable.anyType) : this.addConversionExprIfRequired(namedArg.expr, namedArg.expr.type);
                recordLiteral.fields.add(member);
                iExpr.requiredArgs.remove(arg);
            }
            errorDetail = this.visitCloneReadonly(this.rewriteExpr(recordLiteral), ((BErrorType)iExpr.symbol.type).detailType);
        }
        iExpr.requiredArgs.add(errorDetail);
        return iExpr;
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        this.result = typeInitExpr.type.tag == 14 ? this.rewriteExpr(this.desugarStreamTypeInit(typeInitExpr)) : this.rewrite(this.desugarObjectTypeInit(typeInitExpr), this.env);
    }

    private BLangStatementExpression desugarObjectTypeInit(BLangTypeInit typeInitExpr) {
        typeInitExpr.desugared = true;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(typeInitExpr.pos);
        BType objType = this.getObjectType(typeInitExpr.type);
        BLangSimpleVariableDef objVarDef = this.createVarDef("$obj$", objType, typeInitExpr, typeInitExpr.pos);
        BLangSimpleVarRef objVarRef = ASTBuilderUtil.createVariableRef(typeInitExpr.pos, objVarDef.var.symbol);
        blockStmt.addStatement(objVarDef);
        typeInitExpr.initInvocation.exprSymbol = objVarDef.var.symbol;
        typeInitExpr.initInvocation.symbol = ((BObjectTypeSymbol)objType.tsymbol).generatedInitializerFunc.symbol;
        if (typeInitExpr.initInvocation.type.tag == 10) {
            BLangExpressionStmt initInvExpr = ASTBuilderUtil.createExpressionStmt(typeInitExpr.pos, blockStmt);
            initInvExpr.expr = typeInitExpr.initInvocation;
            typeInitExpr.initInvocation.name.value = Names.GENERATED_INIT_SUFFIX.value;
            BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, objVarRef);
            stmtExpr.type = objVarRef.symbol.type;
            return stmtExpr;
        }
        BLangSimpleVariableDef initInvRetValVarDef = this.createVarDef("$temp$", typeInitExpr.initInvocation.type, typeInitExpr.initInvocation, typeInitExpr.pos);
        blockStmt.addStatement(initInvRetValVarDef);
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$result$", typeInitExpr.type, null, typeInitExpr.pos);
        blockStmt.addStatement(resultVarDef);
        BLangSimpleVarRef initRetValVarRefInCondition = ASTBuilderUtil.createVariableRef(typeInitExpr.pos, initInvRetValVarDef.var.symbol);
        BLangBlockStmt thenStmt = ASTBuilderUtil.createBlockStmt(typeInitExpr.pos);
        BLangTypeTestExpr isErrorTest = ASTBuilderUtil.createTypeTestExpr(typeInitExpr.pos, initRetValVarRefInCondition, this.getErrorTypeNode());
        isErrorTest.type = this.symTable.booleanType;
        BLangSimpleVarRef thenInitRetValVarRef = ASTBuilderUtil.createVariableRef(typeInitExpr.pos, initInvRetValVarDef.var.symbol);
        BLangSimpleVarRef thenResultVarRef = ASTBuilderUtil.createVariableRef(typeInitExpr.pos, resultVarDef.var.symbol);
        BLangAssignment errAssignment = ASTBuilderUtil.createAssignmentStmt(typeInitExpr.pos, thenResultVarRef, thenInitRetValVarRef);
        thenStmt.addStatement(errAssignment);
        BLangSimpleVarRef elseResultVarRef = ASTBuilderUtil.createVariableRef(typeInitExpr.pos, resultVarDef.var.symbol);
        BLangAssignment objAssignment = ASTBuilderUtil.createAssignmentStmt(typeInitExpr.pos, elseResultVarRef, objVarRef);
        BLangBlockStmt elseStmt = ASTBuilderUtil.createBlockStmt(typeInitExpr.pos);
        elseStmt.addStatement(objAssignment);
        BLangIf ifelse = ASTBuilderUtil.createIfElseStmt(typeInitExpr.pos, isErrorTest, thenStmt, elseStmt);
        blockStmt.addStatement(ifelse);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(typeInitExpr.pos, resultVarDef.var.symbol);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.type = resultVarRef.symbol.type;
        return stmtExpr;
    }

    private BLangInvocation desugarStreamTypeInit(BLangTypeInit typeInitExpr) {
        BInvokableSymbol symbol = (BInvokableSymbol)this.symTable.langInternalModuleSymbol.scope.lookup((Name)Names.CONSTRUCT_STREAM).symbol;
        BType targetType = ((BStreamType)typeInitExpr.type).constraint;
        BType errorType = ((BStreamType)typeInitExpr.type).error;
        BTypedescType typedescType = new BTypedescType(targetType, this.symTable.typeDesc.tsymbol);
        BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
        typedescExpr.resolvedType = targetType;
        typedescExpr.type = typedescType;
        BLangExpression iteratorObj = typeInitExpr.argsExpr.get(0);
        BLangInvocation streamConstructInvocation = ASTBuilderUtil.createInvocationExprForMethod(typeInitExpr.pos, symbol, new ArrayList<BLangExpression>(Lists.of(typedescExpr, iteratorObj)), this.symResolver);
        streamConstructInvocation.type = new BStreamType(14, targetType, errorType, null);
        return streamConstructInvocation;
    }

    private BLangSimpleVariableDef createVarDef(String name, BType type, BLangExpression expr, DiagnosticPos pos) {
        BSymbol objSym = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromString(name));
        if (objSym == null || objSym == this.symTable.notFoundSymbol) {
            objSym = new BVarSymbol(0, this.names.fromString(name), this.env.scope.owner.pkgID, type, this.env.scope.owner);
        }
        BLangSimpleVariable objVar = ASTBuilderUtil.createVariable(pos, "$" + name + "$", type, expr, (BVarSymbol)objSym);
        BLangSimpleVariableDef objVarDef = ASTBuilderUtil.createVariableDef(pos);
        objVarDef.var = objVar;
        objVarDef.type = objVar.type;
        return objVarDef;
    }

    private BType getObjectType(BType type) {
        if (type.tag == 32) {
            return type;
        }
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().stream().filter(t -> t.tag == 32).findFirst().orElse(this.symTable.noType);
        }
        throw new IllegalStateException("None object type '" + type.toString() + "' found in object init context");
    }

    BLangErrorType getErrorTypeNode() {
        BLangErrorType errorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorTypeNode.type = this.symTable.errorType;
        return errorTypeNode;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$ternary_result$", ternaryExpr.type, null, ternaryExpr.pos);
        BLangBlockStmt thenBody = ASTBuilderUtil.createBlockStmt(ternaryExpr.pos);
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(ternaryExpr.pos);
        BLangSimpleVarRef thenResultVarRef = ASTBuilderUtil.createVariableRef(ternaryExpr.pos, resultVarDef.var.symbol);
        BLangAssignment thenAssignment = ASTBuilderUtil.createAssignmentStmt(ternaryExpr.pos, thenResultVarRef, ternaryExpr.thenExpr);
        thenBody.addStatement(thenAssignment);
        BLangSimpleVarRef elseResultVarRef = ASTBuilderUtil.createVariableRef(ternaryExpr.pos, resultVarDef.var.symbol);
        BLangAssignment elseAssignment = ASTBuilderUtil.createAssignmentStmt(ternaryExpr.pos, elseResultVarRef, ternaryExpr.elseExpr);
        elseBody.addStatement(elseAssignment);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(ternaryExpr.pos, resultVarDef.var.symbol);
        BLangIf ifElse = ASTBuilderUtil.createIfElseStmt(ternaryExpr.pos, ternaryExpr.expr, thenBody, elseBody);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(ternaryExpr.pos, Lists.of(resultVarDef, ifElse));
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.type = ternaryExpr.type;
        this.result = this.rewriteExpr(stmtExpr);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        waitExpr.exprList = waitExpr.getExpression().getKind() == NodeKind.BINARY_EXPR ? this.collectAllBinaryExprs((BLangBinaryExpr)waitExpr.getExpression(), new ArrayList<BLangExpression>()) : Collections.singletonList(this.rewriteExpr(waitExpr.getExpression()));
        this.result = waitExpr;
    }

    private List<BLangExpression> collectAllBinaryExprs(BLangBinaryExpr binaryExpr, List<BLangExpression> exprs) {
        this.visitBinaryExprOfWait(binaryExpr.lhsExpr, exprs);
        this.visitBinaryExprOfWait(binaryExpr.rhsExpr, exprs);
        return exprs;
    }

    private void visitBinaryExprOfWait(BLangExpression expr, List<BLangExpression> exprs) {
        if (expr.getKind() == NodeKind.BINARY_EXPR) {
            this.collectAllBinaryExprs((BLangBinaryExpr)expr, exprs);
        } else {
            expr = this.rewriteExpr(expr);
            exprs.add(expr);
        }
    }

    @Override
    public void visit(BLangWaitForAllExpr waitExpr) {
        waitExpr.keyValuePairs.forEach(keyValue -> {
            if (keyValue.valueExpr != null) {
                keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
            } else {
                keyValue.keyExpr = this.rewriteExpr(keyValue.keyExpr);
            }
        });
        BLangWaitForAllExpr.BLangWaitLiteral expr = new BLangWaitForAllExpr.BLangWaitLiteral(waitExpr.keyValuePairs, waitExpr.type);
        this.result = this.rewriteExpr(expr);
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewriteExpr(trapExpr.expr);
        if (trapExpr.expr.type.tag != 10) {
            trapExpr.expr = this.addConversionExprIfRequired(trapExpr.expr, trapExpr.type);
        }
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        if (binaryExpr.opKind == OperatorKind.HALF_OPEN_RANGE || binaryExpr.opKind == OperatorKind.CLOSED_RANGE) {
            if (binaryExpr.opKind == OperatorKind.HALF_OPEN_RANGE) {
                binaryExpr.rhsExpr = this.getModifiedIntRangeEndExpr(binaryExpr.rhsExpr);
            }
            this.result = this.rewriteExpr(this.replaceWithIntRange(binaryExpr.pos, binaryExpr.lhsExpr, binaryExpr.rhsExpr));
            return;
        }
        if (binaryExpr.opKind == OperatorKind.AND || binaryExpr.opKind == OperatorKind.OR) {
            this.visitBinaryLogicalExpr(binaryExpr);
            return;
        }
        OperatorKind binaryOpKind = binaryExpr.opKind;
        if (binaryOpKind == OperatorKind.ADD || binaryOpKind == OperatorKind.SUB || binaryOpKind == OperatorKind.MUL || binaryOpKind == OperatorKind.DIV || binaryOpKind == OperatorKind.MOD || binaryOpKind == OperatorKind.BITWISE_AND || binaryOpKind == OperatorKind.BITWISE_OR || binaryOpKind == OperatorKind.BITWISE_XOR) {
            this.checkByteTypeIncompatibleOperations(binaryExpr);
        }
        binaryExpr.lhsExpr = this.rewriteExpr(binaryExpr.lhsExpr);
        binaryExpr.rhsExpr = this.rewriteExpr(binaryExpr.rhsExpr);
        this.result = binaryExpr;
        int rhsExprTypeTag = binaryExpr.rhsExpr.type.tag;
        int lhsExprTypeTag = binaryExpr.lhsExpr.type.tag;
        if (rhsExprTypeTag != lhsExprTypeTag && (binaryExpr.opKind == OperatorKind.EQUAL || binaryExpr.opKind == OperatorKind.NOT_EQUAL || binaryExpr.opKind == OperatorKind.REF_EQUAL || binaryExpr.opKind == OperatorKind.REF_NOT_EQUAL)) {
            if (lhsExprTypeTag == 1 && rhsExprTypeTag == 2) {
                binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, this.symTable.intType);
                return;
            }
            if (lhsExprTypeTag == 2 && rhsExprTypeTag == 1) {
                binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, this.symTable.intType);
                return;
            }
        }
        if (lhsExprTypeTag == rhsExprTypeTag) {
            return;
        }
        if (TypeTags.isStringTypeTag(lhsExprTypeTag) && binaryExpr.opKind == OperatorKind.ADD) {
            if (TypeTags.isXMLTypeTag(rhsExprTypeTag)) {
                binaryExpr.lhsExpr = ASTBuilderUtil.createXMLTextLiteralNode(binaryExpr, binaryExpr.lhsExpr, binaryExpr.lhsExpr.pos, this.symTable.xmlType);
                return;
            }
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, binaryExpr.lhsExpr.type);
            return;
        }
        if (TypeTags.isStringTypeTag(rhsExprTypeTag) && binaryExpr.opKind == OperatorKind.ADD) {
            if (TypeTags.isXMLTypeTag(lhsExprTypeTag)) {
                binaryExpr.rhsExpr = ASTBuilderUtil.createXMLTextLiteralNode(binaryExpr, binaryExpr.rhsExpr, binaryExpr.rhsExpr.pos, this.symTable.xmlType);
                return;
            }
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, binaryExpr.rhsExpr.type);
            return;
        }
        if (lhsExprTypeTag == 4) {
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, binaryExpr.lhsExpr.type);
            return;
        }
        if (rhsExprTypeTag == 4) {
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, binaryExpr.rhsExpr.type);
            return;
        }
        if (lhsExprTypeTag == 3) {
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, binaryExpr.lhsExpr.type);
            return;
        }
        if (rhsExprTypeTag == 3) {
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, binaryExpr.rhsExpr.type);
        }
    }

    private BLangInvocation replaceWithIntRange(DiagnosticPos pos, BLangExpression lhsExpr, BLangExpression rhsExpr) {
        BInvokableSymbol symbol = (BInvokableSymbol)this.symTable.langInternalModuleSymbol.scope.lookup((Name)Names.CREATE_INT_RANGE).symbol;
        BLangInvocation createIntRangeInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, symbol, new ArrayList<BLangExpression>(Lists.of(lhsExpr, rhsExpr)), this.symResolver);
        createIntRangeInvocation.type = this.symTable.intRangeType;
        return createIntRangeInvocation;
    }

    private void checkByteTypeIncompatibleOperations(BLangBinaryExpr binaryExpr) {
        if (binaryExpr.expectedType == null) {
            return;
        }
        int rhsExprTypeTag = binaryExpr.rhsExpr.type.tag;
        int lhsExprTypeTag = binaryExpr.lhsExpr.type.tag;
        if (rhsExprTypeTag != 2 && lhsExprTypeTag != 2) {
            return;
        }
        int resultTypeTag = binaryExpr.expectedType.tag;
        if (resultTypeTag == 1) {
            if (rhsExprTypeTag == 2) {
                binaryExpr.rhsExpr = this.addConversionExprIfRequired(binaryExpr.rhsExpr, this.symTable.intType);
            }
            if (lhsExprTypeTag == 2) {
                binaryExpr.lhsExpr = this.addConversionExprIfRequired(binaryExpr.lhsExpr, this.symTable.intType);
            }
        }
    }

    private boolean isBitwiseShiftOperation(BLangBinaryExpr binaryExpr) {
        return binaryExpr.opKind == OperatorKind.BITWISE_LEFT_SHIFT || binaryExpr.opKind == OperatorKind.BITWISE_RIGHT_SHIFT || binaryExpr.opKind == OperatorKind.BITWISE_UNSIGNED_RIGHT_SHIFT;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        BLangMatchExpression matchExpr = ASTBuilderUtil.createMatchExpression(elvisExpr.lhsExpr);
        matchExpr.patternClauses.add(this.getMatchNullPatternGivenExpression(elvisExpr.pos, this.rewriteExpr(elvisExpr.rhsExpr)));
        matchExpr.type = elvisExpr.type;
        matchExpr.pos = elvisExpr.pos;
        this.result = this.rewriteExpr(matchExpr);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        if (OperatorKind.BITWISE_COMPLEMENT == unaryExpr.operator) {
            this.rewriteBitwiseComplementOperator(unaryExpr);
            return;
        }
        unaryExpr.expr = this.rewriteExpr(unaryExpr.expr);
        this.result = unaryExpr;
    }

    private void rewriteBitwiseComplementOperator(BLangUnaryExpr unaryExpr) {
        DiagnosticPos pos = unaryExpr.pos;
        BLangBinaryExpr binaryExpr = (BLangBinaryExpr)TreeBuilder.createBinaryExpressionNode();
        binaryExpr.pos = pos;
        binaryExpr.opKind = OperatorKind.BITWISE_XOR;
        binaryExpr.lhsExpr = unaryExpr.expr;
        if (2 == unaryExpr.type.tag) {
            binaryExpr.type = this.symTable.byteType;
            binaryExpr.rhsExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.byteType, 255L);
            binaryExpr.opSymbol = (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.BITWISE_XOR, this.symTable.byteType, this.symTable.byteType);
        } else {
            binaryExpr.type = this.symTable.intType;
            binaryExpr.rhsExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, -1L);
            binaryExpr.opSymbol = (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.BITWISE_XOR, this.symTable.intType, this.symTable.intType);
        }
        this.result = this.rewriteExpr(binaryExpr);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        if (conversionExpr.typeNode == null && !conversionExpr.annAttachments.isEmpty()) {
            this.result = this.rewriteExpr(conversionExpr.expr);
            return;
        }
        conversionExpr.typeNode = this.rewrite(conversionExpr.typeNode, this.env);
        conversionExpr.expr = this.rewriteExpr(conversionExpr.expr);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        this.env.enclPkg.lambdaFunctions.add(bLangLambdaFunction);
        this.result = bLangLambdaFunction;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        BLangFunction bLangFunction = (BLangFunction)TreeBuilder.createFunctionNode();
        bLangFunction.setName(bLangArrowFunction.functionName);
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.pos = bLangArrowFunction.pos;
        bLangFunction.addFlag(Flag.LAMBDA);
        lambdaFunction.function = bLangFunction;
        BLangValueType returnType = (BLangValueType)TreeBuilder.createValueTypeNode();
        returnType.type = bLangArrowFunction.body.expr.type;
        bLangFunction.setReturnTypeNode(returnType);
        bLangFunction.setBody(this.populateArrowExprBodyBlock(bLangArrowFunction));
        bLangArrowFunction.params.forEach(bLangFunction::addParameter);
        lambdaFunction.parent = bLangArrowFunction.parent;
        lambdaFunction.type = bLangArrowFunction.funcType;
        BLangFunction funcNode = lambdaFunction.function;
        BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), new Name(funcNode.name.value), this.env.enclPkg.symbol.pkgID, bLangArrowFunction.funcType, this.env.enclEnv.enclVarSym, true);
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.env);
        this.defineInvokableSymbol(funcNode, funcSymbol, invokableEnv);
        List paramSymbols = funcNode.requiredParams.stream().peek(varNode -> {
            Scope enclScope = invokableEnv.scope;
            varNode.symbol.kind = SymbolKind.FUNCTION;
            varNode.symbol.owner = invokableEnv.scope.owner;
            enclScope.define(varNode.symbol.name, varNode.symbol);
        }).map(varNode -> varNode.symbol).collect(Collectors.toList());
        funcSymbol.params = paramSymbols;
        funcSymbol.restParam = this.getRestSymbol(funcNode);
        funcSymbol.retType = funcNode.returnTypeNode.type;
        List<BType> paramTypes = paramSymbols.stream().map(paramSym -> paramSym.type).collect(Collectors.toList());
        funcNode.type = new BInvokableType(paramTypes, this.getRestType(funcSymbol), funcNode.returnTypeNode.type, null);
        lambdaFunction.function.pos = bLangArrowFunction.pos;
        lambdaFunction.function.body.pos = bLangArrowFunction.pos;
        lambdaFunction.capturedClosureEnv = this.env;
        this.rewrite(lambdaFunction.function, this.env);
        this.env.enclPkg.addFunction(lambdaFunction.function);
        bLangArrowFunction.function = lambdaFunction.function;
        this.result = this.rewriteExpr(lambdaFunction);
    }

    private void defineInvokableSymbol(BLangInvokableNode invokableNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv) {
        invokableNode.symbol = funcSymbol;
        invokableEnv.scope = funcSymbol.scope = new Scope(funcSymbol);
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.result = xmlQName;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name = this.rewriteExpr(xmlAttribute.name);
        xmlAttribute.value = this.rewriteExpr(xmlAttribute.value);
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.startTagName = this.rewriteExpr(xmlElementLiteral.startTagName);
        xmlElementLiteral.endTagName = this.rewriteExpr(xmlElementLiteral.endTagName);
        xmlElementLiteral.modifiedChildren = this.rewriteExprs(xmlElementLiteral.modifiedChildren);
        xmlElementLiteral.attributes = this.rewriteExprs(xmlElementLiteral.attributes);
        for (BLangXMLAttribute attribute : xmlElementLiteral.attributes) {
            if (!attribute.isNamespaceDeclr) continue;
            BLangXMLNS xmlns = (xmlElementLiteral.scope.owner.tag & 0x1001) == 4097 ? new BLangXMLNS.BLangPackageXMLNS() : new BLangXMLNS.BLangLocalXMLNS();
            xmlns.namespaceURI = attribute.value.concatExpr;
            xmlns.prefix = ((BLangXMLQName)attribute.name).localname;
            xmlns.symbol = attribute.symbol;
            xmlElementLiteral.inlineNamespaces.add(xmlns);
        }
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.concatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlTextLiteral.textFragments));
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.concatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlCommentLiteral.textFragments));
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.target = this.rewriteExpr(xmlProcInsLiteral.target);
        xmlProcInsLiteral.dataConcatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlProcInsLiteral.dataFragments));
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.concatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlQuotedString.textFragments));
        this.result = xmlQuotedString;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.result = this.rewriteExpr(this.constructStringTemplateConcatExpression(stringTemplateLiteral.exprs));
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        workerSendNode.expr = this.visitCloneInvocation(this.rewriteExpr(workerSendNode.expr), workerSendNode.expr.type);
        if (workerSendNode.keyExpr != null) {
            workerSendNode.keyExpr = this.rewriteExpr(workerSendNode.keyExpr);
        }
        this.result = workerSendNode;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        syncSendExpr.expr = this.visitCloneInvocation(this.rewriteExpr(syncSendExpr.expr), syncSendExpr.expr.type);
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        if (workerReceiveNode.keyExpr != null) {
            workerReceiveNode.keyExpr = this.rewriteExpr(workerReceiveNode.keyExpr);
        }
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        workerFlushExpr.workerIdentifierList = workerFlushExpr.cachedWorkerSendStmts.stream().map(send -> send.workerIdentifier).distinct().collect(Collectors.toList());
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        xmlAttributeAccessExpr.indexExpr = this.rewriteExpr(xmlAttributeAccessExpr.indexExpr);
        xmlAttributeAccessExpr.expr = this.rewriteExpr(xmlAttributeAccessExpr.expr);
        if (xmlAttributeAccessExpr.indexExpr != null && xmlAttributeAccessExpr.indexExpr.getKind() == NodeKind.XML_QNAME) {
            ((BLangXMLQName)xmlAttributeAccessExpr.indexExpr).isUsedInXML = true;
        }
        xmlAttributeAccessExpr.desugared = true;
        this.result = xmlAttributeAccessExpr.lhsVar || xmlAttributeAccessExpr.indexExpr != null ? xmlAttributeAccessExpr : this.rewriteExpr(xmlAttributeAccessExpr);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        this.result = localVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
        this.result = fieldVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
        this.result = packageVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        this.result = mapKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        this.result = mapLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        this.result = structLiteral;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        this.result = waitLiteral;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr = this.rewriteExpr(xmlElementAccess.expr);
        ArrayList<BLangExpression> filters = this.expandFilters(xmlElementAccess.filters);
        BLangInvocation invocationNode = this.createLanglibXMLInvocation(xmlElementAccess.pos, XML_INTERNAL_GET_ELEMENTS, xmlElementAccess.expr, new ArrayList<BLangExpression>(), filters);
        this.result = this.rewriteExpr(invocationNode);
    }

    private ArrayList<BLangExpression> expandFilters(List<BLangXMLElementFilter> filters) {
        Map<Name, BXMLNSSymbol> nameBXMLNSSymbolMap = this.symResolver.resolveAllNamespaces(this.env);
        BXMLNSSymbol defaultNSSymbol = nameBXMLNSSymbolMap.get(this.names.fromString(""));
        String defaultNS = defaultNSSymbol != null ? defaultNSSymbol.namespaceURI : null;
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        for (BLangXMLElementFilter filter : filters) {
            BSymbol nsSymbol = this.symResolver.lookupSymbolInPrefixSpace(this.env, this.names.fromString(filter.namespace));
            if (nsSymbol == this.symTable.notFoundSymbol) {
                if (defaultNS != null && !filter.name.equals("*")) {
                    String expandedName = this.createExpandedQName(defaultNS, filter.name);
                    args.add(this.createStringLiteral(filter.elemNamePos, expandedName));
                    continue;
                }
                args.add(this.createStringLiteral(filter.elemNamePos, filter.name));
                continue;
            }
            BXMLNSSymbol bxmlnsSymbol = (BXMLNSSymbol)nsSymbol;
            String expandedName = this.createExpandedQName(bxmlnsSymbol.namespaceURI, filter.name);
            BLangLiteral stringLiteral = this.createStringLiteral(filter.elemNamePos, expandedName);
            args.add(stringLiteral);
        }
        return args;
    }

    private BLangInvocation createLanglibXMLInvocation(DiagnosticPos pos, String functionName, BLangExpression invokeOnExpr, ArrayList<BLangExpression> args, ArrayList<BLangExpression> restArgs) {
        invokeOnExpr = this.rewriteExpr(invokeOnExpr);
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        invocationNode.pos = pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        name.pos = pos;
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.expr = invokeOnExpr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(this.symTable.xmlType, this.names.fromString(functionName));
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
        requiredArgs.add(invokeOnExpr);
        requiredArgs.addAll(args);
        invocationNode.requiredArgs = requiredArgs;
        invocationNode.restArgs = this.rewriteExprs(restArgs);
        invocationNode.type = ((BInvokableType)invocationNode.symbol.type).getReturnType();
        invocationNode.langLibInvocation = true;
        return invocationNode;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr = this.rewriteExpr(xmlNavigation.expr);
        xmlNavigation.childIndex = this.rewriteExpr(xmlNavigation.childIndex);
        ArrayList<BLangExpression> filters = this.expandFilters(xmlNavigation.filters);
        if (xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.DESCENDANTS) {
            BLangInvocation invocationNode = this.createLanglibXMLInvocation(xmlNavigation.pos, XML_INTERNAL_SELECT_DESCENDANTS, xmlNavigation.expr, new ArrayList<BLangExpression>(), filters);
            this.result = this.rewriteExpr(invocationNode);
        } else if (xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.CHILDREN) {
            BLangInvocation invocationNode = this.createLanglibXMLInvocation(xmlNavigation.pos, XML_INTERNAL_CHILDREN, xmlNavigation.expr, new ArrayList<BLangExpression>(), new ArrayList<BLangExpression>());
            this.result = this.rewriteExpr(invocationNode);
        } else {
            BLangExpression childIndexExpr = xmlNavigation.childIndex == null ? new BLangLiteral(-1L, this.symTable.intType) : xmlNavigation.childIndex;
            ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
            args.add(this.rewriteExpr(childIndexExpr));
            BLangInvocation invocationNode = this.createLanglibXMLInvocation(xmlNavigation.pos, XML_INTERNAL_GET_FILTERED_CHILDREN_FLAT, xmlNavigation.expr, args, filters);
            this.result = this.rewriteExpr(invocationNode);
        }
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr = this.rewriteExpr(assignableExpr.lhsExpr);
        this.result = assignableExpr;
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation fpInvocation) {
        this.result = fpInvocation;
    }

    @Override
    public void visit(BLangTypedescExpr typedescExpr) {
        typedescExpr.typeNode = this.rewrite(typedescExpr.typeNode, this.env);
        this.result = typedescExpr;
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        if (!intRangeExpression.includeStart) {
            intRangeExpression.startExpr = this.getModifiedIntRangeStartExpr(intRangeExpression.startExpr);
        }
        if (!intRangeExpression.includeEnd) {
            intRangeExpression.endExpr = this.getModifiedIntRangeEndExpr(intRangeExpression.endExpr);
        }
        intRangeExpression.startExpr = this.rewriteExpr(intRangeExpression.startExpr);
        intRangeExpression.endExpr = this.rewriteExpr(intRangeExpression.endExpr);
        this.result = intRangeExpression;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.result = this.rewriteExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr = this.rewriteExpr(bLangNamedArgsExpression.expr);
        this.result = bLangNamedArgsExpression.expr;
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
        this.addMatchExprDefaultCase(bLangMatchExpression);
        String matchTempResultVarName = Names.GEN_VAR_PREFIX.value + "temp_result";
        BLangSimpleVariable tempResultVar = ASTBuilderUtil.createVariable(bLangMatchExpression.pos, matchTempResultVarName, bLangMatchExpression.type, null, new BVarSymbol(0, this.names.fromString(matchTempResultVarName), this.env.scope.owner.pkgID, bLangMatchExpression.type, this.env.scope.owner));
        BLangSimpleVariableDef tempResultVarDef = ASTBuilderUtil.createVariableDef(bLangMatchExpression.pos, tempResultVar);
        tempResultVarDef.desugared = true;
        BLangBlockStmt stmts = ASTBuilderUtil.createBlockStmt(bLangMatchExpression.pos, Lists.of(tempResultVarDef));
        ArrayList<BLangMatch.BLangMatchTypedBindingPatternClause> patternClauses = new ArrayList<BLangMatch.BLangMatchTypedBindingPatternClause>();
        for (int i = 0; i < bLangMatchExpression.patternClauses.size(); ++i) {
            BLangMatchExpression.BLangMatchExprPatternClause pattern = bLangMatchExpression.patternClauses.get(i);
            pattern.expr = this.rewriteExpr(pattern.expr);
            BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(bLangMatchExpression.pos, tempResultVar.symbol);
            pattern.expr = this.addConversionExprIfRequired(pattern.expr, tempResultVarRef.type);
            BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(pattern.pos, tempResultVarRef, pattern.expr);
            BLangBlockStmt patternBody = ASTBuilderUtil.createBlockStmt(pattern.pos, Lists.of(assignmentStmt));
            patternClauses.add(ASTBuilderUtil.createMatchStatementPattern(pattern.pos, pattern.variable, patternBody));
        }
        stmts.addStatement(ASTBuilderUtil.createMatchStatement(bLangMatchExpression.pos, bLangMatchExpression.expr, patternClauses));
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(bLangMatchExpression.pos, tempResultVar.symbol);
        BLangStatementExpression statementExpr = ASTBuilderUtil.createStatementExpression(stmts, tempResultVarRef);
        statementExpr.type = bLangMatchExpression.type;
        this.result = this.rewriteExpr(statementExpr);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr, false);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr, true);
    }

    private void visitCheckAndCheckPanicExpr(BLangCheckedExpr checkedExpr, boolean isCheckPanic) {
        String checkedExprVarName = Names.GEN_VAR_PREFIX.value;
        BLangSimpleVariable checkedExprVar = ASTBuilderUtil.createVariable(checkedExpr.pos, checkedExprVarName, checkedExpr.type, null, new BVarSymbol(0, this.names.fromString(checkedExprVarName), this.env.scope.owner.pkgID, checkedExpr.type, this.env.scope.owner));
        final BLangSimpleVariableDef checkedExprVarDef = ASTBuilderUtil.createVariableDef(checkedExpr.pos, checkedExprVar);
        checkedExprVarDef.desugared = true;
        final BLangMatch.BLangMatchTypedBindingPatternClause patternSuccessCase = this.getSafeAssignSuccessPattern(checkedExprVar.pos, checkedExprVar.symbol.type, true, checkedExprVar.symbol, null);
        final BLangMatch.BLangMatchTypedBindingPatternClause patternErrorCase = this.getSafeAssignErrorPattern(checkedExpr.pos, this.env.scope.owner, checkedExpr.equivalentErrorTypeList, isCheckPanic);
        final BLangMatch matchStmt = ASTBuilderUtil.createMatchStatement(checkedExpr.pos, checkedExpr.expr, (List<BLangMatch.BLangMatchTypedBindingPatternClause>)new ArrayList<BLangMatch.BLangMatchTypedBindingPatternClause>(){
            {
                this.add(patternSuccessCase);
                this.add(patternErrorCase);
            }
        });
        BLangBlockStmt generatedStmtBlock = ASTBuilderUtil.createBlockStmt(checkedExpr.pos, (List<BLangStatement>)new ArrayList<BLangStatement>(){
            {
                this.add(checkedExprVarDef);
                this.add(matchStmt);
            }
        });
        BLangSimpleVarRef tempCheckedExprVarRef = ASTBuilderUtil.createVariableRef(checkedExpr.pos, checkedExprVar.symbol);
        BLangStatementExpression statementExpr = ASTBuilderUtil.createStatementExpression(generatedStmtBlock, tempCheckedExprVarRef);
        statementExpr.type = checkedExpr.type;
        this.result = this.rewriteExpr(statementExpr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        BLangTypeInit typeInit = ASTBuilderUtil.createEmptyTypeInit(serviceConstructorExpr.pos, serviceConstructorExpr.serviceNode.serviceTypeDefinition.symbol.type);
        serviceConstructorExpr.serviceNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = this.rewriteExpr(typeInit);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        BLangExpression expr = typeTestExpr.expr;
        if (this.types.isValueType(expr.type)) {
            this.addConversionExprIfRequired(expr, this.symTable.anyType);
        }
        typeTestExpr.expr = this.rewriteExpr(expr);
        typeTestExpr.typeNode = this.rewrite(typeTestExpr.typeNode, this.env);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        BLangBinaryExpr binaryExpr = (BLangBinaryExpr)TreeBuilder.createBinaryExpressionNode();
        binaryExpr.pos = annotAccessExpr.pos;
        binaryExpr.opKind = OperatorKind.ANNOT_ACCESS;
        binaryExpr.lhsExpr = annotAccessExpr.expr;
        binaryExpr.rhsExpr = ASTBuilderUtil.createLiteral(annotAccessExpr.pkgAlias.pos, this.symTable.stringType, annotAccessExpr.annotationSymbol.bvmAlias());
        binaryExpr.type = annotAccessExpr.type;
        binaryExpr.opSymbol = new BOperatorSymbol(this.names.fromString(OperatorKind.ANNOT_ACCESS.value()), null, new BInvokableType(Lists.of(binaryExpr.lhsExpr.type, binaryExpr.rhsExpr.type), annotAccessExpr.type, null), null);
        this.result = this.rewriteExpr(binaryExpr);
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        isLikeExpr.expr = this.rewriteExpr(isLikeExpr.expr);
        this.result = isLikeExpr;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        bLangStatementExpression.expr = this.rewriteExpr(bLangStatementExpression.expr);
        bLangStatementExpression.stmt = this.rewrite(bLangStatementExpression.stmt, this.env);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        BLangStatementExpression stmtExpr = this.queryDesugar.desugarQueryExpr(queryExpr, this.env);
        this.result = this.rewrite(stmtExpr, this.env);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        BLangStatementExpression stmtExpr = this.queryDesugar.desugarQueryAction(queryAction, this.env);
        this.result = this.rewrite(stmtExpr, this.env);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        jsonArrayLiteral.exprs = this.rewriteExprs(jsonArrayLiteral.exprs);
        this.result = jsonArrayLiteral;
    }

    @Override
    public void visit(BLangConstant constant) {
        BConstantSymbol constSymbol = constant.symbol;
        if (constSymbol.literalType.tag <= 6 || constSymbol.literalType.tag == 10) {
            if (constSymbol.literalType.tag != 10 && constSymbol.value.value == null) {
                throw new IllegalStateException();
            }
            BLangLiteral literal = ASTBuilderUtil.createLiteral(constant.expr.pos, constSymbol.literalType, constSymbol.value.value);
            constant.expr = this.rewriteExpr(literal);
        } else {
            constant.expr = this.rewriteExpr(constant.expr);
        }
        constant.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = constant;
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        this.result = ignoreExpr;
    }

    @Override
    public void visit(BLangConstRef constantRef) {
        this.result = ASTBuilderUtil.createLiteral(constantRef.pos, constantRef.type, constantRef.value);
    }

    BLangSimpleVariableDef getIteratorVariableDefinition(DiagnosticPos pos, BVarSymbol collectionSymbol, BInvokableSymbol iteratorInvokableSymbol, boolean isIteratorFuncFromLangLib) {
        BLangSimpleVarRef dataReference = ASTBuilderUtil.createVariableRef(pos, collectionSymbol);
        BLangInvocation iteratorInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        iteratorInvocation.pos = pos;
        iteratorInvocation.expr = dataReference;
        iteratorInvocation.symbol = iteratorInvokableSymbol;
        iteratorInvocation.type = iteratorInvokableSymbol.retType;
        iteratorInvocation.argExprs = Lists.of(dataReference);
        iteratorInvocation.requiredArgs = iteratorInvocation.argExprs;
        iteratorInvocation.langLibInvocation = isIteratorFuncFromLangLib;
        BVarSymbol iteratorSymbol = new BVarSymbol(0, this.names.fromString("$iterator$"), this.env.scope.owner.pkgID, iteratorInvokableSymbol.retType, this.env.scope.owner);
        BLangSimpleVariable iteratorVariable = ASTBuilderUtil.createVariable(pos, "$iterator$", iteratorInvokableSymbol.retType, iteratorInvocation, iteratorSymbol);
        return ASTBuilderUtil.createVariableDef(pos, iteratorVariable);
    }

    BLangSimpleVariableDef getIteratorNextVariableDefinition(DiagnosticPos pos, BType nillableResultType, BVarSymbol iteratorSymbol, BVarSymbol resultSymbol) {
        BLangInvocation nextInvocation = this.createIteratorNextInvocation(pos, iteratorSymbol);
        BLangSimpleVariable resultVariable = ASTBuilderUtil.createVariable(pos, "$result$", nillableResultType, nextInvocation, resultSymbol);
        return ASTBuilderUtil.createVariableDef(pos, resultVariable);
    }

    BLangAssignment getIteratorNextAssignment(DiagnosticPos pos, BVarSymbol iteratorSymbol, BVarSymbol resultSymbol) {
        BLangSimpleVarRef resultReferenceInAssignment = ASTBuilderUtil.createVariableRef(pos, resultSymbol);
        BLangInvocation nextInvocation = this.createIteratorNextInvocation(pos, iteratorSymbol);
        nextInvocation.expr.type = this.types.getSafeType(nextInvocation.expr.type, true, false);
        return ASTBuilderUtil.createAssignmentStmt(pos, resultReferenceInAssignment, nextInvocation, false);
    }

    BLangInvocation createIteratorNextInvocation(DiagnosticPos pos, BVarSymbol iteratorSymbol) {
        BLangIdentifier nextIdentifier = ASTBuilderUtil.createIdentifier(pos, "next");
        BLangSimpleVarRef iteratorReferenceInNext = ASTBuilderUtil.createVariableRef(pos, iteratorSymbol);
        BInvokableSymbol nextFuncSymbol = this.getNextFunc((BObjectType)((BObjectType)iteratorSymbol.type)).symbol;
        BLangInvocation nextInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        nextInvocation.pos = pos;
        nextInvocation.name = nextIdentifier;
        nextInvocation.expr = iteratorReferenceInNext;
        nextInvocation.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, iteratorSymbol));
        nextInvocation.argExprs = nextInvocation.requiredArgs;
        nextInvocation.symbol = nextFuncSymbol;
        nextInvocation.type = nextFuncSymbol.retType;
        return nextInvocation;
    }

    private BAttachedFunction getNextFunc(BObjectType iteratorType) {
        BObjectTypeSymbol iteratorSymbol = (BObjectTypeSymbol)iteratorType.tsymbol;
        for (BAttachedFunction bAttachedFunction : iteratorSymbol.attachedFuncs) {
            if (!bAttachedFunction.funcName.value.equals("next")) continue;
            return bAttachedFunction;
        }
        return null;
    }

    BLangFieldBasedAccess getValueAccessExpression(DiagnosticPos pos, BType varType, BVarSymbol resultSymbol) {
        BLangSimpleVarRef resultReferenceInVariableDef = ASTBuilderUtil.createVariableRef(pos, resultSymbol);
        BLangIdentifier valueIdentifier = ASTBuilderUtil.createIdentifier(pos, "value");
        BLangFieldBasedAccess fieldBasedAccessExpression = ASTBuilderUtil.createFieldAccessExpr(resultReferenceInVariableDef, valueIdentifier);
        fieldBasedAccessExpression.pos = pos;
        fieldBasedAccessExpression.originalType = fieldBasedAccessExpression.type = varType;
        return fieldBasedAccessExpression;
    }

    private BlockFunctionBodyNode populateArrowExprBodyBlock(BLangArrowFunction bLangArrowFunction) {
        BlockFunctionBodyNode blockNode = TreeBuilder.createBlockFunctionBodyNode();
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.pos = bLangArrowFunction.body.expr.pos;
        returnNode.setExpression(bLangArrowFunction.body.expr);
        blockNode.addStatement(returnNode);
        return blockNode;
    }

    private BLangInvocation createInvocationNode(String functionName, List<BLangExpression> args, BType retType) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.symbol = this.symTable.rootScope.lookup((Name)new Name((String)functionName)).symbol;
        invocationNode.type = retType;
        invocationNode.requiredArgs = args;
        return invocationNode;
    }

    private BLangInvocation createLangLibInvocationNode(String functionName, BLangExpression onExpr, List<BLangExpression> args, BType retType, DiagnosticPos pos) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        invocationNode.pos = pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        name.pos = pos;
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.expr = onExpr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(onExpr.type, this.names.fromString(functionName));
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
        requiredArgs.add(onExpr);
        requiredArgs.addAll(args);
        invocationNode.requiredArgs = requiredArgs;
        invocationNode.type = retType != null ? retType : ((BInvokableSymbol)invocationNode.symbol).retType;
        invocationNode.langLibInvocation = true;
        return invocationNode;
    }

    private BLangListConstructorExpr.BLangArrayLiteral createArrayLiteralExprNode() {
        BLangListConstructorExpr.BLangArrayLiteral expr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        expr.exprs = new ArrayList();
        expr.type = new BArrayType(this.symTable.anyType);
        return expr;
    }

    private void visitFunctionPointerInvocation(BLangInvocation iExpr) {
        BLangVariableReference expr;
        if (iExpr.expr == null) {
            expr = new BLangSimpleVarRef();
        } else {
            BLangFieldBasedAccess fieldBasedAccess = new BLangFieldBasedAccess();
            fieldBasedAccess.expr = iExpr.expr;
            fieldBasedAccess.field = iExpr.name;
            expr = fieldBasedAccess;
        }
        expr.symbol = iExpr.symbol;
        expr.type = iExpr.symbol.type;
        BLangSimpleVarRef rewritten = this.rewriteExpr(expr);
        this.result = new BLangInvocation.BFunctionPointerInvocation(iExpr, rewritten);
    }

    private BLangExpression visitCloneInvocation(BLangExpression expr, BType lhsType) {
        if (this.types.isValueType(expr.type)) {
            return expr;
        }
        if (expr.type.tag == 27) {
            return expr;
        }
        BLangInvocation cloneInvok = this.createLangLibInvocationNode("clone", expr, new ArrayList<BLangExpression>(), expr.type, expr.pos);
        return this.addConversionExprIfRequired(cloneInvok, lhsType);
    }

    private BLangExpression visitCloneReadonly(BLangExpression expr, BType lhsType) {
        if (this.types.isValueType(expr.type)) {
            return expr;
        }
        if (expr.type.tag == 27) {
            return expr;
        }
        BLangInvocation cloneInvok = this.createLangLibInvocationNode("cloneReadOnly", expr, new ArrayList<BLangExpression>(), expr.type, expr.pos);
        return this.addConversionExprIfRequired(cloneInvok, lhsType);
    }

    <E extends BLangNode> E rewrite(E node, SymbolEnv env) {
        if (node == null) {
            return null;
        }
        if (node.desugared) {
            return node;
        }
        SymbolEnv previousEnv = this.env;
        this.env = env;
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        resultNode.desugared = true;
        this.env = previousEnv;
        return (E)resultNode;
    }

    <E extends BLangExpression> E rewriteExpr(E node) {
        if (node == null) {
            return null;
        }
        if (node.desugared) {
            return node;
        }
        Object expr = node;
        if (node.impConversionExpr != null) {
            expr = node.impConversionExpr;
            node.impConversionExpr = null;
        }
        expr.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        resultNode.desugared = true;
        return (E)((BLangExpression)resultNode);
    }

    <E extends BLangStatement> E rewrite(E statement, SymbolEnv env) {
        if (statement == null) {
            return null;
        }
        BLangStatement.BLangStatementLink link = new BLangStatement.BLangStatementLink();
        link.parent = this.currentLink;
        this.currentLink = link;
        E stmt = this.rewrite(statement, env);
        link.statement = stmt;
        stmt.statementLink = link;
        this.currentLink = link.parent;
        return stmt;
    }

    private <E extends BLangStatement> List<E> rewriteStmt(List<E> nodeList, SymbolEnv env) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangStatement)nodeList.get(i), env));
        }
        return nodeList;
    }

    private <E extends BLangNode> List<E> rewrite(List<E> nodeList, SymbolEnv env) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangNode)nodeList.get(i), env));
        }
        return nodeList;
    }

    private <E extends BLangExpression> List<E> rewriteExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewriteExpr((BLangExpression)nodeList.get(i)));
        }
        return nodeList;
    }

    private BLangLiteral createStringLiteral(DiagnosticPos pos, String value) {
        BLangLiteral stringLit = new BLangLiteral(value, this.symTable.stringType);
        stringLit.pos = pos;
        return stringLit;
    }

    private BLangLiteral createIntLiteral(long value) {
        BLangLiteral literal = (BLangLiteral)TreeBuilder.createLiteralExpression();
        literal.value = value;
        literal.type = this.symTable.intType;
        return literal;
    }

    private BLangLiteral createByteLiteral(DiagnosticPos pos, Byte value) {
        BLangLiteral byteLiteral = new BLangLiteral(Byte.toUnsignedInt(value), this.symTable.byteType);
        byteLiteral.pos = pos;
        return byteLiteral;
    }

    private BLangExpression createTypeCastExpr(BLangExpression expr, BType targetType) {
        BLangTypeConversionExpr conversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        conversionExpr.pos = expr.pos;
        conversionExpr.expr = expr;
        conversionExpr.type = targetType;
        conversionExpr.targetType = targetType;
        return conversionExpr;
    }

    private BType getElementType(BType type) {
        if (type.tag != 19) {
            return type;
        }
        return this.getElementType(((BArrayType)type).getElementType());
    }

    private void addReturnIfNotPresent(BLangInvokableNode invokableNode) {
        if (Symbols.isNative(invokableNode.symbol) || invokableNode.hasBody() && invokableNode.body.getKind() != NodeKind.BLOCK_FUNCTION_BODY) {
            return;
        }
        BLangBlockFunctionBody funcBody = (BLangBlockFunctionBody)invokableNode.body;
        if (invokableNode.workers.size() == 0 && invokableNode.symbol.type.getReturnType().isNullable() && (funcBody.stmts.size() < 1 || funcBody.stmts.get(funcBody.stmts.size() - 1).getKind() != NodeKind.RETURN)) {
            DiagnosticPos invPos = invokableNode.pos;
            DiagnosticPos returnStmtPos = new DiagnosticPos(invPos.src, invPos.eLine, invPos.eLine, invPos.sCol, invPos.sCol);
            BLangReturn returnStmt = ASTBuilderUtil.createNilReturnStmt(returnStmtPos, this.symTable.nilType);
            funcBody.addStatement(returnStmt);
        }
    }

    private void reorderArguments(BLangInvocation iExpr) {
        BSymbol symbol = iExpr.symbol;
        if (symbol == null || symbol.type.tag != 16) {
            return;
        }
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)symbol;
        if (!invokableSymbol.params.isEmpty()) {
            this.reorderNamedArgs(iExpr, invokableSymbol);
        }
        if (invokableSymbol.restParam == null) {
            return;
        }
        if (iExpr.restArgs.size() == 1 && iExpr.restArgs.get(0).getKind() == NodeKind.REST_ARGS_EXPR) {
            return;
        }
        BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        arrayLiteral.type = invokableSymbol.restParam.type;
        BType elemType = ((BArrayType)arrayLiteral.type).eType;
        ArrayList<BLangExpression> rewrittenRestArgs = new ArrayList<BLangExpression>();
        for (BLangExpression restArg : iExpr.restArgs) {
            rewrittenRestArgs.add(this.addConversionExprIfRequired(restArg, elemType));
        }
        arrayLiteral.exprs = rewrittenRestArgs;
        iExpr.restArgs = new ArrayList<BLangExpression>();
        iExpr.restArgs.add(arrayLiteral);
    }

    private void reorderNamedArgs(BLangInvocation iExpr, BInvokableSymbol invokableSymbol) {
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        HashMap namedArgs = new HashMap();
        iExpr.requiredArgs.stream().filter(expr -> expr.getKind() == NodeKind.NAMED_ARGS_EXPR).forEach(expr -> namedArgs.put(((NamedArgNode)((Object)expr)).getName().value, expr));
        List<BVarSymbol> params = invokableSymbol.params;
        for (int i = 0; i < params.size(); ++i) {
            BVarSymbol param = params.get(i);
            if (iExpr.requiredArgs.size() > i && iExpr.requiredArgs.get(i).getKind() != NodeKind.NAMED_ARGS_EXPR) {
                args.add(iExpr.requiredArgs.get(i));
                continue;
            }
            if (namedArgs.containsKey(param.name.value)) {
                args.add((BLangExpression)namedArgs.get(param.name.value));
                continue;
            }
            BLangIgnoreExpr expr2 = new BLangIgnoreExpr();
            expr2.type = param.type;
            args.add(expr2);
        }
        iExpr.requiredArgs = args;
    }

    private BLangMatch.BLangMatchTypedBindingPatternClause getSafeAssignErrorPattern(DiagnosticPos pos, BSymbol invokableSymbol, List<BType> equivalentErrorTypes, boolean isCheckPanicExpr) {
        final BType enclosingFuncReturnType = ((BInvokableType)invokableSymbol.type).retType;
        Set<BType> returnTypeSet = enclosingFuncReturnType.tag == 20 ? ((BUnionType)enclosingFuncReturnType).getMemberTypes() : new LinkedHashSet<BType>(){
            {
                this.add(enclosingFuncReturnType);
            }
        };
        boolean returnOnError = equivalentErrorTypes.stream().allMatch(errorType -> returnTypeSet.stream().anyMatch(retType -> this.types.isAssignable((BType)errorType, (BType)retType)));
        String patternFailureCaseVarName = Names.GEN_VAR_PREFIX.value + "t_failure";
        BLangSimpleVariable patternFailureCaseVar = ASTBuilderUtil.createVariable(pos, patternFailureCaseVarName, this.symTable.errorType, null, new BVarSymbol(0, this.names.fromString(patternFailureCaseVarName), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner));
        BLangSimpleVarRef patternFailureCaseVarRef = ASTBuilderUtil.createVariableRef(pos, patternFailureCaseVar.symbol);
        BLangBlockStmt patternBlockFailureCase = (BLangBlockStmt)TreeBuilder.createBlockNode();
        patternBlockFailureCase.pos = pos;
        if (!isCheckPanicExpr && returnOnError) {
            BLangReturn returnStmt = (BLangReturn)TreeBuilder.createReturnNode();
            returnStmt.pos = pos;
            returnStmt.expr = patternFailureCaseVarRef;
            patternBlockFailureCase.stmts.add(returnStmt);
        } else {
            BLangPanic panicNode = (BLangPanic)TreeBuilder.createPanicNode();
            panicNode.pos = pos;
            panicNode.expr = patternFailureCaseVarRef;
            patternBlockFailureCase.stmts.add(panicNode);
        }
        return ASTBuilderUtil.createMatchStatementPattern(pos, patternFailureCaseVar, patternBlockFailureCase);
    }

    private BLangMatch.BLangMatchTypedBindingPatternClause getSafeAssignSuccessPattern(DiagnosticPos pos, BType lhsType, boolean isVarDef, BVarSymbol varSymbol, BLangExpression lhsExpr) {
        String patternSuccessCaseVarName = Names.GEN_VAR_PREFIX.value + "t_match";
        BLangSimpleVariable patternSuccessCaseVar = ASTBuilderUtil.createVariable(pos, patternSuccessCaseVarName, lhsType, null, new BVarSymbol(0, this.names.fromString(patternSuccessCaseVarName), this.env.scope.owner.pkgID, lhsType, this.env.scope.owner));
        BLangExpression varRefExpr = isVarDef ? ASTBuilderUtil.createVariableRef(pos, varSymbol) : lhsExpr;
        BLangSimpleVarRef patternSuccessCaseVarRef = ASTBuilderUtil.createVariableRef(pos, patternSuccessCaseVar.symbol);
        final BLangAssignment assignmentStmtSuccessCase = ASTBuilderUtil.createAssignmentStmt(pos, varRefExpr, patternSuccessCaseVarRef, false);
        BLangBlockStmt patternBlockSuccessCase = ASTBuilderUtil.createBlockStmt(pos, (List<BLangStatement>)new ArrayList<BLangStatement>(){
            {
                this.add(assignmentStmtSuccessCase);
            }
        });
        return ASTBuilderUtil.createMatchStatementPattern(pos, patternSuccessCaseVar, patternBlockSuccessCase);
    }

    private BLangStatement generateIfElseStmt(BLangMatch matchStmt, BLangSimpleVariable matchExprVar) {
        BLangIf parentIfNode;
        List<BLangMatch.BLangMatchBindingPatternClause> patterns = matchStmt.patternClauses;
        BLangIf currentIfNode = parentIfNode = this.generateIfElseStmt(patterns.get(0), matchExprVar);
        for (int i = 1; i < patterns.size(); ++i) {
            BLangMatch.BLangMatchBindingPatternClause patternClause = patterns.get(i);
            if (i == patterns.size() - 1 && patternClause.isLastPattern) {
                currentIfNode.elseStmt = this.getMatchPatternElseBody(patternClause, matchExprVar);
                continue;
            }
            currentIfNode.elseStmt = this.generateIfElseStmt(patternClause, matchExprVar);
            currentIfNode = (BLangIf)currentIfNode.elseStmt;
        }
        return parentIfNode;
    }

    private BLangIf generateIfElseStmt(BLangMatch.BLangMatchBindingPatternClause pattern, BLangSimpleVariable matchExprVar) {
        BLangExpression ifCondition = this.createPatternIfCondition(pattern, matchExprVar.symbol);
        if (NodeKind.MATCH_TYPED_PATTERN_CLAUSE == pattern.getKind()) {
            BLangBlockStmt patternBody = this.getMatchPatternBody(pattern, matchExprVar);
            return ASTBuilderUtil.createIfElseStmt(pattern.pos, ifCondition, patternBody, null);
        }
        BType expectedType = matchExprVar.type;
        if (pattern.getKind() == NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE) {
            BLangMatch.BLangMatchStructuredBindingPatternClause matchPattern = (BLangMatch.BLangMatchStructuredBindingPatternClause)pattern;
            expectedType = this.getStructuredBindingPatternType(matchPattern.bindingPatternVariable);
        }
        if (NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE == pattern.getKind()) {
            BLangMatch.BLangMatchStructuredBindingPatternClause structuredPattern = (BLangMatch.BLangMatchStructuredBindingPatternClause)pattern;
            BLangSimpleVariableDef varDef = this.forceCastIfApplicable(matchExprVar.symbol, pattern.pos, expectedType);
            BLangSimpleVarRef matchExprVarRef = ASTBuilderUtil.createVariableRef(pattern.pos, varDef.var.symbol);
            structuredPattern.bindingPatternVariable.expr = matchExprVarRef;
            BLangStatement varDefStmt = NodeKind.TUPLE_VARIABLE == structuredPattern.bindingPatternVariable.getKind() ? ASTBuilderUtil.createTupleVariableDef(pattern.pos, (BLangTupleVariable)structuredPattern.bindingPatternVariable) : (NodeKind.RECORD_VARIABLE == structuredPattern.bindingPatternVariable.getKind() ? ASTBuilderUtil.createRecordVariableDef(pattern.pos, (BLangRecordVariable)structuredPattern.bindingPatternVariable) : (NodeKind.ERROR_VARIABLE == structuredPattern.bindingPatternVariable.getKind() ? ASTBuilderUtil.createErrorVariableDef(pattern.pos, (BLangErrorVariable)structuredPattern.bindingPatternVariable) : ASTBuilderUtil.createVariableDef(pattern.pos, (BLangSimpleVariable)structuredPattern.bindingPatternVariable)));
            if (structuredPattern.typeGuardExpr != null) {
                BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(structuredPattern.pos);
                blockStmt.addStatement(varDef);
                blockStmt.addStatement(varDefStmt);
                BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, structuredPattern.typeGuardExpr);
                stmtExpr.type = this.symTable.booleanType;
                ifCondition = ASTBuilderUtil.createBinaryExpr(pattern.pos, ifCondition, stmtExpr, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
            } else {
                structuredPattern.body.stmts.add(0, varDef);
                structuredPattern.body.stmts.add(1, varDefStmt);
            }
        }
        return ASTBuilderUtil.createIfElseStmt(pattern.pos, ifCondition, pattern.body, null);
    }

    private BLangBlockStmt getMatchPatternBody(BLangMatch.BLangMatchBindingPatternClause pattern, BLangSimpleVariable matchExprVar) {
        BLangMatch.BLangMatchTypedBindingPatternClause patternClause = (BLangMatch.BLangMatchTypedBindingPatternClause)pattern;
        if (patternClause.variable.name.value.equals(Names.IGNORE.value)) {
            return patternClause.body;
        }
        BLangSimpleVarRef matchExprVarRef = ASTBuilderUtil.createVariableRef(patternClause.pos, matchExprVar.symbol);
        BLangExpression patternVarExpr = this.addConversionExprIfRequired(matchExprVarRef, patternClause.variable.type);
        BLangSimpleVariable patternVar = ASTBuilderUtil.createVariable(patternClause.pos, "", patternClause.variable.type, patternVarExpr, patternClause.variable.symbol);
        BLangSimpleVariableDef patternVarDef = ASTBuilderUtil.createVariableDef(patternVar.pos, patternVar);
        patternClause.body.stmts.add(0, patternVarDef);
        BLangBlockStmt body = patternClause.body;
        return body;
    }

    private BLangBlockStmt getMatchPatternElseBody(BLangMatch.BLangMatchBindingPatternClause pattern, BLangSimpleVariable matchExprVar) {
        BLangBlockStmt body = pattern.body;
        if (NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE == pattern.getKind()) {
            BLangSimpleVarRef matchExprVarRef = ASTBuilderUtil.createVariableRef(pattern.pos, matchExprVar.symbol);
            BLangMatch.BLangMatchStructuredBindingPatternClause structuredPattern = (BLangMatch.BLangMatchStructuredBindingPatternClause)pattern;
            structuredPattern.bindingPatternVariable.expr = matchExprVarRef;
            BLangStatement varDefStmt = NodeKind.TUPLE_VARIABLE == structuredPattern.bindingPatternVariable.getKind() ? ASTBuilderUtil.createTupleVariableDef(pattern.pos, (BLangTupleVariable)structuredPattern.bindingPatternVariable) : (NodeKind.RECORD_VARIABLE == structuredPattern.bindingPatternVariable.getKind() ? ASTBuilderUtil.createRecordVariableDef(pattern.pos, (BLangRecordVariable)structuredPattern.bindingPatternVariable) : (NodeKind.ERROR_VARIABLE == structuredPattern.bindingPatternVariable.getKind() ? ASTBuilderUtil.createErrorVariableDef(pattern.pos, (BLangErrorVariable)structuredPattern.bindingPatternVariable) : ASTBuilderUtil.createVariableDef(pattern.pos, (BLangSimpleVariable)structuredPattern.bindingPatternVariable)));
            structuredPattern.body.stmts.add(0, varDefStmt);
            body = structuredPattern.body;
        }
        return body;
    }

    BLangExpression addConversionExprIfRequired(BLangExpression expr, BType lhsType) {
        if (lhsType.tag == 22) {
            return expr;
        }
        BType rhsType = expr.type;
        if (this.types.isSameType(rhsType, lhsType)) {
            return expr;
        }
        this.types.setImplicitCastExpr(expr, rhsType, lhsType);
        if (expr.impConversionExpr != null) {
            return expr;
        }
        if (lhsType.tag == 7 && rhsType.tag == 10) {
            return expr;
        }
        if (lhsType.tag == 10 && rhsType.isNullable()) {
            return expr;
        }
        if (lhsType.tag == 19 && rhsType.tag == 29) {
            return expr;
        }
        BLangTypeConversionExpr conversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        conversionExpr.expr = expr;
        conversionExpr.targetType = lhsType;
        conversionExpr.type = lhsType;
        conversionExpr.pos = expr.pos;
        conversionExpr.checkTypes = false;
        return conversionExpr;
    }

    private BLangExpression createPatternIfCondition(BLangMatch.BLangMatchBindingPatternClause patternClause, BVarSymbol varSymbol) {
        BLangExpression binaryExpr;
        BType[] memberTypes;
        BType patternType;
        switch (patternClause.getKind()) {
            case MATCH_STATIC_PATTERN_CLAUSE: {
                BLangMatch.BLangMatchStaticBindingPatternClause staticPattern = (BLangMatch.BLangMatchStaticBindingPatternClause)patternClause;
                patternType = staticPattern.literal.type;
                break;
            }
            case MATCH_STRUCTURED_PATTERN_CLAUSE: {
                BLangMatch.BLangMatchStructuredBindingPatternClause structuredPattern = (BLangMatch.BLangMatchStructuredBindingPatternClause)patternClause;
                patternType = this.getStructuredBindingPatternType(structuredPattern.bindingPatternVariable);
                break;
            }
            default: {
                BLangMatch.BLangMatchTypedBindingPatternClause simplePattern = (BLangMatch.BLangMatchTypedBindingPatternClause)patternClause;
                patternType = simplePattern.variable.type;
            }
        }
        if (patternType.tag == 20) {
            BUnionType unionType = (BUnionType)patternType;
            memberTypes = unionType.getMemberTypes().toArray(new BType[0]);
        } else {
            memberTypes = new BType[]{patternType};
        }
        if (memberTypes.length == 1) {
            binaryExpr = this.createPatternMatchBinaryExpr(patternClause, varSymbol, memberTypes[0]);
        } else {
            BLangExpression lhsExpr = this.createPatternMatchBinaryExpr(patternClause, varSymbol, memberTypes[0]);
            BLangExpression rhsExpr = this.createPatternMatchBinaryExpr(patternClause, varSymbol, memberTypes[1]);
            binaryExpr = ASTBuilderUtil.createBinaryExpr(patternClause.pos, lhsExpr, rhsExpr, this.symTable.booleanType, OperatorKind.OR, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.OR, lhsExpr.type, rhsExpr.type));
            for (int i = 2; i < memberTypes.length; ++i) {
                lhsExpr = this.createPatternMatchBinaryExpr(patternClause, varSymbol, memberTypes[i]);
                rhsExpr = binaryExpr;
                binaryExpr = ASTBuilderUtil.createBinaryExpr(patternClause.pos, lhsExpr, rhsExpr, this.symTable.booleanType, OperatorKind.OR, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.OR, lhsExpr.type, rhsExpr.type));
            }
        }
        return binaryExpr;
    }

    private BType getStructuredBindingPatternType(BLangVariable bindingPatternVariable) {
        if (NodeKind.TUPLE_VARIABLE == bindingPatternVariable.getKind()) {
            BLangTupleVariable tupleVariable = (BLangTupleVariable)bindingPatternVariable;
            ArrayList<BType> memberTypes = new ArrayList<BType>();
            for (int i = 0; i < tupleVariable.memberVariables.size(); ++i) {
                memberTypes.add(this.getStructuredBindingPatternType(tupleVariable.memberVariables.get(i)));
            }
            BTupleType tupleType = new BTupleType(memberTypes);
            if (tupleVariable.restVariable != null) {
                BArrayType restArrayType = (BArrayType)this.getStructuredBindingPatternType(tupleVariable.restVariable);
                tupleType.restType = restArrayType.eType;
            }
            return tupleType;
        }
        if (NodeKind.RECORD_VARIABLE == bindingPatternVariable.getKind()) {
            BLangRecordVariable recordVariable = (BLangRecordVariable)bindingPatternVariable;
            BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(0, this.names.fromString("$anonRecordType$" + this.recordCount++), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
            recordSymbol.initializerFunc = this.createRecordInitFunc();
            recordSymbol.scope = new Scope(recordSymbol);
            recordSymbol.scope.define(this.names.fromString(recordSymbol.name.value + "." + recordSymbol.initializerFunc.funcName.value), recordSymbol.initializerFunc.symbol);
            ArrayList<BField> fields = new ArrayList<BField>();
            ArrayList<BLangSimpleVariable> typeDefFields = new ArrayList<BLangSimpleVariable>();
            for (int i = 0; i < recordVariable.variableList.size(); ++i) {
                String fieldNameStr = recordVariable.variableList.get((int)i).key.value;
                Name fieldName = this.names.fromString(fieldNameStr);
                BType fieldType = this.getStructuredBindingPatternType(recordVariable.variableList.get((int)i).valueBindingPattern);
                BVarSymbol fieldSymbol = new BVarSymbol(256, fieldName, this.env.enclPkg.symbol.pkgID, fieldType, recordSymbol);
                fields.add(new BField(fieldName, bindingPatternVariable.pos, fieldSymbol));
                typeDefFields.add(ASTBuilderUtil.createVariable(null, fieldNameStr, fieldType, null, fieldSymbol));
                recordSymbol.scope.define(fieldName, fieldSymbol);
            }
            BRecordType recordVarType = new BRecordType(recordSymbol);
            recordVarType.fields = fields;
            recordVarType.restFieldType = recordVariable.restParam != null ? ((BMapType)((BLangSimpleVariable)recordVariable.restParam).type).constraint : this.symTable.anydataType;
            recordSymbol.type = recordVarType;
            recordVarType.tsymbol = recordSymbol;
            BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(typeDefFields, recordVarType, bindingPatternVariable.pos);
            recordTypeNode.initFunction = this.rewrite(TypeDefBuilderHelper.createInitFunctionForRecordType(recordTypeNode, this.env, this.names, this.symTable), this.env);
            TypeDefBuilderHelper.addTypeDefinition(recordVarType, recordSymbol, recordTypeNode, this.env);
            return recordVarType;
        }
        if (NodeKind.ERROR_VARIABLE == bindingPatternVariable.getKind()) {
            BType detailType;
            BLangErrorVariable errorVariable = (BLangErrorVariable)bindingPatternVariable;
            BErrorTypeSymbol errorTypeSymbol = new BErrorTypeSymbol(589852, 1, this.names.fromString("$anonErrorType$" + this.errorCount++), this.env.enclPkg.symbol.pkgID, null, null);
            if ((errorVariable.detail == null || errorVariable.detail.isEmpty()) && errorVariable.restDetail != null) {
                detailType = this.symTable.detailType;
            } else {
                detailType = this.createDetailType(errorVariable.detail, errorVariable.restDetail, this.errorCount++);
                BLangRecordTypeNode recordTypeNode = this.createRecordTypeNode(errorVariable, (BRecordType)detailType);
                TypeDefBuilderHelper.addTypeDefinition(detailType, detailType.tsymbol, recordTypeNode, this.env);
            }
            BErrorType errorType = new BErrorType(errorTypeSymbol, ((BErrorType)errorVariable.type).reasonType, detailType);
            errorTypeSymbol.type = errorType;
            TypeDefBuilderHelper.addTypeDefinition(errorType, errorTypeSymbol, this.createErrorTypeNode(errorType), this.env);
            return errorType;
        }
        return bindingPatternVariable.type;
    }

    private BLangRecordTypeNode createRecordTypeNode(BLangErrorVariable errorVariable, BRecordType detailType) {
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BLangErrorVariable.BLangErrorDetailEntry field : errorVariable.detail) {
            BVarSymbol symbol = field.valueBindingPattern.symbol;
            if (symbol == null) {
                symbol = new BVarSymbol(1, this.names.fromString(field.key.value + "$"), this.env.enclPkg.packageID, this.symTable.pureType, null);
            }
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.valueBindingPattern.pos, symbol.name.value, field.valueBindingPattern.type, field.valueBindingPattern.expr, symbol);
            fieldList.add(fieldVar);
        }
        return TypeDefBuilderHelper.createRecordTypeNode(fieldList, detailType, errorVariable.pos);
    }

    private BType createDetailType(List<BLangErrorVariable.BLangErrorDetailEntry> detail, BLangSimpleVariable restDetail, int errorNo) {
        BRecordTypeSymbol detailRecordTypeSymbol = new BRecordTypeSymbol(327772, 1, this.names.fromString("$anonErrorType$" + errorNo + "$detailType"), this.env.enclPkg.symbol.pkgID, null, null);
        detailRecordTypeSymbol.initializerFunc = this.createRecordInitFunc();
        detailRecordTypeSymbol.scope = new Scope(detailRecordTypeSymbol);
        detailRecordTypeSymbol.scope.define(this.names.fromString(detailRecordTypeSymbol.name.value + "." + detailRecordTypeSymbol.initializerFunc.funcName.value), detailRecordTypeSymbol.initializerFunc.symbol);
        BRecordType detailRecordType = new BRecordType(detailRecordTypeSymbol);
        detailRecordType.restFieldType = this.symTable.anydataType;
        if (restDetail == null) {
            detailRecordType.sealed = true;
        }
        for (BLangErrorVariable.BLangErrorDetailEntry detailEntry : detail) {
            Name fieldName = this.names.fromIdNode(detailEntry.key);
            BType fieldType = this.getStructuredBindingPatternType(detailEntry.valueBindingPattern);
            BVarSymbol fieldSym = new BVarSymbol(1, fieldName, detailRecordTypeSymbol.pkgID, fieldType, detailRecordTypeSymbol);
            detailRecordType.fields.add(new BField(fieldName, detailEntry.key.pos, fieldSym));
            detailRecordTypeSymbol.scope.define(fieldName, fieldSym);
        }
        return detailRecordType;
    }

    private BAttachedFunction createRecordInitFunc() {
        BInvokableType bInvokableType = new BInvokableType(new ArrayList<BType>(), this.symTable.nilType, null);
        BInvokableSymbol initFuncSymbol = Symbols.createFunctionSymbol(1, Names.EMPTY, this.env.enclPkg.symbol.pkgID, bInvokableType, this.env.scope.owner, false);
        initFuncSymbol.retType = this.symTable.nilType;
        return new BAttachedFunction(Names.INIT_FUNCTION_SUFFIX, initFuncSymbol, bInvokableType);
    }

    BLangErrorType createErrorTypeNode(BErrorType errorType) {
        BLangErrorType errorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorTypeNode.type = errorType;
        return errorTypeNode;
    }

    private BLangExpression createPatternMatchBinaryExpr(BLangMatch.BLangMatchBindingPatternClause patternClause, BVarSymbol varSymbol, BType patternType) {
        DiagnosticPos pos = patternClause.pos;
        BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, varSymbol);
        if (NodeKind.MATCH_STATIC_PATTERN_CLAUSE == patternClause.getKind()) {
            BLangMatch.BLangMatchStaticBindingPatternClause pattern = (BLangMatch.BLangMatchStaticBindingPatternClause)patternClause;
            return this.createBinaryExpression(pos, varRef, pattern.literal);
        }
        if (NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE == patternClause.getKind()) {
            return this.createIsLikeExpression(pos, ASTBuilderUtil.createVariableRef(pos, varSymbol), patternType);
        }
        if (patternType == this.symTable.nilType) {
            BLangLiteral bLangLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, null);
            return ASTBuilderUtil.createBinaryExpr(pos, varRef, bLangLiteral, this.symTable.booleanType, OperatorKind.EQUAL, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.EQUAL, this.symTable.anyType, this.symTable.nilType));
        }
        return this.createIsAssignableExpression(pos, varSymbol, patternType);
    }

    private BLangExpression createBinaryExpression(DiagnosticPos pos, BLangSimpleVarRef varRef, BLangExpression expression) {
        BLangBinaryExpr binaryExpr;
        if (NodeKind.GROUP_EXPR == expression.getKind()) {
            return this.createBinaryExpression(pos, varRef, ((BLangGroupExpr)expression).expression);
        }
        if (NodeKind.BINARY_EXPR == expression.getKind()) {
            binaryExpr = (BLangBinaryExpr)expression;
            BLangExpression lhsExpr = this.createBinaryExpression(pos, varRef, binaryExpr.lhsExpr);
            BLangExpression rhsExpr = this.createBinaryExpression(pos, varRef, binaryExpr.rhsExpr);
            binaryExpr = ASTBuilderUtil.createBinaryExpr(pos, lhsExpr, rhsExpr, this.symTable.booleanType, OperatorKind.OR, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.OR, this.symTable.booleanType, this.symTable.booleanType));
        } else {
            if (expression.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)expression).variableName.value.equals(Names.IGNORE.value)) {
                BLangValueType anyType = (BLangValueType)TreeBuilder.createValueTypeNode();
                anyType.type = this.symTable.anyType;
                anyType.typeKind = TypeKind.ANY;
                return ASTBuilderUtil.createTypeTestExpr(pos, varRef, anyType);
            }
            binaryExpr = ASTBuilderUtil.createBinaryExpr(pos, varRef, expression, this.symTable.booleanType, OperatorKind.EQUAL, null);
            BSymbol opSymbol = this.symResolver.resolveBinaryOperator(OperatorKind.EQUAL, varRef.type, expression.type);
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBinaryEqualityForTypeSets(OperatorKind.EQUAL, this.symTable.anydataType, expression.type, binaryExpr);
            }
            binaryExpr.opSymbol = (BOperatorSymbol)opSymbol;
        }
        return binaryExpr;
    }

    private BLangIsAssignableExpr createIsAssignableExpression(DiagnosticPos pos, BVarSymbol varSymbol, BType patternType) {
        BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, varSymbol);
        return ASTBuilderUtil.createIsAssignableExpr(pos, varRef, patternType, this.symTable.booleanType, this.names);
    }

    private BLangIsLikeExpr createIsLikeExpression(DiagnosticPos pos, BLangExpression expr, BType type) {
        return ASTBuilderUtil.createIsLikeExpr(pos, expr, ASTBuilderUtil.createTypeNode(type), this.symTable.booleanType);
    }

    private BLangAssignment createAssignmentStmt(BLangSimpleVariable variable) {
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        varRef.pos = variable.pos;
        varRef.variableName = variable.name;
        varRef.symbol = variable.symbol;
        varRef.type = variable.type;
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        assignmentStmt.expr = variable.expr;
        assignmentStmt.pos = variable.pos;
        assignmentStmt.setVariable(varRef);
        return assignmentStmt;
    }

    private BLangAssignment createStructFieldUpdate(BLangFunction function, BLangSimpleVariable variable, BVarSymbol symbol) {
        BLangSimpleVarRef selfVarRef = ASTBuilderUtil.createVariableRef(variable.pos, symbol);
        BLangFieldBasedAccess fieldAccess = ASTBuilderUtil.createFieldAccessExpr(selfVarRef, variable.name);
        fieldAccess.symbol = variable.symbol;
        fieldAccess.type = variable.type;
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        assignmentStmt.expr = variable.expr;
        assignmentStmt.pos = variable.pos;
        assignmentStmt.setVariable(fieldAccess);
        SymbolEnv initFuncEnv = SymbolEnv.createFunctionEnv(function, function.symbol.scope, this.env);
        return this.rewrite(assignmentStmt, initFuncEnv);
    }

    private void addMatchExprDefaultCase(BLangMatchExpression bLangMatchExpression) {
        List<BType> exprTypes;
        ArrayList<BType> unmatchedTypes = new ArrayList<BType>();
        if (bLangMatchExpression.expr.type.tag == 20) {
            BUnionType unionType = (BUnionType)bLangMatchExpression.expr.type;
            exprTypes = new ArrayList<BType>(unionType.getMemberTypes());
        } else {
            exprTypes = Lists.of(bLangMatchExpression.type);
        }
        for (BType type : exprTypes) {
            boolean assignable = false;
            for (BLangMatchExpression.BLangMatchExprPatternClause pattern : bLangMatchExpression.patternClauses) {
                if (!this.types.isAssignable(type, pattern.variable.type)) continue;
                assignable = true;
                break;
            }
            if (assignable) continue;
            unmatchedTypes.add(type);
        }
        if (unmatchedTypes.isEmpty()) {
            return;
        }
        BType defaultPatternType = unmatchedTypes.size() == 1 ? (BType)unmatchedTypes.get(0) : BUnionType.create(null, new LinkedHashSet<BType>(unmatchedTypes));
        String patternCaseVarName = Names.GEN_VAR_PREFIX.value + "t_match_default";
        BLangSimpleVariable patternMatchCaseVar = ASTBuilderUtil.createVariable(bLangMatchExpression.pos, patternCaseVarName, defaultPatternType, null, new BVarSymbol(0, this.names.fromString(patternCaseVarName), this.env.scope.owner.pkgID, defaultPatternType, this.env.scope.owner));
        BLangMatchExpression.BLangMatchExprPatternClause defaultPattern = (BLangMatchExpression.BLangMatchExprPatternClause)TreeBuilder.createMatchExpressionPattern();
        defaultPattern.variable = patternMatchCaseVar;
        defaultPattern.expr = ASTBuilderUtil.createVariableRef(bLangMatchExpression.pos, patternMatchCaseVar.symbol);
        defaultPattern.pos = bLangMatchExpression.pos;
        bLangMatchExpression.patternClauses.add(defaultPattern);
    }

    private boolean safeNavigate(BLangAccessExpression accessExpr) {
        if (accessExpr.lhsVar || accessExpr.expr == null) {
            return false;
        }
        if (accessExpr.errorSafeNavigation || accessExpr.nilSafeNavigation) {
            return true;
        }
        NodeKind kind = accessExpr.expr.getKind();
        if (kind == NodeKind.FIELD_BASED_ACCESS_EXPR || kind == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            return this.safeNavigate((BLangAccessExpression)accessExpr.expr);
        }
        return false;
    }

    private BLangExpression rewriteSafeNavigationExpr(BLangAccessExpression accessExpr) {
        BType originalExprType = accessExpr.type;
        String matchTempResultVarName = Names.GEN_VAR_PREFIX.value + "temp_result";
        BLangSimpleVariable tempResultVar = ASTBuilderUtil.createVariable(accessExpr.pos, matchTempResultVarName, accessExpr.type, null, new BVarSymbol(0, this.names.fromString(matchTempResultVarName), this.env.scope.owner.pkgID, accessExpr.type, this.env.scope.owner));
        BLangSimpleVariableDef tempResultVarDef = ASTBuilderUtil.createVariableDef(accessExpr.pos, tempResultVar);
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(accessExpr.pos, tempResultVar.symbol);
        this.handleSafeNavigation(accessExpr, accessExpr.type, tempResultVar);
        BLangMatch matcEXpr = (BLangMatch)this.matchStmtStack.firstElement();
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(accessExpr.pos, Lists.of(tempResultVarDef, matcEXpr));
        BLangStatementExpression stmtExpression = ASTBuilderUtil.createStatementExpression(blockStmt, tempResultVarRef);
        stmtExpression.type = originalExprType;
        this.matchStmtStack = new Stack();
        this.accessExprStack = new Stack();
        this.successPattern = null;
        this.safeNavigationAssignment = null;
        return stmtExpression;
    }

    private void handleSafeNavigation(BLangAccessExpression accessExpr, BType type, BLangSimpleVariable tempResultVar) {
        if (accessExpr.expr == null) {
            return;
        }
        NodeKind kind = accessExpr.expr.getKind();
        if (kind == NodeKind.FIELD_BASED_ACCESS_EXPR || kind == NodeKind.INDEX_BASED_ACCESS_EXPR || kind == NodeKind.INVOCATION) {
            this.handleSafeNavigation((BLangAccessExpression)accessExpr.expr, type, tempResultVar);
        }
        if (!accessExpr.errorSafeNavigation && !accessExpr.nilSafeNavigation) {
            BType originalType = accessExpr.originalType;
            accessExpr.type = TypeTags.isXMLTypeTag(originalType.tag) ? BUnionType.create(null, originalType, this.symTable.errorType) : originalType;
            if (this.safeNavigationAssignment != null) {
                this.safeNavigationAssignment.expr = this.addConversionExprIfRequired(accessExpr, tempResultVar.type);
            }
            return;
        }
        BLangMatch matchStmt = ASTBuilderUtil.createMatchStatement(accessExpr.pos, accessExpr.expr, new ArrayList<BLangMatch.BLangMatchTypedBindingPatternClause>());
        if (accessExpr.nilSafeNavigation) {
            matchStmt.patternClauses.add(this.getMatchNullPattern(accessExpr, tempResultVar));
            matchStmt.type = type;
        }
        if (accessExpr.errorSafeNavigation) {
            matchStmt.patternClauses.add(this.getMatchErrorPattern(accessExpr, tempResultVar));
            matchStmt.type = type;
            matchStmt.pos = accessExpr.pos;
        }
        BLangMatch.BLangMatchTypedBindingPatternClause successPattern = this.getSuccessPattern(accessExpr, tempResultVar, accessExpr.errorSafeNavigation);
        matchStmt.patternClauses.add(successPattern);
        this.matchStmtStack.push(matchStmt);
        if (this.successPattern != null) {
            this.successPattern.body = ASTBuilderUtil.createBlockStmt(accessExpr.pos, Lists.of(matchStmt));
        }
        this.successPattern = successPattern;
    }

    private BLangMatch.BLangMatchTypedBindingPatternClause getMatchErrorPattern(BLangExpression expr, BLangSimpleVariable tempResultVar) {
        String errorPatternVarName = Names.GEN_VAR_PREFIX.value + "t_match_error";
        BLangSimpleVariable errorPatternVar = ASTBuilderUtil.createVariable(expr.pos, errorPatternVarName, this.symTable.errorType, null, new BVarSymbol(0, this.names.fromString(errorPatternVarName), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner));
        BLangSimpleVarRef assignmentRhsExpr = ASTBuilderUtil.createVariableRef(expr.pos, errorPatternVar.symbol);
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(expr.pos, tempResultVar.symbol);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(expr.pos, tempResultVarRef, assignmentRhsExpr, false);
        BLangBlockStmt patternBody = ASTBuilderUtil.createBlockStmt(expr.pos, Lists.of(assignmentStmt));
        BLangMatch.BLangMatchTypedBindingPatternClause errorPattern = ASTBuilderUtil.createMatchStatementPattern(expr.pos, errorPatternVar, patternBody);
        return errorPattern;
    }

    private BLangMatchExpression.BLangMatchExprPatternClause getMatchNullPatternGivenExpression(DiagnosticPos pos, BLangExpression expr) {
        String nullPatternVarName = Names.IGNORE.toString();
        BLangSimpleVariable errorPatternVar = ASTBuilderUtil.createVariable(pos, nullPatternVarName, this.symTable.nilType, null, new BVarSymbol(0, this.names.fromString(nullPatternVarName), this.env.scope.owner.pkgID, this.symTable.nilType, this.env.scope.owner));
        BLangMatchExpression.BLangMatchExprPatternClause nullPattern = (BLangMatchExpression.BLangMatchExprPatternClause)TreeBuilder.createMatchExpressionPattern();
        nullPattern.variable = errorPatternVar;
        nullPattern.expr = expr;
        nullPattern.pos = pos;
        return nullPattern;
    }

    private BLangMatch.BLangMatchTypedBindingPatternClause getMatchNullPattern(BLangExpression expr, BLangSimpleVariable tempResultVar) {
        String nullPatternVarName = Names.GEN_VAR_PREFIX.value + "t_match_null";
        BLangSimpleVariable nullPatternVar = ASTBuilderUtil.createVariable(expr.pos, nullPatternVarName, this.symTable.nilType, null, new BVarSymbol(0, this.names.fromString(nullPatternVarName), this.env.scope.owner.pkgID, this.symTable.nilType, this.env.scope.owner));
        BLangSimpleVarRef assignmentRhsExpr = ASTBuilderUtil.createVariableRef(expr.pos, nullPatternVar.symbol);
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(expr.pos, tempResultVar.symbol);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(expr.pos, tempResultVarRef, assignmentRhsExpr, false);
        BLangBlockStmt patternBody = ASTBuilderUtil.createBlockStmt(expr.pos, Lists.of(assignmentStmt));
        BLangMatch.BLangMatchTypedBindingPatternClause nullPattern = ASTBuilderUtil.createMatchStatementPattern(expr.pos, nullPatternVar, patternBody);
        return nullPattern;
    }

    private BLangMatch.BLangMatchTypedBindingPatternClause getSuccessPattern(BLangAccessExpression accessExpr, BLangSimpleVariable tempResultVar, boolean liftError) {
        BType type = this.types.getSafeType(accessExpr.expr.type, true, liftError);
        String successPatternVarName = Names.GEN_VAR_PREFIX.value + "t_match_success";
        BVarSymbol successPatternSymbol = type.tag == 16 ? new BInvokableSymbol(52, 0, this.names.fromString(successPatternVarName), this.env.scope.owner.pkgID, type, this.env.scope.owner) : new BVarSymbol(0, this.names.fromString(successPatternVarName), this.env.scope.owner.pkgID, type, this.env.scope.owner);
        BLangSimpleVariable successPatternVar = ASTBuilderUtil.createVariable(accessExpr.pos, successPatternVarName, type, null, successPatternSymbol);
        accessExpr.expr = ASTBuilderUtil.createVariableRef(accessExpr.pos, successPatternVar.symbol);
        accessExpr.errorSafeNavigation = false;
        accessExpr.nilSafeNavigation = false;
        accessExpr.type = TypeTags.isXMLTypeTag(accessExpr.expr.type.tag) ? BUnionType.create(null, accessExpr.originalType, this.symTable.errorType, this.symTable.nilType) : accessExpr.originalType;
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(accessExpr.pos, tempResultVar.symbol);
        BLangExpression assignmentRhsExpr = this.addConversionExprIfRequired(accessExpr, tempResultVarRef.type);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(accessExpr.pos, tempResultVarRef, assignmentRhsExpr, false);
        BLangBlockStmt patternBody = ASTBuilderUtil.createBlockStmt(accessExpr.pos, Lists.of(assignmentStmt));
        BLangMatch.BLangMatchTypedBindingPatternClause successPattern = ASTBuilderUtil.createMatchStatementPattern(accessExpr.pos, successPatternVar, patternBody);
        this.safeNavigationAssignment = assignmentStmt;
        return successPattern;
    }

    private boolean safeNavigateLHS(BLangExpression expr) {
        if (expr.getKind() != NodeKind.FIELD_BASED_ACCESS_EXPR && expr.getKind() != NodeKind.INDEX_BASED_ACCESS_EXPR) {
            return false;
        }
        BLangExpression varRef = ((BLangAccessExpression)expr).expr;
        if (varRef.type.isNullable()) {
            return true;
        }
        return this.safeNavigateLHS(varRef);
    }

    private BLangStatement rewriteSafeNavigationAssignment(BLangAccessExpression accessExpr, BLangExpression rhsExpr, boolean safeAssignment) {
        this.accessExprStack = new Stack();
        ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>();
        this.createLHSSafeNavigation(stmts, accessExpr.expr);
        BLangAssignment assignment = ASTBuilderUtil.createAssignmentStmt(accessExpr.pos, this.cloneExpression(accessExpr), rhsExpr);
        stmts.add(assignment);
        return ASTBuilderUtil.createBlockStmt(accessExpr.pos, stmts);
    }

    private void createLHSSafeNavigation(List<BLangStatement> stmts, BLangExpression expr) {
        NodeKind kind = expr.getKind();
        boolean root = false;
        if (kind == NodeKind.FIELD_BASED_ACCESS_EXPR || kind == NodeKind.INDEX_BASED_ACCESS_EXPR || kind == NodeKind.INVOCATION) {
            BLangAccessExpression accessExpr = (BLangAccessExpression)expr;
            this.createLHSSafeNavigation(stmts, accessExpr.expr);
            accessExpr.expr = this.accessExprStack.pop();
        } else {
            root = true;
        }
        if (expr.getKind() == NodeKind.INVOCATION) {
            BLangInvocation invocation = (BLangInvocation)expr;
            BVarSymbol interMediateSymbol = new BVarSymbol(0, this.names.fromString(Names.GEN_VAR_PREFIX.value + "i_intermediate"), this.env.scope.owner.pkgID, invocation.type, this.env.scope.owner);
            BLangSimpleVariable intermediateVariable = ASTBuilderUtil.createVariable(expr.pos, interMediateSymbol.name.value, invocation.type, invocation, interMediateSymbol);
            BLangSimpleVariableDef intermediateVariableDefinition = ASTBuilderUtil.createVariableDef(invocation.pos, intermediateVariable);
            stmts.add(intermediateVariableDefinition);
            expr = ASTBuilderUtil.createVariableRef(invocation.pos, interMediateSymbol);
        }
        if (expr.type.isNullable()) {
            BLangTypeTestExpr isNillTest = ASTBuilderUtil.createTypeTestExpr(expr.pos, expr, this.getNillTypeNode());
            isNillTest.type = this.symTable.booleanType;
            BLangBlockStmt thenStmt = ASTBuilderUtil.createBlockStmt(expr.pos);
            expr = this.cloneExpression(expr);
            expr.type = this.types.getSafeType(expr.type, true, false);
            if (this.isDefaultableMappingType(expr.type) && !root) {
                BLangRecordLiteral jsonLiteral = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
                jsonLiteral.type = expr.type;
                jsonLiteral.pos = expr.pos;
                BLangAssignment assignment = ASTBuilderUtil.createAssignmentStmt(expr.pos, expr, jsonLiteral);
                thenStmt.addStatement(assignment);
            } else {
                BLangLiteral literal = (BLangLiteral)TreeBuilder.createLiteralExpression();
                literal.value = ERROR_REASON_NULL_REFERENCE_ERROR;
                literal.type = this.symTable.stringType;
                BLangInvocation errorCtorInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
                errorCtorInvocation.pos = expr.pos;
                errorCtorInvocation.argExprs.add(literal);
                errorCtorInvocation.requiredArgs.add(literal);
                errorCtorInvocation.type = this.symTable.errorType;
                errorCtorInvocation.symbol = this.symTable.errorConstructor;
                BLangPanic panicNode = (BLangPanic)TreeBuilder.createPanicNode();
                panicNode.expr = errorCtorInvocation;
                panicNode.pos = expr.pos;
                thenStmt.addStatement(panicNode);
            }
            BLangIf ifelse = ASTBuilderUtil.createIfElseStmt(expr.pos, isNillTest, thenStmt, null);
            stmts.add(ifelse);
        }
        this.accessExprStack.push(expr);
    }

    BLangValueType getNillTypeNode() {
        BLangValueType nillTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        nillTypeNode.typeKind = TypeKind.NIL;
        nillTypeNode.type = this.symTable.nilType;
        return nillTypeNode;
    }

    private BLangVariableReference cloneExpression(BLangExpression expr) {
        switch (expr.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                return ASTBuilderUtil.createVariableRef(expr.pos, ((BLangSimpleVarRef)expr).symbol);
            }
            case FIELD_BASED_ACCESS_EXPR: 
            case INDEX_BASED_ACCESS_EXPR: 
            case INVOCATION: {
                return this.cloneAccessExpr((BLangAccessExpression)expr);
            }
        }
        throw new IllegalStateException();
    }

    private BLangAccessExpression cloneAccessExpr(BLangAccessExpression originalAccessExpr) {
        BLangAccessExpression accessExpr;
        if (originalAccessExpr.expr == null) {
            return originalAccessExpr;
        }
        NodeKind kind = originalAccessExpr.expr.getKind();
        BLangVariableReference varRef = kind == NodeKind.FIELD_BASED_ACCESS_EXPR || kind == NodeKind.INDEX_BASED_ACCESS_EXPR || kind == NodeKind.INVOCATION ? this.cloneAccessExpr((BLangAccessExpression)originalAccessExpr.expr) : this.cloneExpression(originalAccessExpr.expr);
        varRef.type = this.types.getSafeType(originalAccessExpr.expr.type, true, false);
        switch (originalAccessExpr.getKind()) {
            case FIELD_BASED_ACCESS_EXPR: {
                accessExpr = ASTBuilderUtil.createFieldAccessExpr(varRef, ((BLangFieldBasedAccess)originalAccessExpr).field);
                break;
            }
            case INDEX_BASED_ACCESS_EXPR: {
                accessExpr = ASTBuilderUtil.createIndexAccessExpr(varRef, ((BLangIndexBasedAccess)originalAccessExpr).indexExpr);
                break;
            }
            case INVOCATION: {
                accessExpr = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        accessExpr.originalType = originalAccessExpr.originalType;
        accessExpr.pos = originalAccessExpr.pos;
        accessExpr.lhsVar = originalAccessExpr.lhsVar;
        accessExpr.symbol = originalAccessExpr.symbol;
        accessExpr.errorSafeNavigation = false;
        accessExpr.nilSafeNavigation = false;
        accessExpr.type = originalAccessExpr.originalType;
        return accessExpr;
    }

    private BLangBinaryExpr getModifiedIntRangeStartExpr(BLangExpression expr) {
        BLangLiteral constOneLiteral = ASTBuilderUtil.createLiteral(expr.pos, this.symTable.intType, 1L);
        return ASTBuilderUtil.createBinaryExpr(expr.pos, expr, constOneLiteral, this.symTable.intType, OperatorKind.ADD, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.ADD, this.symTable.intType, this.symTable.intType));
    }

    private BLangBinaryExpr getModifiedIntRangeEndExpr(BLangExpression expr) {
        BLangLiteral constOneLiteral = ASTBuilderUtil.createLiteral(expr.pos, this.symTable.intType, 1L);
        return ASTBuilderUtil.createBinaryExpr(expr.pos, expr, constOneLiteral, this.symTable.intType, OperatorKind.SUB, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.SUB, this.symTable.intType, this.symTable.intType));
    }

    private BLangLiteral getBooleanLiteral(boolean value) {
        BLangLiteral literal = (BLangLiteral)TreeBuilder.createLiteralExpression();
        literal.value = value;
        literal.type = this.symTable.booleanType;
        return literal;
    }

    private boolean isDefaultableMappingType(BType type) {
        switch (this.types.getSafeType((BType)type, (boolean)true, (boolean)false).tag) {
            case 7: 
            case 12: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private BLangFunction createInitFunctionForObjectType(BLangObjectTypeNode structureTypeNode, SymbolEnv env) {
        BLangFunction initFunction = TypeDefBuilderHelper.createInitFunctionForStructureType(structureTypeNode, env, Names.GENERATED_INIT_SUFFIX, this.names, this.symTable);
        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)structureTypeNode.type.tsymbol;
        typeSymbol.generatedInitializerFunc = new BAttachedFunction(Names.GENERATED_INIT_SUFFIX, initFunction.symbol, (BInvokableType)initFunction.type);
        structureTypeNode.generatedInitFunction = initFunction;
        initFunction.returnTypeNode.type = this.symTable.nilType;
        return this.rewrite(initFunction, env);
    }

    private void visitBinaryLogicalExpr(BLangBinaryExpr binaryExpr) {
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$result$", binaryExpr.type, null, binaryExpr.pos);
        BLangBlockStmt thenBody = ASTBuilderUtil.createBlockStmt(binaryExpr.pos);
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(binaryExpr.pos);
        BLangSimpleVarRef thenResultVarRef = ASTBuilderUtil.createVariableRef(binaryExpr.pos, resultVarDef.var.symbol);
        BLangExpression thenResult = binaryExpr.opKind == OperatorKind.AND ? binaryExpr.rhsExpr : this.getBooleanLiteral(true);
        BLangAssignment thenAssignment = ASTBuilderUtil.createAssignmentStmt(binaryExpr.pos, thenResultVarRef, thenResult);
        thenBody.addStatement(thenAssignment);
        BLangSimpleVarRef elseResultVarRef = ASTBuilderUtil.createVariableRef(binaryExpr.pos, resultVarDef.var.symbol);
        BLangExpression elseResult = binaryExpr.opKind == OperatorKind.AND ? this.getBooleanLiteral(false) : binaryExpr.rhsExpr;
        BLangAssignment elseAssignment = ASTBuilderUtil.createAssignmentStmt(binaryExpr.pos, elseResultVarRef, elseResult);
        elseBody.addStatement(elseAssignment);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(binaryExpr.pos, resultVarDef.var.symbol);
        BLangIf ifElse = ASTBuilderUtil.createIfElseStmt(binaryExpr.pos, binaryExpr.lhsExpr, thenBody, elseBody);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(binaryExpr.pos, Lists.of(resultVarDef, ifElse));
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.type = binaryExpr.type;
        this.result = this.rewriteExpr(stmtExpr);
    }

    private BLangFunction splitInitFunction(BLangPackage packageNode, SymbolEnv env) {
        int i;
        BLangStatement statement;
        int splitInitFuncClassCount = 1;
        int splitFuncCount = 0;
        DiagnosticPos packageNodePos = packageNode.pos;
        String packageCUnitName = packageNodePos.src.cUnitName;
        DiagnosticPos newFuncPos = Desugar.getNewFuncPos(packageNodePos, packageCUnitName, splitInitFuncClassCount);
        ++splitInitFuncClassCount;
        int methodSize = 50;
        BLangBlockFunctionBody funcBody = (BLangBlockFunctionBody)packageNode.initFunction.body;
        if (!isJvmTarget) {
            return packageNode.initFunction;
        }
        BLangFunction initFunction = packageNode.initFunction;
        ArrayList<BLangFunction> generatedFunctions = new ArrayList<BLangFunction>();
        ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(funcBody.stmts);
        funcBody.stmts.clear();
        BLangFunction newFunc = initFunction;
        BLangBlockFunctionBody newFuncBody = (BLangBlockFunctionBody)newFunc.body;
        int varDefIndex = 0;
        for (int i2 = 0; i2 < stmts.size() && (statement = (BLangStatement)stmts.get(i2)).getKind() != NodeKind.VARIABLE_DEF; ++i2) {
            ++varDefIndex;
            if (i2 > 0 && (i2 % methodSize == 0 || this.isAssignmentWithInitOrRecordLiteralExpr(statement))) {
                generatedFunctions.add(newFunc);
                newFunc = this.createIntermediateInitFunction(packageNode, env);
                if (++splitFuncCount % 100 == 0) {
                    newFuncPos = Desugar.getNewFuncPos(packageNodePos, packageCUnitName, splitInitFuncClassCount);
                    ++splitInitFuncClassCount;
                }
                newFunc.pos = newFuncPos;
                newFuncBody = (BLangBlockFunctionBody)newFunc.body;
                this.symTable.rootScope.define(this.names.fromIdNode(newFunc.name), newFunc.symbol);
            }
            newFuncBody.stmts.add((BLangStatement)stmts.get(i2));
        }
        ArrayList<BLangStatement> chunkStmts = new ArrayList<BLangStatement>();
        for (i = varDefIndex; i < stmts.size(); ++i) {
            BLangStatement stmt = (BLangStatement)stmts.get(i);
            chunkStmts.add(stmt);
            ++varDefIndex;
            if (stmt.getKind() == NodeKind.ASSIGNMENT && ((BLangAssignment)stmt).expr.getKind() == NodeKind.SERVICE_CONSTRUCTOR && newFuncBody.stmts.size() + chunkStmts.size() > methodSize) {
                if (newFuncBody.stmts.size() + chunkStmts.size() > methodSize) {
                    generatedFunctions.add(newFunc);
                    newFunc = this.createIntermediateInitFunction(packageNode, env);
                    if (++splitFuncCount % 100 == 0) {
                        newFuncPos = Desugar.getNewFuncPos(packageNodePos, packageCUnitName, splitInitFuncClassCount);
                        ++splitInitFuncClassCount;
                    }
                    newFunc.pos = newFuncPos;
                    newFuncBody = (BLangBlockFunctionBody)newFunc.body;
                    this.symTable.rootScope.define(this.names.fromIdNode(newFunc.name), newFunc.symbol);
                }
                newFuncBody.stmts.addAll(chunkStmts);
                chunkStmts.clear();
                continue;
            }
            if (stmt.getKind() == NodeKind.ASSIGNMENT && ((BLangAssignment)stmt).varRef instanceof BLangSimpleVarRef.BLangPackageVarRef && Symbols.isFlagOn(((BLangSimpleVarRef.BLangPackageVarRef)((BLangAssignment)stmt).varRef).varSymbol.flags, 0x100000)) break;
        }
        newFuncBody.stmts.addAll(chunkStmts);
        for (i = varDefIndex; i < stmts.size(); ++i) {
            if (i > 0 && i % methodSize == 0) {
                generatedFunctions.add(newFunc);
                newFunc = this.createIntermediateInitFunction(packageNode, env);
                if (++splitFuncCount % 100 == 0) {
                    newFuncPos = Desugar.getNewFuncPos(packageNodePos, packageCUnitName, splitInitFuncClassCount);
                    ++splitInitFuncClassCount;
                }
                newFunc.pos = newFuncPos;
                newFuncBody = (BLangBlockFunctionBody)newFunc.body;
                this.symTable.rootScope.define(this.names.fromIdNode(newFunc.name), newFunc.symbol);
            }
            newFuncBody.stmts.add((BLangStatement)stmts.get(i));
        }
        generatedFunctions.add(newFunc);
        for (int j = 0; j < generatedFunctions.size() - 1; ++j) {
            BLangFunction thisFunction = (BLangFunction)generatedFunctions.get(j);
            BLangCheckedExpr checkedExpr = ASTBuilderUtil.createCheckExpr(initFunction.pos, this.createInvocationNode(((BLangFunction)generatedFunctions.get((int)(j + 1))).name.value, new ArrayList<BLangExpression>(), this.symTable.errorOrNilType), this.symTable.nilType);
            checkedExpr.equivalentErrorTypeList.add(this.symTable.errorType);
            BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(thisFunction.pos, (BLangBlockFunctionBody)thisFunction.body);
            expressionStmt.expr = checkedExpr;
            expressionStmt.expr.pos = initFunction.pos;
            if (j <= 0) continue;
            thisFunction = this.rewrite(thisFunction, env);
            packageNode.functions.add(thisFunction);
            packageNode.topLevelNodes.add(thisFunction);
        }
        if (generatedFunctions.size() > 1) {
            BLangFunction lastFunc = (BLangFunction)generatedFunctions.get(generatedFunctions.size() - 1);
            lastFunc = this.rewrite(lastFunc, env);
            packageNode.functions.add(lastFunc);
            packageNode.topLevelNodes.add(lastFunc);
        }
        return (BLangFunction)generatedFunctions.get(0);
    }

    private static DiagnosticPos getNewFuncPos(DiagnosticPos packageNodePos, String packageCUnitName, int splitInitFuncClassCount) {
        return new DiagnosticPos(new BDiagnosticSource(packageNodePos.src.pkgID, packageCUnitName + "$" + splitInitFuncClassCount), packageNodePos.sLine, packageNodePos.eLine, packageNodePos.sCol, packageNodePos.eCol);
    }

    private boolean isAssignmentWithInitOrRecordLiteralExpr(BLangStatement statement) {
        if (statement.getKind() == NodeKind.ASSIGNMENT) {
            NodeKind exprKind = ((BLangAssignment)statement).getExpression().getKind();
            return exprKind == NodeKind.TYPE_INIT_EXPR || exprKind == NodeKind.RECORD_LITERAL_EXPR;
        }
        return false;
    }

    private BLangFunction createIntermediateInitFunction(BLangPackage pkgNode, SymbolEnv env) {
        String alias = pkgNode.symbol.pkgID.toString();
        BLangFunction initFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(pkgNode.pos, alias, new Name(Names.INIT_FUNCTION_SUFFIX.value + this.initFuncIndex++), this.symTable);
        this.createInvokableSymbol(initFunction, env);
        return initFunction;
    }

    private BType getRestType(BInvokableSymbol invokableSymbol) {
        if (invokableSymbol != null && invokableSymbol.restParam != null) {
            return invokableSymbol.restParam.type;
        }
        return null;
    }

    private BType getRestType(BLangFunction function) {
        if (function != null && function.restParam != null) {
            return function.restParam.type;
        }
        return null;
    }

    private BVarSymbol getRestSymbol(BLangFunction function) {
        if (function != null && function.restParam != null) {
            return function.restParam.symbol;
        }
        return null;
    }

    private boolean isComputedKey(RecordLiteralNode.RecordField field) {
        if (!field.isKeyValueField()) {
            return false;
        }
        return ((BLangRecordLiteral.BLangRecordKeyValueField)field).key.computedKey;
    }

    private BLangStatementExpression rewriteMappingConstructor(BLangRecordLiteral mappingConstructorExpr) {
        List<RecordLiteralNode.RecordField> fields = mappingConstructorExpr.fields;
        BType type = mappingConstructorExpr.type;
        DiagnosticPos pos = mappingConstructorExpr.pos;
        BLangRecordLiteral recordLiteral = type.tag == 12 ? new BLangRecordLiteral.BLangStructLiteral(pos, type) : new BLangRecordLiteral.BLangMapLiteral(pos, type);
        String name = "$mapping$var$" + this.annonVarCount++;
        BVarSymbol varSymbol = new BVarSymbol(0, this.names.fromString(name), this.env.scope.owner.pkgID, type, this.env.scope.owner);
        BLangSimpleVariable var = ASTBuilderUtil.createVariable(pos, name, type, recordLiteral, varSymbol);
        BLangSimpleVariableDef varDef = ASTBuilderUtil.createVariableDef(pos);
        varDef.var = var;
        varDef.type = type;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        blockStmt.stmts.add(varDef);
        BLangSimpleVarRef mappingVarRef = ASTBuilderUtil.createVariableRef(pos, varSymbol);
        for (RecordLiteralNode.RecordField field : fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangRecordLiteral.BLangRecordKey key = keyValueField.key;
                BLangExpression keyExpr = key.expr;
                BLangExpression indexExpr = key.computedKey ? keyExpr : (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? this.createStringLiteral(pos, ((BLangSimpleVarRef)keyExpr).variableName.value) : (BLangLiteral)keyExpr);
                this.addMemberStoreForKeyValuePair(pos, blockStmt, mappingVarRef, indexExpr, keyValueField.valueExpr);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef varRefField = (BLangSimpleVarRef)((Object)field);
                this.addMemberStoreForKeyValuePair(pos, blockStmt, mappingVarRef, this.createStringLiteral(pos, varRefField.variableName.value), varRefField);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOpField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            BLangForeach foreach = (BLangForeach)TreeBuilder.createForeachNode();
            foreach.pos = pos;
            foreach.collection = this.generateMapEntriesInvocation(spreadOpField.expr, spreadOpField.expr.type);
            this.types.setForeachTypedBindingPatternType(foreach);
            BLangSimpleVariable foreachVariable = ASTBuilderUtil.createVariable(pos, "$foreach$i", foreach.varType);
            foreachVariable.symbol = new BVarSymbol(0, this.names.fromIdNode(foreachVariable.name), this.env.scope.owner.pkgID, foreachVariable.type, this.env.scope.owner);
            BLangSimpleVarRef foreachVarRef = ASTBuilderUtil.createVariableRef(pos, foreachVariable.symbol);
            foreach.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, foreachVariable);
            foreach.isDeclaredWithVar = true;
            BLangBlockStmt foreachBodyBlock = ASTBuilderUtil.createBlockStmt(pos);
            BTupleType foreachVarRefType = (BTupleType)foreachVarRef.type;
            BLangIndexBasedAccess indexExpr = (BLangIndexBasedAccess)TreeBuilder.createIndexBasedAccessNode();
            indexExpr.pos = pos;
            indexExpr.expr = foreachVarRef;
            indexExpr.indexExpr = this.rewriteExpr(this.createIntLiteral(0L));
            indexExpr.type = foreachVarRefType.tupleTypes.get(0);
            BLangIndexBasedAccess valueExpr = (BLangIndexBasedAccess)TreeBuilder.createIndexBasedAccessNode();
            valueExpr.pos = pos;
            valueExpr.expr = foreachVarRef;
            valueExpr.indexExpr = this.rewriteExpr(this.createIntLiteral(1L));
            valueExpr.type = foreachVarRefType.tupleTypes.get(1);
            this.addMemberStoreForKeyValuePair(pos, foreachBodyBlock, mappingVarRef, indexExpr, valueExpr);
            foreach.body = foreachBodyBlock;
            blockStmt.addStatement(foreach);
        }
        BLangStatementExpression stmtExpression = ASTBuilderUtil.createStatementExpression(blockStmt, mappingVarRef);
        stmtExpression.type = type;
        return stmtExpression;
    }

    private void addMemberStoreForKeyValuePair(DiagnosticPos pos, BLangBlockStmt blockStmt, BLangExpression mappingVarRef, BLangExpression indexExpr, BLangExpression value) {
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(pos, blockStmt);
        assignmentStmt.expr = this.rewriteExpr(value);
        BLangIndexBasedAccess indexAccessNode = (BLangIndexBasedAccess)TreeBuilder.createIndexBasedAccessNode();
        indexAccessNode.pos = pos;
        indexAccessNode.expr = mappingVarRef;
        indexAccessNode.indexExpr = this.rewriteExpr(indexExpr);
        indexAccessNode.type = value.type;
        assignmentStmt.varRef = indexAccessNode;
    }

    private Map<String, BLangExpression> getKeyValuePairs(BLangStatementExpression desugaredMappingConst) {
        List<BLangStatement> stmts = ((BLangBlockStmt)desugaredMappingConst.stmt).stmts;
        HashMap<String, BLangExpression> keyValuePairs = new HashMap<String, BLangExpression>();
        for (int i = 1; i < stmts.size(); ++i) {
            BLangAssignment assignmentStmt = (BLangAssignment)stmts.get(i);
            BLangExpression indexExpr = ((BLangIndexBasedAccess)assignmentStmt.varRef).indexExpr;
            if (indexExpr.getKind() != NodeKind.LITERAL) continue;
            keyValuePairs.put((String)((BLangLiteral)indexExpr).value, assignmentStmt.expr);
        }
        return keyValuePairs;
    }

    private static /* synthetic */ boolean lambda$desugarParticipantFunction$15(BLangImportPackage importPackage) {
        return importPackage.symbol.pkgID.toString().equals(Names.TRANSACTION_ORG.value + Names.ORG_NAME_SEPARATOR.value + Names.TRANSACTION_PACKAGE.value);
    }
}

