/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.HttpFiltersDesugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ServiceDesugar {
    private static final CompilerContext.Key<ServiceDesugar> SERVICE_DESUGAR_KEY = new CompilerContext.Key();
    private static final String START_METHOD = "__start";
    private static final String GRACEFUL_STOP = "__gracefulStop";
    private static final String ATTACH_METHOD = "__attach";
    private static final String LISTENER = "$LISTENER";
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private HttpFiltersDesugar httpFiltersDesugar;

    public static ServiceDesugar getInstance(CompilerContext context) {
        ServiceDesugar desugar = context.get(SERVICE_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new ServiceDesugar(context);
        }
        return desugar;
    }

    private ServiceDesugar(CompilerContext context) {
        context.put(SERVICE_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.httpFiltersDesugar = HttpFiltersDesugar.getInstance(context);
    }

    void rewriteListeners(List<BLangSimpleVariable> variables, SymbolEnv env, BLangFunction startFunction, BLangFunction stopFunction) {
        variables.stream().filter(varNode -> Symbols.isFlagOn(varNode.symbol.flags, 0x100000)).forEach(varNode -> this.rewriteListener((BLangSimpleVariable)varNode, env, startFunction, stopFunction));
    }

    private void rewriteListener(BLangSimpleVariable variable, SymbolEnv env, BLangFunction startFunction, BLangFunction stopFunction) {
        this.rewriteListenerLifeCycleFunction(startFunction, variable, env, START_METHOD);
        this.rewriteListenerLifeCycleFunction(stopFunction, variable, env, GRACEFUL_STOP);
    }

    private void rewriteListenerLifeCycleFunction(BLangFunction lifeCycleFunction, BLangSimpleVariable variable, SymbolEnv env, String method) {
        DiagnosticPos pos = variable.pos;
        Name functionName = this.names.fromString(Symbols.getAttachedFuncSymbolName(variable.type.tsymbol.name.value, method));
        BInvokableSymbol methodInvocationSymbol = (BInvokableSymbol)this.symResolver.lookupMemberSymbol(pos, ((BObjectTypeSymbol)variable.type.tsymbol).methodScope, env, functionName, 256);
        BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, variable.symbol);
        this.addMethodInvocation(pos, varRef, methodInvocationSymbol, Collections.emptyList(), Collections.emptyList(), (BLangBlockFunctionBody)lifeCycleFunction.body);
    }

    BLangBlockStmt rewriteServiceVariables(List<BLangService> services, SymbolEnv env) {
        BLangBlockStmt attachmentsBlock = (BLangBlockStmt)TreeBuilder.createBlockNode();
        services.forEach(service -> this.rewriteServiceVariable((BLangService)service, env, attachmentsBlock));
        return attachmentsBlock;
    }

    void rewriteServiceVariable(BLangService service, SymbolEnv env, BLangBlockStmt attachments) {
        if (service.isAnonymousService()) {
            return;
        }
        DiagnosticPos pos = service.pos;
        int count = 0;
        for (BLangExpression attachExpr : service.attachedExprs) {
            BLangSimpleVarRef listenerVarRef;
            if (attachExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                listenerVarRef = (BLangSimpleVarRef)attachExpr;
            } else {
                BLangSimpleVariable listenerVar = ASTBuilderUtil.createVariable(pos, LISTENER + service.name.value + count++, attachExpr.type, attachExpr, null);
                ASTBuilderUtil.defineVariable(listenerVar, env.enclPkg.symbol, this.names);
                listenerVar.symbol.flags |= 0x100000;
                env.enclPkg.globalVars.add(listenerVar);
                listenerVarRef = ASTBuilderUtil.createVariableRef(pos, listenerVar.symbol);
            }
            Name functionName = this.names.fromString(Symbols.getAttachedFuncSymbolName(attachExpr.type.tsymbol.name.value, ATTACH_METHOD));
            BInvokableSymbol methodRef = (BInvokableSymbol)this.symResolver.lookupMemberSymbol(pos, ((BObjectTypeSymbol)listenerVarRef.type.tsymbol).methodScope, env, functionName, 256);
            ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
            args.add(ASTBuilderUtil.createVariableRef(pos, service.variableNode.symbol));
            BLangLiteral serviceName = ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, service.name.value);
            List<BLangNamedArgsExpression> namedArgs = Collections.singletonList(ASTBuilderUtil.createNamedArg("name", serviceName));
            this.addMethodInvocation(pos, listenerVarRef, methodRef, args, namedArgs, attachments);
        }
    }

    private void addMethodInvocation(DiagnosticPos pos, BLangSimpleVarRef varRef, BInvokableSymbol methodRefSymbol, List<BLangExpression> args, List<BLangNamedArgsExpression> namedArgs, BlockNode body) {
        BLangInvocation methodInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, methodRefSymbol, args, this.symResolver);
        methodInvocation.expr = varRef;
        BLangCheckedExpr checkedExpr = ASTBuilderUtil.createCheckExpr(pos, methodInvocation, this.symTable.nilType);
        checkedExpr.equivalentErrorTypeList.add(this.symTable.errorType);
        BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(pos, body);
        expressionStmt.expr = checkedExpr;
        expressionStmt.expr.pos = pos;
    }

    void engageCustomServiceDesugar(BLangService service, SymbolEnv env) {
        BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)service.serviceTypeDefinition.typeNode;
        objectTypeNode.functions.stream().filter(fun -> Symbols.isFlagOn(fun.symbol.flags, 262144)).forEach(func -> this.engageCustomResourceDesugar((BLangFunction)func, env));
    }

    private void engageCustomResourceDesugar(BLangFunction functionNode, SymbolEnv env) {
        this.httpFiltersDesugar.addHttpFilterStatementsToResource(functionNode, env);
        this.httpFiltersDesugar.addCustomAnnotationToResource(functionNode, env);
    }
}

