/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SortablePath
implements Comparable<SortablePath> {
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private static final Pattern semVerPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private final Path path;
    private final BigInteger bigInt;

    public SortablePath(Path path) {
        this.path = path;
        this.bigInt = this.pathToSemVer(path);
    }

    private BigInteger pathToSemVer(Path path) {
        Matcher matcher;
        Path dirName = path.getFileName();
        String version = "";
        if (dirName != null) {
            version = dirName.toString();
        }
        if ((matcher = semVerPattern.matcher(version)).matches()) {
            return this.semVerToBigInt(version.substring(matcher.start(), matcher.end()));
        }
        return MINUS_ONE;
    }

    private BigInteger semVerToBigInt(String version) {
        int[] versionArray = Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        BigInteger sum = BigInteger.valueOf(versionArray[0]);
        sum = sum.shiftLeft(32);
        sum = sum.add(BigInteger.valueOf(versionArray[1]));
        sum = sum.shiftLeft(32);
        sum = sum.add(BigInteger.valueOf(versionArray[2]));
        return sum;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortablePath that = (SortablePath)o;
        return this.bigInt.equals(that.bigInt);
    }

    public int hashCode() {
        return this.bigInt.hashCode();
    }

    @Override
    public int compareTo(SortablePath sortablePath) {
        if (sortablePath == null) {
            return Integer.MAX_VALUE;
        }
        return this.bigInt.compareTo(sortablePath.bigInt);
    }

    public boolean valid() {
        return !this.bigInt.equals(MINUS_ONE);
    }
}

