/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.ballerinalang.cli.module.Pull;
import org.ballerinalang.cli.module.exeptions.CommandException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.model.Proxy;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.repo.HomeBaloRepo;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;
import org.wso2.ballerinalang.util.RepoUtils;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class URIConverter
implements Converter<URI> {
    private HomeBaloRepo homeBaloRepo;
    protected URI base;
    protected final Map<PackageID, Manifest> dependencyManifests;
    private boolean isBuild = true;
    private PrintStream errStream = System.err;

    public URIConverter(URI base, Map<PackageID, Manifest> dependencyManifests) {
        this.base = URI.create(base.toString() + "/modules/");
        this.dependencyManifests = dependencyManifests;
        this.homeBaloRepo = new HomeBaloRepo(this.dependencyManifests);
    }

    public URIConverter(URI base, Map<PackageID, Manifest> dependencyManifests, boolean isBuild) {
        this.base = URI.create(base.toString() + "/modules/");
        this.dependencyManifests = dependencyManifests;
        this.isBuild = isBuild;
        this.homeBaloRepo = new HomeBaloRepo(this.dependencyManifests);
    }

    public void createDirectory(Path dirPath) {
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("error occurred when creating the directory path " + dirPath);
            }
        }
    }

    @Override
    public URI start() {
        return this.base;
    }

    @Override
    public URI combine(URI s, String p) {
        return s.resolve(p + '/');
    }

    @Override
    public Stream<URI> getLatestVersion(URI u, PackageID packageID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<URI> expandBalWithTest(URI uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<URI> expandBal(URI u) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<CompilerInput> finalize(URI remoteURI, PackageID moduleID) {
        String orgName = moduleID.getOrgName().getValue();
        String moduleName = moduleID.getName().getValue();
        Path modulePathInBaloCache = RepoUtils.createAndGetHomeReposPath().resolve("balo_cache").resolve(orgName).resolve(moduleName);
        this.createDirectory(modulePathInBaloCache);
        Proxy proxy = TomlParserUtils.readSettings().getProxy();
        String supportedVersionRange = "";
        boolean nightlyBuild = RepoUtils.getBallerinaVersion().contains("SNAPSHOT");
        for (String supportedPlatform : ProgramFileConstants.SUPPORTED_PLATFORMS) {
            String errorMessage = "";
            try {
                Pull.execute((String)remoteURI.toString(), (String)modulePathInBaloCache.toString(), (String)(orgName + "/" + moduleName), (String)proxy.getHost(), (int)proxy.getPort(), (String)proxy.getUserName(), (String)proxy.getPassword(), (String)supportedVersionRange, (boolean)this.isBuild, (boolean)nightlyBuild, (String)"2020r1", (String)supportedPlatform);
            }
            catch (CommandException e) {
                errorMessage = e.getMessage().trim();
            }
            if (!"".equals(errorMessage)) {
                if (errorMessage.contains("\n\tat")) {
                    errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                }
                if (errorMessage.contains("module already exists in the home repository") && this.isBuild) {
                    Patten patten = this.homeBaloRepo.calculate(moduleID);
                    return patten.convertToSources(this.homeBaloRepo.getConverterInstance(), moduleID);
                }
                if ("".equals(errorMessage.replace("error: \t", "").trim())) continue;
                this.errStream.println(errorMessage.trim());
                return Stream.of(new CompilerInput[0]);
            }
            Patten patten = this.homeBaloRepo.calculate(moduleID);
            return patten.convertToSources(this.homeBaloRepo.getConverterInstance(), moduleID);
        }
        return Stream.of(new CompilerInput[0]);
    }

    public String toString() {
        return this.base.toString();
    }
}

