/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.clauses.FromClauseNode;
import org.ballerinalang.model.clauses.WhereClauseNode;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.cyclefind.GlobalVariableRefAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangEndpoint;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAbort;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangThrow;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTryCatchFinally;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class DataflowAnalyzer
extends BLangNodeVisitor {
    private final SymbolResolver symResolver;
    private final Names names;
    private SymbolEnv env;
    private SymbolTable symTable;
    private BLangDiagnosticLogHelper dlog;
    private Map<BSymbol, InitStatus> uninitializedVars;
    private Map<BSymbol, Set<BSymbol>> globalNodeDependsOn;
    private boolean flowTerminated = false;
    private static final CompilerContext.Key<DataflowAnalyzer> DATAFLOW_ANALYZER_KEY = new CompilerContext.Key();
    private Deque<BSymbol> currDependentSymbol;
    private final GlobalVariableRefAnalyzer globalVariableRefAnalyzer;

    private DataflowAnalyzer(CompilerContext context) {
        context.put(DATAFLOW_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.currDependentSymbol = new ArrayDeque<BSymbol>();
        this.globalVariableRefAnalyzer = GlobalVariableRefAnalyzer.getInstance(context);
    }

    public static DataflowAnalyzer getInstance(CompilerContext context) {
        DataflowAnalyzer dataflowAnalyzer = context.get(DATAFLOW_ANALYZER_KEY);
        if (dataflowAnalyzer == null) {
            dataflowAnalyzer = new DataflowAnalyzer(context);
        }
        return dataflowAnalyzer;
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        this.uninitializedVars = new HashMap<BSymbol, InitStatus>();
        this.globalNodeDependsOn = new LinkedHashMap<BSymbol, Set<BSymbol>>();
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.analyzeNode(pkgNode, pkgEnv);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.DATAFLOW_ANALYZE)) {
            return;
        }
        ArrayList<BLangSimpleVariable> sortedListOfNodes = new ArrayList<BLangSimpleVariable>(pkgNode.globalVars);
        pkgNode.topLevelNodes.forEach(topLevelNode -> {
            if (!sortedListOfNodes.contains(topLevelNode)) {
                sortedListOfNodes.add((BLangSimpleVariable)topLevelNode);
            }
        });
        sortedListOfNodes.forEach(topLevelNode -> this.analyzeNode((BLangNode)((Object)topLevelNode), this.env));
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visit((BLangPackage)testablePackage));
        this.globalVariableRefAnalyzer.analyzeAndReOrder(pkgNode, this.globalNodeDependsOn);
        this.checkUnusedImports(pkgNode.imports);
        pkgNode.completedPhases.add(CompilerPhase.DATAFLOW_ANALYZE);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        this.currDependentSymbol.push(funcNode.symbol);
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        funcNode.annAttachments.forEach(bLangAnnotationAttachment -> this.analyzeNode(bLangAnnotationAttachment.expr, this.env));
        funcNode.requiredParams.forEach(param -> this.analyzeNode((BLangNode)param, funcEnv));
        this.analyzeNode(funcNode.restParam, funcEnv);
        this.analyzeBranch(funcNode.body, funcEnv);
        this.currDependentSymbol.pop();
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        for (BLangStatement statement : body.stmts) {
            this.analyzeNode(statement, bodyEnv);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        this.analyzeNode(body.expr, bodyEnv);
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        blockNode.stmts.forEach(statement -> this.analyzeNode((BLangNode)statement, blockEnv));
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        for (BLangLetVariable letVarDeclaration : letExpression.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVarDeclaration.definitionNode), letExpression.env);
        }
        this.analyzeNode(letExpression.expr, letExpression.env);
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangService service) {
        this.currDependentSymbol.push(service.serviceTypeDefinition.symbol);
        for (BLangExpression attachedExpr : service.attachedExprs) {
            this.analyzeNode(attachedExpr, this.env);
        }
        service.annAttachments.forEach(bLangAnnotationAttachment -> this.analyzeNode(bLangAnnotationAttachment.expr, this.env));
        service.resourceFunctions.forEach(function -> this.analyzeNode((BLangNode)function, this.env));
        this.currDependentSymbol.pop();
    }

    @Override
    public void visit(BLangResource resource) {
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.analyzeNode(typeDefinition.typeNode, this.env);
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        BLangSimpleVariable var = varDefNode.var;
        if (var.expr == null) {
            this.addUninitializedVar(var);
            return;
        }
        this.analyzeNode(var, this.env);
    }

    @Override
    public void visit(BLangSimpleVariable variable) {
        this.analyzeNode(variable.typeNode, this.env);
        if (variable.symbol == null) {
            if (variable.expr != null) {
                this.analyzeNode(variable.expr, this.env);
            }
            return;
        }
        this.currDependentSymbol.push(variable.symbol);
        try {
            if (variable.expr != null) {
                this.analyzeNode(variable.expr, this.env);
                this.uninitializedVars.remove(variable.symbol);
                return;
            }
            BSymbol owner = variable.symbol.owner;
            if (owner.tag != 4097 && owner.tag != 196700) {
                return;
            }
            this.addUninitializedVar(variable);
        }
        finally {
            this.currDependentSymbol.pop();
        }
    }

    @Override
    public void visit(BLangWorker worker) {
        SymbolEnv workerEnv = SymbolEnv.createWorkerEnv(worker, this.env);
        this.analyzeBranch(worker.body, workerEnv);
    }

    @Override
    public void visit(BLangEndpoint endpoint) {
        this.analyzeNode(endpoint.configurationExpr, this.env);
    }

    @Override
    public void visit(BLangAssignment assignment) {
        this.analyzeNode(assignment.expr, this.env);
        this.checkAssignment(assignment.varRef);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.analyzeNode(compoundAssignNode.expr, this.env);
        this.analyzeNode(compoundAssignNode.varRef, this.env);
        this.uninitializedVars.remove(compoundAssignNode.varRef.symbol);
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.terminateFlow();
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.analyzeNode(returnNode.expr, this.env);
        this.terminateFlow();
    }

    @Override
    public void visit(BLangThrow throwNode) {
        this.analyzeNode(throwNode.expr, this.env);
        this.terminateFlow();
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmt) {
        this.analyzeNode(xmlnsStmt.xmlnsDecl, this.env);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.analyzeNode(ifNode.expr, this.env);
        BranchResult ifResult = this.analyzeBranch(ifNode.body, this.env);
        BranchResult elseResult = this.analyzeBranch(ifNode.elseStmt, this.env);
        if (ifResult.flowTerminated) {
            this.uninitializedVars = elseResult.uninitializedVars;
            return;
        }
        if (elseResult.flowTerminated) {
            this.uninitializedVars = ifResult.uninitializedVars;
            return;
        }
        this.uninitializedVars = this.mergeUninitializedVars(ifResult.uninitializedVars, elseResult.uninitializedVars);
    }

    @Override
    public void visit(BLangMatch match) {
        this.analyzeNode(match.expr, this.env);
        Map<BSymbol, InitStatus> uninitVars = new HashMap<BSymbol, InitStatus>();
        BranchResult lastPatternResult = null;
        for (BLangMatch.BLangMatchBindingPatternClause patternClause : match.patternClauses) {
            if (patternClause.isLastPattern) {
                lastPatternResult = this.analyzeBranch(patternClause, this.env);
                continue;
            }
            BranchResult result = this.analyzeBranch(patternClause, this.env);
            if (result.flowTerminated) continue;
            uninitVars = this.mergeUninitializedVars(uninitVars, result.uninitializedVars);
        }
        if (lastPatternResult != null) {
            uninitVars = this.mergeUninitializedVars(uninitVars, lastPatternResult.uninitializedVars);
            this.uninitializedVars = uninitVars;
            return;
        }
        uninitVars = this.mergeUninitializedVars(new HashMap<BSymbol, InitStatus>(), this.uninitializedVars);
        this.uninitializedVars = uninitVars;
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.analyzeNode(foreach.collection, this.env);
        this.analyzeNode(foreach.body, this.env);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        for (FromClauseNode fromClauseNode : queryAction.fromClauseList) {
            this.analyzeNode((BLangFromClause)fromClauseNode, this.env);
        }
        for (WhereClauseNode whereClauseNode : queryAction.whereClauseList) {
            this.analyzeNode((BLangWhereClause)whereClauseNode, this.env);
        }
        this.analyzeNode(queryAction.doClause, this.env);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        Map<BSymbol, InitStatus> prevUninitializedVars = this.uninitializedVars;
        this.analyzeNode(whileNode.expr, this.env);
        this.analyzeNode(whileNode.body, this.env);
        for (BSymbol symbol : prevUninitializedVars.keySet()) {
            if (this.uninitializedVars.containsKey(symbol)) continue;
            this.uninitializedVars.put(symbol, InitStatus.PARTIAL_INIT);
        }
    }

    @Override
    public void visit(BLangLock lockNode) {
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.analyzeNode(transactionNode.transactionBody, this.env);
        this.analyzeNode(transactionNode.onRetryBody, this.env);
        this.analyzeNode(transactionNode.committedBody, this.env);
        this.analyzeNode(transactionNode.abortedBody, this.env);
        Name transactionPkgName = this.names.fromString(Names.DOT.value + Names.TRANSACTION_PACKAGE.value);
        Name compUnitName = this.names.fromString(transactionNode.pos.getSource().getCompilationUnitName());
        this.symResolver.resolvePrefixSymbol(this.env, transactionPkgName, compUnitName);
    }

    @Override
    public void visit(BLangTryCatchFinally tryNode) {
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.analyzeNode(stmt.expr, this.env);
        this.checkAssignment(stmt.varRef);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        this.analyzeNode(workerSendNode.expr, this.env);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        this.analyzeNode(syncSendExpr.expr, this.env);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
    }

    @Override
    public void visit(BLangTableLiteral tableLiteral) {
        this.analyzeNode(tableLiteral.indexColumnsArrayLiteral, this.env);
        this.analyzeNode(tableLiteral.keyColumnsArrayLiteral, this.env);
        tableLiteral.columns.forEach(column -> this.analyzeNode((BLangNode)column, this.env));
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        listConstructorExpr.exprs.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (keyValuePair.key.computedKey) {
                    this.analyzeNode(keyValuePair.key.expr, this.env);
                }
                this.analyzeNode(keyValuePair.valueExpr, this.env);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeNode((BLangRecordLiteral.BLangRecordVarNameField)field, this.env);
                continue;
            }
            this.analyzeNode(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, this.env);
        }
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        this.checkVarRef(varRefExpr.symbol, varRefExpr.pos);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        if (!fieldAccessExpr.lhsVar && this.isObjectMemberAccessWithSelf(fieldAccessExpr)) {
            this.checkVarRef(fieldAccessExpr.symbol, fieldAccessExpr.pos);
        }
        this.analyzeNode(fieldAccessExpr.expr, this.env);
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.analyzeNode(indexAccessExpr.expr, this.env);
        this.analyzeNode(indexAccessExpr.indexExpr, this.env);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.analyzeNode(xmlElementAccess.expr, this.env);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.analyzeNode(xmlNavigation.expr, this.env);
        if (xmlNavigation.childIndex == null) {
            this.analyzeNode(xmlNavigation.childIndex, this.env);
        }
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.analyzeNode(invocationExpr.expr, this.env);
        if (!this.isFieldsInitializedForSelfArgument(invocationExpr)) {
            return;
        }
        if (!this.isFieldsInitializedForSelfInvocation(invocationExpr.requiredArgs, invocationExpr.pos)) {
            return;
        }
        if (!this.isFieldsInitializedForSelfInvocation(invocationExpr.restArgs, invocationExpr.pos)) {
            return;
        }
        invocationExpr.requiredArgs.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        invocationExpr.restArgs.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        BSymbol owner = this.env.scope.owner;
        if (owner.kind == SymbolKind.FUNCTION) {
            BInvokableSymbol invokableOwnerSymbol = (BInvokableSymbol)owner;
            Name name = this.names.fromIdNode(invocationExpr.name);
            BSymbol dependsOnFunctionSym = this.symResolver.lookupSymbolInMainSpace(this.env, name);
            if (this.symTable.notFoundSymbol != dependsOnFunctionSym) {
                this.addDependency(invokableOwnerSymbol, dependsOnFunctionSym);
            }
        } else if (invocationExpr.symbol != null && invocationExpr.symbol.kind == SymbolKind.FUNCTION) {
            BInvokableSymbol invokableProviderSymbol = (BInvokableSymbol)invocationExpr.symbol;
            BSymbol curDependent = this.currDependentSymbol.peek();
            if (curDependent != null && this.isGlobalVarSymbol(curDependent)) {
                this.addDependency(curDependent, invokableProviderSymbol);
            }
        }
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        for (FromClauseNode fromClauseNode : queryExpr.fromClauseList) {
            this.analyzeNode((BLangFromClause)fromClauseNode, this.env);
        }
        for (WhereClauseNode whereClauseNode : queryExpr.whereClauseList) {
            this.analyzeNode((BLangWhereClause)whereClauseNode, this.env);
        }
        this.analyzeNode(queryExpr.selectClause, this.env);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.analyzeNode(fromClause.collection, this.env);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.analyzeNode(whereClause.expression, this.env);
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.analyzeNode(selectClause.expression, this.env);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.analyzeNode(doClause.body, this.env);
    }

    private boolean isFieldsInitializedForSelfArgument(BLangInvocation invocationExpr) {
        if (invocationExpr.expr == null || !this.isSelfKeyWordExpr(invocationExpr.expr)) {
            return true;
        }
        StringBuilder uninitializedFields = this.getUninitializedFieldsForSelfKeyword((BObjectType)((BLangSimpleVarRef)invocationExpr.expr).symbol.type);
        if (uninitializedFields.length() != 0) {
            this.dlog.error(invocationExpr.pos, DiagnosticCode.CONTAINS_UNINITIALIZED_FIELDS, uninitializedFields.toString());
            return false;
        }
        return true;
    }

    private boolean isFieldsInitializedForSelfInvocation(List<BLangExpression> argExpressions, DiagnosticPos pos) {
        for (BLangExpression expr : argExpressions) {
            StringBuilder uninitializedFields;
            if (!this.isSelfKeyWordExpr(expr) || (uninitializedFields = this.getUninitializedFieldsForSelfKeyword((BObjectType)((BLangSimpleVarRef)expr).symbol.type)).length() == 0) continue;
            this.dlog.error(pos, DiagnosticCode.CONTAINS_UNINITIALIZED_FIELDS, uninitializedFields.toString());
            return false;
        }
        return true;
    }

    private boolean isSelfKeyWordExpr(BLangExpression expr) {
        return expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && Names.SELF.value.equals(((BLangSimpleVarRef)expr).getVariableName().getValue());
    }

    private StringBuilder getUninitializedFieldsForSelfKeyword(BObjectType objType) {
        boolean isFirstUninitializedField = true;
        StringBuilder uninitializedFields = new StringBuilder();
        for (BField field : objType.fields) {
            if (!this.uninitializedVars.containsKey(field.symbol)) continue;
            if (isFirstUninitializedField) {
                uninitializedFields = new StringBuilder(field.symbol.getName().value);
                isFirstUninitializedField = false;
                continue;
            }
            uninitializedFields.append(", ").append(field.symbol.getName().value);
        }
        return uninitializedFields;
    }

    private boolean isGlobalVarSymbol(BSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (symbol.owner == null) {
            return false;
        }
        if (symbol.owner.tag != 4097) {
            return false;
        }
        return (symbol.tag & 0x34) == 52 || (symbol.tag & 0x100001C) == 0x100001C;
    }

    private void addDependency(BSymbol dependent, BSymbol provider) {
        if (provider == null || dependent == null || dependent.pkgID != provider.pkgID) {
            return;
        }
        Set providers = this.globalNodeDependsOn.computeIfAbsent(dependent, s -> new LinkedHashSet());
        providers.add(provider);
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        typeInitExpr.argsExpr.forEach(argExpr -> this.analyzeNode((BLangNode)argExpr, this.env));
        if (this.currDependentSymbol.peek() != null) {
            this.addDependency(this.currDependentSymbol.peek(), typeInitExpr.type.tsymbol);
        }
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.analyzeNode(ternaryExpr.expr, this.env);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        this.analyzeNode(waitExpr.getExpression(), this.env);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        waitForAllExpr.keyValuePairs.forEach(keyValue -> {
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            this.analyzeNode(expr, this.env);
        });
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.analyzeNode(binaryExpr.lhsExpr, this.env);
        this.analyzeNode(binaryExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.analyzeNode(elvisExpr.lhsExpr, this.env);
        this.analyzeNode(elvisExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.analyzeNode(groupExpr.expression, this.env);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.analyzeNode(unaryExpr.expr, this.env);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.analyzeNode(conversionExpr.expr, this.env);
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.analyzeNode(xmlAttribute.value, this.env);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.children.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        xmlElementLiteral.attributes.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        xmlElementLiteral.inlineNamespaces.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.textFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.textFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.dataFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.textFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        Map<BSymbol, InitStatus> prevUninitializedVars = this.uninitializedVars;
        BLangFunction funcNode = bLangLambdaFunction.function;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        this.uninitializedVars = this.copyUninitializedVars();
        this.flowTerminated = false;
        this.analyzeNode(funcNode.body, funcEnv);
        this.uninitializedVars = prevUninitializedVars;
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        this.analyzeNode(xmlAttributeAccessExpr.expr, this.env);
        this.analyzeNode(xmlAttributeAccessExpr.indexExpr, this.env);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.analyzeNode(intRangeExpression.startExpr, this.env);
        this.analyzeNode(intRangeExpression.endExpr, this.env);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.analyzeNode(bLangVarArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.analyzeNode(bLangNamedArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
    }

    @Override
    public void visit(BLangMatchExpression matchExpression) {
        this.analyzeNode(matchExpression.expr, this.env);
        matchExpression.patternClauses.forEach(pattern -> this.analyzeNode((BLangNode)pattern, this.env));
    }

    @Override
    public void visit(BLangMatchExpression.BLangMatchExprPatternClause matchExprPatternClause) {
        this.analyzeNode(matchExprPatternClause.expr, this.env);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.analyzeNode(checkedExpr.expr, this.env);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanicExpr) {
        this.analyzeNode(checkPanicExpr.expr, this.env);
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        bLangXMLSequenceLiteral.xmlItems.forEach(xml -> this.analyzeNode((BLangNode)xml, this.env));
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.analyzeNode(exprStmtNode.expr, this.env);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
    }

    @Override
    public void visit(BLangAbort abortNode) {
    }

    @Override
    public void visit(BLangRetry retryNode) {
    }

    @Override
    public void visit(BLangContinue continueNode) {
        this.terminateFlow();
    }

    @Override
    public void visit(BLangCatch catchNode) {
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        bLangArrowFunction.closureVarSymbols.forEach(closureVarSymbol -> {
            if (this.uninitializedVars.keySet().contains(closureVarSymbol.bSymbol)) {
                this.dlog.error(closureVarSymbol.diagnosticPos, DiagnosticCode.UNINITIALIZED_VARIABLE, closureVarSymbol.bSymbol);
            }
        });
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangConstant constant) {
        boolean validVariable;
        boolean bl = validVariable = constant.symbol != null;
        if (validVariable) {
            this.currDependentSymbol.push(constant.symbol);
        }
        try {
            this.analyzeNode(constant.expr, this.env);
        }
        finally {
            if (validVariable) {
                this.currDependentSymbol.pop();
            }
        }
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.analyzeNode(arrayType.getElementType(), this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.analyzeNode(constrainedType.constraint, this.env);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.analyzeNode(streamType.constraint, this.env);
        this.analyzeNode(streamType.error, this.env);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        functionTypeNode.params.forEach(param -> this.analyzeNode(param.typeNode, this.env));
        this.analyzeNode(functionTypeNode.returnTypeNode, this.env);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        unionTypeNode.memberTypeNodes.forEach(typeNode -> this.analyzeNode((BLangNode)typeNode, this.env));
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        SymbolEnv objectEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, this.env);
        this.currDependentSymbol.push(objectTypeNode.symbol);
        objectTypeNode.fields.forEach(field -> this.analyzeNode((BLangNode)field, objectEnv));
        objectTypeNode.referencedFields.forEach(field -> this.analyzeNode((BLangNode)field, objectEnv));
        if (objectTypeNode.initFunction != null) {
            if (objectTypeNode.initFunction.body == null) {
                Optional<BLangFunction> outerFuncDef = objectEnv.enclPkg.functions.stream().filter(f -> f.symbol.name.equals(objectTypeNode.initFunction.symbol.name)).findFirst();
                outerFuncDef.ifPresent(bLangFunction -> {
                    objectTypeNode.initFunction = bLangFunction;
                });
            }
            if (objectTypeNode.initFunction.body != null) {
                if (objectTypeNode.initFunction.body.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
                    for (BLangStatement statement : ((BLangBlockFunctionBody)objectTypeNode.initFunction.body).stmts) {
                        this.analyzeNode(statement, objectEnv);
                    }
                } else if (objectTypeNode.initFunction.body.getKind() == NodeKind.EXPR_FUNCTION_BODY) {
                    this.analyzeNode(((BLangExprFunctionBody)objectTypeNode.initFunction.body).expr, objectEnv);
                }
            }
        }
        if (!Symbols.isFlagOn(objectTypeNode.symbol.flags, 4096)) {
            Stream.concat(objectTypeNode.fields.stream(), objectTypeNode.referencedFields.stream()).filter(field -> !Symbols.isPrivate(field.symbol)).forEach(field -> {
                if (this.uninitializedVars.containsKey(field.symbol)) {
                    this.dlog.error(field.pos, DiagnosticCode.OBJECT_UNINITIALIZED_FIELD, field.name);
                }
            });
        }
        objectTypeNode.functions.forEach(function -> this.analyzeNode((BLangNode)function, this.env));
        objectTypeNode.getTypeReferences().forEach(type -> this.analyzeNode((BLangType)type, this.env));
        this.currDependentSymbol.pop();
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        recordTypeNode.getTypeReferences().forEach(type -> this.analyzeNode((BLangType)type, this.env));
        recordTypeNode.fields.forEach(field -> this.analyzeNode((BLangNode)field, this.env));
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        finiteTypeNode.valueSpace.forEach(value -> this.analyzeNode((BLangNode)value, this.env));
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        tupleTypeNode.memberTypeNodes.forEach(type -> this.analyzeNode((BLangNode)type, this.env));
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine bLangMarkdownDocumentationLine) {
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation bLangDocumentationParameter) {
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation bLangMarkdownReturnParameterDocumentation) {
    }

    @Override
    public void visit(BLangMarkdownDocumentation bLangMarkdownDocumentation) {
    }

    @Override
    public void visit(BLangTestablePackage testablePkgNode) {
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.analyzeNode(panicNode.expr, this.env);
        this.terminateFlow();
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.analyzeNode(trapExpr.expr, this.env);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        if (this.currDependentSymbol.peek() != null) {
            this.addDependency(this.currDependentSymbol.peek(), serviceConstructorExpr.type.tsymbol);
        }
        this.addDependency(serviceConstructorExpr.type.tsymbol, serviceConstructorExpr.serviceNode.symbol);
        this.analyzeNode(serviceConstructorExpr.serviceNode, this.env);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.analyzeNode(typeTestExpr.expr, this.env);
        this.analyzeNode(typeTestExpr.typeNode, this.env);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
    }

    @Override
    public void visit(BLangErrorType errorType) {
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        this.analyzeNode(recordDestructure.expr, this.env);
        this.checkAssignment(recordDestructure.varRef);
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        this.analyzeNode(errorDestructure.expr, this.env);
        this.checkAssignment(errorDestructure.varRef);
    }

    @Override
    public void visit(BLangTupleVarRef tupleVarRefExpr) {
        tupleVarRefExpr.expressions.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        varRefExpr.recordRefFields.forEach(expr -> this.analyzeNode(expr.variableReference, this.env));
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.analyzeNode(varRefExpr.reason, this.env);
        for (BLangNamedArgsExpression args : varRefExpr.detail) {
            this.analyzeNode(args.expr, this.env);
        }
        this.analyzeNode(varRefExpr.restVar, this.env);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.analyzeNode(bLangTupleVariable.typeNode, this.env);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        BLangTupleVariable var = bLangTupleVariableDef.var;
        if (var.expr == null) {
            this.addUninitializedVar(var);
            return;
        }
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        this.analyzeNode(bLangRecordVariable.typeNode, this.env);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        BLangRecordVariable var = bLangRecordVariableDef.var;
        if (var.expr == null) {
            this.addUninitializedVar(var);
        }
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.analyzeNode(bLangErrorVariable.typeNode, this.env);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        BLangErrorVariable var = bLangErrorVariableDef.errorVariable;
        if (var.expr == null) {
            this.addUninitializedVar(var);
        }
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause bLangMatchStaticBindingPatternClause) {
        this.analyzeNode(bLangMatchStaticBindingPatternClause.body, this.env);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause bLangMatchStructuredBindingPatternClause) {
        this.analyzeNode(bLangMatchStructuredBindingPatternClause.body, this.env);
    }

    private void addUninitializedVar(BLangVariable variable) {
        if (!this.uninitializedVars.containsKey(variable.symbol)) {
            this.uninitializedVars.put(variable.symbol, InitStatus.UN_INIT);
        }
    }

    private BranchResult analyzeBranch(BLangNode node, SymbolEnv env) {
        Map<BSymbol, InitStatus> prevUninitializedVars = this.uninitializedVars;
        boolean prevFlowTerminated = this.flowTerminated;
        this.uninitializedVars = this.copyUninitializedVars();
        this.flowTerminated = false;
        this.analyzeNode(node, env);
        BranchResult brachResult = new BranchResult(this.uninitializedVars, this.flowTerminated);
        this.uninitializedVars = prevUninitializedVars;
        this.flowTerminated = prevFlowTerminated;
        return brachResult;
    }

    private Map<BSymbol, InitStatus> copyUninitializedVars() {
        return new HashMap<BSymbol, InitStatus>(this.uninitializedVars);
    }

    private void analyzeNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        if (node != null) {
            node.accept(this);
        }
        this.env = prevEnv;
    }

    private Map<BSymbol, InitStatus> mergeUninitializedVars(Map<BSymbol, InitStatus> firstUninitVars, Map<BSymbol, InitStatus> secondUninitVars) {
        ArrayList<BSymbol> intersection = new ArrayList<BSymbol>(firstUninitVars.keySet());
        intersection.retainAll(secondUninitVars.keySet());
        return Stream.concat(firstUninitVars.entrySet().stream(), secondUninitVars.entrySet().stream()).collect(Collectors.toMap(entry -> (BSymbol)entry.getKey(), entry -> intersection.contains(entry.getKey()) ? (InitStatus)((Object)((Object)entry.getValue())) : InitStatus.PARTIAL_INIT, (a, b) -> {
            if (a == InitStatus.PARTIAL_INIT || b == InitStatus.PARTIAL_INIT) {
                return InitStatus.PARTIAL_INIT;
            }
            return InitStatus.UN_INIT;
        }));
    }

    private void checkVarRef(BSymbol symbol, DiagnosticPos pos) {
        this.recordGlobalVariableReferenceRelationship(symbol);
        InitStatus initStatus = this.uninitializedVars.get(symbol);
        if (initStatus == null) {
            return;
        }
        if (initStatus == InitStatus.UN_INIT) {
            this.dlog.error(pos, DiagnosticCode.UNINITIALIZED_VARIABLE, symbol.name);
            return;
        }
        this.dlog.error(pos, DiagnosticCode.PARTIALLY_INITIALIZED_VARIABLE, symbol.name);
    }

    private void recordGlobalVariableReferenceRelationship(BSymbol symbol) {
        boolean isInPkgLevel;
        BSymbol ownerSymbol = this.env.scope.owner;
        boolean bl = isInPkgLevel = ownerSymbol.getKind() == SymbolKind.PACKAGE;
        if (isInPkgLevel && this.isGlobalVarSymbol(symbol)) {
            BSymbol dependent = this.currDependentSymbol.peek();
            this.addDependency(dependent, symbol);
        } else if (ownerSymbol.kind == SymbolKind.FUNCTION && this.isGlobalVarSymbol(symbol)) {
            BInvokableSymbol invokableOwnerSymbol = (BInvokableSymbol)ownerSymbol;
            this.addDependency(invokableOwnerSymbol, symbol);
        } else if (ownerSymbol.kind == SymbolKind.OBJECT && this.isGlobalVarSymbol(symbol)) {
            this.addDependency(ownerSymbol, symbol);
        }
    }

    private boolean isObjectMemberAccessWithSelf(BLangAccessExpression fieldAccessExpr) {
        if (fieldAccessExpr.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        return Names.SELF.value.equals(((BLangSimpleVarRef)fieldAccessExpr.expr).variableName.value);
    }

    private void checkAssignment(BLangExpression varRef) {
        switch (varRef.getKind()) {
            case RECORD_VARIABLE_REF: {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)varRef;
                recordVarRef.recordRefFields.forEach(field -> this.checkAssignment(field.variableReference));
                if (recordVarRef.restParam != null) {
                    this.checkAssignment((BLangExpression)recordVarRef.restParam);
                }
                return;
            }
            case TUPLE_VARIABLE_REF: {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)varRef;
                tupleVarRef.expressions.forEach(this::checkAssignment);
                if (tupleVarRef.restParam != null) {
                    this.checkAssignment((BLangExpression)tupleVarRef.restParam);
                }
                return;
            }
            case ERROR_VARIABLE_REF: {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)varRef;
                if (errorVarRef.reason != null) {
                    this.checkAssignment(errorVarRef.reason);
                }
                for (BLangNamedArgsExpression expression : errorVarRef.detail) {
                    this.checkAssignment(expression);
                    this.uninitializedVars.remove(((BLangVariableReference)expression.expr).symbol);
                }
                if (errorVarRef.restVar != null) {
                    this.checkAssignment(errorVarRef.restVar);
                }
                return;
            }
            case INDEX_BASED_ACCESS_EXPR: 
            case FIELD_BASED_ACCESS_EXPR: {
                if (this.isObjectMemberAccessWithSelf((BLangAccessExpression)varRef)) {
                    this.uninitializedVars.remove(((BLangVariableReference)varRef).symbol);
                } else {
                    this.analyzeNode(((BLangAccessExpression)varRef).expr, this.env);
                }
                return;
            }
        }
        if (varRef.getKind() != NodeKind.SIMPLE_VARIABLE_REF && varRef.getKind() != NodeKind.XML_ATTRIBUTE_ACCESS_EXPR) {
            return;
        }
        this.uninitializedVars.remove(((BLangVariableReference)varRef).symbol);
    }

    private void terminateFlow() {
        this.flowTerminated = true;
    }

    private void checkUnusedImports(List<BLangImportPackage> imports) {
        for (BLangImportPackage importStmt : imports) {
            if (importStmt.symbol == null || importStmt.symbol.isUsed || Names.IGNORE.value.equals(importStmt.alias.value)) continue;
            this.dlog.error(importStmt.pos, DiagnosticCode.UNUSED_IMPORT_MODULE, importStmt.getQualifiedPackageName());
        }
    }

    private class BranchResult {
        Map<BSymbol, InitStatus> uninitializedVars;
        boolean flowTerminated;

        BranchResult(Map<BSymbol, InitStatus> uninitializedVars, boolean flowTerminated) {
            this.uninitializedVars = uninitializedVars;
            this.flowTerminated = flowTerminated;
        }
    }

    private static enum InitStatus {
        UN_INIT,
        PARTIAL_INIT;

    }
}

