/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.tree.types.BuiltInReferenceTypeNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantValueResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeNarrower;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangEndpoint;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAbort;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangThrow;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTryCatchFinally;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.AttachPoints;
import org.wso2.ballerinalang.util.Lists;

public class SemanticAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<SemanticAnalyzer> SYMBOL_ANALYZER_KEY = new CompilerContext.Key();
    private static final String ANONYMOUS_RECORD_NAME = "anonymous-record";
    private static final String NULL_LITERAL = "null";
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private static final String SPACE = " ";
    public static final String COLON = ":";
    private static final String LISTENER_TYPE_NAME = "lang.object:Listener";
    private static final String LISTENER_NAME = "listener";
    private SymbolTable symTable;
    private SymbolEnter symbolEnter;
    private Names names;
    private SymbolResolver symResolver;
    private TypeChecker typeChecker;
    private Types types;
    private BLangDiagnosticLogHelper dlog;
    private TypeNarrower typeNarrower;
    private ConstantAnalyzer constantAnalyzer;
    private ConstantValueResolver constantValueResolver;
    private SymbolEnv env;
    private BType expType;
    private DiagnosticCode diagCode;
    private BType resType;
    private Map<BVarSymbol, BType.NarrowedTypes> narrowedTypeInfo;
    private Stack<SymbolEnv> prevEnvs = new Stack();

    public static SemanticAnalyzer getInstance(CompilerContext context) {
        SemanticAnalyzer semAnalyzer = context.get(SYMBOL_ANALYZER_KEY);
        if (semAnalyzer == null) {
            semAnalyzer = new SemanticAnalyzer(context);
        }
        return semAnalyzer;
    }

    public SemanticAnalyzer(CompilerContext context) {
        context.put(SYMBOL_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.typeChecker = TypeChecker.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
        this.constantAnalyzer = ConstantAnalyzer.getInstance(context);
        this.constantValueResolver = ConstantValueResolver.getInstance(context);
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        pkgNode.accept(this);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.TYPE_CHECK)) {
            return;
        }
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        pkgNode.topLevelNodes.stream().filter(pkgLevelNode -> pkgLevelNode.getKind() == NodeKind.CONSTANT).forEach(constant -> this.analyzeDef((BLangNode)((Object)constant), pkgEnv));
        this.constantValueResolver.resolve(pkgNode.constants);
        for (int i = 0; i < pkgNode.topLevelNodes.size(); ++i) {
            TopLevelNode pkgLevelNode2 = pkgNode.topLevelNodes.get(i);
            NodeKind kind = pkgLevelNode2.getKind();
            if (kind == NodeKind.CONSTANT || kind == NodeKind.FUNCTION && ((BLangFunction)pkgLevelNode2).flagSet.contains((Object)Flag.LAMBDA)) continue;
            this.analyzeDef((BLangNode)((Object)pkgLevelNode2), pkgEnv);
        }
        while (pkgNode.lambdaFunctions.peek() != null) {
            BLangLambdaFunction lambdaFunction = pkgNode.lambdaFunctions.poll();
            BLangFunction function = lambdaFunction.function;
            lambdaFunction.type = function.symbol.type;
            this.analyzeDef(lambdaFunction.function, lambdaFunction.capturedClosureEnv);
        }
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visit((BLangPackage)testablePackage));
        pkgNode.completedPhases.add(CompilerPhase.TYPE_CHECK);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.type = this.symTable.stringType;
        if (xmlnsNode.symbol == null) {
            this.symbolEnter.defineNode(xmlnsNode, this.env);
        }
        this.typeChecker.checkExpr(xmlnsNode.namespaceURI, this.env, this.symTable.stringType);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.analyzeNode(xmlnsStmtNode.xmlnsDecl, this.env);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        funcNode.symbol.params.forEach(param -> param.flags |= 0x40);
        if (!funcNode.flagSet.contains((Object)Flag.WORKER)) {
            funcNode.annAttachments.forEach(annotationAttachment -> {
                if (Symbols.isFlagOn(funcNode.symbol.flags, 262144)) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.RESOURCE);
                } else if (funcNode.attachedFunction) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.OBJECT_METHOD);
                }
                annotationAttachment.attachPoints.add(AttachPoint.Point.FUNCTION);
                this.analyzeDef((BLangNode)annotationAttachment, funcEnv);
            });
            this.validateAnnotationAttachmentCount(funcNode.annAttachments);
        }
        if (funcNode.returnTypeNode != null) {
            funcNode.returnTypeAnnAttachments.forEach(annotationAttachment -> {
                annotationAttachment.attachPoints.add(AttachPoint.Point.RETURN);
                this.analyzeDef((BLangNode)annotationAttachment, funcEnv);
            });
            this.validateAnnotationAttachmentCount(funcNode.returnTypeAnnAttachments);
        }
        for (BLangSimpleVariable param2 : funcNode.requiredParams) {
            this.symbolEnter.defineExistingVarSymbolInEnv(param2.symbol, funcNode.clonedEnv);
            this.analyzeDef(param2, funcNode.clonedEnv);
        }
        if (funcNode.restParam != null) {
            this.symbolEnter.defineExistingVarSymbolInEnv(funcNode.restParam.symbol, funcNode.clonedEnv);
            this.analyzeDef(funcNode.restParam, funcNode.clonedEnv);
        }
        this.validateObjectAttachedFunction(funcNode);
        if (funcNode.hasBody()) {
            this.analyzeNode(funcNode.body, funcEnv, funcNode.returnTypeNode.type, null);
        }
        if (funcNode.anonForkName != null) {
            funcNode.symbol.enclForkName = funcNode.anonForkName;
        }
        this.processWorkers(funcNode, funcEnv);
    }

    private void processWorkers(BLangInvokableNode invNode, SymbolEnv invEnv) {
        if (invNode.workers.size() > 0) {
            invEnv.scope.entries.putAll(invNode.body.scope.entries);
            for (BLangWorker worker : invNode.workers) {
                this.symbolEnter.defineNode(worker, invEnv);
            }
            for (BLangWorker e : invNode.workers) {
                this.analyzeNode(e, invEnv);
            }
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        this.env = SymbolEnv.createFuncBodyEnv(body, this.env);
        for (BLangStatement stmt : body.stmts) {
            this.analyzeStmt(stmt, this.env);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        this.env = SymbolEnv.createFuncBodyEnv(body, this.env);
        this.typeChecker.checkExpr(body.expr, this.env, this.expType);
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        for (BLangAnnotationAttachment annotationAttachment : body.annAttachments) {
            annotationAttachment.attachPoints.add(AttachPoint.Point.EXTERNAL);
            this.analyzeDef(annotationAttachment, this.env);
        }
        this.validateAnnotationAttachmentCount(body.annAttachments);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE || typeDefinition.typeNode.getKind() == NodeKind.ERROR_TYPE || typeDefinition.typeNode.getKind() == NodeKind.FINITE_TYPE_NODE) {
            this.analyzeDef(typeDefinition.typeNode, this.env);
        }
        typeDefinition.annAttachments.forEach(annotationAttachment -> {
            if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
                annotationAttachment.attachPoints.add(AttachPoint.Point.OBJECT);
            }
            annotationAttachment.attachPoints.add(AttachPoint.Point.TYPE);
            annotationAttachment.accept(this);
        });
        this.validateAnnotationAttachmentCount(typeDefinition.annAttachments);
        this.validateBuiltinTypeAnnotationAttachment(typeDefinition.annAttachments);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        conversionExpr.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.TYPE);
            if (conversionExpr.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
                annotationAttachment.attachPoints.add(AttachPoint.Point.OBJECT);
            }
            annotationAttachment.accept(this);
        });
        this.validateAnnotationAttachmentCount(conversionExpr.annAttachments);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        finiteTypeNode.valueSpace.forEach(val -> {
            if (val.type.tag == 10 && NULL_LITERAL.equals(((BLangLiteral)val).originalValue)) {
                this.dlog.error(val.pos, DiagnosticCode.INVALID_USE_OF_NULL_LITERAL, new Object[0]);
            }
        });
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        SymbolEnv objectEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, this.env);
        boolean isAbstract = objectTypeNode.flagSet.contains((Object)Flag.ABSTRACT);
        objectTypeNode.fields.forEach(field -> {
            this.analyzeDef((BLangNode)field, objectEnv);
            if (isAbstract) {
                if (field.flagSet.contains((Object)Flag.PRIVATE)) {
                    this.dlog.error(field.pos, DiagnosticCode.PRIVATE_FIELD_ABSTRACT_OBJECT, field.symbol.name);
                }
                if (field.expr != null) {
                    this.dlog.error(field.expr.pos, DiagnosticCode.FIELD_WITH_DEFAULT_VALUE_ABSTRACT_OBJECT, new Object[0]);
                }
            }
        });
        objectTypeNode.functions.forEach(func -> {
            this.analyzeDef((BLangNode)func, this.env);
            if (isAbstract && func.flagSet.contains((Object)Flag.PRIVATE)) {
                this.dlog.error(func.pos, DiagnosticCode.PRIVATE_FUNC_ABSTRACT_OBJECT, func.name, objectTypeNode.symbol.name);
            }
            if (isAbstract && func.flagSet.contains((Object)Flag.NATIVE)) {
                this.dlog.error(func.pos, DiagnosticCode.EXTERN_FUNC_ABSTRACT_OBJECT, func.name, objectTypeNode.symbol.name);
            }
            if (func.flagSet.contains((Object)Flag.RESOURCE) && func.flagSet.contains((Object)Flag.NATIVE)) {
                this.dlog.error(func.pos, DiagnosticCode.RESOURCE_FUNCTION_CANNOT_BE_EXTERN, func.name);
            }
        });
        ((BObjectTypeSymbol)objectTypeNode.symbol).referencedFunctions.forEach(func -> this.validateReferencedFunction(objectTypeNode.pos, (BAttachedFunction)func, this.env));
        if (objectTypeNode.initFunction == null) {
            return;
        }
        if (objectTypeNode.initFunction.flagSet.contains((Object)Flag.PRIVATE)) {
            this.dlog.error(objectTypeNode.initFunction.pos, DiagnosticCode.PRIVATE_OBJECT_CONSTRUCTOR, objectTypeNode.symbol.name);
            return;
        }
        if (objectTypeNode.flagSet.contains((Object)Flag.ABSTRACT)) {
            this.dlog.error(objectTypeNode.initFunction.pos, DiagnosticCode.ABSTRACT_OBJECT_CONSTRUCTOR, objectTypeNode.symbol.name);
            return;
        }
        if (objectTypeNode.initFunction.flagSet.contains((Object)Flag.NATIVE)) {
            this.dlog.error(objectTypeNode.initFunction.pos, DiagnosticCode.OBJECT_INIT_FUNCTION_CANNOT_BE_EXTERN, objectTypeNode.symbol.name);
            return;
        }
        this.analyzeDef(objectTypeNode.initFunction, this.env);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        SymbolEnv recordEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        recordTypeNode.fields.forEach(field -> this.analyzeDef((BLangNode)field, recordEnv));
        this.validateDefaultable(recordTypeNode);
        recordTypeNode.analyzed = true;
    }

    @Override
    public void visit(BLangErrorType errorType) {
        BType reasonType = this.getReasonType(errorType);
        if (!this.types.isAssignable(reasonType, this.symTable.stringType)) {
            this.dlog.error(errorType.reasonType.pos, DiagnosticCode.INVALID_ERROR_REASON_TYPE, reasonType);
        } else if (errorType.reasonType != null) {
            this.validateModuleQualifiedReasons(errorType.reasonType.pos, reasonType);
        }
        if (errorType.detailType == null) {
            return;
        }
        BType detailType = errorType.detailType.type;
        if (!this.types.isValidErrorDetailType(detailType)) {
            this.dlog.error(errorType.detailType.pos, DiagnosticCode.INVALID_ERROR_DETAIL_TYPE, errorType.detailType, this.symTable.detailType);
        }
    }

    private BType getReasonType(BLangErrorType errorType) {
        if (errorType.reasonType == null) {
            return this.symTable.stringType;
        }
        return errorType.reasonType.type;
    }

    private void validateModuleQualifiedReasons(DiagnosticPos pos, BType reasonType) {
        switch (reasonType.tag) {
            case 5: {
                return;
            }
            case 31: {
                BFiniteType finiteType = (BFiniteType)reasonType;
                for (BLangExpression expr : finiteType.getValueSpace()) {
                    this.validateModuleQualifiedReason(pos, (String)((BLangLiteral)expr).value);
                }
                return;
            }
            case 20: {
                ((BUnionType)reasonType).getMemberTypes().forEach(type -> this.validateModuleQualifiedReasons(pos, (BType)type));
            }
        }
    }

    private void validateModuleQualifiedReason(DiagnosticPos pos, String reason) {
        if (!reason.startsWith(LEFT_BRACE)) {
            return;
        }
        PackageID currentPackageId = this.env.enclPkg.packageID;
        if (currentPackageId.isUnnamed || reason.contains(SPACE) || !reason.startsWith(LEFT_BRACE.concat(currentPackageId.toString().split(COLON)[0]).concat(RIGHT_BRACE))) {
            this.dlog.warning(pos, DiagnosticCode.NON_MODULE_QUALIFIED_ERROR_REASON, reason);
        }
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        annotationNode.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.ANNOTATION);
            annotationAttachment.accept(this);
        });
        this.validateAnnotationAttachmentCount(annotationNode.annAttachments);
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        BAnnotationSymbol annotationSymbol;
        BSymbol symbol = this.symResolver.resolveAnnotation(annAttachmentNode.pos, this.env, this.names.fromString(annAttachmentNode.pkgAlias.getValue()), this.names.fromString(annAttachmentNode.getAnnotationName().getValue()));
        if (symbol == this.symTable.notFoundSymbol) {
            this.dlog.error(annAttachmentNode.pos, DiagnosticCode.UNDEFINED_ANNOTATION, annAttachmentNode.getAnnotationName().getValue());
            return;
        }
        annAttachmentNode.annotationSymbol = annotationSymbol = (BAnnotationSymbol)symbol;
        if (annotationSymbol.maskedPoints > 0 && !Symbols.isAttachPointPresent(annotationSymbol.maskedPoints, AttachPoints.asMask(annAttachmentNode.attachPoints))) {
            String msg = annAttachmentNode.attachPoints.stream().map(point -> point.name().toLowerCase()).collect(Collectors.joining(", "));
            this.dlog.error(annAttachmentNode.pos, DiagnosticCode.ANNOTATION_NOT_ALLOWED, annotationSymbol, msg);
        }
        this.validateAnnotationAttachmentExpr(annAttachmentNode, annotationSymbol);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        BType lhsType;
        if (varNode.isDeclaredWithVar) {
            this.validateWorkerAnnAttachments(varNode.expr);
            this.handleDeclaredWithVar(varNode);
            this.transferForkFlag(varNode);
            return;
        }
        int ownerSymTag = this.env.scope.owner.tag;
        if ((ownerSymTag & 0x100) == 256 || (ownerSymTag & 0x8000000) == 0x8000000) {
            if (varNode.symbol == null) {
                this.analyzeVarNode(varNode, this.env, AttachPoint.Point.VAR);
            } else {
                this.analyzeVarNode(varNode, this.env, AttachPoint.Point.PARAMETER);
            }
        } else if ((ownerSymTag & 0x3005C) == 196700) {
            this.analyzeVarNode(varNode, this.env, AttachPoint.Point.OBJECT_FIELD, AttachPoint.Point.FIELD);
        } else if ((ownerSymTag & 0x5005C) == 327772) {
            this.analyzeVarNode(varNode, this.env, AttachPoint.Point.RECORD_FIELD, AttachPoint.Point.FIELD);
        } else {
            varNode.annAttachments.forEach(annotationAttachment -> {
                if (Symbols.isFlagOn(varNode.symbol.flags, 0x100000)) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.LISTENER);
                } else if (Symbols.isFlagOn(varNode.symbol.flags, 524288)) {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.SERVICE);
                } else {
                    annotationAttachment.attachPoints.add(AttachPoint.Point.VAR);
                }
                annotationAttachment.accept(this);
            });
        }
        this.validateAnnotationAttachmentCount(varNode.annAttachments);
        this.validateWorkerAnnAttachments(varNode.expr);
        if (this.isIgnoredOrEmpty(varNode)) {
            varNode.symbol = new BVarSymbol(0, Names.IGNORE, this.env.enclPkg.packageID, this.symTable.anyType, this.env.scope.owner);
        }
        varNode.type = lhsType = varNode.symbol.type;
        BLangExpression rhsExpr = varNode.expr;
        if (rhsExpr == null) {
            if (lhsType.tag == 19 && this.typeChecker.isArrayOpenSealedType((BArrayType)lhsType)) {
                this.dlog.error(varNode.pos, DiagnosticCode.SEALED_ARRAY_TYPE_NOT_INITIALIZED, new Object[0]);
            }
            return;
        }
        SymbolEnv varInitEnv = SymbolEnv.createVarInitEnv(varNode, this.env, varNode.symbol);
        this.typeChecker.checkExpr(rhsExpr, varInitEnv, lhsType);
        if (Symbols.isFlagOn(varNode.symbol.flags, 0x100000) && !this.types.checkListenerCompatibility(varNode.symbol.type)) {
            this.dlog.error(varNode.pos, DiagnosticCode.INVALID_LISTENER_VARIABLE, varNode.name);
        }
        this.transferForkFlag(varNode);
    }

    private void analyzeVarNode(BLangSimpleVariable varNode, SymbolEnv env, AttachPoint.Point ... attachPoints) {
        if (varNode.symbol == null) {
            this.symbolEnter.defineNode(varNode, env);
        }
        if (varNode.typeNode != null && varNode.typeNode.getKind() == NodeKind.RECORD_TYPE && !((BLangRecordTypeNode)varNode.typeNode).analyzed) {
            this.analyzeDef(varNode.typeNode, env);
        }
        List<AttachPoint.Point> attachPointsList = Arrays.asList(attachPoints);
        for (BLangAnnotationAttachment annotationAttachment : varNode.annAttachments) {
            annotationAttachment.attachPoints.addAll(attachPointsList);
            annotationAttachment.accept(this);
        }
    }

    private void transferForkFlag(BLangSimpleVariable varNode) {
        if (varNode.expr != null && varNode.expr.getKind() == NodeKind.INVOCATION && varNode.flagSet.contains((Object)Flag.WORKER)) {
            BLangInvocation expr = (BLangInvocation)varNode.expr;
            if (expr.name.value.startsWith("0") && (expr.symbol.flags & 0x2000000) == 0x2000000) {
                varNode.symbol.flags |= 0x2000000;
            }
        }
    }

    private void validateWorkerAnnAttachments(BLangExpression expr) {
        if (expr != null && expr.getKind() == NodeKind.INVOCATION && ((BLangInvocation)expr).async) {
            ((BLangInvocation)expr).annAttachments.forEach(annotationAttachment -> {
                annotationAttachment.attachPoints.add(AttachPoint.Point.WORKER);
                annotationAttachment.accept(this);
            });
            this.validateAnnotationAttachmentCount(((BLangInvocation)expr).annAttachments);
        }
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        if (varNode.isDeclaredWithVar) {
            this.handleDeclaredWithVar(varNode);
            return;
        }
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
        if (!this.validateRecordVariable(varNode)) {
            varNode.type = this.symTable.semanticError;
            return;
        }
        this.symbolEnter.defineNode(varNode, this.env);
        if (varNode.expr == null) {
            return;
        }
        this.typeChecker.checkExpr(varNode.expr, this.env, varNode.type);
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        if (varNode.isDeclaredWithVar) {
            this.expType = this.resolveTupleType(varNode);
            this.handleDeclaredWithVar(varNode);
            return;
        }
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
        if (!this.checkTypeAndVarCountConsistency(varNode)) {
            varNode.type = this.symTable.semanticError;
            return;
        }
        this.symbolEnter.defineNode(varNode, this.env);
        if (varNode.expr == null) {
            return;
        }
        this.typeChecker.checkExpr(varNode.expr, this.env, varNode.type);
    }

    private BType resolveTupleType(BLangTupleVariable varNode) {
        ArrayList<BType> memberTypes = new ArrayList<BType>(varNode.memberVariables.size());
        for (BLangVariable memberVariable : varNode.memberVariables) {
            if (memberVariable.getKind() == NodeKind.TUPLE_VARIABLE) {
                memberTypes.add(this.resolveTupleType((BLangTupleVariable)memberVariable));
                continue;
            }
            memberTypes.add(this.symTable.noType);
        }
        return new BTupleType(memberTypes);
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        if (varNode.isDeclaredWithVar) {
            this.handleDeclaredWithVar(varNode);
            return;
        }
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
        if (!varNode.reasonVarPrefixAvailable && varNode.type == null) {
            BErrorType errorType = new BErrorType(varNode.type.tsymbol, null, null);
            if (varNode.type.tag == 20) {
                Set<BType> members = this.types.expandAndGetMemberTypesRecursive(varNode.type);
                List errorMembers = members.stream().filter(m -> m.tag == 27).map(m -> (BErrorType)m).collect(Collectors.toList());
                if (errorMembers.isEmpty()) {
                    this.dlog.error(varNode.pos, DiagnosticCode.INVALID_ERROR_MATCH_PATTERN, new Object[0]);
                    return;
                }
                if (errorMembers.size() == 1) {
                    errorType.detailType = ((BErrorType)errorMembers.get((int)0)).detailType;
                    errorType.reasonType = ((BErrorType)errorMembers.get((int)0)).reasonType;
                } else {
                    errorType.detailType = this.symTable.detailType;
                    errorType.reasonType = this.symTable.stringType;
                }
                varNode.type = errorType;
            } else if (varNode.type.tag == 27) {
                errorType.detailType = ((BErrorType)varNode.type).detailType;
            }
            if (varNode.reasonMatchConst != null) {
                BTypeSymbol reasonConstTypeSymbol = new BTypeSymbol(0x10001C, 1, this.names.fromString(""), this.env.enclPkg.packageID, null, this.env.scope.owner);
                varNode.reasonMatchConst.type = this.symTable.stringType;
                this.typeChecker.checkExpr(varNode.reasonMatchConst, this.env);
                LinkedHashSet<BLangExpression> members = new LinkedHashSet<BLangExpression>();
                members.add(varNode.reasonMatchConst);
                errorType.reasonType = new BFiniteType(reasonConstTypeSymbol, members);
            } else {
                errorType.reasonType = this.symTable.stringType;
            }
        }
        if (!this.validateErrorVariable(varNode)) {
            varNode.type = this.symTable.semanticError;
            return;
        }
        this.symbolEnter.defineNode(varNode, this.env);
        if (varNode.expr == null) {
            return;
        }
        this.typeChecker.checkExpr(varNode.expr, this.env, varNode.type);
    }

    private void handleDeclaredWithVar(BLangVariable variable) {
        BLangExpression varRefExpr = variable.expr;
        BType rhsType = this.typeChecker.checkExpr(varRefExpr, this.env, this.expType);
        switch (variable.getKind()) {
            case VARIABLE: 
            case LET_VARIABLE: {
                if (!this.validateVariableDefinition(varRefExpr)) {
                    rhsType = this.symTable.semanticError;
                }
                if (variable.flagSet.contains((Object)Flag.LISTENER) && !this.types.checkListenerCompatibility(rhsType)) {
                    this.dlog.error(varRefExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, LISTENER_TYPE_NAME, rhsType);
                    return;
                }
                BLangSimpleVariable simpleVariable = (BLangSimpleVariable)variable;
                Name varName = this.names.fromIdNode(simpleVariable.name);
                if (varName == Names.IGNORE) {
                    this.dlog.error(simpleVariable.pos, DiagnosticCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT, new Object[0]);
                    return;
                }
                simpleVariable.type = rhsType;
                int ownerSymTag = this.env.scope.owner.tag;
                if (((ownerSymTag & 0x100) == 256 || (ownerSymTag & 0x8000000) == 0x8000000) && simpleVariable.symbol == null) {
                    this.symbolEnter.defineNode(simpleVariable, this.env);
                }
                simpleVariable.symbol.type = rhsType;
                break;
            }
            case TUPLE_VARIABLE: {
                if (variable.isDeclaredWithVar && variable.expr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                    ArrayList<String> bindingPatternVars = new ArrayList<String>();
                    List<BLangVariable> members = ((BLangTupleVariable)variable).memberVariables;
                    for (BLangVariable var : members) {
                        bindingPatternVars.add(((BLangSimpleVariable)var).name.value);
                    }
                    this.dlog.error(varRefExpr.pos, DiagnosticCode.CANNOT_INFER_TYPES_FOR_TUPLE_BINDING, bindingPatternVars);
                    variable.type = this.symTable.semanticError;
                    return;
                }
                if (29 != rhsType.tag) {
                    this.dlog.error(varRefExpr.pos, DiagnosticCode.INVALID_TUPLE_BINDING_PATTERN_INFERENCE, rhsType);
                    variable.type = this.symTable.semanticError;
                    return;
                }
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                tupleVariable.type = rhsType;
                if (!this.checkTypeAndVarCountConsistency(tupleVariable)) {
                    tupleVariable.type = this.symTable.semanticError;
                    return;
                }
                this.symbolEnter.defineNode(tupleVariable, this.env);
                break;
            }
            case RECORD_VARIABLE: {
                if (12 != rhsType.tag && 15 != rhsType.tag && 7 != rhsType.tag) {
                    this.dlog.error(varRefExpr.pos, DiagnosticCode.INVALID_TYPE_DEFINITION_FOR_RECORD_VAR, rhsType);
                    variable.type = this.symTable.semanticError;
                }
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                recordVariable.type = rhsType;
                if (this.validateRecordVariable(recordVariable)) break;
                recordVariable.type = this.symTable.semanticError;
                break;
            }
            case ERROR_VARIABLE: {
                if (27 != rhsType.tag) {
                    this.dlog.error(variable.expr.pos, DiagnosticCode.INVALID_TYPE_DEFINITION_FOR_ERROR_VAR, rhsType);
                    variable.type = this.symTable.semanticError;
                    return;
                }
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                if (errorVariable.typeNode != null) {
                    this.symResolver.resolveTypeNode(errorVariable.typeNode, this.env);
                }
                errorVariable.type = rhsType;
                if (!this.validateErrorVariable(errorVariable)) {
                    errorVariable.type = this.symTable.semanticError;
                    return;
                }
                this.symbolEnter.defineNode(errorVariable, this.env);
            }
        }
    }

    void handleDeclaredVarInForeach(BLangVariable variable, BType rhsType, SymbolEnv blockEnv) {
        switch (variable.getKind()) {
            case VARIABLE: {
                BLangSimpleVariable simpleVariable = (BLangSimpleVariable)variable;
                Name varName = this.names.fromIdNode(simpleVariable.name);
                if (varName == Names.IGNORE) {
                    this.dlog.error(simpleVariable.pos, DiagnosticCode.UNDERSCORE_NOT_ALLOWED, new Object[0]);
                    return;
                }
                simpleVariable.type = rhsType;
                int ownerSymTag = blockEnv.scope.owner.tag;
                if ((ownerSymTag & 0x100) == 256 && simpleVariable.symbol == null) {
                    this.symbolEnter.defineNode(simpleVariable, blockEnv);
                }
                this.recursivelySetFinalFlag(simpleVariable);
                break;
            }
            case TUPLE_VARIABLE: {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                if (29 != rhsType.tag && 20 != rhsType.tag) {
                    this.dlog.error(variable.pos, DiagnosticCode.INVALID_TUPLE_BINDING_PATTERN_INFERENCE, rhsType);
                    this.recursivelyDefineVariables(tupleVariable, blockEnv);
                    return;
                }
                tupleVariable.type = rhsType;
                if (rhsType.tag == 29 && !this.checkTypeAndVarCountConsistency(tupleVariable, (BTupleType)tupleVariable.type, blockEnv)) {
                    this.recursivelyDefineVariables(tupleVariable, blockEnv);
                    return;
                }
                if (rhsType.tag == 20 && !this.checkTypeAndVarCountConsistency(tupleVariable, null, blockEnv)) {
                    this.recursivelyDefineVariables(tupleVariable, blockEnv);
                    return;
                }
                this.symbolEnter.defineNode(tupleVariable, blockEnv);
                this.recursivelySetFinalFlag(tupleVariable);
                break;
            }
            case RECORD_VARIABLE: {
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                recordVariable.type = rhsType;
                this.validateRecordVariable(recordVariable, blockEnv);
                this.recursivelySetFinalFlag(recordVariable);
                break;
            }
            case ERROR_VARIABLE: {
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                if (27 != rhsType.tag) {
                    this.dlog.error(variable.pos, DiagnosticCode.INVALID_TYPE_DEFINITION_FOR_ERROR_VAR, rhsType);
                    this.recursivelyDefineVariables(errorVariable, blockEnv);
                    return;
                }
                errorVariable.type = rhsType;
                this.validateErrorVariable(errorVariable);
                this.recursivelySetFinalFlag(errorVariable);
            }
        }
    }

    private void recursivelyDefineVariables(BLangVariable variable, SymbolEnv blockEnv) {
        switch (variable.getKind()) {
            case VARIABLE: {
                Name name = this.names.fromIdNode(((BLangSimpleVariable)variable).name);
                if (name == Names.IGNORE) {
                    return;
                }
                variable.type = this.symTable.semanticError;
                this.symbolEnter.defineVarSymbol(variable.pos, variable.flagSet, variable.type, name, blockEnv);
                break;
            }
            case TUPLE_VARIABLE: {
                ((BLangTupleVariable)variable).memberVariables.forEach(memberVariable -> this.recursivelyDefineVariables((BLangVariable)memberVariable, blockEnv));
                break;
            }
            case RECORD_VARIABLE: {
                ((BLangRecordVariable)variable).variableList.forEach(value -> this.recursivelyDefineVariables(value.valueBindingPattern, blockEnv));
            }
        }
    }

    private void recursivelySetFinalFlag(BLangVariable variable) {
        if (variable == null) {
            return;
        }
        switch (variable.getKind()) {
            case VARIABLE: {
                if (variable.symbol == null) {
                    return;
                }
                variable.symbol.flags |= 4;
                break;
            }
            case TUPLE_VARIABLE: {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                tupleVariable.memberVariables.forEach(this::recursivelySetFinalFlag);
                this.recursivelySetFinalFlag(tupleVariable.restVariable);
                break;
            }
            case RECORD_VARIABLE: {
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                recordVariable.variableList.forEach(value -> this.recursivelySetFinalFlag(value.valueBindingPattern));
                this.recursivelySetFinalFlag((BLangVariable)recordVariable.restParam);
                break;
            }
            case ERROR_VARIABLE: {
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                this.recursivelySetFinalFlag(errorVariable.reason);
                this.recursivelySetFinalFlag(errorVariable.restDetail);
                errorVariable.detail.forEach(bLangErrorDetailEntry -> this.recursivelySetFinalFlag(bLangErrorDetailEntry.valueBindingPattern));
            }
        }
    }

    private boolean checkTypeAndVarCountConsistency(BLangTupleVariable varNode) {
        return this.checkTypeAndVarCountConsistency(varNode, null, this.env);
    }

    private boolean checkTypeAndVarCountConsistency(BLangTupleVariable varNode, BTupleType tupleTypeNode, SymbolEnv env) {
        if (tupleTypeNode == null) {
            switch (varNode.type.tag) {
                case 20: {
                    Set<BType> unionType = this.types.expandAndGetMemberTypesRecursive(varNode.type);
                    List possibleTypes = unionType.stream().filter(type -> {
                        if (29 == type.tag && varNode.memberVariables.size() == ((BTupleType)type).tupleTypes.size()) {
                            return true;
                        }
                        return 17 == type.tag || 11 == type.tag;
                    }).collect(Collectors.toList());
                    if (possibleTypes.isEmpty()) {
                        this.dlog.error(varNode.pos, DiagnosticCode.INVALID_TUPLE_BINDING_PATTERN_DECL, varNode.type);
                        return false;
                    }
                    if (possibleTypes.size() > 1) {
                        ArrayList<BType> memberTupleTypes = new ArrayList<BType>();
                        for (int i = 0; i < varNode.memberVariables.size(); ++i) {
                            LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
                            for (BType possibleType : possibleTypes) {
                                if (possibleType.tag == 29) {
                                    memberTypes.add(((BTupleType)possibleType).tupleTypes.get(i));
                                    continue;
                                }
                                memberTupleTypes.add(varNode.type);
                            }
                            if (memberTypes.size() > 1) {
                                memberTupleTypes.add(BUnionType.create(null, memberTypes));
                                continue;
                            }
                            memberTupleTypes.addAll(memberTypes);
                        }
                        tupleTypeNode = new BTupleType(memberTupleTypes);
                        break;
                    }
                    if (((BType)possibleTypes.get((int)0)).tag == 29) {
                        tupleTypeNode = (BTupleType)possibleTypes.get(0);
                        break;
                    }
                    ArrayList<BType> memberTypes = new ArrayList<BType>();
                    for (int i = 0; i < varNode.memberVariables.size(); ++i) {
                        memberTypes.add((BType)possibleTypes.get(0));
                    }
                    tupleTypeNode = new BTupleType(memberTypes);
                    break;
                }
                case 11: 
                case 17: {
                    ArrayList<BType> memberTupleTypes = new ArrayList<BType>();
                    for (int i = 0; i < varNode.memberVariables.size(); ++i) {
                        memberTupleTypes.add(varNode.type);
                    }
                    tupleTypeNode = new BTupleType(memberTupleTypes);
                    if (varNode.restVariable == null) break;
                    tupleTypeNode.restType = varNode.type;
                    break;
                }
                case 29: {
                    tupleTypeNode = (BTupleType)varNode.type;
                    break;
                }
                default: {
                    this.dlog.error(varNode.pos, DiagnosticCode.INVALID_TUPLE_BINDING_PATTERN_DECL, varNode.type);
                    return false;
                }
            }
        }
        if (tupleTypeNode.tupleTypes.size() != varNode.memberVariables.size() || tupleTypeNode.restType == null && varNode.restVariable != null || tupleTypeNode.restType != null && varNode.restVariable == null) {
            this.dlog.error(varNode.pos, DiagnosticCode.INVALID_TUPLE_BINDING_PATTERN, new Object[0]);
            return false;
        }
        int ignoredCount = 0;
        ArrayList<BLangVariable> memberVariables = new ArrayList<BLangVariable>(varNode.memberVariables);
        if (varNode.restVariable != null) {
            memberVariables.add(varNode.restVariable);
        }
        for (int i = 0; i < memberVariables.size(); ++i) {
            BType type2;
            BLangVariable var = (BLangVariable)memberVariables.get(i);
            BType bType = type2 = i <= tupleTypeNode.tupleTypes.size() - 1 ? tupleTypeNode.tupleTypes.get(i) : new BArrayType(tupleTypeNode.restType);
            if (var.getKind() == NodeKind.VARIABLE) {
                BLangSimpleVariable simpleVar = (BLangSimpleVariable)var;
                Name varName = this.names.fromIdNode(simpleVar.name);
                if (varName == Names.IGNORE) {
                    ++ignoredCount;
                    simpleVar.type = this.symTable.anyType;
                    this.types.checkType(varNode.pos, type2, simpleVar.type, DiagnosticCode.INCOMPATIBLE_TYPES);
                    continue;
                }
            }
            var.type = type2;
            this.analyzeNode(var, env);
        }
        if (!varNode.memberVariables.isEmpty() && ignoredCount == varNode.memberVariables.size() && varNode.restVariable == null) {
            this.dlog.error(varNode.pos, DiagnosticCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateRecordVariable(BLangRecordVariable recordVar) {
        return this.validateRecordVariable(recordVar, this.env);
    }

    private boolean validateRecordVariable(BLangRecordVariable recordVar, SymbolEnv env) {
        BRecordType recordVarType;
        switch (recordVar.type.tag) {
            case 20: {
                BUnionType unionType = (BUnionType)recordVar.type;
                Set<BType> bTypes = this.types.expandAndGetMemberTypesRecursive(unionType);
                List<BType> possibleTypes = bTypes.stream().filter(rec -> this.doesRecordContainKeys((BType)rec, recordVar.variableList, recordVar.restParam != null)).collect(Collectors.toList());
                if (possibleTypes.isEmpty()) {
                    this.dlog.error(recordVar.pos, DiagnosticCode.INVALID_RECORD_BINDING_PATTERN, recordVar.type);
                    return false;
                }
                if (possibleTypes.size() > 1) {
                    BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(0, this.names.fromString(ANONYMOUS_RECORD_NAME), env.enclPkg.symbol.pkgID, null, env.scope.owner);
                    recordVarType = (BRecordType)this.symTable.recordType;
                    List<BField> fields = this.populateAndGetPossibleFieldsForRecVar(recordVar, possibleTypes, recordSymbol);
                    if (recordVar.restParam != null) {
                        LinkedHashSet memberTypes = possibleTypes.stream().map(possibleType -> {
                            if (possibleType.tag == 12) {
                                return ((BRecordType)possibleType).restFieldType;
                            }
                            if (possibleType.tag == 15) {
                                return ((BMapType)possibleType).constraint;
                            }
                            return possibleType;
                        }).collect(Collectors.toCollection(LinkedHashSet::new));
                        recordVarType.restFieldType = memberTypes.size() > 1 ? BUnionType.create(null, memberTypes) : (BType)memberTypes.iterator().next();
                    }
                    recordVarType.tsymbol = recordSymbol;
                    recordVarType.fields = fields;
                    recordSymbol.type = recordVarType;
                    break;
                }
                if (((BType)possibleTypes.get((int)0)).tag == 12) {
                    recordVarType = (BRecordType)possibleTypes.get(0);
                    break;
                }
                if (((BType)possibleTypes.get((int)0)).tag == 15) {
                    recordVarType = this.createSameTypedFieldsRecordType(recordVar, ((BMapType)possibleTypes.get((int)0)).constraint);
                    break;
                }
                recordVarType = this.createSameTypedFieldsRecordType(recordVar, (BType)possibleTypes.get(0));
                break;
            }
            case 12: {
                recordVarType = (BRecordType)recordVar.type;
                break;
            }
            case 15: {
                recordVarType = this.createSameTypedFieldsRecordType(recordVar, ((BMapType)recordVar.type).constraint);
                break;
            }
            case 11: 
            case 17: {
                recordVarType = this.createSameTypedFieldsRecordType(recordVar, recordVar.type);
                break;
            }
            default: {
                this.dlog.error(recordVar.pos, DiagnosticCode.INVALID_RECORD_BINDING_PATTERN, recordVar.type);
                return false;
            }
        }
        Map<String, BField> recordVarTypeFields = recordVarType.fields.stream().collect(Collectors.toMap(field -> field.getName().getValue(), field -> field));
        boolean validRecord = true;
        int ignoredCount = 0;
        for (BLangRecordVariable.BLangRecordVariableKeyValue variable : recordVar.variableList) {
            if (this.names.fromIdNode(variable.getKey()) == Names.IGNORE) {
                this.dlog.error(recordVar.pos, DiagnosticCode.UNDERSCORE_NOT_ALLOWED, new Object[0]);
                continue;
            }
            BLangVariable value = variable.getValue();
            if (value.getKind() == NodeKind.VARIABLE) {
                BLangSimpleVariable simpleVar = (BLangSimpleVariable)value;
                Name varName = this.names.fromIdNode(simpleVar.name);
                if (varName == Names.IGNORE) {
                    ++ignoredCount;
                    simpleVar.type = this.symTable.anyType;
                    if (!recordVarTypeFields.containsKey(variable.getKey().getValue())) continue;
                    this.types.checkType(variable.valueBindingPattern.pos, recordVarTypeFields.get((Object)variable.getKey().getValue()).type, simpleVar.type, DiagnosticCode.INCOMPATIBLE_TYPES);
                    continue;
                }
            }
            if (!recordVarTypeFields.containsKey(variable.getKey().getValue())) {
                if (recordVarType.sealed) {
                    validRecord = false;
                    this.dlog.error(recordVar.pos, DiagnosticCode.INVALID_FIELD_IN_RECORD_BINDING_PATTERN, variable.getKey().getValue(), recordVar.type);
                    continue;
                }
                BType restType = recordVarType.restFieldType.tag == 11 || recordVarType.restFieldType.tag == 17 ? recordVarType.restFieldType : BUnionType.create(null, recordVarType.restFieldType, this.symTable.nilType);
                value.type = restType;
                value.accept(this);
                continue;
            }
            value.type = recordVarTypeFields.get((Object)variable.getKey().getValue()).type;
            value.accept(this);
        }
        if (!recordVar.variableList.isEmpty() && ignoredCount == recordVar.variableList.size() && recordVar.restParam == null) {
            this.dlog.error(recordVar.pos, DiagnosticCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT, new Object[0]);
            return false;
        }
        if (recordVar.restParam != null) {
            ((BLangVariable)recordVar.restParam).type = this.getRestParamType(recordVarType);
            this.symbolEnter.defineNode((BLangNode)((Object)recordVar.restParam), env);
        }
        return validRecord;
    }

    private boolean validateErrorVariable(BLangErrorVariable errorVariable) {
        BErrorType errorType;
        switch (errorVariable.type.tag) {
            case 20: {
                BUnionType unionType = (BUnionType)errorVariable.type;
                List possibleTypes = unionType.getMemberTypes().stream().filter(type -> 27 == type.tag).map(BErrorType.class::cast).collect(Collectors.toList());
                if (possibleTypes.isEmpty()) {
                    this.dlog.error(errorVariable.pos, DiagnosticCode.INVALID_ERROR_BINDING_PATTERN, errorVariable.type);
                    return false;
                }
                if (possibleTypes.size() > 1) {
                    LinkedHashSet<BType> detailType = new LinkedHashSet<BType>();
                    for (BErrorType possibleErrType : possibleTypes) {
                        detailType.add(possibleErrType.detailType);
                    }
                    BType errorDetailType = detailType.size() > 1 ? BUnionType.create(null, detailType) : (BType)detailType.iterator().next();
                    errorType = new BErrorType(null, this.symTable.stringType, errorDetailType);
                    break;
                }
                errorType = (BErrorType)possibleTypes.get(0);
                break;
            }
            case 27: {
                errorType = (BErrorType)errorVariable.type;
                break;
            }
            default: {
                this.dlog.error(errorVariable.pos, DiagnosticCode.INVALID_ERROR_BINDING_PATTERN, errorVariable.type);
                return false;
            }
        }
        errorVariable.type = errorType;
        boolean isReasonIgnored = false;
        BLangSimpleVariable reasonVariable = errorVariable.reason;
        if (Names.IGNORE == this.names.fromIdNode(reasonVariable.name)) {
            reasonVariable.type = this.symTable.noType;
            isReasonIgnored = true;
        } else {
            errorVariable.reason.type = errorType.reasonType;
            errorVariable.reason.accept(this);
        }
        if (errorVariable.detail == null || errorVariable.detail.isEmpty() && !this.isRestDetailBindingAvailable(errorVariable)) {
            if (isReasonIgnored) {
                this.dlog.error(errorVariable.pos, DiagnosticCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT, new Object[0]);
                return false;
            }
            return this.validateErrorReasonMatchPatternSyntax(errorVariable);
        }
        if (errorType.detailType.getKind() == TypeKind.RECORD) {
            return this.validateErrorVariable(errorVariable, errorType);
        }
        if (errorType.detailType.getKind() == TypeKind.UNION) {
            BErrorTypeSymbol errorTypeSymbol = new BErrorTypeSymbol(589852, 1, Names.ERROR, this.env.enclPkg.packageID, this.symTable.errorType, this.env.scope.owner);
            errorVariable.type = new BErrorType(errorTypeSymbol, this.symTable.stringType, this.symTable.detailType);
            return this.validateErrorVariable(errorVariable);
        }
        if (this.isRestDetailBindingAvailable(errorVariable)) {
            errorVariable.restDetail.type = this.symTable.detailType;
            errorVariable.restDetail.accept(this);
        }
        return true;
    }

    private boolean validateErrorVariable(BLangErrorVariable errorVariable, BErrorType errorType) {
        if (!this.validateErrorReasonMatchPatternSyntax(errorVariable)) {
            return false;
        }
        BRecordType recordType = (BRecordType)errorType.detailType;
        Map<String, BField> detailFields = recordType.fields.stream().collect(Collectors.toMap(f -> f.name.value, f -> f));
        HashSet<String> matchedDetailFields = new HashSet<String>();
        for (BLangErrorVariable.BLangErrorDetailEntry errorDetailEntry : errorVariable.detail) {
            boolean isIgnoredVar;
            String entryName = errorDetailEntry.key.getValue();
            matchedDetailFields.add(entryName);
            BField entryField = detailFields.get(entryName);
            BLangVariable boundVar = errorDetailEntry.valueBindingPattern;
            if (entryField != null) {
                boundVar.type = (entryField.symbol.flags & 0x2000) == 8192 ? BUnionType.create(null, entryField.type, this.symTable.nilType) : entryField.type;
            } else {
                if (recordType.sealed) {
                    this.dlog.error(errorVariable.pos, DiagnosticCode.INVALID_ERROR_BINDING_PATTERN, errorVariable.type);
                    boundVar.type = this.symTable.semanticError;
                    return false;
                }
                boundVar.type = BUnionType.create(null, recordType.restFieldType, this.symTable.nilType);
            }
            if (isIgnoredVar = boundVar.getKind() == NodeKind.VARIABLE && ((BLangSimpleVariable)boundVar).name.value.equals(Names.IGNORE.value)) continue;
            boundVar.accept(this);
        }
        if (this.isRestDetailBindingAvailable(errorVariable)) {
            BTypeSymbol typeSymbol = this.createTypeSymbol(12);
            BType constraint = this.getRestMapConstraintType(detailFields, matchedDetailFields, recordType);
            BMapType restType = new BMapType(15, constraint, typeSymbol);
            typeSymbol.type = restType;
            errorVariable.restDetail.type = restType;
            errorVariable.restDetail.accept(this);
        }
        return true;
    }

    private BType getRestMapConstraintType(Map<String, BField> errorDetailFields, Set<String> matchedDetailFields, BRecordType recordType) {
        BUnionType restUnionType = BUnionType.create(null, new BType[0]);
        if (!recordType.sealed) {
            restUnionType.add(recordType.restFieldType);
        }
        for (Map.Entry<String, BField> entry : errorDetailFields.entrySet()) {
            BType type;
            if (matchedDetailFields.contains(entry.getKey()) || this.types.isAssignable(type = entry.getValue().getType(), restUnionType)) continue;
            restUnionType.add(type);
        }
        Set<BType> memberTypes = restUnionType.getMemberTypes();
        if (memberTypes.size() == 1) {
            return memberTypes.iterator().next();
        }
        return restUnionType;
    }

    private boolean validateErrorReasonMatchPatternSyntax(BLangErrorVariable errorVariable) {
        if (errorVariable.isInMatchStmt && !errorVariable.reasonVarPrefixAvailable && errorVariable.reasonMatchConst == null && this.isReasonSpecified(errorVariable)) {
            BSymbol reasonConst = this.symResolver.lookupSymbolInMainSpace(this.env.enclEnv, this.names.fromString(errorVariable.reason.name.value));
            if ((reasonConst.tag & 0x100001C) != 0x100001C) {
                this.dlog.error(errorVariable.reason.pos, DiagnosticCode.INVALID_ERROR_REASON_BINDING_PATTERN, errorVariable.reason.name);
            } else {
                this.dlog.error(errorVariable.reason.pos, DiagnosticCode.UNSUPPORTED_ERROR_REASON_CONST_MATCH, new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isReasonSpecified(BLangErrorVariable errorVariable) {
        return !this.isIgnoredOrEmpty(errorVariable.reason);
    }

    private boolean isIgnoredOrEmpty(BLangSimpleVariable varNode) {
        return varNode.name.value.equals(Names.IGNORE.value) || varNode.name.value.equals("");
    }

    private boolean isRestDetailBindingAvailable(BLangErrorVariable errorVariable) {
        return errorVariable.restDetail != null && !errorVariable.restDetail.name.value.equals(Names.IGNORE.value);
    }

    private BTypeSymbol createTypeSymbol(int type) {
        return new BTypeSymbol(type, 1, Names.EMPTY, this.env.enclPkg.packageID, null, this.env.scope.owner);
    }

    private List<BField> populateAndGetPossibleFieldsForRecVar(BLangRecordVariable recordVar, List<BType> possibleTypes, BRecordTypeSymbol recordSymbol) {
        ArrayList<BField> fields = new ArrayList<BField>();
        for (BLangRecordVariable.BLangRecordVariableKeyValue bLangRecordVariableKeyValue : recordVar.variableList) {
            String fieldName = bLangRecordVariableKeyValue.key.value;
            LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
            for (BType possibleType : possibleTypes) {
                if (possibleType.tag == 12) {
                    BRecordType possibleRecordType = (BRecordType)possibleType;
                    Optional<BField> optionalField = possibleRecordType.fields.stream().filter(field -> field.getName().getValue().equals(fieldName)).findFirst();
                    if (optionalField.isPresent()) {
                        BField bField = optionalField.get();
                        if (Symbols.isOptional(bField.symbol)) {
                            memberTypes.add(this.symTable.nilType);
                        }
                        memberTypes.add(bField.type);
                        continue;
                    }
                    memberTypes.add(possibleRecordType.restFieldType);
                    memberTypes.add(this.symTable.nilType);
                    continue;
                }
                if (possibleType.tag == 15) {
                    BMapType possibleMapType = (BMapType)possibleType;
                    memberTypes.add(possibleMapType.constraint);
                    continue;
                }
                memberTypes.add(possibleType);
            }
            BType fieldType = memberTypes.size() > 1 ? BUnionType.create(null, memberTypes) : (BType)memberTypes.iterator().next();
            fields.add(new BField(this.names.fromString(fieldName), recordVar.pos, new BVarSymbol(0, this.names.fromString(fieldName), this.env.enclPkg.symbol.pkgID, fieldType, recordSymbol)));
        }
        return fields;
    }

    private BRecordType createSameTypedFieldsRecordType(BLangRecordVariable recordVar, BType fieldTypes) {
        BType fieldType = fieldTypes.isNullable() ? fieldTypes : BUnionType.create(null, fieldTypes, this.symTable.nilType);
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(0, this.names.fromString(ANONYMOUS_RECORD_NAME), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        List fields = recordVar.variableList.stream().map(bLangRecordVariableKeyValue -> bLangRecordVariableKeyValue.key.value).map(fieldName -> new BField(this.names.fromString((String)fieldName), recordVar.pos, new BVarSymbol(0, this.names.fromString((String)fieldName), this.env.enclPkg.symbol.pkgID, fieldType, recordSymbol))).collect(Collectors.toList());
        BRecordType recordVarType = (BRecordType)this.symTable.recordType;
        recordVarType.fields = fields;
        recordSymbol.type = recordVarType;
        recordVarType.tsymbol = recordSymbol;
        recordVarType.sealed = false;
        recordVarType.restFieldType = fieldTypes;
        return recordVarType;
    }

    private boolean doesRecordContainKeys(BType varType, List<BLangRecordVariable.BLangRecordVariableKeyValue> variableList, boolean hasRestParam) {
        if (varType.tag == 15 || varType.tag == 17 || varType.tag == 11) {
            return true;
        }
        if (varType.tag != 12) {
            return false;
        }
        BRecordType recordVarType = (BRecordType)varType;
        Map<String, BField> recordVarTypeFields = recordVarType.fields.stream().collect(Collectors.toMap(field -> field.getName().getValue(), field -> field));
        for (BLangRecordVariable.BLangRecordVariableKeyValue var : variableList) {
            if (recordVarTypeFields.containsKey(var.key.value) || !recordVarType.sealed) continue;
            return false;
        }
        if (!hasRestParam) {
            return true;
        }
        return !recordVarType.sealed;
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        this.env = SymbolEnv.createBlockEnv(blockNode, this.env);
        blockNode.stmts.forEach(stmt -> this.analyzeStmt((BLangStatement)stmt, this.env));
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        Name varName = this.names.fromIdNode(varDefNode.var.name);
        if (varName == Names.IGNORE) {
            this.dlog.error(varDefNode.var.pos, DiagnosticCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT, new Object[0]);
            return;
        }
        this.analyzeDef(varDefNode.var, this.env);
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode) {
        if (varDefNode.var.expr.getKind() == NodeKind.RECORD_LITERAL_EXPR) {
            this.dlog.error(varDefNode.pos, DiagnosticCode.INVALID_LITERAL_FOR_TYPE, "record binding pattern");
            return;
        }
        this.analyzeDef(varDefNode.var, this.env);
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode) {
        this.analyzeDef(varDefNode.errorVariable, this.env);
    }

    @Override
    public void visit(BLangTupleVariableDef tupleVariableDef) {
        this.analyzeDef(tupleVariableDef.var, this.env);
    }

    private Boolean validateLhsVar(BLangExpression vRef) {
        if (vRef.getKind() == NodeKind.INVOCATION) {
            this.dlog.error(((BLangInvocation)vRef).pos, DiagnosticCode.INVALID_INVOCATION_LVALUE_ASSIGNMENT, vRef);
            return false;
        }
        if (vRef.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || vRef.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            this.validateLhsVar(((BLangAccessExpression)vRef).expr);
        }
        return true;
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment) {
        ArrayList<BType> expTypes = new ArrayList<BType>();
        BLangVariableReference varRef = compoundAssignment.varRef;
        boolean isValidVarRef = this.validateLhsVar(varRef);
        if (isValidVarRef) {
            compoundAssignment.varRef.compoundAssignmentLhsVar = true;
            this.typeChecker.checkExpr(varRef, this.env);
            expTypes.add(varRef.type);
        } else {
            expTypes.add(this.symTable.semanticError);
        }
        this.typeChecker.checkExpr(compoundAssignment.expr, this.env);
        this.checkConstantAssignment(varRef);
        if (expTypes.get(0) != this.symTable.semanticError && compoundAssignment.expr.type != this.symTable.semanticError) {
            BSymbol opSymbol = this.symResolver.resolveBinaryOperator(compoundAssignment.opKind, (BType)expTypes.get(0), compoundAssignment.expr.type);
            if (opSymbol == this.symTable.notFoundSymbol) {
                this.dlog.error(compoundAssignment.pos, DiagnosticCode.BINARY_OP_INCOMPATIBLE_TYPES, new Object[]{compoundAssignment.opKind, expTypes.get(0), compoundAssignment.expr.type});
            } else {
                compoundAssignment.modifiedExpr = this.getBinaryExpr(varRef, compoundAssignment.expr, compoundAssignment.opKind, opSymbol);
                compoundAssignment.modifiedExpr.parent = compoundAssignment;
                this.types.checkTypes(compoundAssignment.modifiedExpr, Lists.of(compoundAssignment.modifiedExpr.type), expTypes);
            }
        }
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        BLangExpression varRef = assignNode.varRef;
        if (varRef.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || varRef.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            ((BLangAccessExpression)varRef).leafNode = true;
        }
        this.setTypeOfVarRefInAssignment(varRef);
        this.expType = varRef.type;
        this.typeChecker.checkExpr(assignNode.expr, this.env, this.expType);
        this.validateWorkerAnnAttachments(assignNode.expr);
        this.resetTypeNarrowing(varRef, assignNode.expr.type);
    }

    @Override
    public void visit(BLangTupleDestructure tupleDeStmt) {
        for (BLangExpression tupleVar : tupleDeStmt.varRef.expressions) {
            this.setTypeOfVarRefForBindingPattern(tupleVar);
        }
        if (tupleDeStmt.varRef.restParam != null) {
            this.setTypeOfVarRefForBindingPattern((BLangExpression)tupleDeStmt.varRef.restParam);
        }
        this.setTypeOfVarRef(tupleDeStmt.varRef);
        BType type = this.typeChecker.checkExpr(tupleDeStmt.expr, this.env, tupleDeStmt.varRef.type);
        if (tupleDeStmt.expr.type.tag == 19) {
            this.dlog.error(tupleDeStmt.expr.pos, DiagnosticCode.BINDING_PATTERN_NOT_YET_SUPPORTED, tupleDeStmt.expr.type);
            return;
        }
        if (type.tag != 26) {
            this.checkTupleVarRefEquivalency(tupleDeStmt.pos, tupleDeStmt.varRef, tupleDeStmt.expr.type, tupleDeStmt.expr.pos);
        }
    }

    @Override
    public void visit(BLangRecordDestructure recordDeStmt) {
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue keyValue : recordDeStmt.varRef.recordRefFields) {
            this.setTypeOfVarRefForBindingPattern(keyValue.variableReference);
        }
        if (recordDeStmt.varRef.restParam != null) {
            this.setTypeOfVarRefForBindingPattern((BLangExpression)recordDeStmt.varRef.restParam);
        }
        this.setTypeOfVarRef(recordDeStmt.varRef);
        this.typeChecker.checkExpr(recordDeStmt.varRef, this.env);
        if (recordDeStmt.expr.getKind() == NodeKind.RECORD_LITERAL_EXPR) {
            this.dlog.error(recordDeStmt.expr.pos, DiagnosticCode.INVALID_RECORD_LITERAL_BINDING_PATTERN, new Object[0]);
            return;
        }
        this.typeChecker.checkExpr(recordDeStmt.expr, this.env);
        this.checkRecordVarRefEquivalency(recordDeStmt.pos, recordDeStmt.varRef, recordDeStmt.expr.type, recordDeStmt.expr.pos);
    }

    @Override
    public void visit(BLangErrorDestructure errorDeStmt) {
        if (errorDeStmt.varRef.reason.getKind() != NodeKind.SIMPLE_VARIABLE_REF || this.names.fromIdNode(((BLangSimpleVarRef)errorDeStmt.varRef.reason).variableName) != Names.IGNORE) {
            this.setTypeOfVarRefInErrorBindingAssignment(errorDeStmt.varRef.reason);
        } else {
            errorDeStmt.varRef.reason.type = this.symTable.noType;
        }
        this.typeChecker.checkExpr(errorDeStmt.expr, this.env);
        this.checkErrorVarRefEquivalency(errorDeStmt.pos, errorDeStmt.varRef, errorDeStmt.expr.type, errorDeStmt.expr.pos);
    }

    private void checkRecordVarRefEquivalency(DiagnosticPos pos, BLangRecordVarRef lhsVarRef, BType rhsType, DiagnosticPos rhsPos) {
        if (rhsType.tag == 15) {
            BType expectedType;
            final BMapType rhsMapType = (BMapType)rhsType;
            switch (rhsMapType.constraint.tag) {
                case 7: 
                case 11: 
                case 17: {
                    expectedType = rhsMapType.constraint;
                    break;
                }
                case 20: {
                    final BUnionType unionType = (BUnionType)rhsMapType.constraint;
                    LinkedHashSet<BType> unionMemberTypes = new LinkedHashSet<BType>(){
                        {
                            this.addAll(unionType.getMemberTypes());
                            this.add(((SemanticAnalyzer)SemanticAnalyzer.this).symTable.nilType);
                        }
                    };
                    expectedType = BUnionType.create(null, unionMemberTypes);
                    break;
                }
                default: {
                    expectedType = BUnionType.create(null, new LinkedHashSet<BType>(){
                        {
                            this.add(rhsMapType.constraint);
                            this.add(((SemanticAnalyzer)SemanticAnalyzer.this).symTable.nilType);
                        }
                    });
                }
            }
            lhsVarRef.recordRefFields.forEach(field -> this.types.checkType(field.variableReference.pos, expectedType, field.variableReference.type, DiagnosticCode.INCOMPATIBLE_TYPES));
            if (lhsVarRef.restParam != null) {
                this.types.checkType(((BLangSimpleVarRef)lhsVarRef.restParam).pos, (BType)rhsMapType, ((BLangSimpleVarRef)lhsVarRef.restParam).type, DiagnosticCode.INCOMPATIBLE_TYPES);
            }
            return;
        }
        if (rhsType.tag != 12) {
            this.dlog.error(rhsPos, DiagnosticCode.INCOMPATIBLE_TYPES, "record type", rhsType);
            return;
        }
        BRecordType rhsRecordType = (BRecordType)rhsType;
        lhsVarRef.recordRefFields.stream().filter(lhsField -> rhsRecordType.fields.stream().noneMatch(rhsField -> lhsField.variableName.value.equals(rhsField.name.toString()))).forEach(lhsField -> this.dlog.error(pos, DiagnosticCode.INVALID_FIELD_IN_RECORD_BINDING_PATTERN, lhsField.variableName.value, rhsType));
        for (BField rhsField : rhsRecordType.fields) {
            List expField = lhsVarRef.recordRefFields.stream().filter(field -> field.variableName.value.equals(rhsField.name.toString())).collect(Collectors.toList());
            if (expField.isEmpty()) continue;
            if (expField.size() > 1) {
                this.dlog.error(pos, DiagnosticCode.MULTIPLE_RECORD_REF_PATTERN_FOUND, rhsField.name);
                return;
            }
            BLangExpression variableReference = ((BLangRecordVarRef.BLangRecordVarRefKeyValue)expField.get((int)0)).variableReference;
            if (variableReference.getKind() == NodeKind.RECORD_VARIABLE_REF) {
                this.checkRecordVarRefEquivalency(variableReference.pos, (BLangRecordVarRef)variableReference, rhsField.type, rhsPos);
                continue;
            }
            if (variableReference.getKind() == NodeKind.TUPLE_VARIABLE_REF) {
                this.checkTupleVarRefEquivalency(pos, (BLangTupleVarRef)variableReference, rhsField.type, rhsPos);
                continue;
            }
            if (variableReference.getKind() == NodeKind.ERROR_VARIABLE_REF) {
                this.checkErrorVarRefEquivalency(pos, (BLangErrorVarRef)variableReference, rhsField.type, rhsPos);
                continue;
            }
            if (variableReference.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                Name varName = this.names.fromIdNode(((BLangSimpleVarRef)variableReference).variableName);
                if (varName == Names.IGNORE) continue;
                this.resetTypeNarrowing(variableReference, rhsField.type);
                this.types.checkType(variableReference.pos, rhsField.type, variableReference.type, DiagnosticCode.INCOMPATIBLE_TYPES);
                continue;
            }
            this.dlog.error(variableReference.pos, DiagnosticCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, variableReference);
        }
        if (lhsVarRef.restParam != null) {
            this.types.checkType(((BLangSimpleVarRef)lhsVarRef.restParam).pos, (BType)this.getRestParamType(rhsRecordType), ((BLangSimpleVarRef)lhsVarRef.restParam).type, DiagnosticCode.INCOMPATIBLE_TYPES);
        }
    }

    private BMapType getRestParamType(BRecordType recordType) {
        BType memberType = this.hasErrorTypedField(recordType) ? (this.hasOnlyPureTypedFields(recordType) ? this.symTable.pureType : BUnionType.create(null, this.symTable.anyType, this.symTable.errorType)) : (this.hasOnlyAnydataTypedFields(recordType) ? this.symTable.anydataType : this.symTable.anyType);
        return new BMapType(15, memberType, null);
    }

    private boolean hasOnlyAnydataTypedFields(BRecordType recordType) {
        boolean allAnydataFields = recordType.fields.stream().map(field -> field.type).allMatch(fieldType -> fieldType.isAnydata());
        return allAnydataFields && (recordType.sealed || recordType.restFieldType.isAnydata());
    }

    private boolean hasOnlyPureTypedFields(BRecordType recordType) {
        boolean allPureFields = recordType.fields.stream().map(field -> field.type).allMatch(fieldType -> fieldType.isPureType());
        return allPureFields && (recordType.sealed || recordType.restFieldType.isPureType());
    }

    private boolean hasErrorTypedField(BRecordType recordType) {
        return this.hasErrorType(recordType.restFieldType) || recordType.fields.stream().map(field -> field.type).anyMatch(this::hasErrorType);
    }

    private boolean hasErrorType(BType type) {
        if (type.tag != 20) {
            return type.tag == 27;
        }
        return ((BUnionType)type).getMemberTypes().stream().anyMatch(this::hasErrorType);
    }

    private void checkTupleVarRefEquivalency(DiagnosticPos pos, BLangTupleVarRef target, BType source, DiagnosticPos rhsPos) {
        if (source.tag != 29) {
            this.dlog.error(rhsPos, DiagnosticCode.INCOMPATIBLE_TYPES, target.type, source);
            return;
        }
        if (target.restParam == null) {
            if (((BTupleType)source).restType != null) {
                this.dlog.error(rhsPos, DiagnosticCode.INCOMPATIBLE_TYPES, target.type, source);
                return;
            }
            if (((BTupleType)source).tupleTypes.size() != target.expressions.size()) {
                this.dlog.error(rhsPos, DiagnosticCode.INCOMPATIBLE_TYPES, target.type, source);
                return;
            }
        }
        ArrayList<BType> sourceTypes = new ArrayList<BType>(((BTupleType)source).tupleTypes);
        if (((BTupleType)source).restType != null) {
            sourceTypes.add(((BTupleType)source).restType);
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            BLangExpression varRefExpr = target.expressions.size() > i ? target.expressions.get(i) : (BLangExpression)target.restParam;
            BType sourceType = (BType)sourceTypes.get(i);
            if (NodeKind.RECORD_VARIABLE_REF == varRefExpr.getKind()) {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)varRefExpr;
                this.checkRecordVarRefEquivalency(pos, recordVarRef, sourceType, rhsPos);
                continue;
            }
            if (NodeKind.TUPLE_VARIABLE_REF == varRefExpr.getKind()) {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)varRefExpr;
                this.checkTupleVarRefEquivalency(pos, tupleVarRef, sourceType, rhsPos);
                continue;
            }
            if (NodeKind.ERROR_VARIABLE_REF == varRefExpr.getKind()) {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)varRefExpr;
                this.checkErrorVarRefEquivalency(pos, errorVarRef, sourceType, rhsPos);
                continue;
            }
            if (varRefExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)varRefExpr;
                Name varName = this.names.fromIdNode(simpleVarRef.variableName);
                if (varName == Names.IGNORE) continue;
                this.resetTypeNarrowing(simpleVarRef, sourceType);
                BType targetType = target.expressions.size() > i ? varRefExpr.type : ((BArrayType)varRefExpr.type).eType;
                if (this.types.isAssignable(sourceType, targetType)) continue;
                this.dlog.error(rhsPos, DiagnosticCode.INCOMPATIBLE_TYPES, target.type, source);
                break;
            }
            this.dlog.error(varRefExpr.pos, DiagnosticCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, varRefExpr);
        }
    }

    private void checkErrorVarRefEquivalency(DiagnosticPos pos, BLangErrorVarRef lhsRef, BType rhsType, DiagnosticPos rhsPos) {
        if (rhsType.tag != 27) {
            this.dlog.error(rhsPos, DiagnosticCode.INCOMPATIBLE_TYPES, this.symTable.errorType, rhsType);
            return;
        }
        this.typeChecker.checkExpr(lhsRef, this.env);
        if (lhsRef.type == this.symTable.semanticError) {
            return;
        }
        BErrorType expErrorType = (BErrorType)lhsRef.type;
        BErrorType rhsErrorType = (BErrorType)rhsType;
        if (lhsRef.reason.type.tag != 22) {
            this.resetTypeNarrowing(lhsRef.reason, rhsErrorType.reasonType);
            if (!this.types.isAssignable(rhsErrorType.reasonType, expErrorType.reasonType)) {
                this.dlog.error(lhsRef.reason.pos, DiagnosticCode.INCOMPATIBLE_TYPES, expErrorType.reasonType, rhsErrorType.reasonType);
            }
        }
        if (rhsErrorType.detailType.tag != 12) {
            return;
        }
        BRecordType rhsDetailType = (BRecordType)rhsErrorType.detailType;
        Map<String, BField> fields = rhsDetailType.fields.stream().collect(Collectors.toMap(field -> field.name.value, field -> field));
        BType wideType = this.interpolateWideType(rhsDetailType, lhsRef.detail);
        for (BLangNamedArgsExpression detailItem : lhsRef.detail) {
            BType matchedType;
            BField matchedDetailItem = fields.get(detailItem.name.value);
            if (matchedDetailItem == null) {
                if (rhsDetailType.sealed) {
                    this.dlog.error(detailItem.pos, DiagnosticCode.INVALID_FIELD_IN_RECORD_BINDING_PATTERN, detailItem.name);
                    return;
                }
                matchedType = BUnionType.create(null, this.symTable.nilType, rhsDetailType.restFieldType);
            } else {
                matchedType = Symbols.isOptional(matchedDetailItem.symbol) ? BUnionType.create(null, this.symTable.nilType, matchedDetailItem.type) : matchedDetailItem.type;
            }
            this.checkErrorDetailRefItem(detailItem.pos, rhsPos, detailItem, matchedType);
            this.resetTypeNarrowing(detailItem.expr, matchedType);
            if (this.types.isAssignable(matchedType, detailItem.expr.type)) continue;
            this.dlog.error(detailItem.pos, DiagnosticCode.INCOMPATIBLE_TYPES, detailItem.expr.type, matchedType);
        }
        if (lhsRef.restVar != null && !this.isIgnoreVar(lhsRef)) {
            this.setTypeOfVarRefInErrorBindingAssignment(lhsRef.restVar);
            BMapType expRestType = new BMapType(15, wideType, null);
            if (lhsRef.restVar.type.tag != 15 || !this.types.isAssignable(wideType, ((BMapType)lhsRef.restVar.type).constraint)) {
                this.dlog.error(lhsRef.restVar.pos, DiagnosticCode.INCOMPATIBLE_TYPES, lhsRef.restVar.type, expRestType);
                return;
            }
            this.resetTypeNarrowing(lhsRef.restVar, expRestType);
            this.typeChecker.checkExpr(lhsRef.restVar, this.env);
        }
    }

    private BType interpolateWideType(BRecordType rhsDetailType, List<BLangNamedArgsExpression> detailType) {
        Set extractedKeys = detailType.stream().map(detail -> detail.name.value).collect(Collectors.toSet());
        BUnionType wideType = BUnionType.create(null, new BType[0]);
        for (BField field : rhsDetailType.fields) {
            if (extractedKeys.contains(field.name.value)) continue;
            wideType.add(field.type);
        }
        if (!rhsDetailType.sealed) {
            wideType.add(rhsDetailType.restFieldType);
        }
        return wideType;
    }

    private boolean isIgnoreVar(BLangErrorVarRef lhsRef) {
        if (lhsRef.restVar != null && lhsRef.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)lhsRef.restVar).variableName.value.equals(Names.IGNORE.value);
        }
        return false;
    }

    private void checkErrorDetailRefItem(DiagnosticPos pos, DiagnosticPos rhsPos, BLangNamedArgsExpression detailItem, BType expectedType) {
        if (detailItem.expr.getKind() == NodeKind.RECORD_VARIABLE_REF) {
            this.typeChecker.checkExpr(detailItem.expr, this.env);
            this.checkRecordVarRefEquivalency(pos, (BLangRecordVarRef)detailItem.expr, expectedType, rhsPos);
            return;
        }
        if (detailItem.getKind() == NodeKind.SIMPLE_VARIABLE_REF && detailItem.name.value.equals(Names.IGNORE.value)) {
            return;
        }
        this.setTypeOfVarRefInErrorBindingAssignment(detailItem.expr);
    }

    private void checkConstantAssignment(BLangExpression varRef) {
        if (varRef.type == this.symTable.semanticError) {
            return;
        }
        if (varRef.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return;
        }
        BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)varRef;
        if (simpleVarRef.pkgSymbol != null && simpleVarRef.pkgSymbol.tag == 8193) {
            this.dlog.error(varRef.pos, DiagnosticCode.XML_QNAME_UPDATE_NOT_ALLOWED, new Object[0]);
            return;
        }
        Name varName = this.names.fromIdNode(simpleVarRef.variableName);
        if (!Names.IGNORE.equals(varName) && this.env.enclInvokable != this.env.enclPkg.initFunction) {
            if ((simpleVarRef.symbol.flags & 4) == 4) {
                if ((simpleVarRef.symbol.flags & 0x80000) == 524288) {
                    this.dlog.error(varRef.pos, DiagnosticCode.INVALID_ASSIGNMENT_DECLARATION_FINAL, Names.SERVICE);
                } else if ((simpleVarRef.symbol.flags & 0x100000) == 0x100000) {
                    this.dlog.error(varRef.pos, DiagnosticCode.INVALID_ASSIGNMENT_DECLARATION_FINAL, LISTENER_NAME);
                } else {
                    this.dlog.error(varRef.pos, DiagnosticCode.CANNOT_ASSIGN_VALUE_FINAL, varRef);
                }
            } else if ((simpleVarRef.symbol.flags & 0x8000) == 32768) {
                this.dlog.error(varRef.pos, DiagnosticCode.CANNOT_ASSIGN_VALUE_TO_CONSTANT, new Object[0]);
            } else if ((simpleVarRef.symbol.flags & 0x40) == 64) {
                this.dlog.error(varRef.pos, DiagnosticCode.CANNOT_ASSIGN_VALUE_FUNCTION_ARGUMENT, varRef);
            }
        }
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        SymbolEnv stmtEnv = new SymbolEnv(exprStmtNode, this.env.scope);
        this.env.copyTo(stmtEnv);
        BType bType = this.typeChecker.checkExpr(exprStmtNode.expr, stmtEnv, this.symTable.noType);
        if (bType != this.symTable.nilType && bType != this.symTable.semanticError) {
            this.dlog.error(exprStmtNode.pos, DiagnosticCode.ASSIGNMENT_REQUIRED, new Object[0]);
        }
        this.validateWorkerAnnAttachments(exprStmtNode.expr);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.typeChecker.checkExpr(ifNode.expr, this.env, this.symTable.booleanType);
        BType actualType = ifNode.expr.type;
        if (29 == actualType.tag) {
            this.dlog.error(ifNode.expr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.symTable.booleanType, actualType);
        }
        Map<BVarSymbol, BType.NarrowedTypes> prevNarrowedTypeInfo = this.narrowedTypeInfo;
        SymbolEnv ifEnv = this.typeNarrower.evaluateTruth(ifNode.expr, ifNode.body, this.env);
        this.narrowedTypeInfo = new HashMap<BVarSymbol, BType.NarrowedTypes>();
        this.analyzeStmt(ifNode.body, ifEnv);
        if (ifNode.expr.narrowedTypeInfo == null || ifNode.expr.narrowedTypeInfo.isEmpty()) {
            ifNode.expr.narrowedTypeInfo = this.narrowedTypeInfo;
        }
        if (prevNarrowedTypeInfo != null) {
            prevNarrowedTypeInfo.putAll(this.narrowedTypeInfo);
        }
        if (ifNode.elseStmt != null) {
            SymbolEnv elseEnv = this.typeNarrower.evaluateFalsity(ifNode.expr, ifNode.elseStmt, this.env);
            this.analyzeStmt(ifNode.elseStmt, elseEnv);
        }
        this.narrowedTypeInfo = prevNarrowedTypeInfo;
    }

    @Override
    public void visit(BLangMatch matchNode) {
        List<BType> exprTypes;
        BType exprType = this.typeChecker.checkExpr(matchNode.expr, this.env, this.symTable.noType);
        if (exprType.tag == 20) {
            BUnionType unionType = (BUnionType)exprType;
            exprTypes = new ArrayList<BType>(unionType.getMemberTypes());
        } else {
            exprTypes = Lists.of(exprType);
        }
        matchNode.patternClauses.forEach(patternClause -> {
            patternClause.matchExpr = matchNode.expr;
            patternClause.accept(this);
        });
        matchNode.exprTypes = exprTypes;
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause patternClause) {
        this.checkStaticMatchPatternLiteralType(patternClause.literal);
        this.analyzeStmt(patternClause.body, this.env);
    }

    private BType checkStaticMatchPatternLiteralType(BLangExpression expression) {
        switch (expression.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: {
                return this.typeChecker.checkExpr(expression, this.env);
            }
            case BINARY_EXPR: {
                BLangBinaryExpr binaryExpr = (BLangBinaryExpr)expression;
                BType lhsType = this.checkStaticMatchPatternLiteralType(binaryExpr.lhsExpr);
                BType rhsType = this.checkStaticMatchPatternLiteralType(binaryExpr.rhsExpr);
                if (lhsType.tag == 22 || rhsType.tag == 22) {
                    this.dlog.error(binaryExpr.pos, DiagnosticCode.INVALID_LITERAL_FOR_MATCH_PATTERN, new Object[0]);
                    expression.type = this.symTable.errorType;
                    return expression.type;
                }
                expression.type = this.symTable.anyType;
                return expression.type;
            }
            case RECORD_LITERAL_EXPR: {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)expression;
                recordLiteral.type = new BMapType(15, this.symTable.anydataType, null);
                for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
                    BLangRecordLiteral.BLangRecordKeyValueField recLiteralKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    if (this.isValidRecordLiteralKey(recLiteralKeyValue)) {
                        BType fieldType = this.checkStaticMatchPatternLiteralType(recLiteralKeyValue.valueExpr);
                        if (fieldType.tag == 22) {
                            this.dlog.error(recLiteralKeyValue.valueExpr.pos, DiagnosticCode.INVALID_LITERAL_FOR_MATCH_PATTERN, new Object[0]);
                            expression.type = this.symTable.errorType;
                            return expression.type;
                        }
                        this.types.setImplicitCastExpr(recLiteralKeyValue.valueExpr, fieldType, this.symTable.anyType);
                        continue;
                    }
                    recLiteralKeyValue.key.expr.type = this.symTable.errorType;
                    this.dlog.error(recLiteralKeyValue.key.expr.pos, DiagnosticCode.INVALID_RECORD_LITERAL_KEY, new Object[0]);
                }
                return recordLiteral.type;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                BLangListConstructorExpr listConstructor = (BLangListConstructorExpr)expression;
                ArrayList<BType> results = new ArrayList<BType>();
                for (int i = 0; i < listConstructor.exprs.size(); ++i) {
                    BType literalType = this.checkStaticMatchPatternLiteralType(listConstructor.exprs.get(i));
                    if (literalType.tag == 22) {
                        this.dlog.error(listConstructor.exprs.get((int)i).pos, DiagnosticCode.INVALID_LITERAL_FOR_MATCH_PATTERN, new Object[0]);
                        expression.type = this.symTable.errorType;
                        return expression.type;
                    }
                    results.add(literalType);
                }
                listConstructor.type = new BTupleType(results);
                return listConstructor.type;
            }
            case GROUP_EXPR: {
                BLangGroupExpr groupExpr = (BLangGroupExpr)expression;
                BType literalType = this.checkStaticMatchPatternLiteralType(groupExpr.expression);
                if (literalType.tag == 22) {
                    this.dlog.error(groupExpr.expression.pos, DiagnosticCode.INVALID_LITERAL_FOR_MATCH_PATTERN, new Object[0]);
                    expression.type = this.symTable.errorType;
                    return expression.type;
                }
                groupExpr.type = literalType;
                return groupExpr.type;
            }
            case SIMPLE_VARIABLE_REF: {
                Name varName = this.names.fromIdNode(((BLangSimpleVarRef)expression).variableName);
                if (varName == Names.IGNORE) {
                    expression.type = this.symTable.anyType;
                    return expression.type;
                }
                BType exprType = this.typeChecker.checkExpr(expression, this.env);
                if (exprType.tag == 26 || ((BLangSimpleVarRef)expression).symbol.getKind() != SymbolKind.CONSTANT) {
                    this.dlog.error(expression.pos, DiagnosticCode.INVALID_LITERAL_FOR_MATCH_PATTERN, new Object[0]);
                    expression.type = this.symTable.noType;
                    return expression.type;
                }
                return exprType;
            }
        }
        this.dlog.error(expression.pos, DiagnosticCode.INVALID_LITERAL_FOR_MATCH_PATTERN, new Object[0]);
        expression.type = this.symTable.errorType;
        return expression.type;
    }

    private boolean isValidRecordLiteralKey(BLangRecordLiteral.BLangRecordKeyValueField recLiteralKeyValue) {
        NodeKind kind = recLiteralKeyValue.key.expr.getKind();
        return kind == NodeKind.SIMPLE_VARIABLE_REF || (kind == NodeKind.LITERAL || kind == NodeKind.NUMERIC_LITERAL) && this.typeChecker.checkExpr((BLangExpression)recLiteralKeyValue.key.expr, (SymbolEnv)this.env).tag == 5;
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause patternClause) {
        patternClause.bindingPatternVariable.type = patternClause.matchExpr.type;
        patternClause.bindingPatternVariable.expr = patternClause.matchExpr;
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(patternClause.body, this.env);
        if (patternClause.typeGuardExpr != null) {
            this.analyzeDef(patternClause.bindingPatternVariable, blockEnv);
            this.typeChecker.checkExpr(patternClause.typeGuardExpr, blockEnv);
            blockEnv = this.typeNarrower.evaluateTruth(patternClause.typeGuardExpr, patternClause.body, blockEnv);
        } else {
            this.analyzeDef(patternClause.bindingPatternVariable, blockEnv);
        }
        this.analyzeStmt(patternClause.body, blockEnv);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.typeChecker.checkExpr(foreach.collection, this.env);
        this.types.setForeachTypedBindingPatternType(foreach);
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(foreach.body, this.env);
        this.handleForeachVariables(foreach, blockEnv);
        this.analyzeStmt(foreach.body, blockEnv);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.typeChecker.checkExpr(whileNode.expr, this.env, this.symTable.booleanType);
        BType actualType = whileNode.expr.type;
        if (29 == actualType.tag) {
            this.dlog.error(whileNode.expr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.symTable.booleanType, actualType);
        }
        SymbolEnv whileEnv = this.typeNarrower.evaluateTruth(whileNode.expr, whileNode.body, this.env);
        this.analyzeStmt(whileNode.body, whileEnv);
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.analyzeStmt(lockNode.body, this.env);
    }

    @Override
    public void visit(BLangService serviceNode) {
        BServiceSymbol serviceSymbol = (BServiceSymbol)serviceNode.symbol;
        SymbolEnv serviceEnv = SymbolEnv.createServiceEnv(serviceNode, serviceSymbol.scope, this.env);
        serviceNode.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.SERVICE);
            this.analyzeDef((BLangNode)annotationAttachment, serviceEnv);
        });
        this.validateAnnotationAttachmentCount(serviceNode.annAttachments);
        if (serviceNode.isAnonymousServiceValue) {
            return;
        }
        for (BLangExpression attachExpr : serviceNode.attachedExprs) {
            BType exprType = this.typeChecker.checkExpr(attachExpr, this.env);
            if (exprType != this.symTable.semanticError && !this.types.checkListenerCompatibility(exprType)) {
                this.dlog.error(attachExpr.pos, DiagnosticCode.INCOMPATIBLE_TYPES, LISTENER_NAME, exprType);
            } else if (exprType != this.symTable.semanticError && serviceNode.listenerType == null) {
                serviceNode.listenerType = exprType;
            } else if (exprType != this.symTable.semanticError) {
                this.types.isSameType(exprType, serviceNode.listenerType);
            }
            if (attachExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef attachVarRef = (BLangSimpleVarRef)attachExpr;
                if (attachVarRef.symbol == null || Symbols.isFlagOn(attachVarRef.symbol.flags, 0x100000)) continue;
                this.dlog.error(attachVarRef.pos, DiagnosticCode.INVALID_LISTENER_ATTACHMENT, new Object[0]);
                continue;
            }
            if (attachExpr.getKind() == NodeKind.TYPE_INIT_EXPR) continue;
            this.dlog.error(attachExpr.pos, DiagnosticCode.INVALID_LISTENER_ATTACHMENT, new Object[0]);
        }
    }

    private void validateDefaultable(BLangRecordTypeNode recordTypeNode) {
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            if (!field.flagSet.contains((Object)Flag.OPTIONAL) || field.expr == null) continue;
            this.dlog.error(field.pos, DiagnosticCode.DEFAULT_VALUES_NOT_ALLOWED_FOR_OPTIONAL_FIELDS, field.name.value);
        }
    }

    @Override
    public void visit(BLangResource resourceNode) {
    }

    @Override
    public void visit(BLangTryCatchFinally tryCatchFinally) {
        this.dlog.error(tryCatchFinally.pos, DiagnosticCode.TRY_STMT_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void visit(BLangCatch bLangCatch) {
        SymbolEnv catchBlockEnv = SymbolEnv.createBlockEnv(bLangCatch.body, this.env);
        this.analyzeNode(bLangCatch.param, catchBlockEnv);
        if (bLangCatch.param.type.tag != 27) {
            this.dlog.error(bLangCatch.param.pos, DiagnosticCode.INCOMPATIBLE_TYPES, this.symTable.errorType, bLangCatch.param.type);
        }
        this.analyzeStmt(bLangCatch.body, catchBlockEnv);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        SymbolEnv transactionEnv = SymbolEnv.createTransactionEnv(transactionNode, this.env);
        this.analyzeStmt(transactionNode.transactionBody, transactionEnv);
        if (transactionNode.onRetryBody != null) {
            this.analyzeStmt(transactionNode.onRetryBody, transactionEnv);
        }
        if (transactionNode.committedBody != null) {
            this.analyzeStmt(transactionNode.committedBody, transactionEnv);
        }
        if (transactionNode.abortedBody != null) {
            this.analyzeStmt(transactionNode.abortedBody, transactionEnv);
        }
        if (transactionNode.retryCount != null) {
            this.typeChecker.checkExpr(transactionNode.retryCount, transactionEnv, this.symTable.intType);
            this.checkRetryStmtValidity(transactionNode.retryCount);
        }
    }

    @Override
    public void visit(BLangAbort abortNode) {
    }

    @Override
    public void visit(BLangRetry retryNode) {
    }

    private boolean isJoinResultType(BLangSimpleVariable var) {
        BLangType type = var.typeNode;
        if (type instanceof BuiltInReferenceTypeNode) {
            return ((BuiltInReferenceTypeNode)((Object)type)).getTypeKind() == TypeKind.MAP;
        }
        return false;
    }

    private BLangSimpleVariableDef createVarDef(BLangSimpleVariable var) {
        BLangSimpleVariableDef varDefNode = new BLangSimpleVariableDef();
        varDefNode.var = var;
        varDefNode.pos = var.pos;
        return varDefNode;
    }

    private BLangBlockStmt generateCodeBlock(StatementNode ... statements) {
        BLangBlockStmt block = new BLangBlockStmt();
        for (StatementNode stmt : statements) {
            block.addStatement(stmt);
        }
        return block;
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        for (BLangSimpleVariableDef worker : forkJoin.workers) {
            BLangFunction function = ((BLangLambdaFunction)worker.var.expr).function;
            function.symbol.enclForkName = function.anonForkName;
            ((BInvokableSymbol)worker.var.symbol).enclForkName = function.anonForkName;
        }
    }

    @Override
    public void visit(BLangWorker workerNode) {
        SymbolEnv workerEnv = SymbolEnv.createWorkerEnv(workerNode, this.env);
        this.analyzeNode(workerNode.body, workerEnv);
    }

    @Override
    public void visit(BLangEndpoint endpointNode) {
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        workerSendNode.env = this.env;
        this.typeChecker.checkExpr(workerSendNode.expr, this.env);
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(workerSendNode.workerIdentifier));
        workerSendNode.type = this.symTable.notFoundSymbol.equals(symbol) ? this.symTable.semanticError : symbol.type;
        if (workerSendNode.isChannel) {
            this.dlog.error(workerSendNode.pos, DiagnosticCode.UNDEFINED_ACTION, new Object[0]);
        }
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.typeChecker.checkExpr(returnNode.expr, this.env, this.env.enclInvokable.returnTypeNode.type);
        this.validateWorkerAnnAttachments(returnNode.expr);
    }

    BType analyzeDef(BLangNode node, SymbolEnv env) {
        return this.analyzeNode(node, env);
    }

    BType analyzeStmt(BLangStatement stmtNode, SymbolEnv env) {
        return this.analyzeNode(stmtNode, env);
    }

    public BType analyzeNode(BLangNode node, SymbolEnv env) {
        return this.analyzeNode(node, env, this.symTable.noType, null);
    }

    @Override
    public void visit(BLangContinue continueNode) {
    }

    @Override
    public void visit(BLangBreak breakNode) {
    }

    @Override
    public void visit(BLangThrow throwNode) {
        this.dlog.error(throwNode.pos, DiagnosticCode.THROW_STMT_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.typeChecker.checkExpr(panicNode.expr, this.env, this.symTable.errorType);
    }

    BType analyzeNode(BLangNode node, SymbolEnv env, BType expType, DiagnosticCode diagCode) {
        this.prevEnvs.push(this.env);
        BType preExpType = this.expType;
        DiagnosticCode preDiagCode = this.diagCode;
        this.env = env;
        this.expType = expType;
        this.diagCode = diagCode;
        node.accept(this);
        this.env = this.prevEnvs.pop();
        this.expType = preExpType;
        this.diagCode = preDiagCode;
        return this.resType;
    }

    @Override
    public void visit(BLangConstant constant) {
        if (this.names.fromIdNode(constant.name) == Names.IGNORE) {
            this.dlog.error(constant.name.pos, DiagnosticCode.UNDERSCORE_NOT_ALLOWED, new Object[0]);
        }
        if (constant.typeNode != null && !this.types.isAllowedConstantType(constant.typeNode.type)) {
            this.dlog.error(constant.typeNode.pos, DiagnosticCode.CANNOT_DEFINE_CONSTANT_WITH_TYPE, constant.typeNode);
        }
        constant.annAttachments.forEach(annotationAttachment -> {
            annotationAttachment.attachPoints.add(AttachPoint.Point.CONST);
            annotationAttachment.accept(this);
        });
        BLangExpression expression = constant.expr;
        if (expression.getKind() != NodeKind.LITERAL && expression.getKind() != NodeKind.NUMERIC_LITERAL && constant.typeNode == null) {
            constant.type = this.symTable.semanticError;
            this.dlog.error(expression.pos, DiagnosticCode.TYPE_REQUIRED_FOR_CONST_WITH_EXPRESSIONS, new Object[0]);
            return;
        }
        this.typeChecker.checkExpr(expression, this.env, constant.symbol.type);
        this.constantAnalyzer.visit(constant);
    }

    private void checkAnnotConstantExpression(BLangExpression expression) {
        switch (expression.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: {
                break;
            }
            case SIMPLE_VARIABLE_REF: {
                BSymbol symbol = ((BLangSimpleVarRef)expression).symbol;
                if (symbol == null || (symbol.tag & 0x100001C) == 0x100001C) break;
                this.dlog.error(expression.pos, DiagnosticCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
                break;
            }
            case RECORD_LITERAL_EXPR: {
                ((BLangRecordLiteral)expression).fields.forEach(field -> {
                    if (field.isKeyValueField()) {
                        BLangRecordLiteral.BLangRecordKeyValueField pair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        this.checkAnnotConstantExpression(pair.key.expr);
                        this.checkAnnotConstantExpression(pair.valueExpr);
                    } else {
                        this.checkAnnotConstantExpression((BLangRecordLiteral.BLangRecordVarNameField)field);
                    }
                });
                break;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                ((BLangListConstructorExpr)expression).exprs.forEach(this::checkAnnotConstantExpression);
                break;
            }
            case FIELD_BASED_ACCESS_EXPR: {
                this.checkAnnotConstantExpression(((BLangFieldBasedAccess)expression).expr);
                break;
            }
            default: {
                this.dlog.error(expression.pos, DiagnosticCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
            }
        }
    }

    private void handleForeachVariables(BLangForeach foreachStmt, SymbolEnv blockEnv) {
        BLangVariable variableNode = (BLangVariable)foreachStmt.variableDefinitionNode.getVariable();
        if (foreachStmt.isDeclaredWithVar) {
            this.handleDeclaredVarInForeach(variableNode, foreachStmt.varType, blockEnv);
            return;
        }
        BType typeNodeType = this.symResolver.resolveTypeNode(variableNode.typeNode, blockEnv);
        if (this.types.isAssignable(foreachStmt.varType, typeNodeType)) {
            this.handleDeclaredVarInForeach(variableNode, foreachStmt.varType, blockEnv);
            return;
        }
        this.dlog.error(variableNode.typeNode.pos, DiagnosticCode.INCOMPATIBLE_TYPES, foreachStmt.varType, typeNodeType);
        this.handleDeclaredVarInForeach(variableNode, typeNodeType, blockEnv);
    }

    private void checkRetryStmtValidity(BLangExpression retryCountExpr) {
        boolean error = true;
        NodeKind retryKind = retryCountExpr.getKind();
        if (retryKind == NodeKind.LITERAL || retryKind == NodeKind.NUMERIC_LITERAL) {
            int retryCount;
            if (retryCountExpr.type.tag == 1 && (retryCount = Integer.parseInt(((BLangLiteral)retryCountExpr).getValue().toString())) >= 0) {
                error = false;
            }
        } else if (retryKind == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)retryCountExpr).symbol.flags == 4 && ((BLangSimpleVarRef)retryCountExpr).symbol.type.tag == 1) {
            error = false;
        }
        if (error) {
            this.dlog.error(retryCountExpr.pos, DiagnosticCode.INVALID_RETRY_COUNT, new Object[0]);
        }
    }

    private void checkTransactionHandlerValidity(BLangExpression transactionHanlder) {
        if (transactionHanlder != null) {
            BSymbol handlerSymbol = ((BLangSimpleVarRef)transactionHanlder).symbol;
            if (handlerSymbol != null && handlerSymbol.kind != SymbolKind.FUNCTION) {
                this.dlog.error(transactionHanlder.pos, DiagnosticCode.INVALID_FUNCTION_POINTER_ASSIGNMENT_FOR_HANDLER, new Object[0]);
            }
            if (transactionHanlder.type.tag == 16) {
                BInvokableType handlerType = (BInvokableType)transactionHanlder.type;
                int parameterCount = handlerType.paramTypes.size();
                if (parameterCount != 1) {
                    this.dlog.error(transactionHanlder.pos, DiagnosticCode.INVALID_TRANSACTION_HANDLER_ARGS, new Object[0]);
                }
                if (handlerType.paramTypes.get((int)0).tag != 5) {
                    this.dlog.error(transactionHanlder.pos, DiagnosticCode.INVALID_TRANSACTION_HANDLER_ARGS, new Object[0]);
                }
                if (handlerType.retType.tag != 10) {
                    this.dlog.error(transactionHanlder.pos, DiagnosticCode.INVALID_TRANSACTION_HANDLER_SIGNATURE, new Object[0]);
                }
            } else {
                this.dlog.error(transactionHanlder.pos, DiagnosticCode.LAMBDA_REQUIRED_FOR_TRANSACTION_HANDLER, new Object[0]);
            }
        }
    }

    private BLangExpression getBinaryExpr(BLangExpression lExpr, BLangExpression rExpr, OperatorKind opKind, BSymbol opSymbol) {
        BLangBinaryExpr binaryExpressionNode = (BLangBinaryExpr)TreeBuilder.createBinaryExpressionNode();
        binaryExpressionNode.lhsExpr = lExpr;
        binaryExpressionNode.rhsExpr = rExpr;
        binaryExpressionNode.pos = rExpr.pos;
        binaryExpressionNode.opKind = opKind;
        if (opSymbol != this.symTable.notFoundSymbol) {
            binaryExpressionNode.type = opSymbol.type.getReturnType();
            binaryExpressionNode.opSymbol = (BOperatorSymbol)opSymbol;
        } else {
            binaryExpressionNode.type = this.symTable.semanticError;
        }
        return binaryExpressionNode;
    }

    private boolean validateVariableDefinition(BLangExpression expr) {
        if (expr.getKind() == NodeKind.TYPE_INIT_EXPR && ((BLangTypeInit)expr).userDefinedType == null) {
            this.dlog.error(expr.pos, DiagnosticCode.INVALID_ANY_VAR_DEF, new Object[0]);
            return false;
        }
        return true;
    }

    private void setTypeOfVarRefInErrorBindingAssignment(BLangExpression expr) {
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF && expr.getKind() != NodeKind.RECORD_VARIABLE_REF && expr.getKind() != NodeKind.ERROR_VARIABLE_REF && expr.getKind() != NodeKind.TUPLE_VARIABLE_REF) {
            this.dlog.error(expr.pos, DiagnosticCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, expr);
            expr.type = this.symTable.semanticError;
        }
        this.setTypeOfVarRef(expr);
    }

    private void setTypeOfVarRefInAssignment(BLangExpression expr) {
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF && expr.getKind() != NodeKind.INDEX_BASED_ACCESS_EXPR && expr.getKind() != NodeKind.FIELD_BASED_ACCESS_EXPR && expr.getKind() != NodeKind.XML_ATTRIBUTE_ACCESS_EXPR && expr.getKind() != NodeKind.RECORD_VARIABLE_REF && expr.getKind() != NodeKind.ERROR_VARIABLE_REF && expr.getKind() != NodeKind.TUPLE_VARIABLE_REF) {
            this.dlog.error(expr.pos, DiagnosticCode.INVALID_VARIABLE_ASSIGNMENT, expr);
            expr.type = this.symTable.semanticError;
        }
        this.setTypeOfVarRef(expr);
    }

    private void setTypeOfVarRef(BLangExpression expr) {
        BVarSymbol originSymbol;
        BLangVariableReference varRefExpr = (BLangVariableReference)expr;
        varRefExpr.lhsVar = true;
        this.typeChecker.checkExpr(varRefExpr, this.env);
        this.checkConstantAssignment(varRefExpr);
        if (this.isSimpleVarRef(expr) && (originSymbol = ((BVarSymbol)((BLangSimpleVarRef)expr).symbol).originalSymbol) != null) {
            varRefExpr.type = originSymbol.type;
        }
    }

    private void setTypeOfVarRefForBindingPattern(BLangExpression expr) {
        BLangVariableReference varRefExpr = (BLangVariableReference)expr;
        varRefExpr.lhsVar = true;
        this.typeChecker.checkExpr(varRefExpr, this.env);
        switch (expr.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                this.setTypeOfVarRef(expr);
                break;
            }
            case TUPLE_VARIABLE_REF: {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)expr;
                tupleVarRef.expressions.forEach(this::setTypeOfVarRefForBindingPattern);
                if (tupleVarRef.restParam != null) {
                    this.setTypeOfVarRefForBindingPattern((BLangExpression)tupleVarRef.restParam);
                }
                return;
            }
            case RECORD_VARIABLE_REF: {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)expr;
                recordVarRef.recordRefFields.forEach(refKeyValue -> this.setTypeOfVarRefForBindingPattern(refKeyValue.variableReference));
                if (recordVarRef.restParam != null) {
                    this.setTypeOfVarRefForBindingPattern((BLangExpression)recordVarRef.restParam);
                }
                return;
            }
            case ERROR_VARIABLE_REF: {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)expr;
                this.setTypeOfVarRefForBindingPattern(errorVarRef.reason);
                errorVarRef.detail.forEach(namedArgExpr -> this.setTypeOfVarRefForBindingPattern(namedArgExpr.expr));
                if (errorVarRef.restVar == null) break;
                this.setTypeOfVarRefForBindingPattern(errorVarRef.restVar);
            }
        }
    }

    private void validateAnnotationAttachmentExpr(BLangAnnotationAttachment annAttachmentNode, BAnnotationSymbol annotationSymbol) {
        if (annotationSymbol.attachedType == null || this.types.isAssignable(annotationSymbol.attachedType.type, this.symTable.trueType)) {
            if (annAttachmentNode.expr != null) {
                this.dlog.error(annAttachmentNode.pos, DiagnosticCode.ANNOTATION_ATTACHMENT_CANNOT_HAVE_A_VALUE, annotationSymbol.name);
            }
            return;
        }
        if (annAttachmentNode.expr == null) {
            this.dlog.error(annAttachmentNode.pos, DiagnosticCode.ANNOTATION_ATTACHMENT_REQUIRES_A_VALUE, annotationSymbol.name);
            return;
        }
        BType annotType = annotationSymbol.attachedType.type;
        this.typeChecker.checkExpr(annAttachmentNode.expr, this.env, annotType.tag == 19 ? ((BArrayType)annotType).eType : annotType);
        if (Symbols.isFlagOn(annotationSymbol.flags, 32768)) {
            if (annotationSymbol.points.stream().anyMatch(attachPoint -> !attachPoint.source)) {
                this.constantAnalyzer.analyzeExpr(annAttachmentNode.expr);
                return;
            }
            this.checkAnnotConstantExpression(annAttachmentNode.expr);
        }
    }

    private void validateAnnotationAttachmentCount(List<BLangAnnotationAttachment> attachments) {
        HashMap<BAnnotationSymbol, Integer> attachmentCounts = new HashMap<BAnnotationSymbol, Integer>();
        for (BLangAnnotationAttachment attachment : attachments) {
            if (attachment.annotationSymbol == null) continue;
            attachmentCounts.merge(attachment.annotationSymbol, 1, Integer::sum);
        }
        attachmentCounts.forEach((symbol, count) -> {
            if ((symbol.attachedType == null || symbol.attachedType.type.tag != 19) && count > 1) {
                Optional<Object> found = Optional.empty();
                for (BLangAnnotationAttachment attachment : attachments) {
                    if (!attachment.annotationSymbol.equals(symbol)) continue;
                    found = Optional.of(attachment);
                    break;
                }
                this.dlog.error(((BLangAnnotationAttachment)found.get()).pos, DiagnosticCode.ANNOTATION_ATTACHMENT_CANNOT_SPECIFY_MULTIPLE_VALUES, symbol.name);
            }
        });
    }

    private void validateBuiltinTypeAnnotationAttachment(List<BLangAnnotationAttachment> attachments) {
        if (PackageID.isLangLibPackageID(this.env.enclPkg.packageID)) {
            return;
        }
        for (BLangAnnotationAttachment attachment : attachments) {
            if (attachment.annotationSymbol == null || !attachment.annotationSymbol.pkgID.equals(PackageID.ANNOTATIONS)) continue;
            String annotationName = attachment.annotationName.value;
            if (annotationName.equals(Names.ANNOTATION_TYPE_PARAM.value)) {
                this.dlog.error(attachment.pos, DiagnosticCode.TYPE_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
                continue;
            }
            if (!annotationName.equals(Names.ANNOTATION_BUILTIN_SUBTYPE.value)) continue;
            this.dlog.error(attachment.pos, DiagnosticCode.TYPE_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
        }
    }

    private void validateObjectAttachedFunction(BLangFunction funcNode) {
        if (!funcNode.attachedFunction) {
            return;
        }
        if (Symbols.isFlagOn(funcNode.receiver.type.tsymbol.flags, 4096)) {
            if (funcNode.body != null) {
                this.dlog.error(funcNode.pos, DiagnosticCode.ABSTRACT_OBJECT_FUNCTION_CANNOT_HAVE_BODY, funcNode.name, funcNode.receiver.type);
            }
            return;
        }
        if (funcNode.interfaceFunction && !this.env.enclPkg.objAttachedFunctions.contains(funcNode.symbol)) {
            this.dlog.error(funcNode.pos, DiagnosticCode.INVALID_INTERFACE_ON_NON_ABSTRACT_OBJECT, funcNode.name, funcNode.receiver.type);
        }
    }

    private void validateReferencedFunction(DiagnosticPos pos, BAttachedFunction func, SymbolEnv env) {
        if (Symbols.isFlagOn(func.symbol.receiverSymbol.type.tsymbol.flags, 4096)) {
            return;
        }
        if (!Symbols.isFunctionDeclaration(func.symbol)) {
            return;
        }
        if (!env.enclPkg.objAttachedFunctions.contains(func.symbol)) {
            this.dlog.error(pos, DiagnosticCode.INVALID_INTERFACE_ON_NON_ABSTRACT_OBJECT, func.funcName, func.symbol.receiverSymbol.type);
        }
    }

    private boolean isSimpleVarRef(BLangExpression expr) {
        if (expr.type.tag == 26 || expr.type.tag == 22 || expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        if (((BLangSimpleVarRef)expr).symbol == null) {
            return false;
        }
        return (((BLangSimpleVarRef)expr).symbol.tag & 0x34) == 52;
    }

    private void resetTypeNarrowing(BLangExpression lhsExpr, BType rhsType) {
        if (!this.isSimpleVarRef(lhsExpr)) {
            return;
        }
        BVarSymbol varSymbol = (BVarSymbol)((BLangSimpleVarRef)lhsExpr).symbol;
        if (varSymbol.originalSymbol == null) {
            return;
        }
        if (!this.types.isAssignable(rhsType, varSymbol.type)) {
            if (this.narrowedTypeInfo != null) {
                BType currentType = ((BLangSimpleVarRef)lhsExpr).symbol.type;
                this.narrowedTypeInfo.put(this.typeNarrower.getOriginalVarSymbol(varSymbol), new BType.NarrowedTypes(currentType, currentType));
            }
            this.defineOriginalSymbol(lhsExpr, this.typeNarrower.getOriginalVarSymbol(varSymbol), this.env);
            this.env = this.prevEnvs.pop();
        }
    }

    private void defineOriginalSymbol(BLangExpression lhsExpr, BVarSymbol varSymbol, SymbolEnv env) {
        BSymbol foundSym = this.symResolver.lookupSymbolInMainSpace(env, varSymbol.name);
        if (foundSym == varSymbol) {
            this.prevEnvs.push(env);
            return;
        }
        env = SymbolEnv.createTypeNarrowedEnv(lhsExpr, env);
        this.symbolEnter.defineTypeNarrowedSymbol(lhsExpr.pos, env, varSymbol, varSymbol.type);
        SymbolEnv prevEnv = this.prevEnvs.pop();
        this.defineOriginalSymbol(lhsExpr, varSymbol, prevEnv);
        this.prevEnvs.push(env);
    }
}

