/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class SymbolResolver
extends BLangNodeVisitor {
    private static final CompilerContext.Key<SymbolResolver> SYMBOL_RESOLVER_KEY = new CompilerContext.Key();
    private SymbolTable symTable;
    private Names names;
    private BLangDiagnosticLogHelper dlog;
    private Types types;
    private SymbolEnv env;
    private BType resultType;
    private DiagnosticCode diagCode;
    private SymbolEnter symbolEnter;
    private BLangAnonymousModelHelper anonymousModelHelper;

    public static SymbolResolver getInstance(CompilerContext context) {
        SymbolResolver symbolResolver = context.get(SYMBOL_RESOLVER_KEY);
        if (symbolResolver == null) {
            symbolResolver = new SymbolResolver(context);
        }
        return symbolResolver;
    }

    public SymbolResolver(CompilerContext context) {
        context.put(SYMBOL_RESOLVER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.types = Types.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
    }

    public boolean checkForUniqueSymbol(DiagnosticPos pos, SymbolEnv env, BSymbol symbol) {
        BSymbol foundSym = this.symTable.notFoundSymbol;
        int expSymTag = symbol.tag;
        if ((expSymTag & 1) == 1) {
            foundSym = this.lookupSymbolInPrefixSpace(env, symbol.name);
        } else if ((expSymTag & 2) == 2) {
            foundSym = this.lookupSymbolInAnnotationSpace(env, symbol.name);
        } else if ((expSymTag & 0x4000100) == 0x4000100) {
            foundSym = this.lookupSymbolInConstructorSpace(env, symbol.name);
        } else if ((expSymTag & 4) == 4) {
            foundSym = this.lookupSymbolForDecl(env, symbol.name, 4);
        }
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        if (this.isRedeclaredSymbol(symbol, foundSym)) {
            this.dlog.error(pos, DiagnosticCode.REDECLARED_SYMBOL, symbol.name);
            return false;
        }
        if ((foundSym.tag & 0x84) == 132) {
            return false;
        }
        return this.isDistinctSymbol(pos, symbol, foundSym);
    }

    private boolean isRedeclaredSymbol(BSymbol symbol, BSymbol foundSym) {
        return this.hasSameOwner(symbol, foundSym) || this.isSymbolRedeclaredInTestPackage(symbol, foundSym);
    }

    public boolean checkForUniqueSymbol(SymbolEnv env, BSymbol symbol) {
        BSymbol foundSym = this.lookupSymbolInMainSpace(env, symbol.name);
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        return this.isDistinctSymbol(symbol, foundSym);
    }

    public boolean checkForUniqueSymbolInCurrentScope(DiagnosticPos pos, SymbolEnv env, BSymbol symbol, int expSymTag) {
        BSymbol foundSym = this.lookupSymbolInGivenScope(env, symbol.name, expSymTag);
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        return this.isDistinctSymbol(pos, symbol, foundSym);
    }

    private boolean isDistinctSymbol(DiagnosticPos pos, BSymbol symbol, BSymbol foundSym) {
        if (symbol.tag == 0x4000100 && foundSym.tag == 589852) {
            return false;
        }
        if (this.isSymbolDefinedInRootPkgLvl(foundSym)) {
            this.dlog.error(pos, DiagnosticCode.REDECLARED_BUILTIN_SYMBOL, symbol.name);
            return false;
        }
        return true;
    }

    private boolean isDistinctSymbol(BSymbol symbol, BSymbol foundSym) {
        if (symbol.tag == 0x4000100 && foundSym.tag == 589852) {
            return false;
        }
        if (this.isSymbolDefinedInRootPkgLvl(foundSym)) {
            return false;
        }
        return !this.hasSameOwner(symbol, foundSym);
    }

    private boolean hasSameOwner(BSymbol symbol, BSymbol foundSym) {
        if (foundSym.owner == symbol.owner) {
            return true;
        }
        if (Symbols.isFlagOn(symbol.owner.flags, 0x200000) && (foundSym.owner.tag & 0x100) == 256) {
            return true;
        }
        return (symbol.owner.tag & 0x8000000) == 0x8000000 && (foundSym.owner.tag & 0x100) == 256;
    }

    private boolean isSymbolRedeclaredInTestPackage(BSymbol symbol, BSymbol foundSym) {
        return Symbols.isFlagOn(symbol.owner.flags, 16384) && !Symbols.isFlagOn(foundSym.owner.flags, 16384);
    }

    private boolean isSymbolDefinedInRootPkgLvl(BSymbol foundSym) {
        return this.symTable.rootPkgSymbol.pkgID.equals(foundSym.pkgID) && (foundSym.tag & 0x14) == 20;
    }

    public BSymbol lookupSymbolInGivenScope(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if (this.symTable.rootPkgSymbol.pkgID.equals(entry.symbol.pkgID) && (entry.symbol.tag & 0x14) == 20) {
                return entry.symbol;
            }
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        return this.symTable.notFoundSymbol;
    }

    public boolean checkForUniqueMemberSymbol(DiagnosticPos pos, SymbolEnv env, BSymbol symbol) {
        BSymbol foundSym = this.lookupMemberSymbol(pos, env.scope, env, symbol.name, symbol.tag);
        if (foundSym != this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticCode.REDECLARED_SYMBOL, symbol.name);
            return false;
        }
        return true;
    }

    public BSymbol resolveBinaryOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        return this.resolveOperator(this.names.fromString(opKind.value()), Lists.of(lhsType, rhsType));
    }

    BSymbol createEqualityOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        List<BType> paramTypes = Lists.of(lhsType, rhsType);
        BType retType = this.symTable.booleanType;
        BInvokableType opType = new BInvokableType(paramTypes, retType, null);
        return new BOperatorSymbol(this.names.fromString(opKind.value()), null, opType, null);
    }

    public BSymbol resolveUnaryOperator(DiagnosticPos pos, OperatorKind opKind, BType type) {
        return this.resolveOperator(this.names.fromString(opKind.value()), Lists.of(type));
    }

    public BSymbol resolveOperator(Name name, List<BType> types) {
        Scope.ScopeEntry entry = this.symTable.rootScope.lookup(name);
        return this.resolveOperator(entry, types);
    }

    public BSymbol resolvePkgSymbol(DiagnosticPos pos, SymbolEnv env, Name pkgAlias) {
        if (pkgAlias == Names.EMPTY) {
            return env.enclPkg.symbol;
        }
        BSymbol pkgSymbol = this.lookupSymbolInPrefixSpace(env, pkgAlias);
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticCode.UNDEFINED_MODULE, pkgAlias.value);
        }
        return pkgSymbol;
    }

    public BSymbol resolvePrefixSymbol(SymbolEnv env, Name pkgAlias, Name compUnit) {
        if (pkgAlias == Names.EMPTY) {
            return env.enclPkg.symbol;
        }
        Scope.ScopeEntry entry = env.scope.lookup(pkgAlias);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x2001) == 8193) {
                return entry.symbol;
            }
            if ((entry.symbol.tag & 1) == 1 && ((BPackageSymbol)entry.symbol).compUnit.equals(compUnit)) {
                ((BPackageSymbol)entry.symbol).isUsed = true;
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.resolvePrefixSymbol(env.enclEnv, pkgAlias, compUnit);
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol resolveAnnotation(DiagnosticPos pos, SymbolEnv env, Name pkgAlias, Name annotationName) {
        return this.lookupAnnotationSpaceSymbolInPackage(pos, env, pkgAlias, annotationName);
    }

    public BSymbol resolveStructField(DiagnosticPos pos, SymbolEnv env, Name fieldName, BTypeSymbol structSymbol) {
        return this.lookupMemberSymbol(pos, structSymbol.scope, env, fieldName, 52);
    }

    public BSymbol resolveObjectField(DiagnosticPos pos, SymbolEnv env, Name fieldName, BTypeSymbol objectSymbol) {
        return this.lookupMemberSymbol(pos, objectSymbol.scope, env, fieldName, 52);
    }

    public BSymbol resolveObjectMethod(DiagnosticPos pos, SymbolEnv env, Name fieldName, BObjectTypeSymbol objectSymbol) {
        return this.lookupMemberSymbol(pos, objectSymbol.methodScope, env, fieldName, 52);
    }

    public BType resolveTypeNode(BLangType typeNode, SymbolEnv env) {
        return this.resolveTypeNode(typeNode, env, DiagnosticCode.UNKNOWN_TYPE);
    }

    public BType resolveTypeNode(BLangType typeNode, SymbolEnv env, DiagnosticCode diagCode) {
        SymbolEnv prevEnv = this.env;
        DiagnosticCode preDiagCode = this.diagCode;
        this.env = env;
        this.diagCode = diagCode;
        typeNode.accept(this);
        this.env = prevEnv;
        this.diagCode = preDiagCode;
        if (typeNode.nullable && this.resultType.tag == 20) {
            BUnionType unionType = (BUnionType)this.resultType;
            unionType.add(this.symTable.nilType);
        } else if (typeNode.nullable && this.resultType.tag != 7 && this.resultType.tag != 17) {
            this.resultType = BUnionType.create(null, this.resultType, this.symTable.nilType);
        }
        typeNode.type = this.resultType;
        return this.resultType;
    }

    private BSymbol lookupSymbolForDecl(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) == expSymTag) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.lookupSymbol(env.enclEnv, name, expSymTag);
        }
        return this.symTable.notFoundSymbol;
    }

    private BSymbol lookupSymbol(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.lookupSymbol(env.enclEnv, name, expSymTag);
        }
        return this.symTable.notFoundSymbol;
    }

    private boolean isFieldRefFromWithinARecord(BSymbol symbol, SymbolEnv env) {
        return (symbol.owner.tag & 0x5005C) == 327772 && env.enclType != null && env.enclType.getKind() == NodeKind.RECORD_TYPE;
    }

    public BSymbol lookupSymbolInMainSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 4);
    }

    public BSymbol lookupSymbolInAnnotationSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 2);
    }

    public BSymbol lookupSymbolInPrefixSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 1);
    }

    public BSymbol lookupSymbolInConstructorSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 0x4000100);
    }

    public BSymbol lookupLangLibMethod(BType type, Name name) {
        BSymbol bSymbol;
        if (this.symTable.langAnnotationModuleSymbol == null) {
            return this.symTable.notFoundSymbol;
        }
        switch (type.tag) {
            case 19: 
            case 29: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langArrayModuleSymbol, name);
                break;
            }
            case 4: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langDecimalModuleSymbol, name);
                break;
            }
            case 27: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langErrorModuleSymbol, name);
                break;
            }
            case 3: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langFloatModuleSymbol, name);
                break;
            }
            case 30: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langFutureModuleSymbol, name);
                break;
            }
            case 1: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langIntModuleSymbol, name);
                break;
            }
            case 12: 
            case 15: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langMapModuleSymbol, name);
                break;
            }
            case 32: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langObjectModuleSymbol, name);
                break;
            }
            case 14: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langStreamModuleSymbol, name);
                break;
            }
            case 5: 
            case 42: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langStringModuleSymbol, name);
                break;
            }
            case 9: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langTableModuleSymbol, name);
                break;
            }
            case 13: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langTypedescModuleSymbol, name);
                break;
            }
            case 8: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langXmlModuleSymbol, name);
                break;
            }
            case 6: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langBooleanModuleSymbol, name);
                break;
            }
            case 20: {
                Iterator<BType> itr = ((BUnionType)type).getMemberTypes().iterator();
                if (!itr.hasNext()) {
                    throw new IllegalArgumentException(String.format("Union type '%s' does not have member types", type.toString()));
                }
                BType member = itr.next();
                if (this.types.isSubTypeOfBaseType(type, member.tag)) {
                    bSymbol = this.lookupLangLibMethod(member, name);
                    break;
                }
                bSymbol = this.symTable.notFoundSymbol;
                break;
            }
            default: {
                bSymbol = this.symTable.notFoundSymbol;
            }
        }
        if (bSymbol == this.symTable.notFoundSymbol) {
            bSymbol = this.lookupLangLibMethodInModule(this.symTable.langValueModuleSymbol, name);
        }
        if (bSymbol == this.symTable.notFoundSymbol) {
            bSymbol = this.lookupLangLibMethodInModule(this.symTable.langInternalModuleSymbol, name);
        }
        return bSymbol;
    }

    BSymbol lookupClosureVarSymbol(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if (this.symTable.rootPkgSymbol.pkgID.equals(entry.symbol.pkgID) && (entry.symbol.tag & 0x14) == 20) {
                return entry.symbol;
            }
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv == null || env.enclEnv.node == null) {
            return this.symTable.notFoundSymbol;
        }
        return this.lookupClosureVarSymbol(env.enclEnv, name, expSymTag);
    }

    public BSymbol lookupMainSpaceSymbolInPackage(DiagnosticPos pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInMainSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.getSource().getCompilationUnitName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 4);
    }

    public BSymbol lookupPrefixSpaceSymbolInPackage(DiagnosticPos pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInPrefixSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.getSource().getCompilationUnitName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 1);
    }

    public BSymbol lookupAnnotationSpaceSymbolInPackage(DiagnosticPos pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInAnnotationSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.getSource().getCompilationUnitName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 2);
    }

    public BSymbol lookupConstructorSpaceSymbolInPackage(DiagnosticPos pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInConstructorSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.getSource().getCompilationUnitName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 0x4000100);
    }

    public BSymbol lookupLangLibMethodInModule(BPackageSymbol moduleSymbol, Name name) {
        Scope.ScopeEntry entry = moduleSymbol.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x334) != 820) {
                entry = entry.next;
                continue;
            }
            if (this.isMemberAccessAllowed(this.env, entry.symbol)) {
                return entry.symbol;
            }
            return this.symTable.notFoundSymbol;
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol lookupMemberSymbol(DiagnosticPos pos, Scope scope, SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) != expSymTag) {
                entry = entry.next;
                continue;
            }
            if (this.isMemberAccessAllowed(env, entry.symbol)) {
                return entry.symbol;
            }
            this.dlog.error(pos, DiagnosticCode.ATTEMPT_REFER_NON_ACCESSIBLE_SYMBOL, entry.symbol.name);
            return this.symTable.notFoundSymbol;
        }
        return this.symTable.notFoundSymbol;
    }

    public Map<Name, BXMLNSSymbol> resolveAllNamespaces(SymbolEnv env) {
        LinkedHashMap<Name, BXMLNSSymbol> namespaces = new LinkedHashMap<Name, BXMLNSSymbol>();
        this.addNamespacesInScope(namespaces, env);
        return namespaces;
    }

    public void reloadErrorAndDependentTypes() {
        Scope.ScopeEntry entry = this.symTable.rootPkgSymbol.scope.lookup(Names.ERROR);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xC) != 12) {
                entry = entry.next;
                continue;
            }
            this.symTable.errorType = (BErrorType)entry.symbol.type;
            this.symTable.detailType = (BRecordType)this.symTable.errorType.detailType;
            this.symTable.errorConstructor = ((BErrorTypeSymbol)this.symTable.errorType.tsymbol).ctorSymbol;
            this.symTable.pureType = BUnionType.create(null, this.symTable.anydataType, this.symTable.errorType);
            this.symTable.detailType.restFieldType = this.symTable.pureType;
            this.symTable.streamType = new BStreamType(14, this.symTable.pureType, null, null);
            this.symTable.defineOperators();
            this.symTable.pureType = BUnionType.create(null, this.symTable.anydataType, this.symTable.errorType);
            this.symTable.errorOrNilType = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
            this.symTable.anyOrErrorType = BUnionType.create(null, this.symTable.anyType, this.symTable.errorType);
            this.symTable.mapAllType = new BMapType(15, this.symTable.anyOrErrorType, null);
            return;
        }
        throw new IllegalStateException("built-in error not found ?");
    }

    public void reloadIntRangeType() {
        Scope.ScopeEntry entry = this.symTable.langInternalModuleSymbol.scope.lookup(Names.CREATE_INT_RANGE);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x100) != 256) {
                entry = entry.next;
                continue;
            }
            this.symTable.intRangeType = (BObjectType)((BInvokableType)entry.symbol.type).retType;
            this.symTable.defineBinaryOperator(OperatorKind.CLOSED_RANGE, this.symTable.intType, this.symTable.intType, this.symTable.intRangeType);
            this.symTable.defineBinaryOperator(OperatorKind.HALF_OPEN_RANGE, this.symTable.intType, this.symTable.intType, this.symTable.intRangeType);
            return;
        }
        throw new IllegalStateException("built-in Integer Range type not found ?");
    }

    @Override
    public void visit(BLangValueType valueTypeNode) {
        this.visitBuiltInTypeNode(valueTypeNode, valueTypeNode.typeKind, this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
        this.visitBuiltInTypeNode(builtInRefType, builtInRefType.typeKind, this.env);
    }

    @Override
    public void visit(BLangArrayType arrayTypeNode) {
        this.resultType = this.resolveTypeNode(arrayTypeNode.elemtype, this.env, this.diagCode);
        if (this.resultType == this.symTable.noType) {
            return;
        }
        for (int i = 0; i < arrayTypeNode.dimensions; ++i) {
            int size;
            BTypeSymbol arrayTypeSymbol = Symbols.createTypeSymbol(8388636, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
            this.resultType = arrayTypeNode.sizes.length == 0 ? new BArrayType(this.resultType, arrayTypeSymbol) : ((size = arrayTypeNode.sizes[i]) == -1 ? new BArrayType(this.resultType, arrayTypeSymbol, size, BArrayState.UNSEALED) : (size == -2 ? new BArrayType(this.resultType, arrayTypeSymbol, size, BArrayState.OPEN_SEALED) : new BArrayType(this.resultType, arrayTypeSymbol, size, BArrayState.CLOSED_SEALED)));
            arrayTypeSymbol.type = this.resultType;
        }
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        LinkedHashSet memberTypes = unionTypeNode.memberTypeNodes.stream().map(memTypeNode -> this.resolveTypeNode((BLangType)memTypeNode, this.env)).flatMap(memBType -> memBType.tag == 20 && !Symbols.isFlagOn(memBType.tsymbol.flags, 0x400000) ? ((BUnionType)memBType).getMemberTypes().stream() : Stream.of(memBType)).collect(Collectors.toCollection(LinkedHashSet::new));
        BTypeSymbol unionTypeSymbol = Symbols.createTypeSymbol(2097180, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        if (memberTypes.contains(this.symTable.noType)) {
            this.resultType = this.symTable.noType;
            return;
        }
        BUnionType unionType = BUnionType.create(unionTypeSymbol, memberTypes);
        unionTypeSymbol.type = unionType;
        this.resultType = unionType;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        EnumSet<Flag> flags = EnumSet.copyOf(objectTypeNode.flagSet);
        if (objectTypeNode.isAnonymous) {
            flags.add(Flag.PUBLIC);
        }
        BTypeSymbol objectSymbol = Symbols.createObjectSymbol(Flags.asMask(flags), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        BObjectType objectType = flags.contains((Object)Flag.SERVICE) ? new BServiceType(objectSymbol) : new BObjectType(objectSymbol);
        objectSymbol.type = objectType;
        objectTypeNode.symbol = objectSymbol;
        this.resultType = objectType;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        if (recordTypeNode.symbol == null) {
            EnumSet<Flag> flags = recordTypeNode.isAnonymous ? EnumSet.of(Flag.PUBLIC, Flag.ANONYMOUS) : EnumSet.noneOf(Flag.class);
            BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(flags), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
            BRecordType recordType = new BRecordType(recordSymbol);
            recordSymbol.type = recordType;
            recordTypeNode.symbol = recordSymbol;
            if (this.env.node.getKind() != NodeKind.PACKAGE) {
                recordSymbol.name = this.names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(this.env.enclPkg.packageID));
                this.symbolEnter.defineSymbol(recordTypeNode.pos, recordTypeNode.symbol, this.env);
                this.symbolEnter.defineNode(recordTypeNode, this.env);
            }
            this.resultType = recordType;
        } else {
            this.resultType = recordTypeNode.symbol.type;
        }
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(0x10001C, Flags.asMask(EnumSet.noneOf(Flag.class)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        BFiniteType finiteType = new BFiniteType(finiteTypeSymbol);
        for (BLangExpression literal : finiteTypeNode.valueSpace) {
            ((BLangLiteral)literal).type = this.symTable.getTypeFromTag(((BLangLiteral)literal).type.tag);
            finiteType.addValue(literal);
        }
        finiteTypeSymbol.type = finiteType;
        this.resultType = finiteType;
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        List<BType> memberTypes = tupleTypeNode.memberTypeNodes.stream().map(memTypeNode -> this.resolveTypeNode((BLangType)memTypeNode, this.env)).collect(Collectors.toList());
        if (memberTypes.contains(this.symTable.noType)) {
            this.resultType = this.symTable.noType;
            return;
        }
        BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4194332, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        BTupleType tupleType = new BTupleType(tupleTypeSymbol, memberTypes);
        tupleTypeSymbol.type = tupleType;
        if (tupleTypeNode.restParamType != null) {
            tupleType.restType = this.resolveTypeNode(tupleTypeNode.restParamType, this.env);
        }
        this.resultType = tupleType;
    }

    @Override
    public void visit(BLangErrorType errorTypeNode) {
        BType reasonType = Optional.ofNullable(errorTypeNode.reasonType).map(bLangType -> this.resolveTypeNode((BLangType)bLangType, this.env)).orElse(this.symTable.stringType);
        BType detailType = Optional.ofNullable(errorTypeNode.detailType).map(bLangType -> this.resolveTypeNode((BLangType)bLangType, this.env)).orElse(this.symTable.detailType);
        if (detailType == null && PackageID.ANNOTATIONS.equals(this.env.enclPkg.packageID)) {
            BSymbol symbol = this.lookupSymbolInMainSpace(this.env, Names.ERROR);
            this.resultType = symbol.type;
            this.symTable.errorType = (BErrorType)this.resultType;
            this.symTable.detailType = (BRecordType)this.symTable.errorType.detailType;
            return;
        }
        if (reasonType == this.symTable.stringType && detailType == this.symTable.detailType) {
            this.resultType = this.symTable.errorType;
            return;
        }
        BErrorTypeSymbol errorTypeSymbol = Symbols.createErrorSymbol(Flags.asMask(EnumSet.noneOf(Flag.class)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        BErrorType errorType = new BErrorType(errorTypeSymbol, reasonType, detailType);
        errorTypeSymbol.type = errorType;
        this.resultType = errorType;
    }

    @Override
    public void visit(BLangConstrainedType constrainedTypeNode) {
        BType type = this.resolveTypeNode(constrainedTypeNode.type, this.env);
        BType constraintType = this.resolveTypeNode(constrainedTypeNode.constraint, this.env);
        if (constraintType == this.symTable.noType) {
            this.resultType = this.symTable.noType;
            return;
        }
        BType constrainedType = null;
        if (type.tag == 9) {
            if (constraintType.tag == 32) {
                this.dlog.error(constrainedTypeNode.pos, DiagnosticCode.OBJECT_TYPE_NOT_ALLOWED, new Object[0]);
                this.resultType = this.symTable.semanticError;
                return;
            }
            this.resultType = new BTableType(9, constraintType, type.tsymbol);
            return;
        }
        if (type.tag == 30) {
            constrainedType = new BFutureType(30, constraintType, null);
        } else if (type.tag == 15) {
            constrainedType = new BMapType(15, constraintType, null);
        } else if (type.tag == 13) {
            constrainedType = new BTypedescType(constraintType, null);
        } else if (type.tag == 8) {
            constrainedType = this.symTable.xmlType;
        } else {
            return;
        }
        BTypeSymbol typeSymbol = type.tsymbol;
        constrainedType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.pkgID, constrainedType, typeSymbol.owner);
        this.resultType = constrainedType;
    }

    @Override
    public void visit(BLangStreamType streamTypeNode) {
        BType error;
        BType type = this.resolveTypeNode(streamTypeNode.type, this.env);
        BType constraintType = this.resolveTypeNode(streamTypeNode.constraint, this.env);
        BType bType = error = streamTypeNode.error != null ? this.resolveTypeNode(streamTypeNode.error, this.env) : null;
        if (constraintType == this.symTable.noType) {
            this.resultType = this.symTable.noType;
            return;
        }
        BStreamType streamType = new BStreamType(14, constraintType, error, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        streamType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.pkgID, streamType, typeSymbol.owner);
        this.resultType = streamType;
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedTypeNode) {
        Name pkgAlias = this.names.fromIdNode(userDefinedTypeNode.pkgAlias);
        Name typeName = this.names.fromIdNode(userDefinedTypeNode.typeName);
        BSymbol symbol = this.symTable.notFoundSymbol;
        if (this.env.scope.owner.tag == 2) {
            symbol = this.lookupAnnotationSpaceSymbolInPackage(userDefinedTypeNode.pos, this.env, pkgAlias, typeName);
        }
        if (symbol == this.symTable.notFoundSymbol) {
            BSymbol tempSymbol = this.lookupMainSpaceSymbolInPackage(userDefinedTypeNode.pos, this.env, pkgAlias, typeName);
            if ((tempSymbol.tag & 0xC) == 12) {
                symbol = tempSymbol;
            }
        }
        if (symbol == this.symTable.notFoundSymbol) {
            symbol = this.lookupMemberSymbol(userDefinedTypeNode.pos, this.symTable.rootScope, this.env, typeName, 20);
        }
        if (this.env.logErrors && symbol == this.symTable.notFoundSymbol) {
            this.dlog.error(userDefinedTypeNode.pos, this.diagCode, typeName);
            this.resultType = this.symTable.semanticError;
            return;
        }
        this.resultType = symbol.type;
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        this.resultType = this.createInvokableType(functionTypeNode.getParams(), functionTypeNode.restParam, functionTypeNode.returnTypeNode, Flags.asMask(functionTypeNode.flagSet), this.env);
    }

    /*
     * WARNING - void declaration
     */
    public BInvokableType createInvokableType(List<? extends BLangVariable> paramVars, BLangVariable restVariable, BLangType retTypeVar, int flags, SymbolEnv env) {
        void var11_14;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>();
        boolean foundDefaultableParam = false;
        ArrayList<String> paramNames = new ArrayList<String>();
        for (BLangVariable bLangVariable : paramVars) {
            BVarSymbol symbol;
            BType type;
            BLangSimpleVariable param = (BLangSimpleVariable)bLangVariable;
            Name paramName = this.names.fromIdNode(param.name);
            if (paramName != Names.EMPTY) {
                if (paramNames.contains(paramName.value)) {
                    this.dlog.error(param.name.pos, DiagnosticCode.REDECLARED_SYMBOL, paramName.value);
                } else {
                    paramNames.add(paramName.value);
                }
            }
            bLangVariable.type = type = this.resolveTypeNode(param.getTypeNode(), env);
            paramTypes.add(type);
            if (param.expr != null) {
                foundDefaultableParam = true;
            }
            param.symbol = symbol = new BVarSymbol(type.flags, paramName, env.enclPkg.symbol.pkgID, type, env.scope.owner);
            if (param.expr == null && foundDefaultableParam) {
                this.dlog.error(param.pos, DiagnosticCode.REQUIRED_PARAM_DEFINED_AFTER_DEFAULTABLE_PARAM, new Object[0]);
            }
            if (param.flagSet.contains((Object)Flag.PUBLIC)) {
                symbol.flags |= 1;
            }
            if (param.expr != null) {
                symbol.flags |= 0x2000;
                symbol.defaultableParam = true;
            }
            params.add(symbol);
        }
        BType retType = this.resolveTypeNode(retTypeVar, this.env);
        Object var11_12 = null;
        BType restType = null;
        if (restVariable != null) {
            restVariable.type = restType = this.resolveTypeNode(restVariable.typeNode, env);
            BVarSymbol bVarSymbol = new BVarSymbol(restType.flags, this.names.fromIdNode(((BLangSimpleVariable)restVariable).name), env.enclPkg.symbol.pkgID, restType, env.scope.owner);
        }
        BInvokableType bInvokableType = new BInvokableType(paramTypes, restType, retType, null);
        bInvokableType.flags = flags;
        BInvokableTypeSymbol tsymbol = Symbols.createInvokableTypeSymbol(33554460, flags, env.enclPkg.symbol.pkgID, bInvokableType, env.scope.owner);
        tsymbol.params = params;
        tsymbol.restParam = var11_14;
        tsymbol.returnType = retType;
        bInvokableType.tsymbol = tsymbol;
        return bInvokableType;
    }

    public Map<Name, List<Scope.ScopeEntry>> getAllVisibleInScopeSymbols(SymbolEnv env) {
        HashMap<Name, List<Scope.ScopeEntry>> visibleEntries = new HashMap<Name, List<Scope.ScopeEntry>>();
        env.scope.entries.forEach((key, value) -> {
            ArrayList<Scope.ScopeEntry> entryList = new ArrayList<Scope.ScopeEntry>();
            entryList.add((Scope.ScopeEntry)value);
            visibleEntries.put((Name)key, (List<Scope.ScopeEntry>)entryList);
        });
        if (env.enclEnv != null) {
            this.getAllVisibleInScopeSymbols(env.enclEnv).forEach((name, entryList) -> {
                if (!visibleEntries.containsKey(name)) {
                    visibleEntries.put((Name)name, (List<Scope.ScopeEntry>)entryList);
                } else {
                    List scopeEntries = (List)visibleEntries.get(name);
                    entryList.forEach(scopeEntry -> {
                        if (!scopeEntries.contains(scopeEntry) && !(scopeEntry.symbol instanceof BVarSymbol)) {
                            scopeEntries.add(scopeEntry);
                        }
                    });
                }
            });
        }
        return visibleEntries;
    }

    public BSymbol getBinaryEqualityForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType, BLangBinaryExpr binaryExpr) {
        boolean validEqualityIntersectionExists;
        switch (opKind) {
            case EQUAL: 
            case NOT_EQUAL: {
                validEqualityIntersectionExists = this.types.validEqualityIntersectionExists(lhsType, rhsType);
                break;
            }
            case REF_EQUAL: 
            case REF_NOT_EQUAL: {
                validEqualityIntersectionExists = this.types.isAssignable(lhsType, rhsType) || this.types.isAssignable(rhsType, lhsType);
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (validEqualityIntersectionExists) {
            if (!this.types.isValueType(lhsType) && !this.types.isValueType(rhsType) || this.types.isValueType(lhsType) && this.types.isValueType(rhsType)) {
                return this.createEqualityOperator(opKind, lhsType, rhsType);
            }
            this.types.setImplicitCastExpr(binaryExpr.rhsExpr, rhsType, this.symTable.anyType);
            this.types.setImplicitCastExpr(binaryExpr.lhsExpr, lhsType, this.symTable.anyType);
            switch (opKind) {
                case REF_EQUAL: {
                    return this.createEqualityOperator(OperatorKind.EQUAL, this.symTable.anyType, this.symTable.anyType);
                }
                case REF_NOT_EQUAL: {
                    return this.createEqualityOperator(OperatorKind.NOT_EQUAL, this.symTable.anyType, this.symTable.anyType);
                }
            }
            return this.createEqualityOperator(opKind, this.symTable.anyType, this.symTable.anyType);
        }
        return this.symTable.notFoundSymbol;
    }

    private BSymbol resolveOperator(Scope.ScopeEntry entry, List<BType> types) {
        BSymbol foundSymbol = this.symTable.notFoundSymbol;
        while (entry != Scope.NOT_FOUND_ENTRY) {
            BInvokableType opType = (BInvokableType)entry.symbol.type;
            if (types.size() == opType.paramTypes.size()) {
                boolean match = true;
                for (int i = 0; i < types.size(); ++i) {
                    if (types.get((int)i).tag == opType.paramTypes.get((int)i).tag) continue;
                    match = false;
                }
                if (match) {
                    foundSymbol = entry.symbol;
                    break;
                }
            }
            entry = entry.next;
        }
        return foundSymbol;
    }

    private void visitBuiltInTypeNode(BLangType typeNode, TypeKind typeKind, SymbolEnv env) {
        Name typeName = this.names.fromTypeKind(typeKind);
        BSymbol typeSymbol = this.lookupMemberSymbol(typeNode.pos, this.symTable.rootScope, env, typeName, 12);
        if (typeSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(typeNode.pos, this.diagCode, typeName);
        }
        this.resultType = typeNode.type = typeSymbol.type;
    }

    private void addNamespacesInScope(Map<Name, BXMLNSSymbol> namespaces, SymbolEnv env) {
        if (env == null) {
            return;
        }
        env.scope.entries.forEach((name, scopeEntry) -> {
            if (scopeEntry.symbol.kind == SymbolKind.XMLNS) {
                BXMLNSSymbol nsSymbol = (BXMLNSSymbol)scopeEntry.symbol;
                if (!namespaces.containsKey(name)) {
                    namespaces.put((Name)name, nsSymbol);
                }
            }
        });
        this.addNamespacesInScope(namespaces, env.enclEnv);
    }

    private boolean isMemberAccessAllowed(SymbolEnv env, BSymbol symbol) {
        if (Symbols.isPublic(symbol)) {
            return true;
        }
        if (!Symbols.isPrivate(symbol)) {
            return env.enclPkg.symbol.pkgID == symbol.pkgID;
        }
        if (env.enclType != null) {
            return env.enclType.type.tsymbol == symbol.owner;
        }
        return this.isMemberAllowed(env, symbol);
    }

    private boolean isMemberAllowed(SymbolEnv env, BSymbol symbol) {
        return env != null && (env.enclInvokable != null && env.enclInvokable.symbol.receiverSymbol != null && env.enclInvokable.symbol.receiverSymbol.type.tsymbol == symbol.owner || this.isMemberAllowed(env.enclEnv, symbol));
    }
}

