/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.Name;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class TypeParamAnalyzer {
    private static final CompilerContext.Key<TypeParamAnalyzer> TYPE_PARAM_ANALYZER_KEY = new CompilerContext.Key();
    private SymbolTable symTable;
    private Types types;
    private Names names;
    private BLangDiagnosticLogHelper dlog;

    public static TypeParamAnalyzer getInstance(CompilerContext context) {
        TypeParamAnalyzer types = context.get(TYPE_PARAM_ANALYZER_KEY);
        if (types == null) {
            types = new TypeParamAnalyzer(context);
        }
        return types;
    }

    private TypeParamAnalyzer(CompilerContext context) {
        context.put(TYPE_PARAM_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
    }

    static boolean isTypeParam(BType expType) {
        return Symbols.isFlagOn(expType.flags, 0x400000) || expType.tsymbol != null && Symbols.isFlagOn(expType.tsymbol.flags, 0x400000);
    }

    public static boolean containsTypeParam(BType type) {
        return TypeParamAnalyzer.containsTypeParam(type, new HashSet<BType>());
    }

    void checkForTypeParamsInArg(DiagnosticPos pos, BType actualType, SymbolEnv env, BType expType) {
        if (this.notRequireTypeParams(env)) {
            return;
        }
        FindTypeParamResult findTypeParamResult = new FindTypeParamResult();
        this.findTypeParam(pos, expType, actualType, env, new HashSet<BType>(), findTypeParamResult);
    }

    boolean notRequireTypeParams(SymbolEnv env) {
        return env.typeParamsEntries == null;
    }

    BType getReturnTypeParams(SymbolEnv env, BType expType) {
        if (this.notRequireTypeParams(env) || env.typeParamsEntries.isEmpty()) {
            return expType;
        }
        return this.getMatchingBoundType(expType, env);
    }

    public BType getNominalType(BType type, Name name, int flag) {
        if (name == Names.EMPTY) {
            return type;
        }
        return this.createBuiltInType(type, name, flag);
    }

    BType createTypeParam(BType type, Name name) {
        int flag = type.flags | 0x400000;
        return this.createBuiltInType(type, name, flag);
    }

    BType getMatchingBoundType(BType expType, SymbolEnv env) {
        return this.getMatchingBoundType(expType, env, new HashSet<BType>());
    }

    private static boolean containsTypeParam(BType type, HashSet<BType> resolvedTypes) {
        if (TypeParamAnalyzer.isTypeParam(type)) {
            return true;
        }
        if (resolvedTypes.contains(type)) {
            return false;
        }
        resolvedTypes.add(type);
        switch (type.tag) {
            case 19: {
                return TypeParamAnalyzer.containsTypeParam(((BArrayType)type).eType, resolvedTypes);
            }
            case 29: {
                BTupleType bTupleType = (BTupleType)type;
                for (BType member : bTupleType.tupleTypes) {
                    if (!TypeParamAnalyzer.containsTypeParam(member, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 9: {
                return TypeParamAnalyzer.containsTypeParam(((BTableType)type).constraint, resolvedTypes);
            }
            case 15: {
                return TypeParamAnalyzer.containsTypeParam(((BMapType)type).constraint, resolvedTypes);
            }
            case 14: {
                return TypeParamAnalyzer.containsTypeParam(((BStreamType)type).constraint, resolvedTypes);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.fields) {
                    BType bFieldType = field.getType();
                    if (!TypeParamAnalyzer.containsTypeParam(bFieldType, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 16: {
                BInvokableType invokableType = (BInvokableType)type;
                for (BType paramType : invokableType.paramTypes) {
                    if (!TypeParamAnalyzer.containsTypeParam(paramType, resolvedTypes)) continue;
                    return true;
                }
                return TypeParamAnalyzer.containsTypeParam(invokableType.retType, resolvedTypes);
            }
            case 32: {
                if (type instanceof BServiceType) {
                    return false;
                }
                BObjectType objectType = (BObjectType)type;
                for (Object field : objectType.fields) {
                    BType bFieldType = ((BField)field).getType();
                    if (!TypeParamAnalyzer.containsTypeParam(bFieldType, resolvedTypes)) continue;
                    return true;
                }
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
                for (BAttachedFunction fuc : objectTypeSymbol.attachedFuncs) {
                    if (!TypeParamAnalyzer.containsTypeParam(fuc.type, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 20: {
                BUnionType unionType = (BUnionType)type;
                for (BType bType : unionType.getMemberTypes()) {
                    if (!TypeParamAnalyzer.containsTypeParam(bType, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 27: {
                BErrorType errorType = (BErrorType)type;
                return TypeParamAnalyzer.containsTypeParam(errorType.reasonType, resolvedTypes) || TypeParamAnalyzer.containsTypeParam(errorType.detailType, resolvedTypes);
            }
            case 13: {
                return TypeParamAnalyzer.containsTypeParam(((BTypedescType)type).constraint, resolvedTypes);
            }
        }
        return false;
    }

    private BType createBuiltInType(BType type, Name name, int flag) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new BType(type.tag, null, name, flag);
            }
            case 17: {
                return new BAnyType(type.tag, null, name, flag);
            }
            case 11: {
                return new BAnydataType(type.tag, null, name, flag);
            }
        }
        return type;
    }

    private void findTypeParam(DiagnosticPos pos, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(pos, expType, actualType, env, resolvedTypes, result, false);
    }

    private void findTypeParam(DiagnosticPos pos, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result, boolean checkContravariance) {
        if (resolvedTypes.contains(expType)) {
            return;
        }
        resolvedTypes.add(expType);
        if (TypeParamAnalyzer.isTypeParam(expType)) {
            this.updateTypeParamAndBoundType(pos, env, expType, actualType);
            if (checkContravariance) {
                this.types.checkType(pos, this.getMatchingBoundType(expType, env, new HashSet<BType>()), actualType, DiagnosticCode.INCOMPATIBLE_TYPES);
            } else {
                this.types.checkType(pos, actualType, this.getMatchingBoundType(expType, env, new HashSet<BType>()), DiagnosticCode.INCOMPATIBLE_TYPES);
            }
            return;
        }
        switch (expType.tag) {
            case 19: {
                if (actualType.tag == 19) {
                    this.findTypeParam(pos, ((BArrayType)expType).eType, ((BArrayType)actualType).eType, env, resolvedTypes, result);
                }
                if (actualType.tag == 29) {
                    this.findTypeParamInTupleForArray(pos, (BArrayType)expType, (BTupleType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 9: {
                if (actualType.tag == 9) {
                    this.findTypeParam(pos, ((BTableType)expType).constraint, ((BTableType)actualType).constraint, env, resolvedTypes, result);
                }
                return;
            }
            case 15: {
                if (actualType.tag == 15) {
                    this.findTypeParam(pos, ((BMapType)expType).constraint, ((BMapType)actualType).constraint, env, resolvedTypes, result);
                }
                if (actualType.tag == 12) {
                    this.findTypeParamInMapForRecord(pos, (BMapType)expType, (BRecordType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 14: {
                if (actualType.tag == 14) {
                    this.findTypeParamInStream(pos, (BStreamType)expType, (BStreamType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 29: {
                if (actualType.tag == 29) {
                    this.findTypeParamInTuple(pos, (BTupleType)expType, (BTupleType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 12: {
                if (actualType.tag == 12) {
                    this.findTypeParamInRecord(pos, (BRecordType)expType, (BRecordType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 16: {
                if (actualType.tag == 16) {
                    this.findTypeParamInInvokableType(pos, (BInvokableType)expType, (BInvokableType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 32: {
                if (actualType.tag == 32 && !(actualType instanceof BServiceType)) {
                    this.findTypeParamInObject(pos, (BObjectType)expType, (BObjectType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 20: {
                if (actualType.tag == 20) {
                    this.findTypeParamInUnion(pos, (BUnionType)expType, (BUnionType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 27: {
                if (actualType.tag == 27) {
                    this.findTypeParamInError(pos, (BErrorType)expType, (BErrorType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag == 20 && this.types.isSubTypeOfBaseType(actualType, 27)) {
                    this.findTypeParamInError(pos, (BErrorType)expType, this.symTable.errorType, env, resolvedTypes, result);
                }
                return;
            }
            case 13: {
                if (actualType.tag != 13) break;
                this.findTypeParam(pos, ((BTypedescType)expType).constraint, ((BTypedescType)actualType).constraint, env, resolvedTypes, result);
            }
        }
    }

    private void updateTypeParamAndBoundType(DiagnosticPos pos, SymbolEnv env, BType typeParamType, BType boundType) {
        if (env.typeParamsEntries.stream().noneMatch(entry -> entry.typeParam.tsymbol.pkgID.equals(typeParamType.tsymbol.pkgID) && entry.typeParam.tsymbol.name.equals(typeParamType.tsymbol.name))) {
            if (boundType == this.symTable.noType) {
                this.dlog.error(pos, DiagnosticCode.CANNOT_INFER_TYPE, new Object[0]);
                return;
            }
            env.typeParamsEntries.add(new SymbolEnv.TypeParamEntry(typeParamType, boundType));
        }
    }

    private void findTypeParamInTuple(DiagnosticPos pos, BTupleType expType, BTupleType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (int i = 0; i < expType.tupleTypes.size() && i < actualType.tupleTypes.size(); ++i) {
            this.findTypeParam(pos, expType.tupleTypes.get(i), actualType.tupleTypes.get(i), env, resolvedTypes, result);
        }
    }

    private void findTypeParamInStream(DiagnosticPos pos, BStreamType expType, BStreamType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(pos, expType.constraint, actualType.constraint, env, resolvedTypes, result);
        this.findTypeParam(pos, expType.error, actualType.error != null ? actualType.error : this.symTable.nilType, env, resolvedTypes, result);
    }

    private void findTypeParamInTupleForArray(DiagnosticPos pos, BArrayType expType, BTupleType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> tupleTypes = new LinkedHashSet<BType>(actualType.tupleTypes);
        if (actualType.restType != null) {
            tupleTypes.add(actualType.restType);
        }
        BUnionType tupleElementType = BUnionType.create(null, tupleTypes);
        this.findTypeParam(pos, expType.eType, tupleElementType, env, resolvedTypes, result);
    }

    private void findTypeParamInRecord(DiagnosticPos pos, BRecordType expType, BRecordType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (BField exField : expType.fields) {
            BType actualFieldType = actualType.fields.stream().filter(acField -> exField.name.equals(acField.name)).findFirst().map(acField -> acField.type).orElse(null);
            if (actualFieldType == null) continue;
            this.findTypeParam(pos, exField.type, actualFieldType, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInMapForRecord(DiagnosticPos pos, BMapType expType, BRecordType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> reducedTypeSet;
        LinkedHashSet<BType> fields = actualType.fields.stream().map(f -> f.type).collect(Collectors.toCollection(LinkedHashSet::new));
        if (actualType.restFieldType != this.symTable.noType) {
            reducedTypeSet = new LinkedHashSet<BType>();
            for (BType fType : fields) {
                if (this.types.isAssignable(fType, actualType.restFieldType)) continue;
                reducedTypeSet.add(fType);
            }
            reducedTypeSet.add(actualType.restFieldType);
        } else {
            reducedTypeSet = fields;
        }
        BType commonFieldType = reducedTypeSet.size() == 1 ? (BType)reducedTypeSet.iterator().next() : BUnionType.create(null, reducedTypeSet);
        this.findTypeParam(pos, expType.constraint, commonFieldType, env, resolvedTypes, result);
    }

    private void findTypeParamInInvokableType(DiagnosticPos pos, BInvokableType expType, BInvokableType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (int i = 0; i < expType.paramTypes.size() && i < actualType.paramTypes.size(); ++i) {
            this.findTypeParam(pos, expType.paramTypes.get(i), actualType.paramTypes.get(i), env, resolvedTypes, result, true);
        }
        this.findTypeParam(pos, expType.retType, actualType.retType, env, resolvedTypes, result);
    }

    private void findTypeParamInObject(DiagnosticPos pos, BObjectType expType, BObjectType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (BField exField : expType.fields) {
            BType actualFieldType = actualType.fields.stream().filter(acField -> exField.name.equals(acField.name)).findFirst().map(acField -> acField.type).orElse(null);
            if (actualFieldType == null) continue;
            this.findTypeParam(pos, exField.type, actualFieldType, env, resolvedTypes, result);
        }
        List expAttFunctions = ((BObjectTypeSymbol)expType.tsymbol).attachedFuncs;
        List actualAttFunctions = ((BObjectTypeSymbol)actualType.tsymbol).attachedFuncs;
        for (BAttachedFunction expFunc : expAttFunctions) {
            BInvokableType actFuncType = actualAttFunctions.stream().filter(actFunc -> actFunc.funcName.equals(expFunc.funcName)).findFirst().map(actFunc -> actFunc.type).orElse(null);
            if (actFuncType == null) continue;
            this.findTypeParamInInvokableType(pos, expFunc.type, actFuncType, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInUnion(DiagnosticPos pos, BUnionType expType, BUnionType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        if (expType.getMemberTypes().size() != 2 || !expType.isNullable() || actualType.getMemberTypes().size() != 2 || !actualType.isNullable()) {
            return;
        }
        BType exp = expType.getMemberTypes().stream().filter(type -> type != this.symTable.nilType).findFirst().orElse(this.symTable.nilType);
        BType act = actualType.getMemberTypes().stream().filter(type -> type != this.symTable.nilType).findFirst().orElse(this.symTable.nilType);
        this.findTypeParam(pos, exp, act, env, resolvedTypes, result);
    }

    private void findTypeParamInError(DiagnosticPos pos, BErrorType expType, BErrorType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        if (expType == this.symTable.errorType) {
            return;
        }
        this.findTypeParam(pos, expType.detailType, actualType.detailType, env, resolvedTypes, result);
        this.findTypeParam(pos, expType.reasonType, actualType.reasonType, env, resolvedTypes, result);
    }

    private BType getMatchingBoundType(BType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        if (TypeParamAnalyzer.isTypeParam(expType)) {
            return env.typeParamsEntries.stream().filter(typeParamEntry -> typeParamEntry.typeParam == expType).findFirst().map(typeParamEntry -> typeParamEntry.boundType).orElse(this.symTable.noType);
        }
        if (resolvedTypes.contains(expType)) {
            return expType;
        }
        resolvedTypes.add(expType);
        switch (expType.tag) {
            case 19: {
                BType elementType = ((BArrayType)expType).eType;
                return new BArrayType(this.getMatchingBoundType(elementType, env, resolvedTypes));
            }
            case 9: {
                return new BTableType(9, this.getMatchingBoundType(((BTableType)expType).constraint, env, resolvedTypes), this.symTable.tableType.tsymbol);
            }
            case 15: {
                BType constraint = ((BMapType)expType).constraint;
                return new BMapType(15, this.getMatchingBoundType(constraint, env, resolvedTypes), this.symTable.mapType.tsymbol);
            }
            case 14: {
                BType streamConstraint = this.getMatchingBoundType(((BStreamType)expType).constraint, env, resolvedTypes);
                BType streamError = ((BStreamType)expType).error != null ? this.getMatchingOptionalBoundType((BUnionType)((BStreamType)expType).error, env, resolvedTypes) : null;
                return new BStreamType(14, streamConstraint, streamError, this.symTable.streamType.tsymbol);
            }
            case 29: {
                return this.getMatchingTupleBoundType((BTupleType)expType, env, resolvedTypes);
            }
            case 12: {
                return this.getMatchingRecordBoundType((BRecordType)expType, env, resolvedTypes);
            }
            case 16: {
                return this.getMatchingFunctionBoundType((BInvokableType)expType, env, resolvedTypes);
            }
            case 32: {
                if (expType instanceof BServiceType) {
                    return expType;
                }
                return this.getMatchingObjectBoundType((BObjectType)expType, env, resolvedTypes);
            }
            case 20: {
                return this.getMatchingOptionalBoundType((BUnionType)expType, env, resolvedTypes);
            }
            case 27: {
                return this.getMatchingErrorBoundType((BErrorType)expType, env, resolvedTypes);
            }
            case 13: {
                BType constraint = ((BTypedescType)expType).constraint;
                return new BTypedescType(this.getMatchingBoundType(constraint, env, resolvedTypes), this.symTable.typeDesc.tsymbol);
            }
        }
        return expType;
    }

    private BTupleType getMatchingTupleBoundType(BTupleType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        ArrayList<BType> tupleTypes = new ArrayList<BType>();
        expType.tupleTypes.forEach(type -> tupleTypes.add(this.getMatchingBoundType((BType)type, env, resolvedTypes)));
        return new BTupleType(tupleTypes);
    }

    private BRecordType getMatchingRecordBoundType(BRecordType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        BRecordTypeSymbol expTSymbol = (BRecordTypeSymbol)expType.tsymbol;
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(expTSymbol.flags, expTSymbol.name, expTSymbol.pkgID, null, expType.tsymbol.scope.owner);
        recordSymbol.scope = new Scope(recordSymbol);
        recordSymbol.initializerFunc = expTSymbol.initializerFunc;
        ArrayList<BField> fields = new ArrayList<BField>();
        for (BField expField : expType.fields) {
            BField field = new BField(expField.name, expField.pos, new BVarSymbol(0, expField.name, env.enclPkg.packageID, this.getMatchingBoundType(expField.type, env, resolvedTypes), env.scope.owner));
            fields.add(field);
            recordSymbol.scope.define(expField.name, field.symbol);
        }
        BRecordType bRecordType = new BRecordType(recordSymbol);
        bRecordType.fields = fields;
        recordSymbol.type = bRecordType;
        if (expType.sealed) {
            bRecordType.sealed = true;
        }
        bRecordType.restFieldType = this.getMatchingBoundType(expType.restFieldType, env, resolvedTypes);
        return bRecordType;
    }

    private BInvokableType getMatchingFunctionBoundType(BInvokableType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        List<BType> paramTypes = expType.paramTypes.stream().map(type -> this.getMatchingBoundType((BType)type, env, resolvedTypes)).collect(Collectors.toList());
        BType restType = expType.restType;
        return new BInvokableType(paramTypes, restType, this.getMatchingBoundType(expType.retType, env, resolvedTypes), Symbols.createInvokableTypeSymbol(33554460, expType.flags, env.enclPkg.symbol.pkgID, expType, env.scope.owner));
    }

    private BType getMatchingObjectBoundType(BObjectType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        BObjectTypeSymbol actObjectSymbol = (BObjectTypeSymbol)Symbols.createObjectSymbol(expType.tsymbol.flags, expType.tsymbol.name, expType.tsymbol.pkgID, null, expType.tsymbol.scope.owner);
        BObjectType objectType = new BObjectType(actObjectSymbol);
        actObjectSymbol.type = objectType;
        actObjectSymbol.scope = new Scope(actObjectSymbol);
        actObjectSymbol.methodScope = new Scope(actObjectSymbol);
        for (BField expField : expType.fields) {
            BField field = new BField(expField.name, expField.pos, new BVarSymbol(expField.symbol.flags, expField.name, env.enclPkg.packageID, this.getMatchingBoundType(expField.type, env, resolvedTypes), env.scope.owner));
            objectType.fields.add(field);
            objectType.tsymbol.scope.define(expField.name, field.symbol);
        }
        for (BAttachedFunction expFunc : ((BObjectTypeSymbol)expType.tsymbol).attachedFuncs) {
            BInvokableType matchType = this.getMatchingFunctionBoundType(expFunc.type, env, resolvedTypes);
            BInvokableSymbol invokableSymbol = new BInvokableSymbol(expFunc.symbol.tag, expFunc.symbol.flags, expFunc.symbol.name, env.enclPkg.packageID, matchType, env.scope.owner);
            invokableSymbol.retType = invokableSymbol.getType().retType;
            matchType.tsymbol = Symbols.createTypeSymbol(33554460, invokableSymbol.flags, Names.EMPTY, env.enclPkg.symbol.pkgID, invokableSymbol.type, env.scope.owner);
            actObjectSymbol.attachedFuncs.add(new BAttachedFunction(expFunc.funcName, invokableSymbol, matchType));
            String funcName = Symbols.getAttachedFuncSymbolName(actObjectSymbol.type.tsymbol.name.value, expFunc.funcName.value);
            actObjectSymbol.methodScope.define(this.names.fromString(funcName), invokableSymbol);
        }
        return objectType;
    }

    private BType getMatchingOptionalBoundType(BUnionType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        LinkedHashSet<BType> members = new LinkedHashSet<BType>();
        expType.getMemberTypes().forEach(type -> members.add(this.getMatchingBoundType((BType)type, env, resolvedTypes)));
        return BUnionType.create(null, members);
    }

    private BType getMatchingErrorBoundType(BErrorType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        if (expType == this.symTable.errorType) {
            return expType;
        }
        BType reasonType = this.getMatchingBoundType(expType.reasonType, env, resolvedTypes);
        BType detailType = this.getMatchingBoundType(expType.detailType, env, resolvedTypes);
        BErrorTypeSymbol typeSymbol = new BErrorTypeSymbol(589852, this.symTable.errorType.tsymbol.flags, this.symTable.errorType.tsymbol.name, this.symTable.errorType.tsymbol.pkgID, null, null);
        BErrorType errorType = new BErrorType(typeSymbol, reasonType, detailType);
        typeSymbol.type = errorType;
        return errorType;
    }

    private static class FindTypeParamResult {
        boolean found = false;
        boolean isNew = false;

        private FindTypeParamResult() {
        }
    }
}

