/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.AnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.AttachPoints;

public class BAnnotationSymbol
extends BTypeSymbol
implements AnnotationSymbol {
    public BTypeSymbol attachedType;
    public Set<AttachPoint> points;
    public int maskedPoints;

    @Deprecated
    public BAnnotationSymbol(Name name, int flags, int maskedPoints, PackageID pkgID, BType type, BSymbol owner) {
        super(2, flags, name, pkgID, type, owner);
        this.maskedPoints = maskedPoints;
        this.points = new HashSet<AttachPoint>();
    }

    public BAnnotationSymbol(Name name, int flags, Set<AttachPoint> points, PackageID pkgID, BType type, BSymbol owner) {
        super(2, flags, name, pkgID, type, owner);
        this.points = points;
        this.maskedPoints = this.getMaskedPoints(points);
    }

    @Override
    public String toString() {
        return this.pkgID != null && !this.pkgID.toString().equals(".") ? this.pkgID.toString() + ":" + this.name : this.name.toString();
    }

    public String bvmAlias() {
        String pkg = this.pkgID.toString();
        return !pkg.equals(".") ? pkg + ":" + this.name : this.name.toString();
    }

    @Override
    public BAnnotationSymbol createLabelSymbol() {
        BAnnotationSymbol copy = Symbols.createAnnotationSymbol(this.flags, this.points, Names.EMPTY, this.pkgID, this.type, this.owner);
        copy.attachedType = this.attachedType;
        copy.isLabel = true;
        return copy;
    }

    private int getMaskedPoints(Set<AttachPoint> attachPoints) {
        HashSet<AttachPoint.Point> points = new HashSet();
        if (!attachPoints.isEmpty()) {
            for (AttachPoint attachPoint : attachPoints) {
                points.add(attachPoint.point);
            }
        } else {
            points = EnumSet.noneOf(AttachPoint.Point.class);
        }
        return AttachPoints.asMask(points);
    }
}

