/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.types.FiniteType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class BFiniteType
extends BType
implements FiniteType {
    private Set<BLangExpression> valueSpace;
    private boolean nullable = false;
    private Optional<Boolean> isAnyData = Optional.empty();

    public BFiniteType(BTypeSymbol tsymbol) {
        super(31, tsymbol);
        this.valueSpace = new LinkedHashSet<BLangExpression>();
    }

    public BFiniteType(BTypeSymbol tsymbol, Set<BLangExpression> valueSpace) {
        super(31, tsymbol);
        this.valueSpace = valueSpace;
    }

    public Set<BLangExpression> getValueSpace() {
        return Collections.unmodifiableSet(this.valueSpace);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.FINITE;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner("|");
        for (BLangExpression value : this.valueSpace) {
            if (value.type.tag == 3) {
                joiner.add(value.toString() + "f");
                continue;
            }
            if (value.type.tag == 4) {
                joiner.add(value.toString() + "d");
                continue;
            }
            joiner.add(value.toString());
        }
        return joiner.toString();
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isAnydata() {
        if (this.isAnyData.isPresent()) {
            return this.isAnyData.get();
        }
        for (BLangExpression value : this.valueSpace) {
            if (value.type.isAnydata()) continue;
            this.isAnyData = Optional.of(false);
            return false;
        }
        this.isAnyData = Optional.of(true);
        return true;
    }

    public void addValue(BLangExpression value) {
        this.valueSpace.add(value);
        if (!this.nullable && value.type.isNullable()) {
            this.nullable = true;
        }
    }
}

