/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.List;
import org.ballerinalang.model.types.InvokableType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BInvokableType
extends BType
implements InvokableType {
    public List<BType> paramTypes;
    public BType restType;
    public BType retType;

    public BInvokableType(List<BType> paramTypes, BType restType, BType retType, BTypeSymbol tsymbol) {
        super(16, tsymbol);
        this.paramTypes = paramTypes;
        this.restType = restType;
        this.retType = retType;
    }

    public BInvokableType(List<BType> paramTypes, BType retType, BTypeSymbol tsymbol) {
        this(paramTypes, null, retType, tsymbol);
    }

    public List<BType> getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public BType getReturnType() {
        return this.retType;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        return "function " + this.getTypeSignature();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BInvokableType)) {
            return false;
        }
        BInvokableType that = (BInvokableType)o;
        if (this.paramTypes != null ? !this.paramTypes.equals(that.paramTypes) : that.paramTypes != null) {
            return false;
        }
        if (this.retType != null ? !this.retType.equals(that.retType) : that.retType != null) {
            return false;
        }
        return this.restType != null ? this.restType.equals(that.restType) : that.restType == null;
    }

    public int hashCode() {
        int result = this.paramTypes != null ? this.paramTypes.hashCode() : 0;
        result = 31 * result + (this.retType != null ? this.retType.hashCode() : 0);
        return result;
    }

    public String getTypeSignature() {
        String retTypeWithParam = this.retType.toString();
        if (this.retType.getKind() != TypeKind.NIL) {
            retTypeWithParam = "(" + retTypeWithParam + ")";
        }
        String restParam = "";
        if (this.restType != null && this.restType instanceof BArrayType) {
            if (!this.paramTypes.isEmpty()) {
                restParam = restParam + ", ";
            }
            restParam = restParam + ((BArrayType)this.restType).eType + "...";
        }
        return "(" + (this.paramTypes.size() != 0 ? BInvokableType.getBTypeListAsString(this.paramTypes) : "") + restParam + ") returns " + retTypeWithParam;
    }

    private static String getBTypeListAsString(List<BType> typeNames) {
        StringBuffer br = new StringBuffer();
        int i = 0;
        for (BType type : typeNames) {
            br.append(type);
            if (++i >= typeNames.size()) continue;
            br.append(",");
        }
        return br.toString();
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }
}

